/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import com.actelion.research.gui.hidpi.ScaledEditorKit;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;

public class ScaledHTML
extends BasicHTML {
    static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }";

    public static View createHTMLView(JComponent jComponent, String string) {
        ScaledEditorKit scaledEditorKit = ScaledEditorKit.create();
        Document document = scaledEditorKit.createDefaultDocument(jComponent.getFont(), jComponent.getForeground());
        Object object = jComponent.getClientProperty("html.base");
        if (object instanceof URL) {
            ((HTMLDocument)document).setBase((URL)object);
        }
        StringReader stringReader = new StringReader(string);
        try {
            scaledEditorKit.read(stringReader, document, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ViewFactory viewFactory = scaledEditorKit.getViewFactory();
        View view = viewFactory.create(document.getDefaultRootElement());
        Renderer renderer = new Renderer(jComponent, viewFactory, view);
        return renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRenderer(JComponent jComponent, String string) {
        View view = null;
        try {
            View view2 = (View)jComponent.getClientProperty("html");
            if (ScaledHTML.isHTMLString(string)) {
                view = ScaledHTML.createHTMLView(jComponent, string);
            }
            if (view != view2 && view2 != null) {
                for (int i = 0; i < view2.getViewCount(); ++i) {
                    view2.getView(i).setParent(null);
                }
            }
            jComponent.putClientProperty("html", view);
        }
        catch (Throwable throwable) {
            jComponent.putClientProperty("html", view);
            throw throwable;
        }
    }

    static class Renderer
    extends View {
        private int width;
        private View view;
        private ViewFactory factory;
        private JComponent host;

        Renderer(JComponent jComponent, ViewFactory viewFactory, View view) {
            super(null);
            this.host = jComponent;
            this.factory = viewFactory;
            this.view = view;
            this.view.setParent(this);
            this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int n) {
            if (n == 0) {
                return this.width;
            }
            return this.view.getPreferredSpan(n);
        }

        @Override
        public float getMinimumSpan(int n) {
            return this.view.getMinimumSpan(n);
        }

        @Override
        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            this.host.revalidate();
            this.host.repaint();
        }

        @Override
        public float getAlignment(int n) {
            return this.view.getAlignment(n);
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            this.view.setSize(rectangle.width, rectangle.height);
            this.view.paint(graphics, shape);
        }

        @Override
        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.view;
        }

        @Override
        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(n, shape, bias);
        }

        @Override
        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            return this.view.modelToView(n, bias, n2, bias2, shape);
        }

        @Override
        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return this.view.viewToModel(f, f2, shape, biasArray);
        }

        @Override
        public Document getDocument() {
            return this.view.getDocument();
        }

        @Override
        public int getStartOffset() {
            return this.view.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.view.getEndOffset();
        }

        @Override
        public Element getElement() {
            return this.view.getElement();
        }

        @Override
        public void setSize(float f, float f2) {
            this.width = (int)f;
            this.view.setSize(f, f2);
        }

        @Override
        public Container getContainer() {
            return this.host;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.factory;
        }
    }
}

