/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.generic;

import com.actelion.research.gui.generic.GenericShape;
import java.util.Arrays;

public class GenericPolygon
implements GenericShape {
    private double[] mX;
    private double[] mY;
    private int mIndex;

    public GenericPolygon(int n) {
        this.mX = new double[n];
        this.mY = new double[n];
        this.mIndex = 0;
    }

    public GenericPolygon() {
        this.mX = new double[64];
        this.mY = new double[64];
        this.mIndex = 0;
    }

    public void addPoint(double d, double d2) {
        if (this.mIndex == this.mX.length) {
            this.mX = Arrays.copyOf(this.mX, 2 * this.mIndex);
            this.mY = Arrays.copyOf(this.mY, 2 * this.mIndex);
        }
        this.mX[this.mIndex] = d;
        this.mY[this.mIndex] = d2;
        ++this.mIndex;
    }

    public void removeLastPoint() {
        if (this.mIndex > 0) {
            --this.mIndex;
        }
    }

    public void clear() {
        this.mIndex = 0;
    }

    @Override
    public boolean contains(double d, double d2) {
        boolean bl = false;
        int n = this.mIndex - 1;
        int n2 = 0;
        while (n2 < this.mIndex) {
            if (this.mY[n2] > d2 != this.mY[n] > d2 && d < (this.mX[n] - this.mX[n2]) * (d2 - this.mY[n2]) / (this.mY[n] - this.mY[n2]) + this.mX[n2]) {
                bl = !bl;
            }
            n = n2++;
        }
        return bl;
    }

    public int getSize() {
        return this.mIndex;
    }

    public double getX(int n) {
        return this.mX[n];
    }

    public double getY(int n) {
        return this.mY[n];
    }

    public double[] getX() {
        return this.mX;
    }

    public double[] getY() {
        return this.mY;
    }
}

