/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.fx;

import com.actelion.research.gui.fx.FXImage;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javax.swing.UIManager;

public class FXDrawContext
implements GenericDrawContext {
    private GraphicsContext mG;
    private int mRGB;

    public FXDrawContext(GraphicsContext graphicsContext) {
        this.mG = graphicsContext;
        this.mG.setLineCap(StrokeLineCap.ROUND);
    }

    @Override
    public int getFontSize() {
        return (int)this.mG.getFont().getSize();
    }

    @Override
    public void setFont(int n, boolean bl, boolean bl2) {
        FontWeight fontWeight = bl ? FontWeight.BOLD : FontWeight.NORMAL;
        FontPosture fontPosture = bl2 ? FontPosture.ITALIC : FontPosture.REGULAR;
        this.mG.setFont(Font.font(null, (FontWeight)fontWeight, (FontPosture)fontPosture, (double)n));
    }

    @Override
    public void drawLine(double d, double d2, double d3, double d4) {
        this.mG.strokeLine(d, d2, d3, d4);
    }

    @Override
    public void drawDottedLine(double d, double d2, double d3, double d4) {
        double[] dArray = this.mG.getLineDashes();
        this.mG.setLineDashes(new double[]{3.0 * this.mG.getLineWidth()});
        this.mG.strokeLine(d, d2, d3, d4);
        this.mG.setLineDashes(dArray);
    }

    @Override
    public void drawRectangle(double d, double d2, double d3, double d4) {
        this.mG.strokeRect(d, d2, d3, d4);
    }

    @Override
    public void fillRectangle(double d, double d2, double d3, double d4) {
        this.mG.fillRect(d, d2, d3, d4);
    }

    @Override
    public void drawCircle(double d, double d2, double d3) {
        this.mG.strokeOval(d, d2, d3, d3);
    }

    @Override
    public void fillCircle(double d, double d2, double d3) {
        this.mG.fillOval(d, d2, d3, d3);
    }

    @Override
    public void drawPolygon(GenericPolygon genericPolygon) {
        this.mG.strokePolygon(genericPolygon.getX(), genericPolygon.getY(), genericPolygon.getSize());
    }

    @Override
    public void fillPolygon(GenericPolygon genericPolygon) {
        this.mG.fillPolygon(genericPolygon.getX(), genericPolygon.getY(), genericPolygon.getSize());
    }

    @Override
    public float getLineWidth() {
        return (float)this.mG.getLineWidth();
    }

    @Override
    public void setLineWidth(float f) {
        this.mG.setLineWidth((double)f);
    }

    @Override
    public int getRGB() {
        return this.mRGB;
    }

    @Override
    public void setRGB(int n) {
        this.mRGB = n;
        float f = (float)(n >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(n >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(n & 0xFF) / 255.0f;
        Color color = new Color((double)f, (double)f2, (double)f3, 1.0);
        this.mG.setStroke((Paint)color);
        this.mG.setFill((Paint)color);
    }

    @Override
    public void drawString(double d, double d2, String string) {
        this.mG.fillText(string, d, d2);
    }

    @Override
    public void drawCenteredString(double d, double d2, String string) {
        double d3 = this.getBounds(string).getWidth();
        this.mG.fillText(string, d - d3 / 2.0, d2 + this.mG.getFont().getSize() / 3.0);
    }

    @Override
    public GenericRectangle getBounds(String string) {
        Text text = new Text(string);
        text.setFont(this.mG.getFont());
        Bounds bounds = text.getLayoutBounds();
        return new GenericRectangle(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public void drawImage(GenericImage genericImage, double d, double d2) {
        this.mG.drawImage((Image)genericImage.get(), d, d2);
    }

    @Override
    public void drawImage(GenericImage genericImage, double d, double d2, double d3, double d4, double d5, double d6) {
        this.mG.drawImage((Image)genericImage.get(), d, d2, d5, d6, d3, d4, d5, d6);
    }

    @Override
    public void drawImage(GenericImage genericImage, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.mG.drawImage((Image)genericImage.get(), d, d2, d3, d4, d5, d6, d7, d8);
    }

    @Override
    public boolean isDarkBackground() {
        return false;
    }

    @Override
    public int getForegroundRGB() {
        return UIManager.getColor("TextArea.foreground").getRGB();
    }

    @Override
    public int getBackgroundRGB() {
        return UIManager.getColor("TextArea.background").getRGB();
    }

    @Override
    public int getSelectionBackgroundRGB() {
        return UIManager.getColor("TextArea.selectionBackground").getRGB();
    }

    @Override
    public GenericImage createARGBImage(int n, int n2) {
        return new FXImage(n, n2);
    }
}

