/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.generic.GenericCanvas;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericMouseEvent;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.util.ColorHelper;

public class GenericEditorToolbar
implements GenericEventListener<GenericMouseEvent> {
    protected static final int cButtonsPerColumn = 17;
    private static final int cImageOversize = 4;
    protected static final int cButtonClear = 0;
    protected static final int cButtonCleanStructure = 1;
    public static final int cToolLassoPointer = 2;
    protected static final int cToolUnknownParity = 3;
    protected static final int cToolDelete = 4;
    protected static final int cToolStdBond = 5;
    protected static final int cToolUpBond = 6;
    protected static final int cTool3Ring = 7;
    protected static final int cTool5Ring = 8;
    protected static final int cTool7Ring = 9;
    protected static final int cToolPosCharge = 10;
    protected static final int cToolAtomC = 11;
    protected static final int cToolAtomN = 12;
    protected static final int cToolAtomO = 13;
    protected static final int cToolAtomF = 14;
    protected static final int cToolAtomBr = 15;
    protected static final int cToolAtomH = 16;
    protected static final int cButtonUndo = 17;
    protected static final int cToolZoom = 18;
    protected static final int cToolMapper = 19;
    protected static final int cToolESR = 20;
    protected static final int cToolText = 21;
    protected static final int cToolChain = 22;
    protected static final int cToolDownBond = 23;
    protected static final int cTool4Ring = 24;
    protected static final int cTool6Ring = 25;
    protected static final int cToolAromRing = 26;
    protected static final int cToolNegCharge = 27;
    protected static final int cToolAtomSi = 28;
    protected static final int cToolAtomP = 29;
    protected static final int cToolAtomS = 30;
    protected static final int cToolAtomCl = 31;
    protected static final int cToolAtomI = 32;
    protected static final int cToolCustomAtom = 33;
    protected static final int cBorder = Math.round(HiDPIHelper.scale(2.0f));
    protected static final float cSourceButtonSize = 84.0f;
    protected static final float cButtonSize = HiDPIHelper.getUIScaleFactor() * 21.0f;
    protected static final int cToolESRAbs = 101;
    protected static final int cToolESROr = 102;
    protected static final int cToolESRAnd = 103;
    private GenericCanvas mToolbarCanvas;
    private GenericEditorArea mArea;
    private GenericImage mImageNormal;
    private GenericImage mImageDisabled;
    private GenericImage mESRImageNormal;
    protected int mWidth;
    protected int mHeight;
    protected int mCurrentTool;
    protected int mSelectedButton;
    protected int mHighlightedButton;
    protected int mESRSelected;
    private float mImageScaling;

    public GenericEditorToolbar(GenericCanvas genericCanvas, GenericEditorArea genericEditorArea) {
        this.mToolbarCanvas = genericCanvas;
        this.mArea = genericEditorArea;
        this.init();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    private void init() {
        this.mImageNormal = this.mArea.getUIHelper().createImage("editorButtons.png");
        if (LookAndFeelHelper.isDarkLookAndFeel()) {
            HiDPIHelper.adaptForLookAndFeel(this.mImageNormal);
        }
        this.mImageDisabled = this.mArea.getUIHelper().createImage("editorButtons.png");
        HiDPIHelper.disableImage(this.mImageDisabled);
        this.mWidth = 2 * cBorder + HiDPIHelper.scale(this.mImageNormal.getWidth() / 4);
        this.mHeight = 2 * cBorder + HiDPIHelper.scale(this.mImageNormal.getHeight() / 4);
        this.mESRImageNormal = this.mArea.getUIHelper().createImage("esrButtons.png");
        this.mImageScaling = 4.0f / HiDPIHelper.getUIScaleFactor();
        this.mCurrentTool = 5;
        this.mSelectedButton = -1;
        this.mHighlightedButton = -1;
    }

    public void setCurrentTool(int n) {
        if (this.mCurrentTool != n) {
            this.mCurrentTool = n;
            this.mArea.toolChanged(n);
            this.mToolbarCanvas.repaint();
        }
    }

    public void paintContent(GenericDrawContext genericDrawContext) {
        int n = this.mToolbarCanvas.getBackgroundRGB();
        boolean bl = (double)ColorHelper.perceivedBrightness(n) < 0.5;
        int n2 = bl ? ColorHelper.brighter(n, 0.6f) : ColorHelper.darker(n, 0.6f);
        int n3 = bl ? ColorHelper.brighter(n, 0.8f) : ColorHelper.darker(n, 0.8f);
        int n4 = this.mImageNormal.getWidth();
        int n5 = this.mImageNormal.getHeight();
        genericDrawContext.drawImage(this.mImageNormal, 0.0, 0.0, n4, n5, cBorder, cBorder, (float)n4 / this.mImageScaling, (float)n5 / this.mImageScaling);
        double[] dArray = this.getButtonLocation(20);
        genericDrawContext.drawImage(this.mESRImageNormal, 0.0, (float)this.mESRSelected * 84.0f, 84.0, 84.0, dArray[0], dArray[1], cButtonSize, cButtonSize);
        if ((this.mArea.getMode() & 4) == 0) {
            this.drawButton(genericDrawContext, 19, -1, true);
        }
        if ((this.mArea.getMode() & 8) == 0) {
            this.drawButton(genericDrawContext, 21, -1, true);
        }
        this.drawButton(genericDrawContext, this.mCurrentTool, n3, false);
        if (this.mHighlightedButton != -1 && this.mHighlightedButton != this.mSelectedButton) {
            this.drawButton(genericDrawContext, this.mHighlightedButton, n2, false);
        }
        if (this.mSelectedButton != -1) {
            this.drawButton(genericDrawContext, this.mSelectedButton, 7167924, false);
        }
    }

    @Override
    public void eventHappened(GenericMouseEvent genericMouseEvent) {
        if (genericMouseEvent.getWhat() == 1) {
            int n = this.getButtonNo(genericMouseEvent);
            if (!this.isSelectableButton(n)) {
                return;
            }
            if (n == 20 && n == this.mCurrentTool) {
                ++this.mESRSelected;
                this.mESRSelected %= 3;
            }
            this.mSelectedButton = n;
            this.mToolbarCanvas.repaint();
        } else if (genericMouseEvent.getWhat() == 2) {
            if (this.mSelectedButton == -1) {
                return;
            }
            int n = this.getButtonNo(genericMouseEvent);
            if (n != this.mSelectedButton || this.mSelectedButton == 19 && (this.mArea.getMode() & 4) == 0 || this.mSelectedButton == 21 && (this.mArea.getMode() & 8) == 0) {
                this.mSelectedButton = -1;
                this.mToolbarCanvas.repaint();
                return;
            }
            this.mSelectedButton = -1;
            if (n == 0 || n == 1 || n == 17) {
                this.mToolbarCanvas.repaint();
                this.mArea.buttonPressed(n);
                return;
            }
            this.mCurrentTool = n;
            this.mToolbarCanvas.repaint();
            if (this.mCurrentTool == 20) {
                this.mArea.toolChanged(this.mESRSelected == 0 ? 101 : (this.mESRSelected == 1 ? 103 : 102));
            } else if (this.mCurrentTool == 33) {
                this.mArea.showCustomAtomDialog(-1, () -> this.mArea.toolChanged(n), null);
            } else {
                this.mArea.toolChanged(n);
            }
        } else if (genericMouseEvent.getWhat() == 6 || genericMouseEvent.getWhat() == 5) {
            int n = this.getButtonNo(genericMouseEvent);
            if (n == this.mSelectedButton) {
                n = -1;
            }
            if (n != this.mHighlightedButton) {
                this.mHighlightedButton = n;
                this.mToolbarCanvas.repaint();
            }
        }
    }

    protected int getButtonNo(GenericMouseEvent genericMouseEvent) {
        int n = genericMouseEvent.getX() - cBorder;
        int n2 = genericMouseEvent.getY() - cBorder;
        if (n < 0 || (float)n >= 2.0f * cButtonSize || n2 < 0 || (float)n2 >= 17.0f * cButtonSize) {
            return -1;
        }
        int n3 = 17 * (int)((float)n / cButtonSize) + (int)((float)n2 / cButtonSize);
        return this.isSelectableButton(n3) ? n3 : -1;
    }

    private boolean isSelectableButton(int n) {
        return !(n < 0 || n >= 34 || n == this.mCurrentTool && n != 20 && n != 33 || n == 19 && (this.mArea.getMode() & 4) == 0 || n == 21 && (this.mArea.getMode() & 8) == 0);
    }

    private void drawButton(GenericDrawContext genericDrawContext, int n, int n2, boolean bl) {
        double[] dArray = this.getButtonLocation(n);
        if ((n2 |= Integer.MIN_VALUE) != -1) {
            genericDrawContext.setRGB(n2);
            genericDrawContext.fillRectangle(dArray[0], dArray[1], cButtonSize, cButtonSize);
        }
        if (n == 20) {
            genericDrawContext.drawImage(this.mESRImageNormal, 0.0, (float)this.mESRSelected * 84.0f, 84.0, 84.0, dArray[0], dArray[1], cButtonSize, cButtonSize);
        } else {
            genericDrawContext.drawImage(bl ? this.mImageDisabled : this.mImageNormal, (dArray[0] - (double)cBorder) * (double)this.mImageScaling, (dArray[1] - (double)cBorder) * (double)this.mImageScaling, 84.0, 84.0, dArray[0], dArray[1], cButtonSize, cButtonSize);
        }
    }

    private double[] getButtonLocation(int n) {
        double[] dArray = new double[]{cButtonSize * (float)(n / 17) + (float)cBorder, cButtonSize * (float)(n % 17) + (float)cBorder};
        return dArray;
    }
}

