/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.gui.editor.FXEditorArea;
import com.actelion.research.gui.editor.GenericEditorToolbar;
import com.actelion.research.gui.fx.FXDrawContext;
import com.actelion.research.gui.fx.FXMouseHandler;
import com.actelion.research.gui.generic.GenericCanvas;
import com.actelion.research.gui.generic.GenericDrawContext;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FXEditorToolbar
extends Canvas
implements GenericCanvas {
    private GenericEditorToolbar mGenericToolbar;
    private volatile boolean mDrawPending;

    public FXEditorToolbar(FXEditorArea fXEditorArea) {
        this.mGenericToolbar = new GenericEditorToolbar(this, fXEditorArea.getGenericDrawArea());
        FXMouseHandler fXMouseHandler = new FXMouseHandler(this.mGenericToolbar);
        fXMouseHandler.addListener(this.mGenericToolbar);
        this.setOnMousePressed(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 1));
        this.setOnMouseReleased(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 2));
        this.setOnMouseMoved(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 6));
        this.setOnMouseDragged(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 7));
        this.setOnMouseExited(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 5));
        this.setWidth(this.mGenericToolbar.getWidth());
        this.setHeight(this.mGenericToolbar.getHeight());
        GraphicsContext graphicsContext = this.getGraphicsContext2D();
        this.mGenericToolbar.paintContent(new FXDrawContext(graphicsContext));
    }

    @Override
    public double getCanvasWidth() {
        return this.getWidth();
    }

    @Override
    public double getCanvasHeight() {
        return this.getHeight();
    }

    @Override
    public int getBackgroundRGB() {
        Paint paint;
        BackgroundFill backgroundFill;
        Background background;
        Parent parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Pane); parent = parent.getParent()) {
        }
        if (parent != null && parent instanceof Pane && (background = ((Pane)parent).getBackground()) != null && (backgroundFill = (BackgroundFill)background.getFills().get(0)) != null && (paint = backgroundFill.getFill()) instanceof Color) {
            Color color = (Color)paint;
            return (Math.round(255.0f * (float)color.getRed()) << 16) + (Math.round(255.0f * (float)color.getGreen()) << 8) + Math.round(255.0f * (float)color.getBlue());
        }
        return 0xE0E0E0;
    }

    @Override
    public void repaint() {
        if (!this.mDrawPending) {
            this.mDrawPending = true;
            Platform.runLater(() -> this.draw());
        }
    }

    private void draw() {
        this.mDrawPending = false;
        GraphicsContext graphicsContext = this.getGraphicsContext2D();
        graphicsContext.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        this.mGenericToolbar.paintContent(new FXDrawContext(graphicsContext));
    }

    @Override
    public GenericDrawContext getDrawContext() {
        return new FXDrawContext(this.getGraphicsContext2D());
    }
}

