/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.util.ColorHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    private static final long serialVersionUID = 537331719L;
    private static int sBorderWidth;
    private static int sThinSize;
    private Insets mInsets;
    private Color mColor;

    public ShadowBorder() {
        this.mInsets = new Insets(ShadowBorder.thinSize(), ShadowBorder.thinSize(), ShadowBorder.shadowSize(), ShadowBorder.shadowSize());
    }

    public static int thinSize() {
        if (sThinSize == 0) {
            sThinSize = HiDPIHelper.scale(1.0f);
        }
        return sThinSize;
    }

    public static int shadowSize() {
        if (sBorderWidth == 0) {
            sBorderWidth = HiDPIHelper.scale(3.0f);
        }
        return sBorderWidth;
    }

    public void setColor(Color color) {
        this.mColor = color;
    }

    public ShadowBorder(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(HiDPIHelper.scale(n), HiDPIHelper.scale(n2), HiDPIHelper.scale(n3), HiDPIHelper.scale(n4));
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.mInsets;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        super.paintBorder(component, graphics, n, n2, n3, n4);
        Color[] colorArray = new Color[ShadowBorder.shadowSize()];
        colorArray[0] = this.mColor != null ? this.mColor : component.getBackground().darker();
        Color color = component.getParent().getBackground();
        for (n5 = 1; n5 < colorArray.length; ++n5) {
            colorArray[n5] = ColorHelper.intermediateColor(colorArray[0], color, 0.3f + 0.7f * (float)Math.pow((float)n5 / (float)colorArray.length, 1.6));
        }
        graphics.translate(n, n2);
        n5 = this.mInsets.top;
        int n6 = this.mInsets.left;
        int n7 = n4 -= this.mInsets.bottom;
        int n8 = n3 -= this.mInsets.right;
        n4 -= this.mInsets.top;
        n3 -= this.mInsets.left;
        graphics.setColor(color);
        graphics.fillRect(n8 + 1, n5 - 1, colorArray.length - 1, colorArray.length);
        graphics.fillRect(n6 - 1, n7 + 1, colorArray.length, colorArray.length - 1);
        graphics.fillRect(n8 + colorArray.length - 1, n7 + colorArray.length - 1, 1, 1);
        graphics.setColor(colorArray[0]);
        graphics.fillRect(n6 - 1, n5 - 1, n3 + 1, 1);
        graphics.fillRect(n6 - 1, n5 - 1, 1, n4 + 1);
        graphics.fillRect(n8, n5, 1, n4);
        graphics.fillRect(n6, n7, n3, 1);
        for (int i = 1; i < colorArray.length; ++i) {
            graphics.setColor(colorArray[i]);
            graphics.fillRect(n8 + i, n5 + i, 1, n4);
            graphics.fillRect(n6 + i, n7 + i, n3, 1);
            graphics.fillRect(n8 + i - 1, n5 + i - 2, 1, 1);
            graphics.fillRect(n6 + i - 2, n7 + i - 1, 1, 1);
            graphics.fillRect(n8 + i - 1, n7 + i - 1, 1, 1);
        }
        graphics.translate(-n, -n2);
    }
}

