/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import com.actelion.research.gui.dock.DividerChangeListener;
import com.actelion.research.gui.dock.Dockable;
import com.actelion.research.gui.dock.GhostPreview;
import com.actelion.research.gui.dock.TransferableDockable;
import com.actelion.research.gui.dock.TreeContainer;
import com.actelion.research.gui.dock.TreeFork;
import com.actelion.research.gui.dock.TreeLeaf;
import com.actelion.research.gui.dock.TreeRoot;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.OverlayLayout;

public class JDockingPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 0x20070720L;
    public static final int DOCK_CENTER = 0;
    public static final int DOCK_TOP = 1;
    public static final int DOCK_LEFT = 2;
    public static final int DOCK_BOTTOM = 3;
    public static final int DOCK_RIGHT = 4;
    public static final int ALLOWED_DRAG_DROP_ACTIONS = 2;
    private TreeMap<String, Dockable> mDockableMap = new TreeMap();
    private TreeMap<String, TreeLeaf> mLeafMap = new TreeMap();
    private Dockable mPreviousTargetDockable;
    private TreeRoot mTreeRoot;
    private TreeLeaf mTargetLeaf;
    private int mTargetPosition = -1;
    private int mPreviousTargetPosition;
    private GhostPreview mPreview = new GhostPreview();
    private Dockable mMaximizedView;
    private Vector<DividerChangeListener> mDividerChangeListeners;

    public JDockingPanel() {
        this.setLayout(new OverlayLayout(this));
        new DropTarget(this, 2, new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                Dockable dockable = JDockingPanel.this.getDraggedDockable(dropTargetDragEvent);
                if (dockable != null) {
                    Point point = dropTargetDragEvent.getLocation();
                    Rectangle rectangle = dockable.getHeader().getBounds();
                    point.translate(rectangle.x, rectangle.y);
                    JDockingPanel.this.updatePreview(point, dockable);
                }
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (JDockingPanel.this.mTargetPosition == -1 || !transferable.isDataFlavorSupported(TransferableDockable.DF_DOCKABLE_DEF)) {
                    dropTargetDropEvent.rejectDrop();
                } else {
                    dropTargetDropEvent.acceptDrop(2);
                    try {
                        String string = (String)transferable.getTransferData(TransferableDockable.DF_DOCKABLE_DEF);
                        for (int i = 0; i < JDockingPanel.this.mTargetLeaf.getDockableCount(); ++i) {
                            if (string.equals(JDockingPanel.this.mTargetLeaf.getDockable(i).getTitle())) continue;
                            String string2 = JDockingPanel.this.mTargetLeaf.getDockable(i).getTitle();
                            JDockingPanel.this.relocateView(string, string2, JDockingPanel.this.mTargetPosition, 0.5f);
                            break;
                        }
                        dropTargetDropEvent.dropComplete(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                JDockingPanel.this.mTargetPosition = -1;
            }
        }, true);
    }

    public void addDividerChangeLister(DividerChangeListener dividerChangeListener) {
        if (this.mDividerChangeListeners == null) {
            this.mDividerChangeListeners = new Vector();
        }
        this.mDividerChangeListeners.add(dividerChangeListener);
        if (this.mTreeRoot != null) {
            this.mTreeRoot.setDividerChangeListeners(this.mDividerChangeListeners);
        }
    }

    public void removeDividerChangeLister(DividerChangeListener dividerChangeListener) {
        if (this.mDividerChangeListeners != null) {
            this.mDividerChangeListeners.remove(dividerChangeListener);
            if (this.mTreeRoot != null) {
                this.mTreeRoot.setDividerChangeListeners(this.mDividerChangeListeners);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().startsWith("close_")) {
            String string = actionEvent.getActionCommand().substring(6);
            this.undock(string, false);
        } else if (actionEvent.getActionCommand().startsWith("max_")) {
            String string = actionEvent.getActionCommand().substring(4);
            this.maximize(string, null);
        }
    }

    public void maximize(String string, JToolBar jToolBar) {
        Dockable dockable = this.mDockableMap.get(string);
        if (this.mMaximizedView != null) {
            this.remove(this.mMaximizedView);
            dockable.endBorrowContent();
            this.mTreeRoot.getChild().getComponent().setVisible(true);
            this.mMaximizedView = null;
            this.validate();
        } else if (!(this.mTreeRoot.getComponent() instanceof Dockable)) {
            this.mTreeRoot.getChild().getComponent().setVisible(false);
            this.selectDockable(dockable);
            JComponent jComponent = dockable.borrowContent();
            this.mMaximizedView = new Dockable(this, jComponent, string, jToolBar);
            this.mMaximizedView.setPopupProvider(dockable.getPopupProvider());
            this.mMaximizedView.setVisible(true);
            this.add(this.mMaximizedView);
            this.validate();
        }
    }

    protected void fireDockableSelected(Dockable dockable) {
        this.actionPerformed(new ActionEvent(this, 1001, "selected_" + dockable.getTitle()));
    }

    private void updatePreview(Point point, Dockable dockable) {
        this.mTargetPosition = -1;
        Dockable dockable2 = null;
        for (Dockable dockable3 : this.mDockableMap.values()) {
            Rectangle rectangle;
            if (!dockable3.isVisible() || !(rectangle = this.getAbsoluteBounds(dockable3.getContent())).contains(point)) continue;
            dockable2 = dockable3;
            this.mTargetPosition = this.getPosition(point, rectangle);
            break;
        }
        this.updatePreview(dockable, dockable2);
    }

    public Rectangle getAbsoluteBounds(Component component) {
        Rectangle rectangle = component.getBounds();
        for (Container container = component.getParent(); container != this; container = container.getParent()) {
            Point point = container.getLocation();
            rectangle.translate(point.x, point.y);
        }
        return rectangle;
    }

    private int getPosition(Point point, Rectangle rectangle) {
        boolean bl;
        int n = point.x - rectangle.x;
        int n2 = point.y - rectangle.y;
        if (n > rectangle.width / 4 && n < rectangle.width * 3 / 4 && n2 > rectangle.height / 4 && n2 < rectangle.height * 3 / 4) {
            return 0;
        }
        boolean bl2 = (double)n / (double)rectangle.width > (double)n2 / (double)rectangle.height;
        boolean bl3 = bl = (double)n / (double)rectangle.width + (double)n2 / (double)rectangle.height < 1.0;
        if (bl2) {
            return bl ? 1 : 4;
        }
        return bl ? 2 : 3;
    }

    private void updatePreview(Dockable dockable, Dockable dockable2) {
        if (dockable2 == null) {
            this.mTargetPosition = -1;
        } else if (dockable2 == dockable) {
            TreeLeaf treeLeaf = this.mLeafMap.get(dockable.getTitle());
            if (this.mTargetPosition == 0 || treeLeaf.getDockableCount() == 1) {
                this.mTargetPosition = -1;
            } else {
                this.mTargetLeaf = treeLeaf;
            }
        } else {
            this.mTargetLeaf = this.mLeafMap.get(dockable2.getTitle());
        }
        if (this.mPreviousTargetDockable != dockable2 || this.mPreviousTargetPosition != this.mTargetPosition) {
            if (this.mTargetPosition != -1) {
                this.mPreview.createPreview(dockable, dockable2, this.mTargetPosition, this);
            }
            this.mPreviousTargetDockable = dockable2;
            this.mPreviousTargetPosition = this.mTargetPosition;
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.mTargetPosition != -1) {
            this.mPreview.drawPreview((Graphics2D)graphics);
        }
    }

    public void relocateView(String string, String string2, int n, float f) {
        Dockable dockable = this.getDockable(string);
        this.undock(string, true);
        this.dock(dockable, n, this.mLeafMap.get(string2), f, true);
    }

    public void dock(Dockable dockable) {
        this.dock(dockable, 0);
    }

    public void dock(Dockable dockable, int n) {
        this.dock(dockable, n, this.getSelectedLeaf(), 0.5, false);
    }

    public void dock(Dockable dockable, String string) {
        int n;
        String string2;
        if (string == null || string.equals("root")) {
            this.dock(dockable, 0, this.getSelectedLeaf(), Double.NaN, false);
            return;
        }
        int n2 = string.indexOf(9);
        int n3 = string.indexOf(9, n2 + 1);
        String string3 = string.substring(0, n2);
        String string4 = n3 == -1 ? string.substring(n2 + 1) : string.substring(n2 + 1, n3);
        String string5 = string2 = n3 == -1 ? null : string.substring(n3);
        int n4 = "center".equals(string4) ? 0 : ("top".equals(string4) ? 1 : ("left".equals(string4) ? 2 : ("bottom".equals(string4) ? 3 : (n = "right".equals(string4) ? 4 : -1))));
        double d = string2 != null ? Double.parseDouble(string2) : (n == 0 ? Double.NaN : 0.5);
        this.dock(dockable, n, this.mLeafMap.get(string3), d, false);
    }

    private void dock(Dockable dockable, int n, TreeLeaf treeLeaf, double d, boolean bl) {
        this.mDockableMap.put(dockable.getTitle(), dockable);
        if (treeLeaf == null) {
            TreeLeaf treeLeaf2 = new TreeLeaf(dockable, this, bl);
            this.mTreeRoot = new TreeRoot(this, treeLeaf2);
            this.mLeafMap.put(dockable.getTitle(), treeLeaf2);
        } else if (n == 0) {
            treeLeaf.addContent(dockable, bl);
            this.mLeafMap.put(dockable.getTitle(), treeLeaf);
        } else {
            TreeLeaf treeLeaf3 = new TreeLeaf(dockable, this, bl);
            TreeContainer treeContainer = treeLeaf.getParent();
            TreeFork treeFork = new TreeFork(treeLeaf, treeLeaf3, n, d, this.mDividerChangeListeners);
            treeContainer.replaceChildElement(treeLeaf, treeFork);
            this.mLeafMap.put(dockable.getTitle(), treeLeaf3);
        }
        this.selectDockable(dockable);
        this.validate();
    }

    public void undock(String string) {
        this.undock(string, false);
    }

    public void undock(String string, boolean bl) {
        Dockable dockable = this.mDockableMap.get(string);
        if (dockable != null) {
            if (this.mDockableMap.size() == 1) {
                this.undockAll();
                return;
            }
            boolean bl2 = dockable.isSelected();
            TreeLeaf treeLeaf = this.mLeafMap.get(string);
            this.mLeafMap.remove(string);
            if (treeLeaf.removeContent(dockable, bl)) {
                TreeLeaf treeLeaf2;
                if (bl2 && (treeLeaf2 = this.mLeafMap.get(this.mLeafMap.firstKey())) != null) {
                    treeLeaf2.setSelected(true);
                }
            } else if (bl2) {
                treeLeaf.setSelected(true);
            }
            this.mDockableMap.remove(string);
            this.validate();
            this.repaint();
        }
    }

    public void undockAll() {
        this.mTreeRoot = null;
        this.mDockableMap.clear();
        this.mLeafMap.clear();
        this.removeAll();
        this.validate();
        this.repaint();
    }

    public Set<String> getDockableTitles() {
        return this.mDockableMap.keySet();
    }

    public Collection<Dockable> getDockables() {
        return this.mDockableMap.values();
    }

    public Dockable getDockable(String string) {
        return this.mDockableMap.get(string);
    }

    public String getTitle(Dockable dockable) {
        for (String string : this.mDockableMap.keySet()) {
            if (this.mDockableMap.get(string) != dockable) continue;
            return string;
        }
        return null;
    }

    public int getDockableCount() {
        return this.mDockableMap.size();
    }

    public String[] getDockInfoSequence() {
        if (this.mTreeRoot == null) {
            return null;
        }
        return this.mTreeRoot.createStateInfo().toArray(new String[0]);
    }

    public boolean isInFrontInTabbedPane(String string) {
        Dockable dockable = this.mDockableMap.get(string);
        if (dockable == null) {
            return false;
        }
        Container container = dockable.getParent();
        if (container instanceof JTabbedPane) {
            return dockable == ((JTabbedPane)container).getSelectedComponent();
        }
        return false;
    }

    public void setToFrontInTabbedPane(String string) {
        Container container;
        Dockable dockable = this.mDockableMap.get(string);
        if (dockable != null && (container = dockable.getParent()) instanceof JTabbedPane) {
            ((JTabbedPane)container).setSelectedComponent(dockable);
        }
    }

    public boolean isVisibleInSplitPane(String string, boolean bl) {
        Component component = this.mDockableMap.get(string);
        if (component == null) {
            return false;
        }
        Container container = component.getParent();
        if (container instanceof JTabbedPane) {
            if (component != ((JTabbedPane)container).getSelectedComponent()) {
                return false;
            }
            component = container;
            container = container.getParent();
        }
        if (container instanceof JSplitPane) {
            return bl && component == ((JSplitPane)container).getLeftComponent() || !bl && component == ((JSplitPane)container).getRightComponent();
        }
        return false;
    }

    public boolean changeTitle(String string, String string2) {
        if (this.mDockableMap.containsKey(string2) || string2.indexOf(9) != -1) {
            return false;
        }
        Dockable dockable = this.mDockableMap.get(string);
        this.mDockableMap.remove(string);
        this.mDockableMap.put(string2, dockable);
        dockable.setTitle(string2);
        TreeLeaf treeLeaf = this.mLeafMap.get(string);
        treeLeaf.changeTitle(string, string2);
        this.mLeafMap.remove(string);
        this.mLeafMap.put(string2, treeLeaf);
        if (this.mMaximizedView != null && this.mMaximizedView.getTitle().equals(string)) {
            this.mMaximizedView.setTitle(string2);
        }
        return true;
    }

    public Dockable getDockable(Component component) {
        if (component != null) {
            for (Dockable dockable : this.mDockableMap.values()) {
                if (dockable.getContent() != component) continue;
                return dockable;
            }
        }
        return null;
    }

    public Dockable getSelectedDockable() {
        for (Dockable dockable : this.mDockableMap.values()) {
            if (!dockable.isSelected()) continue;
            return dockable;
        }
        return null;
    }

    public Dockable getDraggedDockable(DropTargetDragEvent dropTargetDragEvent) {
        Transferable transferable = dropTargetDragEvent.getTransferable();
        if (transferable.isDataFlavorSupported(TransferableDockable.DF_DOCKABLE_DEF)) {
            try {
                return this.getDockable((String)transferable.getTransferData(TransferableDockable.DF_DOCKABLE_DEF));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void visibilityChanged(Dockable dockable, boolean bl) {
        dockable.notifyVisibility(bl);
    }

    public void selectDockable(Dockable dockable) {
        if (dockable != null) {
            for (Dockable dockable2 : this.mDockableMap.values()) {
                dockable2.setSelected(dockable2 == dockable);
            }
            TreeLeaf treeLeaf = this.mLeafMap.get(dockable.getTitle());
            if (treeLeaf != null) {
                treeLeaf.setSelectedDockable(dockable);
            }
        }
    }

    private TreeLeaf getSelectedLeaf() {
        for (TreeLeaf treeLeaf : this.mLeafMap.values()) {
            if (!treeLeaf.isSelected()) continue;
            return treeLeaf;
        }
        return null;
    }

    public boolean isMaximized() {
        return this.mMaximizedView != null;
    }

    public void redistribute() {
        ArrayList<Dockable> arrayList = new ArrayList<Dockable>(this.getDockables());
        Collections.sort(arrayList, new Comparator<Dockable>(){

            @Override
            public int compare(Dockable dockable, Dockable dockable2) {
                return dockable.getTitle().compareTo(dockable2.getTitle());
            }
        });
        if (arrayList.size() <= 1) {
            return;
        }
        this.mTreeRoot = null;
        this.mLeafMap.clear();
        this.mDockableMap.clear();
        this.removeAll();
        this.validate();
        for (Dockable object : arrayList) {
            object.borrowContent();
        }
        if (arrayList.size() > 0) {
            Dockable dockable = (Dockable)arrayList.get(0);
            TreeLeaf treeLeaf = new TreeLeaf(dockable, this, false);
            this.mTreeRoot = new TreeRoot(this, treeLeaf);
            this.mLeafMap.put(dockable.getTitle(), treeLeaf);
            this.mDockableMap.put(dockable.getTitle(), dockable);
            this.redistribute(arrayList, 0, arrayList.size(), treeLeaf);
        }
        for (Dockable dockable : arrayList) {
            dockable.endBorrowContent();
        }
        this.validate();
        this.repaint();
    }

    private void redistribute(List<Dockable> list, int n, int n2, TreeLeaf treeLeaf) {
        TreeFork treeFork;
        TreeContainer treeContainer;
        Dockable dockable;
        int n3 = n + (n2 - n + 3) / 4;
        int n4 = n3 + (n2 - n3 + 2) / 3;
        int n5 = n4 + (n2 - n4 + 1) / 2;
        System.out.println(n + " " + n3 + " " + n4 + " " + n5 + " " + n2);
        TreeLeaf treeLeaf2 = null;
        TreeLeaf treeLeaf3 = null;
        TreeLeaf treeLeaf4 = null;
        if (n4 > n3 && n4 < list.size()) {
            dockable = list.get(n4);
            treeLeaf3 = new TreeLeaf(dockable, this, false);
            treeContainer = treeLeaf.getParent();
            treeFork = new TreeFork(treeLeaf, treeLeaf3, 3, 0.5, this.mDividerChangeListeners);
            treeContainer.replaceChildElement(treeLeaf, treeFork);
            this.mLeafMap.put(dockable.getTitle(), treeLeaf3);
            this.mDockableMap.put(dockable.getTitle(), dockable);
        }
        if (n3 > n && n3 < list.size()) {
            dockable = list.get(n3);
            treeLeaf2 = new TreeLeaf(dockable, this, false);
            treeContainer = treeLeaf.getParent();
            treeFork = new TreeFork(treeLeaf, treeLeaf2, 4, 0.5, this.mDividerChangeListeners);
            treeContainer.replaceChildElement(treeLeaf, treeFork);
            this.mLeafMap.put(dockable.getTitle(), treeLeaf2);
            this.mDockableMap.put(dockable.getTitle(), dockable);
        }
        if (n5 > n4 && n5 < list.size()) {
            dockable = list.get(n5);
            treeLeaf4 = new TreeLeaf(dockable, this, false);
            treeContainer = treeLeaf3.getParent();
            treeFork = new TreeFork(treeLeaf3, treeLeaf4, 4, 0.5, this.mDividerChangeListeners);
            treeContainer.replaceChildElement(treeLeaf3, treeFork);
            this.mLeafMap.put(dockable.getTitle(), treeLeaf4);
            this.mDockableMap.put(dockable.getTitle(), dockable);
        }
        if (n3 > n + 1) {
            this.redistribute(list, n, n3, treeLeaf);
        }
        if (n4 > n3 + 1) {
            this.redistribute(list, n3, n4, treeLeaf2);
        }
        if (n5 > n4 + 1) {
            this.redistribute(list, n4, n5, treeLeaf3);
        }
        if (n2 > n5 + 1) {
            this.redistribute(list, n5, n2, treeLeaf4);
        }
    }
}

