/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import com.actelion.research.gui.dock.DockableHeader;
import com.actelion.research.gui.dock.JDockingPanel;
import com.actelion.research.gui.dock.PopupProvider;
import com.actelion.research.gui.dock.ShadowBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class Dockable
extends JPanel {
    private static final long serialVersionUID = 0x20070720L;
    private DockableHeader mHeader;
    private JDockingPanel mDockingPanel;
    private JComponent mContent;
    private boolean mIsSelected;
    private boolean mIsVisible;

    public Dockable(JDockingPanel jDockingPanel, JComponent jComponent, String string, JToolBar jToolBar) {
        super(new BorderLayout());
        this.setBorder(new ShadowBorder());
        this.mDockingPanel = jDockingPanel;
        this.mContent = jComponent;
        this.mHeader = new DockableHeader(this, string, jToolBar);
        this.mIsVisible = false;
        this.add((Component)this.mHeader, "North");
        this.add((Component)jComponent, "Center");
        this.mHeader.update(this.mIsSelected);
    }

    public void setContentMinimumSize(Dimension dimension) {
        this.mContent.setMinimumSize(dimension);
        this.mHeader.setMinimumSize(new Dimension(dimension.width, this.mHeader.getPreferredSize().height));
    }

    public String getTitle() {
        return this.mHeader.getTitle();
    }

    public DockableHeader getHeader() {
        return this.mHeader;
    }

    public JDockingPanel getDockingPanel() {
        return this.mDockingPanel;
    }

    public void setTitle(String string) {
        String string2 = this.getTitle();
        this.mHeader.setTitle(string);
        this.firePropertyChange("title", string2, string);
    }

    public JComponent borrowContent() {
        try {
            this.remove(this.mContent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.mContent;
    }

    public void endBorrowContent() {
        this.add((Component)this.mContent, "Center");
    }

    public JComponent getContent() {
        return this.mContent;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public boolean isMaximized() {
        return this.mDockingPanel.isMaximized();
    }

    protected void notifyVisibility(boolean bl) {
        this.mIsVisible = bl;
    }

    public boolean isVisibleDockable() {
        return this.mIsVisible;
    }

    public void setSelected(boolean bl) {
        if (this.mIsSelected != bl) {
            this.mIsSelected = bl;
            this.mHeader.update(bl);
            if (bl) {
                this.mContent.requestFocus();
            }
            this.firePropertyChange("selected", !bl, bl);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.mHeader != null) {
            this.mHeader.update(this.mIsSelected);
        }
    }

    public Component getDragHandle() {
        return this.mHeader;
    }

    public PopupProvider getPopupProvider() {
        return this.mHeader.getPopupProvider();
    }

    public void setPopupProvider(PopupProvider popupProvider) {
        this.mHeader.setPopupProvider(popupProvider);
    }
}

