/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class TextClipboardHandler {
    public static String pasteText() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null) {
            try {
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public static boolean copyText(String string) {
        boolean bl = false;
        try {
            TextSelection textSelection = new TextSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(textSelection, null);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private TextClipboardHandler() {
    }

    private static class TextSelection
    implements Transferable {
        private String data;

        public TextSelection(String string) {
            this.data = string;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.stringFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!DataFlavor.stringFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.data;
        }
    }
}

