/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.clipboard;

import com.actelion.research.chem.Depictor2D;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import com.actelion.research.chem.io.RXNFileCreator;
import com.actelion.research.chem.io.RXNFileParser;
import com.actelion.research.chem.name.StructureNameResolver;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.gui.clipboard.IClipboardHandler;
import com.actelion.research.gui.clipboard.ImageClipboardHandler;
import com.actelion.research.gui.clipboard.NativeClipboardAccessor;
import com.actelion.research.gui.clipboard.external.ChemDrawCDX;
import com.actelion.research.gui.dnd.MoleculeTransferable;
import com.actelion.research.gui.dnd.ReactionTransferable;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.wmf.WMF;
import com.actelion.research.gui.wmf.WMFGraphics2D;
import com.actelion.research.util.Platform;
import com.actelion.research.util.Sketch;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;

public class ClipboardHandler
implements IClipboardHandler {
    private static final byte[] MDLSK = new byte[]{77, 68, 76, 83, 75, 0, 0};

    @Override
    public ArrayList<StereoMolecule> pasteMolecules() {
        return this.pasteMolecules(true, true, 1);
    }

    @Override
    public StereoMolecule pasteMolecule() {
        return this.pasteMolecule(true, 1);
    }

    @Override
    public StereoMolecule pasteMolecule(boolean bl, int n) {
        ArrayList<StereoMolecule> arrayList = this.pasteMolecules(bl, false, n);
        return arrayList.size() == 0 ? null : arrayList.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<StereoMolecule> pasteMolecules(boolean bl, boolean bl2, int n) {
        StereoMolecule stereoMolecule;
        ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>();
        StereoMolecule stereoMolecule2 = stereoMolecule = Platform.isWindows() ? this.pasteMoleculeWindowsNative(bl) : this.pasteMoleculeLinux();
        if (stereoMolecule != null) {
            arrayList.add(stereoMolecule);
        }
        if (arrayList.size() == 0) {
            void var7_9;
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            Object object = null;
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (var7_9 != null) {
                try {
                    stereoMolecule = new MolfileParser().getCompactMolecule((String)var7_9);
                    if (stereoMolecule != null && stereoMolecule.getAllAtoms() != 0) {
                        arrayList.add(stereoMolecule);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList<String> arrayList2 = null;
                if (arrayList.size() == 0) {
                    boolean bl3 = true;
                    int n2 = -1;
                    BufferedReader bufferedReader = new BufferedReader(new StringReader((String)var7_9));
                    try {
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            string = string.trim();
                            if (bl3) {
                                String[] stringArray = string.split("\\t");
                                for (int i = 0; i < stringArray.length; ++i) {
                                    if (!stringArray[i].endsWith("[idcode]")) continue;
                                    n2 = i;
                                    break;
                                }
                                bl3 = false;
                                if (n2 != -1) continue;
                            }
                            try {
                                void var13_28;
                                String[] stringArray;
                                String string2 = string;
                                if (n2 != -1 && n2 < (stringArray = string.split("\\t")).length) {
                                    String string3 = stringArray[n2];
                                }
                                stereoMolecule = new IDCodeParser(bl).getCompactMolecule((String)var13_28);
                            }
                            catch (Exception exception) {
                                stereoMolecule = null;
                            }
                            if (stereoMolecule == null || stereoMolecule.getAllAtoms() == 0) {
                                stereoMolecule = new StereoMolecule();
                                try {
                                    new SmilesParser(n, false).parse(stereoMolecule, string);
                                }
                                catch (Exception exception) {
                                    stereoMolecule = null;
                                }
                            }
                            if (stereoMolecule == null || stereoMolecule.getAllAtoms() == 0) {
                                stereoMolecule = StructureNameResolver.resolveLocal(string);
                            }
                            if (!(stereoMolecule != null && stereoMolecule.getAllAtoms() != 0 || bl2)) {
                                stereoMolecule = StructureNameResolver.resolveRemote(string);
                            }
                            if (stereoMolecule != null && stereoMolecule.getAllAtoms() != 0) {
                                arrayList.add(stereoMolecule);
                                if (!bl2) {
                                    break;
                                }
                            } else if (bl2) {
                                if (arrayList2 == null) {
                                    arrayList2 = new ArrayList<String>();
                                }
                                arrayList2.add(string);
                            }
                            string = bufferedReader.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (arrayList2 != null && arrayList2.size() != 0) {
                    String[] stringArray;
                    for (String string : stringArray = StructureNameResolver.resolveRemote(arrayList2.toArray(new String[0]))) {
                        try {
                            stereoMolecule = new IDCodeParser(bl).getCompactMolecule(string);
                            if (stereoMolecule == null || stereoMolecule.getAllAtoms() == 0) continue;
                            arrayList.add(stereoMolecule);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (bl) {
            for (StereoMolecule stereoMolecule3 : arrayList) {
                if (!stereoMolecule3.is3D()) continue;
                stereoMolecule3.ensureHelperArrays(15);
                new CoordinateInventor().invent(stereoMolecule3);
            }
        }
        System.out.println("returned mol(s): " + arrayList.size());
        return arrayList;
    }

    private StereoMolecule pasteMoleculeWindowsNative(boolean bl) {
        Object object;
        Object object2;
        StereoMolecule stereoMolecule = null;
        byte[] byArray = NativeClipboardAccessor.getClipboardData("ACT_MOLECULE");
        if (byArray != null) {
            try {
                object2 = new ObjectInputStream(new ByteArrayInputStream(byArray));
                object = ((ObjectInputStream)object2).readObject();
                if (object instanceof StereoMolecule) {
                    stereoMolecule = (StereoMolecule)object;
                }
                ((ObjectInputStream)object2).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Parsing NC_SERIALIZEMOLECULE during clipboard paste: Exception " + exception);
            }
        }
        System.out.println("Mol is " + stereoMolecule);
        if (stereoMolecule == null) {
            byArray = NativeClipboardAccessor.getClipboardData("MDLCT");
            if (!(byArray == null && (byArray = NativeClipboardAccessor.getClipboardData("MDL_MOL")) == null || ((MolfileParser)(object2 = new MolfileParser())).parse(stereoMolecule = new StereoMolecule(), new String(byArray)))) {
                stereoMolecule = null;
                System.out.println("Error Parsing CTAB during clipboard paste");
            }
            if (stereoMolecule == null && ((byArray = NativeClipboardAccessor.getClipboardData("MDLSK")) != null || (byArray = NativeClipboardAccessor.getClipboardData("MDLSK_EMBEDDED")) != null)) {
                try {
                    stereoMolecule = new StereoMolecule();
                    if (!Sketch.createMolFromSketchBuffer(stereoMolecule, byArray)) {
                        stereoMolecule = null;
                    }
                }
                catch (IOException iOException) {
                    stereoMolecule = null;
                    iOException.printStackTrace();
                    System.out.println("Parsing NC_SKETCH during clipboard paste: Exception " + iOException);
                }
            }
        }
        object2 = null;
        if (stereoMolecule == null && (byArray = NativeClipboardAccessor.getClipboardData("IDCODE")) != null) {
            object2 = new String(byArray);
            try {
                stereoMolecule = new StereoMolecule();
                object = new IDCodeParser(bl);
                ((IDCodeParserWithoutCoordinateInvention)object).parse(stereoMolecule, byArray);
                if (stereoMolecule.getAllAtoms() == 0) {
                    stereoMolecule = null;
                } else {
                    System.out.printf("NC_IDCODE '%s' successfully interpreted as idcode\n", object2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.printf("NC_IDCODE '%s' could not be parsed: " + exception + "\n", object2);
                stereoMolecule = null;
            }
        }
        return stereoMolecule;
    }

    private StereoMolecule pasteMoleculeLinux() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            return (StereoMolecule)transferable.getTransferData(ChemistryFlavors.DF_SERIALIZED_MOLECULE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Reaction pasteReaction() {
        Reaction reaction;
        Reaction reaction2 = reaction = Platform.isWindows() ? this.pasteReactionWindowsNative() : this.pasteReactionLinux();
        if (reaction == null) {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            String string = null;
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null) {
                try {
                    reaction = ReactionEncoder.decode(string, true);
                    if (reaction != null && reaction.isEmpty()) {
                        reaction = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (reaction == null) {
                    try {
                        reaction = new RXNFileParser().getReaction(string);
                        if (reaction != null && reaction.isEmpty()) {
                            reaction = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (reaction == null) {
                    try {
                        reaction = new SmilesParser().parseReaction(string);
                        if (reaction != null && reaction.isEmpty()) {
                            reaction = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return reaction;
    }

    public Reaction pasteReactionWindowsNative() {
        Reaction reaction = null;
        byte[] byArray = NativeClipboardAccessor.getClipboardData("ACT_REACTION");
        if (byArray != null) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                Object object = objectInputStream.readObject();
                if (object instanceof Reaction) {
                    reaction = (Reaction)object;
                }
                objectInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("ClipboardHandler.pasteReaction(): Exception " + exception);
            }
        } else {
            byArray = NativeClipboardAccessor.getClipboardData("MDLCT");
            if (byArray != null) {
                RXNFileParser rXNFileParser = new RXNFileParser();
                reaction = new Reaction();
                try {
                    if (!rXNFileParser.parse(reaction, new String(byArray))) {
                        reaction = null;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Error parsing Reaction Buffer " + exception);
                    reaction = null;
                }
            } else {
                byArray = NativeClipboardAccessor.getClipboardData("MDLSK");
                if (byArray != null) {
                    try {
                        reaction = new Reaction();
                        if (!Sketch.createReactionFromSketchBuffer(reaction, byArray)) {
                            reaction = null;
                        }
                    }
                    catch (IOException iOException) {
                        reaction = null;
                    }
                }
            }
        }
        return reaction;
    }

    private Reaction pasteReactionLinux() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            return (Reaction)transferable.getTransferData(ChemistryFlavors.DF_SERIALIZED_REACTION);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean copyMolecule(String string) {
        StereoMolecule stereoMolecule = new StereoMolecule();
        MolfileParser molfileParser = new MolfileParser();
        molfileParser.parse(stereoMolecule, string);
        return this.copyMolecule(stereoMolecule);
    }

    @Override
    public boolean copyMolecule(StereoMolecule stereoMolecule) {
        if (!Platform.isWindows()) {
            MoleculeTransferable moleculeTransferable = new MoleculeTransferable(stereoMolecule);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(moleculeTransferable, moleculeTransferable);
            return true;
        }
        boolean bl = false;
        try {
            StereoMolecule stereoMolecule2 = stereoMolecule.getCompactCopy();
            for (int i = 0; i < stereoMolecule2.getAllAtoms(); ++i) {
                stereoMolecule2.setAtomMapNo(i, 0, false);
            }
            byte[] byArray = Sketch.createSketchFromMol(stereoMolecule2);
            File file = File.createTempFile("actnca", ".wmf");
            file.deleteOnExit();
            String string = null;
            if (this.writeMol2Metafile(file, stereoMolecule2, byArray)) {
                string = file.getAbsolutePath();
            }
            System.out.println("CopyMolecule");
            ChemDrawCDX chemDrawCDX = new ChemDrawCDX();
            byte[] byArray2 = chemDrawCDX.getChemDrawBuffer(stereoMolecule2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(stereoMolecule);
            objectOutputStream.close();
            byteArrayOutputStream.close();
            bl = NativeClipboardAccessor.copyMoleculeToClipboard(string, byArray2, byteArrayOutputStream.toByteArray());
            file.delete();
        }
        catch (IOException iOException) {
            System.err.println("ClipboardHandler: Exception copying Molecule " + iOException);
        }
        return bl;
    }

    @Override
    public boolean copyReaction(Reaction reaction) {
        if (!Platform.isWindows()) {
            ReactionTransferable reactionTransferable = new ReactionTransferable(reaction);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(reactionTransferable, reactionTransferable);
            return true;
        }
        boolean bl = false;
        try {
            bl = this.copyReactionToClipboard(null, reaction);
        }
        catch (IOException iOException) {
            System.err.println("ClipboardHandler: Exception Copying Reaction " + iOException);
        }
        return bl;
    }

    private Reaction makeRXNCopy(Reaction reaction) {
        Reaction reaction2 = new Reaction(reaction);
        int n = reaction2.getMolecules();
        for (int i = 0; i < n; ++i) {
            reaction2.getMolecule(i).ensureHelperArrays(31);
        }
        return reaction2;
    }

    @Override
    public boolean copyReaction(String string) {
        boolean bl = false;
        try {
            Reaction reaction = new Reaction();
            RXNFileParser rXNFileParser = new RXNFileParser();
            rXNFileParser.parse(reaction, string);
            bl = this.copyReactionToClipboard(string, reaction);
        }
        catch (IOException iOException) {
            System.err.println("ClipboardHandler: Exception copying reaction " + iOException);
        }
        catch (Exception exception) {
            System.err.println("ClipboardHandler: Exception copying reaction " + exception);
        }
        return bl;
    }

    private boolean copyReactionToClipboard(String string, Reaction reaction) throws IOException {
        Object object;
        if (string == null) {
            object = new RXNFileCreator(reaction);
            string = ((RXNFileCreator)object).getRXNfile();
        }
        object = new ChemDrawCDX();
        byte[] byArray = ((ChemDrawCDX)object).getChemDrawBuffer(reaction);
        System.out.println("copyReactionToClipboard");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(reaction);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return NativeClipboardAccessor.copyReactionToClipboard(string.getBytes(), byArray, byteArrayOutputStream.toByteArray());
    }

    private boolean writeMol2Metafile(File file, StereoMolecule stereoMolecule, byte[] byArray) {
        boolean bl = false;
        try {
            bl = this.writeMol2Metafile(new FileOutputStream(file), stereoMolecule, byArray);
        }
        catch (Exception exception) {
            System.err.println("ClipboardHandler: Exception writing molfile " + exception);
            exception.printStackTrace();
        }
        return bl;
    }

    private boolean writeMol2Metafile(OutputStream outputStream, StereoMolecule stereoMolecule, byte[] byArray) throws IOException {
        int n = 300;
        int n2 = 200;
        WMF wMF = new WMF();
        WMFGraphics2D wMFGraphics2D = new WMFGraphics2D(wMF, n, n2, Color.black, Color.white);
        Depictor2D depictor2D = new Depictor2D(stereoMolecule);
        depictor2D.updateCoords(wMFGraphics2D, new GenericRectangle(0.0, 0.0, n, n2), 65536);
        depictor2D.paint(wMFGraphics2D);
        if (byArray != null) {
            byte[] byArray2 = new byte[MDLSK.length + byArray.length];
            System.arraycopy(MDLSK, 0, byArray2, 0, MDLSK.length);
            System.arraycopy(byArray, 0, byArray2, MDLSK.length, byArray.length);
            wMF.escape(15, byArray2);
        }
        wMF.writeWMF(outputStream);
        outputStream.close();
        return true;
    }

    public static boolean setClipBoardData(String string, byte[] byArray) {
        if (Platform.isWindows()) {
            return NativeClipboardAccessor.setClipBoardData(string, byArray);
        }
        return false;
    }

    public static boolean copyMetaFile(byte[] byArray) {
        return Platform.isWindows() ? ClipboardHandler.setClipBoardData("CF_METAFILEPICT", byArray) : false;
    }

    @Override
    public boolean copyImage(Image image) {
        return ImageClipboardHandler.copyImage(image);
    }

    @Override
    public Image pasteImage() {
        return ImageClipboardHandler.pasteImage();
    }

    public static Image getImage() {
        return ImageClipboardHandler.pasteImage();
    }

    public static void putImage(Image image) {
        ImageClipboardHandler.copyImage(image);
    }
}

