/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.gui.PruningBarEvent;
import com.actelion.research.gui.PruningBarListener;
import com.actelion.research.gui.swing.SwingUIHelper;
import com.actelion.research.util.ColorHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JPruningBar
extends JPanel
implements MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 537330439L;
    private static final Color cShadowColor = new Color(153, 153, 153);
    private static final Color cDarkShadowColor = new Color(102, 102, 102);
    private static final Color cThumbColor = new Color(153, 153, 204);
    private static final Color cThumbShadowColor = new Color(102, 102, 153);
    private static final Color cThumbHighlightColor = new Color(204, 204, 255);
    private static final Color[] cWaterBlueColor = new Color[]{new Color(188, 216, 248), new Color(184, 215, 247), new Color(170, 205, 245), new Color(150, 194, 242), new Color(116, 172, 235), new Color(138, 190, 243), new Color(146, 196, 247), new Color(155, 203, 252), new Color(164, 208, 255), new Color(170, 215, 255), new Color(177, 223, 255), new Color(193, 235, 255), new Color(207, 245, 255), new Color(207, 255, 255)};
    private static final Color[] cWaterRedColor = new Color[]{new Color(255, 189, 219), new Color(247, 189, 215), new Color(247, 173, 207), new Color(247, 148, 195), new Color(239, 115, 174), new Color(247, 140, 190), new Color(247, 148, 199), new Color(255, 156, 203), new Color(255, 165, 211), new Color(255, 173, 215), new Color(255, 181, 223), new Color(255, 198, 235), new Color(255, 206, 247), new Color(255, 206, 255)};
    private static final int cOverallWidth = 16;
    private static final int cThumbHeight = 14;
    private static final int cBorder = 2;
    private float mLowValue;
    private float mMinValue;
    private float mHighValue;
    private float mMaxValue;
    private float mSegmentSize;
    private boolean mIsHorizontal;
    private boolean mUpdateNeeded;
    private boolean mUseRedColor;
    private boolean mAllowDoubleClickChange;
    private boolean mWasDragged;
    private int mID;
    private int mMousePosition;
    private int mClickedArea;
    private int mPosition1;
    private int mPosition2;
    private ArrayList<PruningBarListener> mListener;

    public JPruningBar() {
        this(0.0f, 100.0f, true, 0, false);
    }

    public JPruningBar(boolean bl) {
        this(0.0f, 100.0f, bl, 0, false);
    }

    public JPruningBar(boolean bl, int n) {
        this(0.0f, 100.0f, bl, n, false);
    }

    public JPruningBar(float f, float f2, boolean bl, int n) {
        this(f, f2, bl, n, false);
    }

    public JPruningBar(float f, float f2, boolean bl, int n, boolean bl2) {
        this.init();
        this.mMinValue = f;
        this.mLowValue = f;
        this.mHighValue = f2;
        this.mMaxValue = f2;
        this.mIsHorizontal = bl;
        this.mID = n;
        this.mAllowDoubleClickChange = bl2;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (this.mUpdateNeeded) {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.mIsHorizontal) {
                n4 = 2;
                n3 = dimension.width - 2 - 1;
                n2 = (dimension.height - 16) / 2;
                n = n2 + 16 - 1;
            } else {
                n4 = (dimension.width - 16) / 2;
                n3 = n4 + 16 - 1;
                n2 = 2;
                n = dimension.height - 2 - 1;
            }
            this.setColor(graphics, cShadowColor);
            graphics.drawLine(n4 + 1, n2 + 1, n4 + 1, n - 1);
            graphics.drawLine(n4 + 1, n2 + 1, n3 - 1, n2 + 1);
            int n5 = this.mIsHorizontal ? n3 - n4 : n - n2;
            float f = this.mMaxValue - this.mMinValue;
            this.mSegmentSize = f / (float)(n5 -= 30);
            if (this.mIsHorizontal) {
                this.mPosition1 = (int)((this.mLowValue - this.mMinValue + this.mSegmentSize / 2.0f) / this.mSegmentSize) + 1;
                this.mPosition2 = (int)((this.mHighValue - this.mMinValue + this.mSegmentSize / 2.0f) / this.mSegmentSize) + 1 + 14 + 1;
            } else {
                this.mPosition1 = (int)((this.mMaxValue - this.mHighValue + this.mSegmentSize / 2.0f) / this.mSegmentSize) + 1;
                this.mPosition2 = (int)((this.mMaxValue - this.mLowValue + this.mSegmentSize / 2.0f) / this.mSegmentSize) + 1 + 14 + 1;
            }
            this.drawThumb(graphics, n4, n2, this.mPosition1);
            this.drawThumb(graphics, n4, n2, this.mPosition2);
            if (this.mPosition2 > this.mPosition1 + 14 + 2) {
                int n6 = this.mPosition1 + 14 + 1;
                int n7 = this.mPosition2 - 2;
                for (int i = 0; i < 14; ++i) {
                    this.setColor(graphics, this.mUseRedColor ? cWaterRedColor[i] : cWaterBlueColor[i]);
                    if (this.mIsHorizontal) {
                        graphics.drawLine(n4 + n6, n2 + i + 1, n4 + n7, n2 + i + 1);
                        continue;
                    }
                    graphics.drawLine(n4 + i + 1, n2 + n6, n4 + i + 1, n2 + n7);
                }
            }
            this.setColor(graphics, cDarkShadowColor);
            graphics.drawRect(n4, n2, n3 - n4, n - n2);
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public float getLowValue() {
        return this.mLowValue;
    }

    public float getHighValue() {
        return this.mHighValue;
    }

    public float getMaximumValue() {
        return this.mMaxValue;
    }

    public float getMinimumValue() {
        return this.mMinValue;
    }

    public void reset() {
        boolean bl = this.setHigh(this.mMaxValue);
        boolean bl2 = this.setLow(this.mMinValue);
        if (bl || bl2) {
            this.informListeners(false);
            this.mUpdateNeeded = true;
            this.repaint();
        }
    }

    public void setLowAndHigh(float f, float f2, boolean bl) {
        if (f < this.mMinValue) {
            f = this.mMinValue;
        }
        if (f2 > this.mMaxValue) {
            f2 = this.mMaxValue;
        }
        if ((f != this.mLowValue || f2 != this.mHighValue) && f <= f2) {
            this.mLowValue = f;
            this.mHighValue = f2;
            if (!bl) {
                this.informListeners(false);
            }
            this.mUpdateNeeded = true;
            this.repaint();
        }
    }

    public void setLowValue(float f) {
        if (this.setLow(f)) {
            this.informListeners(false);
            this.mUpdateNeeded = true;
            this.repaint();
        }
    }

    public void setID(int n) {
        this.mID = n;
    }

    public void setHighValue(float f) {
        if (this.setHigh(f)) {
            this.informListeners(false);
            this.mUpdateNeeded = true;
            this.repaint();
        }
    }

    public void setMaximumValue(float f) {
        if (f < this.mMinValue) {
            f = this.mMinValue;
        }
        if (this.mMaxValue != f) {
            this.mMaxValue = f;
            if (this.mHighValue > this.mMaxValue) {
                this.mHighValue = this.mMaxValue;
            }
            if (this.mLowValue > this.mHighValue) {
                this.mLowValue = this.mHighValue;
            }
            this.informListeners(false);
            this.mUpdateNeeded = true;
            this.repaint();
        }
    }

    public void setMinimumValue(float f) {
        if (f > this.mMaxValue) {
            f = this.mMaxValue;
        }
        if (this.mMinValue != f) {
            this.mMinValue = f;
            if (this.mLowValue < this.mMinValue) {
                this.mLowValue = this.mMinValue;
            }
            if (this.mHighValue < this.mLowValue) {
                this.mHighValue = this.mLowValue;
            }
            this.informListeners(false);
            this.mUpdateNeeded = true;
            this.repaint();
        }
    }

    public void setMinAndMax(float f, float f2) {
        this.mLowValue = this.mMinValue = f;
        this.mHighValue = this.mMaxValue = f2;
        this.mUpdateNeeded = true;
        this.repaint();
    }

    public void setUseRedColor(boolean bl) {
        if (this.mUseRedColor != bl) {
            this.mUseRedColor = bl;
            this.mUpdateNeeded = true;
            this.repaint();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.mIsHorizontal) {
            return new Dimension(56, 20);
        }
        return new Dimension(20, 56);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mIsHorizontal) {
            return new Dimension(100, 20);
        }
        return new Dimension(20, 100);
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.mIsHorizontal) {
            return new Dimension(Short.MAX_VALUE, 20);
        }
        return new Dimension(20, Short.MAX_VALUE);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.mMousePosition = this.mIsHorizontal ? mouseEvent.getX() : mouseEvent.getY();
        this.mWasDragged = false;
        this.mClickedArea = 0;
        this.mClickedArea = this.mMousePosition < this.mPosition1 ? 0 : (this.mMousePosition <= this.mPosition1 + 14 ? 1 : (this.mMousePosition <= this.mPosition2 ? 2 : (this.mMousePosition <= this.mPosition2 + 14 ? 3 : 0)));
        if (!(this.mIsHorizontal || this.mClickedArea != 1 && this.mClickedArea != 3)) {
            this.mClickedArea = 4 - this.mClickedArea;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mWasDragged) {
            this.informListeners(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Window window;
        if (this.mAllowDoubleClickChange && mouseEvent.getClickCount() == 2 && (this.mClickedArea == 1 || this.mClickedArea == 3) && (window = SwingUIHelper.getWindow(this)) != null) {
            try {
                String string = JOptionPane.showInputDialog(window, "Please type in a value!", "Set Value", 3);
                if (string != null) {
                    float f = Float.parseFloat(string);
                    if (this.mClickedArea == 1) {
                        this.informListeners(f, Float.NaN);
                    } else if (this.mClickedArea == 3) {
                        this.informListeners(Float.NaN, f);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = this.mIsHorizontal ? mouseEvent.getX() : mouseEvent.getY();
        if (n == this.mMousePosition) {
            return;
        }
        this.mWasDragged = true;
        float f = this.mSegmentSize * (float)(n - this.mMousePosition);
        if (!this.mIsHorizontal) {
            f = -f;
        }
        if (mouseEvent.isControlDown()) {
            f = (float)((double)f / 10.0);
        }
        boolean bl = false;
        switch (this.mClickedArea) {
            case 1: {
                if ((double)f < 0.0 && this.mLowValue > this.mMinValue || (double)f > 0.0 && this.mLowValue < this.mHighValue) {
                    bl = true;
                }
                if (this.mLowValue + f < this.mMinValue) {
                    this.mLowValue = this.mMinValue;
                    break;
                }
                if (this.mLowValue + f > this.mHighValue) {
                    this.mLowValue = this.mHighValue;
                    break;
                }
                this.mLowValue += f;
                break;
            }
            case 2: {
                if ((double)f < 0.0 && this.mLowValue > this.mMinValue || (double)f > 0.0 && this.mHighValue < this.mMaxValue) {
                    bl = true;
                }
                if (this.mLowValue + f < this.mMinValue) {
                    this.mHighValue -= this.mLowValue - this.mMinValue;
                    this.mLowValue = this.mMinValue;
                    break;
                }
                if (this.mHighValue + f > this.mMaxValue) {
                    this.mLowValue += this.mMaxValue - this.mHighValue;
                    this.mHighValue = this.mMaxValue;
                    break;
                }
                this.mLowValue += f;
                this.mHighValue += f;
                break;
            }
            case 3: {
                if ((double)f < 0.0 && this.mHighValue > this.mLowValue || (double)f > 0.0 && this.mHighValue < this.mMaxValue) {
                    bl = true;
                }
                if (this.mHighValue + f > this.mMaxValue) {
                    this.mHighValue = this.mMaxValue;
                    break;
                }
                if (this.mHighValue + f < this.mLowValue) {
                    this.mHighValue = this.mLowValue;
                    break;
                }
                this.mHighValue += f;
            }
        }
        if (bl) {
            this.informListeners(true);
            this.mMousePosition = n;
            this.mUpdateNeeded = true;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void addPruningBarListener(PruningBarListener pruningBarListener) {
        this.mListener.add(pruningBarListener);
    }

    public void removePruningBarListener(PruningBarListener pruningBarListener) {
        this.mListener.remove(pruningBarListener);
    }

    public void firePruningBarChanged() {
        this.informListeners(false);
    }

    private void drawThumb(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        this.setColor(graphics, cThumbColor);
        if (this.mIsHorizontal) {
            graphics.fillRect(n + n3 + 1, n2 + 2, 13, 13);
            n7 = n + n3 + 2;
            n6 = n2 + 3;
        } else {
            graphics.fillRect(n + 2, n2 + n3 + 1, 13, 13);
            n7 = n + 3;
            n6 = n2 + n3 + 2;
        }
        this.setColor(graphics, cThumbHighlightColor);
        if (this.mIsHorizontal) {
            graphics.drawLine(n + n3, n2 + 1, n + n3 + 14 - 2, n2 + 1);
            graphics.drawLine(n + n3, n2 + 1, n + n3, n2 + 16 - 2);
        } else {
            graphics.drawLine(n + 1, n2 + n3, n + 1, n2 + n3 + 14 - 2);
            graphics.drawLine(n + 1, n2 + n3, n + 16 - 2, n2 + n3);
        }
        for (n5 = 0; n5 < 5; ++n5) {
            for (n4 = 0; n4 < 5; ++n4) {
                if ((n5 + n4 & 1) != 0) continue;
                graphics.drawLine(n7 + n5 * 2, n6 + n4 * 2, n7 + n5 * 2, n6 + n4 * 2);
            }
        }
        this.setColor(graphics, cThumbShadowColor);
        if (this.mIsHorizontal) {
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + 16 - 2);
            graphics.drawLine(n + n3 + 14, n2 + 1, n + n3 + 14, n2 + 16 - 2);
        } else {
            graphics.drawLine(n + 1, n2 + n3 - 1, n + 16 - 2, n2 + n3 - 1);
            graphics.drawLine(n + 1, n2 + n3 + 14, n + 16 - 2, n2 + n3 + 14);
        }
        for (n5 = 0; n5 < 5; ++n5) {
            for (n4 = 0; n4 < 5; ++n4) {
                if ((n5 + n4 & 1) != 0) continue;
                graphics.drawLine(n7 + n5 * 2 + 1, n6 + n4 * 2 + 1, n7 + n5 * 2 + 1, n6 + n4 * 2 + 1);
            }
        }
    }

    private void setColor(Graphics graphics, Color color) {
        graphics.setColor(this.isEnabled() ? color : ColorHelper.intermediateColor(color, Color.LIGHT_GRAY, 0.7f));
    }

    private void init() {
        this.setOpaque(false);
        this.mUpdateNeeded = true;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mListener = new ArrayList();
    }

    private boolean setHigh(float f) {
        if (f < this.mLowValue) {
            f = this.mLowValue;
        } else if (f > this.mMaxValue) {
            f = this.mMaxValue;
        }
        if (f == this.mHighValue) {
            return false;
        }
        this.mHighValue = f;
        return true;
    }

    private boolean setLow(float f) {
        if (f < this.mMinValue) {
            f = this.mMinValue;
        } else if (f > this.mHighValue) {
            f = this.mHighValue;
        }
        if (f == this.mLowValue) {
            return false;
        }
        this.mLowValue = f;
        return true;
    }

    private void informListeners(float f, float f2) {
        for (int i = 0; i < this.mListener.size(); ++i) {
            this.mListener.get(i).pruningBarChanged(new PruningBarEvent(this, f, f2, false, this.mID, 2));
        }
    }

    private void informListeners(boolean bl) {
        for (int i = 0; i < this.mListener.size(); ++i) {
            this.mListener.get(i).pruningBarChanged(new PruningBarEvent(this, this.mLowValue, this.mHighValue, bl, this.mID, 1));
        }
    }
}

