/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction.mapping;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.CanonizerBaseValue;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.mapping.RootAtomPair;
import com.actelion.research.chem.reaction.mapping.RootAtomPairDecisionHelper;
import com.actelion.research.util.ByteArrayComparator;
import com.actelion.research.util.IntArrayComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.TreeSet;

public class RootAtomPairSource {
    private static final int MAX_PAIR_SEQUENCES = 64;
    private static final int MAX_ENVIRONMENT_RADIUS = 7;
    private static final int MIN_ENVIRONMENT_RADIUS = 2;
    private static final int PSEUDO_MAP_NO_SKIPPED_PAIR = -99999;
    private ArrayList<RootAtomPair> mPairBuffer;
    private StereoMolecule mReactant;
    private StereoMolecule mProduct;
    private Canonizer mReactantCanonizer;
    private Canonizer mProductCanonizer;
    private CanonizerBaseValue[] mCanBase;
    private int mSequenceCount;
    private int mCurrentRadius;
    private int mManualMapCount;
    private int mMappableAtomCount;
    private int mCurrentEnvIndex0;
    private int mCurrentEnvIndex1;
    private int mCurrentEnvIndex2;
    private int mCurrentEnvIndex3;
    private RootAtomPairDecisionHelper mDecisionHelper;
    private boolean mIsStoichiometric;
    private int[] mReactantRank;
    private int[] mProductRank;
    private int[] mReactantFragmentNo;
    private int[] mProductFragmentNo;
    private int[] mReactantMapNo;
    private int[] mProductMapNo;
    private int mAtomBits;
    private int mMaxConnAtoms;
    private int mHighestReactionRank;
    private int mHighestProductRank;
    private boolean[] mReactantFragmentUsed;
    private boolean[] mProductFragmentUsed;
    private TreeMap<byte[], int[][]>[] mEnvToAtomsMap;
    private byte[][][] mEnvKey;

    public RootAtomPairSource(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int[] nArray, int[] nArray2) {
        this.mReactant = stereoMolecule;
        this.mProduct = stereoMolecule2;
        this.mReactantMapNo = nArray;
        this.mProductMapNo = nArray2;
        this.initializeAtomRanking();
        this.initializeRanks();
        this.mEnvToAtomsMap = this.buildEnvToAtomMaps();
        this.mEnvKey = this.getEnvKeys(this.mEnvToAtomsMap);
        this.mMappableAtomCount = 0;
        for (byte[] byArray : this.mEnvToAtomsMap[0].keySet()) {
            int[][] nArray3 = this.mEnvToAtomsMap[0].get(byArray);
            this.mMappableAtomCount += Math.min(nArray3[0].length, nArray3[1].length);
        }
        this.mIsStoichiometric = this.mMappableAtomCount == this.mReactant.getAtoms() && this.mReactant.getAtoms() == this.mProduct.getAtoms();
        this.mReactantFragmentNo = new int[this.mReactant.getAtoms()];
        this.mProductFragmentNo = new int[this.mProduct.getAtoms()];
        this.mReactantFragmentUsed = new boolean[this.mReactant.getFragmentNumbers(this.mReactantFragmentNo, false, false)];
        this.mProductFragmentUsed = new boolean[this.mProduct.getFragmentNumbers(this.mProductFragmentNo, false, false)];
        this.mManualMapCount = this.assignManuallyMappedPairs();
        this.mCurrentRadius = 7;
        this.mSequenceCount = 0;
    }

    private void initializeAtomRanking() {
        int n;
        int n2 = Math.max(this.mReactant.getAtoms(), this.mProduct.getAtoms());
        this.mAtomBits = Canonizer.getNeededBits(n2);
        this.mMaxConnAtoms = 2;
        for (n = 0; n < this.mReactant.getAtoms(); ++n) {
            this.mMaxConnAtoms = Math.max(this.mMaxConnAtoms, this.mReactant.getConnAtoms(n) + this.mReactant.getMetalBondedConnAtoms(n));
        }
        for (n = 0; n < this.mProduct.getAtoms(); ++n) {
            this.mMaxConnAtoms = Math.max(this.mMaxConnAtoms, this.mProduct.getConnAtoms(n) + this.mProduct.getMetalBondedConnAtoms(n));
        }
        n = Math.max(2, (62 + this.mAtomBits + this.mMaxConnAtoms * (this.mAtomBits + 5)) / 63);
        this.mCanBase = new CanonizerBaseValue[n2];
        for (int i = 0; i < n2; ++i) {
            this.mCanBase[i] = new CanonizerBaseValue(n);
        }
        this.mReactantCanonizer = new Canonizer(this.mReactant, 1);
        this.mProductCanonizer = new Canonizer(this.mProduct, 1);
    }

    private void initializeRanks() {
        this.mReactantRank = (int[])this.mReactantCanonizer.getSymmetryRanks().clone();
        this.mProductRank = (int[])this.mProductCanonizer.getSymmetryRanks().clone();
        for (int n : this.mReactantRank) {
            if (this.mHighestReactionRank >= n) continue;
            this.mHighestReactionRank = n;
        }
        for (int n : this.mProductRank) {
            if (this.mHighestProductRank >= n) continue;
            this.mHighestProductRank = n;
        }
    }

    private void reset() {
        Arrays.fill(this.mReactantMapNo, 0);
        Arrays.fill(this.mProductMapNo, 0);
        Arrays.fill(this.mReactantFragmentUsed, false);
        Arrays.fill(this.mProductFragmentUsed, false);
        this.initializeRanks();
        this.mDecisionHelper.reset();
        this.mManualMapCount = this.assignManuallyMappedPairs();
        this.mCurrentRadius = 7;
        this.mCurrentEnvIndex0 = 0;
        this.mCurrentEnvIndex1 = 0;
        this.mCurrentEnvIndex2 = 0;
        this.mCurrentEnvIndex3 = 0;
    }

    public int getMappableAtomCount() {
        return this.mMappableAtomCount;
    }

    public int getManualMapCount() {
        return this.mManualMapCount;
    }

    public boolean hasNextPairSequence() {
        if (this.mSequenceCount++ == 64) {
            return false;
        }
        if (this.mDecisionHelper == null) {
            this.mDecisionHelper = new RootAtomPairDecisionHelper();
            return true;
        }
        if (this.mDecisionHelper.isComplete()) {
            return false;
        }
        this.reset();
        return true;
    }

    private byte[][][] classifyAtomEnvironment(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(7);
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        byte[][][] byArray = new byte[stereoMolecule.getAtoms()][8][];
        int[] nArray = new int[stereoMolecule.getAtoms()];
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (i != 0) {
                Arrays.fill(blArray, false);
            }
            int n = 0;
            int n2 = 0;
            stereoMolecule.setAtomSelection(i, true);
            for (int j = 0; j <= 7 && n2 < stereoMolecule.getAtoms(); ++j) {
                int n3;
                if (n2 == 0) {
                    nArray[0] = i;
                    blArray[i] = true;
                    n2 = 1;
                } else {
                    n3 = n2;
                    for (int k = n; k < n2; ++k) {
                        int n4 = nArray[k];
                        for (int i2 = 0; i2 < stereoMolecule.getConnAtoms(n4); ++i2) {
                            int n5 = stereoMolecule.getConnAtom(n4, i2);
                            if (blArray[n5]) continue;
                            blArray[n5] = true;
                            nArray[n3++] = n5;
                        }
                    }
                    if (n3 == n2) break;
                    n = n2;
                    n2 = n3;
                }
                if (j == 0) {
                    byArray[i][j] = new byte[2];
                    byArray[i][j][0] = (byte)stereoMolecule.getAtomicNo(i);
                    byArray[i][j][1] = (byte)stereoMolecule.getAtomMass(i);
                    continue;
                }
                stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, null);
                for (n3 = 0; n3 < stereoMolecule2.getAllAtoms(); ++n3) {
                    stereoMolecule2.setAtomCharge(n3, 0);
                    stereoMolecule2.setAtomRadical(n3, 0);
                }
                byArray[i][j] = new Canonizer(stereoMolecule2, 16).getIDCode().getBytes();
            }
            stereoMolecule.setAtomSelection(i, false);
        }
        return byArray;
    }

    private TreeMap<byte[], int[][]>[] buildEnvToAtomMaps() {
        byte[][][] byArray = this.classifyAtomEnvironment(this.mReactant);
        byte[][][] byArray2 = this.classifyAtomEnvironment(this.mProduct);
        TreeMap[] treeMapArray = new TreeMap[8];
        TreeMap<byte[], int[]>[] treeMapArray2 = this.buildEnvToAtomMaps(this.mReactant, byArray);
        TreeMap<byte[], int[]>[] treeMapArray3 = this.buildEnvToAtomMaps(this.mProduct, byArray2);
        for (int i = 0; i <= 7; ++i) {
            treeMapArray[i] = new TreeMap(new ByteArrayComparator());
            for (byte[] byArray3 : treeMapArray2[i].keySet()) {
                int[] nArray = treeMapArray2[i].get(byArray3);
                int[] nArray2 = treeMapArray3[i].get(byArray3);
                if (nArray2 == null) continue;
                int[][] nArrayArray = new int[][]{nArray, nArray2};
                treeMapArray[i].put(byArray3, nArrayArray);
            }
        }
        return treeMapArray;
    }

    private TreeMap<byte[], int[]>[] buildEnvToAtomMaps(StereoMolecule stereoMolecule, byte[][][] byArray) {
        TreeMap[] treeMapArray = new TreeMap[8];
        for (int i = 0; i <= 7; ++i) {
            treeMapArray[i] = new TreeMap(new ByteArrayComparator());
            for (int j = 0; j < stereoMolecule.getAtoms(); ++j) {
                byte[] byArray2 = byArray[j][i];
                if (byArray2 == null) continue;
                int[] nArray = (int[])treeMapArray[i].get(byArray2);
                nArray = nArray == null ? new int[1] : Arrays.copyOf(nArray, nArray.length + 1);
                nArray[nArray.length - 1] = j;
                treeMapArray[i].put(byArray2, nArray);
            }
        }
        return treeMapArray;
    }

    private byte[][][] getEnvKeys(TreeMap<byte[], int[][]>[] treeMapArray) {
        byte[][][] byArrayArray = new byte[8][][];
        for (int i = 0; i <= 7; ++i) {
            byArrayArray[i] = new byte[treeMapArray[i].size()][];
            int n = 0;
            for (byte[] byArray : treeMapArray[i].keySet()) {
                byArrayArray[i][n++] = byArray;
            }
        }
        return byArrayArray;
    }

    private int assignManuallyMappedPairs() {
        this.mPairBuffer = new ArrayList();
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < this.mProduct.getAtoms(); ++i) {
            if (this.mProduct.getAtomMapNo(i) == 0 || this.mProduct.isAutoMappedAtom(i)) continue;
            n2 = Math.max(n2, this.mProduct.getAtomMapNo(i));
        }
        if (n2 != 0) {
            int n3;
            int[] nArray = new int[n2 + 1];
            for (n3 = 0; n3 < this.mProduct.getAtoms(); ++n3) {
                if (this.mProduct.getAtomMapNo(n3) == 0 || this.mProduct.isAutoMappedAtom(n3)) continue;
                nArray[this.mProduct.getAtomMapNo((int)n3)] = n3 + 1;
            }
            for (n3 = 0; n3 < this.mReactant.getAtoms(); ++n3) {
                int n4 = this.mReactant.getAtomMapNo(n3);
                if (n4 == 0 || n4 > n2 || this.mReactant.isAutoMappedAtom(n3) || nArray[n4] == 0) continue;
                int n5 = nArray[n4] - 1;
                this.mReactantMapNo[n3] = n;
                this.mProductMapNo[n5] = n++;
                this.mPairBuffer.add(new RootAtomPair(n3, n5));
            }
        }
        return this.mPairBuffer.size();
    }

    public RootAtomPair nextPair() {
        int n;
        RootAtomPair rootAtomPair = this.nextRawPair();
        while (rootAtomPair != null) {
            int n2;
            n = 0;
            for (n2 = 0; n2 < this.mReactant.getConnAtoms(rootAtomPair.reactantAtom); ++n2) {
                if (this.mReactantMapNo[this.mReactant.getConnAtom(rootAtomPair.reactantAtom, n2)] != 0) continue;
                n = 1;
            }
            n2 = 0;
            for (int i = 0; i < this.mProduct.getConnAtoms(rootAtomPair.productAtom); ++i) {
                if (this.mProductMapNo[this.mProduct.getConnAtom(rootAtomPair.productAtom, i)] != 0) continue;
                n2 = 1;
            }
            if (n != 0 && n2 != 0) break;
            this.mReactantMapNo[rootAtomPair.reactantAtom] = -99999;
            this.mProductMapNo[rootAtomPair.productAtom] = -99999;
            rootAtomPair = this.nextRawPair();
        }
        if (rootAtomPair == null) {
            for (n = 0; n < this.mReactantMapNo.length; ++n) {
                if (this.mReactantMapNo[n] != -99999) continue;
                this.mReactantMapNo[n] = 0;
            }
            for (n = 0; n < this.mProductMapNo.length; ++n) {
                if (this.mProductMapNo[n] != -99999) continue;
                this.mProductMapNo[n] = 0;
            }
        }
        return rootAtomPair;
    }

    private RootAtomPair nextRawPair() {
        Object object;
        while (this.mPairBuffer.size() != 0) {
            object = this.mPairBuffer.remove(0);
            if (this.mReactantMapNo[((RootAtomPair)object).reactantAtom] != 0 || this.mProductMapNo[((RootAtomPair)object).productAtom] != 0) continue;
            return object;
        }
        while (this.mCurrentRadius >= 0) {
            RootAtomPair rootAtomPair;
            int[][] nArray;
            while (this.mCurrentRadius >= 2 && this.mCurrentEnvIndex0 < this.mEnvKey[this.mCurrentRadius].length) {
                object = this.mEnvKey[this.mCurrentRadius][this.mCurrentEnvIndex0];
                nArray = this.mEnvToAtomsMap[this.mCurrentRadius].get(object);
                if (this.mReactant.getAtomicNo(nArray[0][0]) == 6 && (rootAtomPair = this.makePairsFromSimilarAtoms(nArray[0], nArray[1])) != null) {
                    return rootAtomPair;
                }
                ++this.mCurrentEnvIndex0;
            }
            while (this.mCurrentRadius >= 2 && this.mCurrentEnvIndex1 < this.mEnvKey[this.mCurrentRadius].length) {
                object = this.mEnvKey[this.mCurrentRadius][this.mCurrentEnvIndex1];
                nArray = this.mEnvToAtomsMap[this.mCurrentRadius].get(object);
                if (this.mReactant.getAtomicNo(nArray[0][0]) != 6 && (rootAtomPair = this.makePairsFromSimilarAtoms(nArray[0], nArray[1])) != null) {
                    return rootAtomPair;
                }
                ++this.mCurrentEnvIndex1;
            }
            while (this.mIsStoichiometric && this.mCurrentRadius == 0 && this.mCurrentEnvIndex2 < this.mEnvKey[0].length) {
                if ((nArray = this.mEnvToAtomsMap[this.mCurrentRadius].get(object = (Object)this.mEnvKey[0][this.mCurrentEnvIndex2++]))[0].length != 1 || nArray[1].length != 1 || (rootAtomPair = this.tryCreatePair(nArray[0][0], nArray[1][0])) == null) continue;
                return rootAtomPair;
            }
            while (this.mCurrentEnvIndex3 < this.mEnvKey[this.mCurrentRadius].length) {
                if ((nArray = this.mEnvToAtomsMap[this.mCurrentRadius].get(object = (Object)this.mEnvKey[this.mCurrentRadius][this.mCurrentEnvIndex3++]))[0].length == 1 && nArray[1].length == 1) {
                    RootAtomPair rootAtomPair2 = this.tryCreatePair(nArray[0][0], nArray[1][0]);
                    if (rootAtomPair2 == null) continue;
                    return rootAtomPair2;
                }
                if ((nArray[0].length < nArray[1].length || !this.areInDistinctEquivalentFragments(nArray[0], this.mReactantFragmentNo, this.mReactantFragmentUsed, this.mReactantRank)) && (nArray[1].length < nArray[0].length || !this.areInDistinctEquivalentFragments(nArray[1], this.mProductFragmentNo, this.mProductFragmentUsed, this.mProductRank))) continue;
                for (int i = 0; i < Math.min(nArray[0].length, nArray[1].length); ++i) {
                    RootAtomPair rootAtomPair3 = this.tryCreatePair(nArray[0][i], nArray[1][i]);
                    if (rootAtomPair3 == null) continue;
                    return rootAtomPair3;
                }
            }
            --this.mCurrentRadius;
            this.mCurrentEnvIndex0 = 0;
            this.mCurrentEnvIndex1 = 0;
            this.mCurrentEnvIndex2 = 0;
            this.mCurrentEnvIndex3 = 0;
        }
        return null;
    }

    private RootAtomPair makePairsFromSimilarAtoms(int[] nArray, int[] nArray2) {
        int[] nArray3 = this.getUnmappedAtoms(nArray, this.mReactantMapNo);
        if (nArray3 == null) {
            return null;
        }
        int[] nArray4 = this.getUnmappedAtoms(nArray2, this.mProductMapNo);
        if (nArray4 == null) {
            return null;
        }
        if (nArray3.length == 1 && nArray4.length == 1) {
            return new RootAtomPair(nArray3[0], nArray4[0]);
        }
        int[][] nArray5 = this.createDistinctRankPairs(nArray3, nArray4);
        if (nArray5.length == 1) {
            return new RootAtomPair(nArray3[0], nArray4[0]);
        }
        int n = this.mDecisionHelper.getNextChoice(nArray5.length);
        int n2 = -1;
        for (int n3 : nArray3) {
            if (this.mReactantRank[n3] != nArray5[n][0]) continue;
            n2 = n3;
            break;
        }
        int n4 = -1;
        for (int n5 : nArray4) {
            if (this.mProductRank[n5] != nArray5[n][1]) continue;
            n4 = n5;
            break;
        }
        this.mHighestReactionRank = this.elevateAtomRank(this.mReactant, this.mReactantRank, n2, this.mHighestReactionRank);
        this.mHighestProductRank = this.elevateAtomRank(this.mProduct, this.mProductRank, n4, this.mHighestProductRank);
        return new RootAtomPair(n2, n4);
    }

    private int[] getUnmappedAtoms(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int n2 : nArray) {
            if (nArray2[n2] != 0) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray3 = new int[n];
        n = 0;
        for (int n3 : nArray) {
            if (nArray2[n3] != 0) continue;
            nArray3[n++] = n3;
        }
        return nArray3;
    }

    private RootAtomPair tryCreatePair(int n, int n2) {
        if (this.mReactantMapNo[n] == 0 && this.mProductMapNo[n2] == 0) {
            return this.createPair(n, n2);
        }
        return null;
    }

    private RootAtomPair createPair(int n, int n2) {
        if (this.mProduct.getConnAtoms(n2) != 0) {
            this.mReactantFragmentUsed[this.mReactantFragmentNo[n]] = true;
        }
        if (this.mReactant.getConnAtoms(n) != 0) {
            this.mProductFragmentUsed[this.mProductFragmentNo[n2]] = true;
        }
        return new RootAtomPair(n, n2);
    }

    private int[][] createDistinctRankPairs(int[] nArray, int[] nArray2) {
        TreeSet<int[]> treeSet = new TreeSet<int[]>(new IntArrayComparator());
        for (int n : nArray) {
            for (int n2 : nArray2) {
                int[] nArray3 = new int[]{this.mReactantRank[n], this.mProductRank[n2]};
                treeSet.add(nArray3);
            }
        }
        return (int[][])treeSet.toArray((T[])new int[0][]);
    }

    private int elevateAtomRank(StereoMolecule stereoMolecule, int[] nArray, int n, int n2) {
        int n3;
        int n4 = nArray[n];
        boolean bl = false;
        for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
            if (n3 == n || nArray[n3] != n4) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return n2;
        }
        for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
            if (n3 != n && nArray[n3] <= n4) continue;
            int n5 = n3;
            nArray[n5] = nArray[n5] + 1;
        }
        ++n2;
        do {
            n3 = n2;
            this.canCalcNextBaseValues(stereoMolecule, nArray);
        } while (n3 != (n2 = this.consolidateRanking(nArray)));
        return n2;
    }

    private void canCalcNextBaseValues(StereoMolecule stereoMolecule, int[] nArray) {
        int n;
        int n2;
        int[] nArray2 = new int[this.mMaxConnAtoms];
        for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
            int n3;
            n = stereoMolecule.getConnAtoms(n2) + stereoMolecule.getMetalBondedConnAtoms(n2);
            int n4 = 0;
            for (n3 = 0; n3 < stereoMolecule.getAllConnAtomsPlusMetalBonds(n2); ++n3) {
                int n5;
                if (n3 >= stereoMolecule.getConnAtoms(n2) && n3 < stereoMolecule.getAllConnAtoms(n2)) continue;
                int n6 = 2 * nArray[stereoMolecule.getConnAtom(n2, n3)];
                int n7 = stereoMolecule.getConnBond(n2, n3);
                if (stereoMolecule.getBondOrder(n7) == 2 && !stereoMolecule.isAromaticBond(n7)) {
                    ++n6;
                }
                for (n5 = 0; n5 < n4 && n6 >= nArray2[n5]; ++n5) {
                }
                for (int i = n4; i > n5; --i) {
                    nArray2[i] = nArray2[i - 1];
                }
                nArray2[n5] = n6;
                ++n4;
            }
            this.mCanBase[n2].init(n2);
            this.mCanBase[n2].add(this.mAtomBits, nArray[n2]);
            for (n3 = n; n3 < this.mMaxConnAtoms; ++n3) {
                this.mCanBase[n2].add(this.mAtomBits + 1, 0L);
            }
            for (n3 = 0; n3 < n; ++n3) {
                this.mCanBase[n2].add(this.mAtomBits + 1, nArray2[n3]);
            }
        }
        for (n2 = stereoMolecule.getAtoms(); n2 < this.mCanBase.length; ++n2) {
            this.mCanBase[n2].init(n2);
            this.mCanBase[n2].add(this.mAtomBits, stereoMolecule.getAtoms() + 1);
            for (n = 0; n < this.mMaxConnAtoms; ++n) {
                this.mCanBase[n2].add(this.mAtomBits + 1, 0L);
            }
        }
    }

    private int consolidateRanking(int[] nArray) {
        int n = 0;
        Arrays.sort(this.mCanBase);
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0 || this.mCanBase[i].compareTo(this.mCanBase[i - 1]) != 0) {
                // empty if block
            }
            int n2 = this.mCanBase[i].getAtom();
            nArray[n2] = ++n;
        }
        return n;
    }

    private boolean areInDistinctEquivalentFragments(int[] nArray, int[] nArray2, boolean[] blArray, int[] nArray3) {
        for (int n : nArray) {
            if (!blArray[nArray2[n]]) continue;
            return false;
        }
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray3[nArray[i]] == nArray3[nArray[0]]) continue;
            return false;
        }
        return true;
    }
}

