/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction.mapping;

import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.IReactionMapper;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.mapping.ChemicalRule;
import com.actelion.research.chem.reaction.mapping.SimilarityGraphBasedReactionMapper;

public class ChemicalRuleEnhancedReactionMapper
implements IReactionMapper {
    private static final int MAX_MATCH_COUNT = 512;
    private static final ChemicalRule[] CHEMICAL_RULE = new ChemicalRule[]{new ChemicalRule("d", "gGQ@@eKtrAkDH!gGQ@@djsRIKVPP#qMsT qM\\V#!R_yL@dw~l@Jp@dsNR_@", 3.5f), new ChemicalRule("e", "daXJ@@PjyITuiX@`!dahJ@@SJYIMMfPB#IaLJfxP IaAhl[`#!ROrp?Ds|lOqNk?g?l_zLsSGp", 1.5f), new ChemicalRule("g", "gBa`@lde@XS@!gCA`@mDPOdku`#qbq qJt#!R_zq?dxgFLvHB", 5.5f), new ChemicalRule("o", "gGQHDDqIUjdB!gGQHHDqAeMjhB#qbqk qfQ]#!R_zq?dw~l_yM?kCM|?@", 0.5f), new ChemicalRule("r", "gOQdEjHbAFQRBrtAaJ!gNQdEbHbABCTKPFDH#qbMwX qbM~X#!RCwpb@@M`CpL}cg@CL|jB", 0.5f), new ChemicalRule("s", "gOp`ATigujj`H!gOp`ATiVKjj`H#qnyS` qY~eP#!R?`@_YQ|ZFBqSFHc}L{IB", 0.5f), new ChemicalRule("t", "gOP`@dcUZdB!gNp`@tiTMjj@`#q{ir` qkLrx#!R@ANZXPAl@AL@[@@SLtj|", 0.5f), new ChemicalRule("u", "daXB`Hrn@HrPEILt`D!daXB`DJn@HRUMjV@H#IxVaLJ` IylJhPP#!R_zL@hs`Q_zq?dw~l_yLsBkp", 0.5f), new ChemicalRule("Sakurai", "gOQH@wAINvZ@pdcFe@x@!gOQH@wAIgJi@pdcFe@x@#qreKx qrLkx#!R_g~HO_fQbOvw?[_|L}r\\", 4.5f), new ChemicalRule("Mitsunobu", "gFP`ATfRjdPp`}KEYg]d@!gFP`ATfRjd`pekL{l`#qrLk qZLn#!Rw`Bg?Hc|i}uUYcMb``", 4.5f), new ChemicalRule("Aldol-Addition", "gOQ@AdTAcS@^Pvb}GdThXJg@HUfI\u007flP!gGQ@@dsuRAcJg@HUaH#qYEbp qYub#!Rw[\\\\mw?^akFC|CtwLtI\\", 1.5f), new ChemicalRule("Aldol-Condensation", "gOQ@AdTAcS@^Pvb}GdThXJg@HUfI\u007flP!gFQ@@`rrpdlHHpipBEXb@#qYEbp q^aU#!Rw[\\\\mw?^akFC|CtwLtI\\", 2.5f), new ChemicalRule("Acetal-Aldol-Addition", "dmdB@@serQS@sJjfd@p`Xir\\@`j\\@aUJHI@!daxL@@[df[ZjT@qQdxACdxABjTQb@#qB@`OuX qBtM{#!RM?rH?C]}_`CW?Ev^@T@wwS^B_`@sHop", 1.5f), new ChemicalRule("Acetal-Aldol-Condensation", "dmdB@@serQS@sJjfd@p`Xir\\@`j\\@aUJHI@!gNp`CTjUiV@qQS`DJg@HUVHR@#qB@`OuX qqj{`#!RM?rH?C]}_`CW?Ev^@T@wwS^B_`@sHop", 1.5f), new ChemicalRule("Acetal-Aldol-Condensation-Cyclization", "dkLB@@ZURYUvUjejhHYpaHpr\\@aUJHp`!didD@@EIfU[hBA@CFAS`DJqq@#IXljNPY@@@ IXljXxT#!R_`CW@h`BuwvH_[yOb@I~@M_|bOsW_Wx@LuJb", 7.5f), new ChemicalRule("Enolester-Cleavage", "gOQ`@fdscT`_Qp!gOQ`@cdTASS@P#q}Kr` q}cNP#!R?g~H?[_}bOrH?WzeLyH\\", 5.3f), new ChemicalRule("propargylEnone", "gCa@@dmXFD@!gCa@@dkHD#qNT qLV#!RXIq`pp@sLwI|", 5.5f), new ChemicalRule("Arndt-Eistert", "daiDaJYBBHj^{HhAYMpAaA@!daiD`FzLBHPVsZl@p`@#IyHHZ[@ IzDGBi`#!R@W|h_U\\}X{GUJU\\}TEpsHap", 11.5f), new ChemicalRule("Curtius", "gO]IcVaDF[s{HhCIe@`!gN]HMWADHJfm`XP@#q~Jk` qytUX#!R?g}HoU_]U\\eWwQ@\\Lwq\\", 9.5f), new ChemicalRule("diazomethanHomologation", "gFU@lQioIIs\\AyH!gFU@CPdimXD#qbM^ qbqk#!Rk}rop?v~k|L@kKNB@`", 7.5f), new ChemicalRule("ene-Metathesis", "daX@@LdPLSSPHEelRXwQIHXLa`ZFChXO}IL[`!daX@@LdPLSSPHEelRXwQIHXLa`ZFChXO}IL[`#qT@q@ qt@Q@#!RNIu^@O{wD^EGhkzO?aBsdcp", 3.5f), new ChemicalRule("yne-Metathesis", "daX@@LdPLWWPAlRXwQIHXLa`ZFChXO}IL[`!daX@@LdPLWWPAlRXwQIHXLa`ZFChXO}IL[`#qT@q@ qt@Q@#!RZmoi@Fjo|SFe|IkGiUBSLop", 3.5f), new ChemicalRule("ene-yne-Metathesis", "dcd@@LdPLPLWSSPIdulrXwKlVRFCHXFa`zFAXXMa`\u007fudqnWP!dcT@@LdbbplTsTtFPx}[MeMr{Ela`jFAhXNa`VFCXXO}[J[et#qe@N@S@ qeHP@s@#!R_c}~@Gx?QgF}bKwW@h`yoosW?Hb}usNRO@", 7.5f), new ChemicalRule("Alkyne-Cyclisation", "gG`@DcO|CFAFC`@!gFp@DiTt@@CFAFC`@#qi\\V qiSt#!Rb@JNyk\\Bl^{~@CORp`", 8.5f), new ChemicalRule("Elimination-Claisen", "gNp`AldTQji@~a`!gOP`@teTZdCzN@#qtHUX qtSi@#!RupI~Owx@uwwW_]_|LyK|", 4.5f), new ChemicalRule("imineFormationAzaCope", "daZH@LAIMUjd@pRL@!daZH@HAAn]jd@p`@#IGfaLJ` IFDzfK@#!RXpAl@HYrXs}lOvL?[C|sTdH", 8.5f), new ChemicalRule("didehydroCopeWithAromatisation", "gNp@Di]ejDcjbrlwK`!gOp@DjWkB@@H#qrLkx q\\oQp#!R?`Bw?[\\BmpK~@K\\BL~JB", 4.5f), new ChemicalRule("symAldolNitrogenRing", "dovJ@GBfttf\\v\\qjViPCADGbDodnGp!doNJ@JCSmtefWTCaYjje@H#IlZXi]]yL~C IqMVCzaIim?#!R@hb}b@A~Owz}uzyl_]\\Bus}~@GxBbLfaOwzUicMbX`", 0.5f), new ChemicalRule("Diels-Alder", "gFP@LdPLjA@!gFp@DiTujhB#qiZf qMSf#!R?`BH?X`BIo[~_sNr``", 3.5f), new ChemicalRule("Cope", "gGQ@DeZmRAbhcApIF@P@!gGQ@HeZmRAbhc@HIFC`@#qkNT qi\\V#!R@BM_Hu}lWrM_[COBO@", 5.5f), new ChemicalRule("OxyCope", "gNq@@dr}SHFD@!gNq@@djkUHD#qynZ` qykbp#!Ro`AH`c]|\\KtwoS]|LvIB", 4.5f), new ChemicalRule("Vinylcyclopropane", "gKP@DklVj@`!gKP@Di\\Vj@`#qaVh qTqh#!Rm?t@?h`BbOtsdop", 3.5f), new ChemicalRule("Furan-CH2-OH-Rearrangement", "gOp`@tiguif`H!gOp`@tfWMZZ`H#qZna@ qZtM@#!RTXC@z]BRe?s|bKx@L}KB", 6.5f), new ChemicalRule("rearrangement1032", "gOp`ATieMji`H!gOp`ATeekZj`H#qaSnx qa]~P#!ROh]`lkoYCONJ_quT|qJl", 5.5f), new ChemicalRule("Pinacol-Rearrangement", "gNp`ATffjj@pPh!gOP`@tfXZhCAA`#qb^ix qb^oH#!R?m}WoRb}Og?~wu^BLsH\\", 6.5f), new ChemicalRule("1,3-WaterEliminationWith12Shift", "gJQ@@dmU@_SP!gKa@@`vtA}A@#qiTp qjap#!R?`ADddRm?basHdH", 6.5f), new ChemicalRule("Epoxydation", "gB``ADcdCB@!gC``AhtUPGtt@#qqb qtQ#!R_vsFWg}lLvK|", 6.3f), new ChemicalRule("oxydativePropargylAmine13Shift", "gKi@HDEZpLHOQP!gJY@BDeVXQL#qMr` qNTh#!R|Wk@H|@\\@BrStnH", 6.5f), new ChemicalRule("Baeyer-Villiger", "gFQ`@[dTAZ`LHP!gFQ`@jdrMPGtl@#qrak qrlK#!R?g~H?[_}AZfw?COBG@", 7.5f)};
    private static boolean sInitialized;
    private StereoMolecule mReactant;
    private StereoMolecule mProduct;
    private float mScore;
    private int mMaxRuleTries;
    private ChemicalRule mAppliedRule;
    private StringBuilder mHistory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChemicalRuleEnhancedReactionMapper() {
        if (!sInitialized) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (!sInitialized) {
                    for (ChemicalRule chemicalRule : CHEMICAL_RULE) {
                        chemicalRule.initialize();
                    }
                    sInitialized = true;
                }
            }
        }
        this.mMaxRuleTries = Integer.MAX_VALUE;
    }

    @Override
    public Reaction mapReaction(Reaction reaction, SSSearcher sSSearcher) {
        this.map(reaction);
        return reaction;
    }

    public void map(Reaction reaction) {
        SimilarityGraphBasedReactionMapper similarityGraphBasedReactionMapper = new SimilarityGraphBasedReactionMapper();
        similarityGraphBasedReactionMapper.mergeReactantsAndProducts(reaction);
        this.mReactant = similarityGraphBasedReactionMapper.getReactant();
        this.mProduct = similarityGraphBasedReactionMapper.getProduct();
        this.mReactant.ensureHelperArrays(1);
        this.mProduct.ensureHelperArrays(1);
        SSSearcher sSSearcher = new SSSearcher();
        SSSearcher sSSearcher2 = new SSSearcher();
        sSSearcher.setMolecule(this.mReactant);
        sSSearcher2.setMolecule(this.mProduct);
        this.mScore = -2.1474836E9f;
        int[] objectArray = null;
        int[] nArray = null;
        int n = 0;
        this.mAppliedRule = null;
        int n2 = 0;
        this.mHistory = new StringBuilder();
        StereoMolecule stereoMolecule = new StereoMolecule();
        for (ChemicalRule chemicalRule : CHEMICAL_RULE) {
            if (n2++ == this.mMaxRuleTries) break;
            sSSearcher.setFragment(chemicalRule.getReactant());
            sSSearcher.setFragmentSymmetryConstraints(chemicalRule.getReactantAtomSymmetryConstraints());
            if (0 == sSSearcher.findFragmentInMolecule(6, 8)) continue;
            sSSearcher2.setFragment(chemicalRule.getProduct());
            if (!sSSearcher2.isFragmentInMolecule() || sSSearcher.getMatchList().size() > 512) continue;
            float f = -10000.0f;
            for (int[] nArray2 : sSSearcher.getMatchList()) {
                if (n2++ >= this.mMaxRuleTries) break;
                this.mReactant.copyMolecule(stereoMolecule);
                chemicalRule.apply(stereoMolecule, nArray2);
                int[] nArray3 = new int[this.mReactant.getAtoms()];
                int[] nArray4 = new int[this.mProduct.getAtoms()];
                similarityGraphBasedReactionMapper.map(stereoMolecule, this.mProduct, nArray3, nArray4);
                float f2 = similarityGraphBasedReactionMapper.getScore() - chemicalRule.getPanalty();
                if (f < f2) {
                    f = f2;
                }
                if (!(this.mScore < f2)) continue;
                this.mScore = f2;
                objectArray = nArray3;
                nArray = nArray4;
                n = similarityGraphBasedReactionMapper.getGraphMapNoCount();
                this.mAppliedRule = chemicalRule;
            }
            String string = similarityGraphBasedReactionMapper.getAtomPairSequenceCount() <= 1 ? "" : " (rootPairSets:" + similarityGraphBasedReactionMapper.getAtomPairSequenceCount() + ")";
            this.mHistory.append(chemicalRule.getName() + f + (String)string + "\n");
        }
        int[] nArray5 = new int[this.mReactant.getAtoms()];
        int[] nArray6 = new int[this.mProduct.getAtoms()];
        similarityGraphBasedReactionMapper.map(this.mReactant, this.mProduct, nArray5, nArray6);
        float f = similarityGraphBasedReactionMapper.getScore();
        if (this.mScore <= f) {
            this.mAppliedRule = null;
            this.mScore = f;
            objectArray = nArray5;
            nArray = nArray6;
            n = similarityGraphBasedReactionMapper.getGraphMapNoCount();
        }
        String string = similarityGraphBasedReactionMapper.getAtomPairSequenceCount() <= 1 ? "" : " (rootPairSets:" + similarityGraphBasedReactionMapper.getAtomPairSequenceCount() + ")";
        this.mHistory.append("no rule:" + f + string + "\n");
        if (this.mScore != -2.1474836E9f) {
            similarityGraphBasedReactionMapper.copyMapNosToReaction(reaction, objectArray, nArray, n);
        }
    }

    public void setMaximumRuleTries(int n) {
        this.mMaxRuleTries = n;
    }

    public String getHistory() {
        return this.mHistory.toString();
    }

    public float getScore() {
        return this.mScore;
    }

    public ChemicalRule getAppliedRule() {
        return this.mAppliedRule;
    }
}

