/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.ClassificationData;
import java.util.TreeMap;

public class FunctionalGroupClassifier {
    private StereoMolecule mMol;
    private TreeMap<Integer, Integer> mFunctionalGroupCountMap;

    public FunctionalGroupClassifier(StereoMolecule stereoMolecule) {
        this.mMol = stereoMolecule;
        this.mMol.ensureHelperArrays(15);
    }

    public TreeMap<Integer, Integer> getFunctionGroupCountMap() {
        if (this.mFunctionalGroupCountMap == null) {
            this.classifyFunctionalGroups();
        }
        return this.mFunctionalGroupCountMap;
    }

    public int[][] getOrganicFunctionalGroupCounts() {
        if (this.mFunctionalGroupCountMap == null) {
            this.classifyFunctionalGroups();
        }
        int[][] nArray = new int[this.mFunctionalGroupCountMap.size()][2];
        int n = 0;
        for (Integer n2 : this.mFunctionalGroupCountMap.keySet()) {
            nArray[n][0] = n2;
            nArray[n][1] = this.mFunctionalGroupCountMap.get(n2).byteValue();
            ++n;
        }
        return nArray;
    }

    public static int getFunctionalGroupEquivalenceLevel(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        int n3 = 1;
        for (int i = 1; i < 8; ++i) {
            if (FunctionalGroupClassifier.nodeExists(n, i) || FunctionalGroupClassifier.nodeExists(n2, i)) {
                return -1;
            }
            if ((n |= n3) == (n2 |= n3)) {
                return i;
            }
            n3 *= 2;
        }
        return -1;
    }

    private static boolean nodeExists(int n, int n2) {
        return ClassificationData.getInstance().getEFGName(n, 8 - n2) != null;
    }

    private void classifyFunctionalGroups() {
        int n;
        int n2;
        this.mFunctionalGroupCountMap = new TreeMap();
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            this.mMol.setAtomMarker(n2, this.mMol.getAtomicNo(n2) != 6 || this.getAtomPi(n2) != 0 || this.mMol.isAtomStereoCenter(n2));
        }
        for (n2 = 0; n2 < this.mMol.getRingSet().getSize(); ++n2) {
            int n3;
            if (this.mMol.getRingSet().getRingSize(n2) != 3) continue;
            int[] nArray = this.mMol.getRingSet().getRingAtoms(n2);
            n = 0;
            for (n3 = 0; n3 < 3; ++n3) {
                if (this.mMol.getAtomicNo(nArray[n3]) == 6) continue;
                n = 1;
            }
            if (n == 0) {
                // empty if block
            }
            for (n3 = 0; n3 < 3; ++n3) {
                this.mMol.setAtomMarker(nArray[n3], true);
            }
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (!this.mMol.isMarkedAtom(n2) || !this.mMol.isMetalAtom(n2)) continue;
            this.classMet(n2);
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (!this.mMol.isMarkedAtom(n2) || this.mMol.getAtomicNo(n2) != 5) continue;
            this.storeEClass(this.classB(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (!this.mMol.isMarkedAtom(n2) || this.mMol.getAtomicNo(n2) != 14) continue;
            this.storeEClass(this.classSi(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            int n4;
            if (!this.mMol.isMarkedAtom(n2) || !this.mMol.isElectronegative(n2)) continue;
            if (this.mMol.getConnAtoms(n2) == 1) {
                if (this.mMol.getConnBondOrder(n2, 0) != 2 || this.mMol.getAtomicNo(n4 = this.mMol.getConnAtom(n2, 0)) != 6) continue;
                this.storeEClass(this.classCX(n2, n4));
                continue;
            }
            if (this.mMol.getAtomicNo(n2) != 7) continue;
            for (n4 = 0; n4 < this.mMol.getConnAtoms(n2); ++n4) {
                if (this.mMol.getConnBondOrder(n2, n4) != 2 || this.mMol.getAtomicNo(n = this.mMol.getConnAtom(n2, n4)) != 6) continue;
                this.storeEClass(this.classCX(n2, n));
            }
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 33 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classAs(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 52 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classTe(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 34 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classSe(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 15 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classP(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 16 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classS(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 53 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classI(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 35 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classBr(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 17 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classCl(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 9 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classF(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 7 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classN(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 8 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classO(n2));
        }
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomicNo(n2) != 6 || !this.mMol.isMarkedAtom(n2)) continue;
            this.storeEClass(this.classC(n2));
        }
    }

    private void classMet(int n) {
        int[] nArray = new int[16];
        int n2 = this.getCarbons(n, nArray);
        this.mMol.setAtomMarker(n, false);
        if (n2 > 1) {
            for (int i = 0; i < n2; ++i) {
                this.classCMet(nArray[i], n);
            }
        } else if (n2 == 1) {
            this.classCMet(nArray[0], n);
        }
    }

    private void classCMet(int n, int n2) {
        byte[] byArray = new byte[]{-2, -2, -2, 0, 8, -2, -2, -2, -2, -2, -2, 4, 8, 16, -2, -2, -2, -2, -2, 4, 12, 40, 48, 52, 52, 56, 56, 56, 56, 32, 36, 20, 24, -2, -2, -2, -2, 4, 12, 40, 48, 52, 52, -2, 60, 60, 60, 32, 36, 20, 24, 28, -2, -2, -2, 4, 12, 40, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 48, 52, 52, 60, 60, 60, 60, 32, 36, 20, 24, 28, -2, -2, -2, -2, -2, 40, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44};
        int n3 = byArray[this.mMol.getAtomicNo(n2)];
        if (n3 == -2) {
            this.storeEClass(-2);
            return;
        }
        if (this.getAtomZ(n) != 0) {
            n3 += 2;
        }
        if (this.mMol.isAllylicAtom(n)) {
            ++n3;
        }
        this.storeEClass(n3);
    }

    private int classB(int n) {
        int[] nArray = new int[16];
        this.mMol.setAtomMarker(n, false);
        if (this.getAtomPi(n) != 0) {
            return -2;
        }
        if (this.mMol.getAtomCharge(n) == -1) {
            int n2 = this.getHeteros(n, nArray, -1);
            if (n2 != this.getAtomZ(n)) {
                return -2;
            }
            switch (n2) {
                case 4: {
                    return 71;
                }
                case 3: {
                    if (this.getAtomSigma(n) != 0) {
                        return 70;
                    }
                    return 64;
                }
                case 2: {
                    if (this.getAtomSigma(n) == 2) {
                        return 69;
                    }
                    return 64;
                }
                case 1: {
                    if (this.getAtomSigma(n) == 3) {
                        return 68;
                    }
                    return 65;
                }
            }
            if (this.getAtomSigma(n) == 4) {
                return 67;
            }
            return 66;
        }
        if (this.mMol.getAtomCharge(n) != 0) {
            return -2;
        }
        int n3 = this.getHeteros(n, nArray, -1);
        if (n3 != this.getAtomZ(n)) {
            return 87;
        }
        if (this.mMol.getConnAtoms(n) - this.getAtomZ(n) - this.getAtomSigma(n) != 0) {
            return 79;
        }
        switch (n3) {
            case 3: {
                if (this.mMol.getAtomicNo(nArray[0]) == this.mMol.getAtomicNo(nArray[1]) && this.mMol.getAtomicNo(nArray[1]) == this.mMol.getAtomicNo(nArray[2])) {
                    if (this.mMol.getAtomicNo(nArray[0]) == 7) {
                        return 84;
                    }
                    if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                        return 85;
                    }
                }
                return 86;
            }
            case 2: {
                if (this.mMol.getConnAtoms(n) < 3) {
                    if (this.mMol.getAtomicNo(nArray[0]) == this.mMol.getAtomicNo(nArray[1])) {
                        if (this.mMol.getAtomicNo(nArray[0]) == 7) {
                            return 76;
                        }
                        if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                            return 77;
                        }
                    }
                    return 78;
                }
                int n4 = -1;
                for (int i = 0; i < this.mMol.getConnAtoms(n) && this.mMol.isElectronegative(n4 = this.mMol.getConnAtom(n, i)); ++i) {
                }
                if (this.getAtomSigma(n) != 0) {
                    if (this.mMol.getAtomicNo(nArray[0]) == this.mMol.getAtomicNo(nArray[1])) {
                        switch (this.mMol.getAtomicNo(nArray[0])) {
                            case 7: {
                                return 92;
                            }
                            case 8: {
                                if (this.mMol.isAromaticAtom(n4)) {
                                    return 88;
                                }
                                if (this.getAtomPi(n4) != 0) {
                                    return 89;
                                }
                                if (this.mMol.isAllylicAtom(n4)) {
                                    return 90;
                                }
                                return 91;
                            }
                        }
                    }
                    return 93;
                }
                return -2;
            }
            case 1: {
                if (this.mMol.getConnAtoms(n) == 1) {
                    return 75;
                }
                if (this.mMol.getConnAtoms(n) == 2) {
                    return 74;
                }
                if (this.mMol.getConnAtoms(n) != 3) break;
                switch (this.mMol.getAtomicNo(nArray[0])) {
                    case 7: {
                        return 80;
                    }
                    case 8: {
                        return 81;
                    }
                    case 16: {
                        return 82;
                    }
                }
                return 83;
            }
        }
        switch (this.getAtomSigma(n)) {
            case 3: {
                return 94;
            }
            case 2: {
                return 72;
            }
        }
        return 73;
    }

    private int classSi(int n) {
        int n2;
        int n3;
        int n4;
        int[] nArray = new int[16];
        this.mMol.setAtomMarker(n, false);
        if (this.getAtomPi(n) != 0) {
            return -2;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (n4 = 0; n4 < this.mMol.getConnAtoms(n); ++n4) {
            n3 = this.mMol.getConnAtom(n, n4);
            if (this.mMol.getAtomicNo(n3) != 6) continue;
            if (this.getAtomPi(n3) == 2) {
                bl = true;
                continue;
            }
            if (this.mMol.isAromaticAtom(n3)) {
                bl2 = true;
                continue;
            }
            if (this.getAtomPi(n3) == 1) {
                bl3 = true;
                continue;
            }
            if (this.getAtomZ(n3) > 1) {
                for (n2 = 0; n2 < this.mMol.getConnAtoms(n3); ++n2) {
                    int n5 = this.mMol.getConnAtom(n3, n2);
                    if (this.mMol.getAtomicNo(n5) != 8 || this.mMol.getConnBondOrder(n3, n2) != 2) continue;
                    bl4 = true;
                }
            }
            if (bl4 || !this.mMol.isAllylicAtom(n3)) continue;
            bl5 = true;
        }
        if (this.getAtomZ(n) == 0) {
            switch (this.getAtomSigma(n)) {
                case 4: {
                    if (bl4) {
                        return 180;
                    }
                    if (bl) {
                        return 176;
                    }
                    if (bl3) {
                        return 177;
                    }
                    if (bl5) {
                        return 179;
                    }
                    if (bl2) {
                        return 178;
                    }
                    return 181;
                }
                case 3: {
                    return 160;
                }
                case 2: {
                    return 161;
                }
            }
            return 162;
        }
        if (this.getAtomZ(n) == 1) {
            n4 = 0;
            for (n3 = 0; n3 < this.mMol.getConnAtoms(n); ++n3) {
                n2 = this.mMol.getConnAtom(n, n3);
                if (this.mMol.isElectronegative(n2)) {
                    nArray[0] = n2;
                    continue;
                }
                n4 += this.getAtomSigma(n2);
            }
            switch (this.getAtomSigma(n)) {
                case 3: {
                    if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                        switch (n4) {
                            case 0: {
                                return 136;
                            }
                            case 1: {
                                return 137;
                            }
                            case 2: {
                                return 138;
                            }
                            case 3: {
                                return 139;
                            }
                            case 4: {
                                return 140;
                            }
                            case 5: {
                                return 141;
                            }
                            case 6: {
                                return 142;
                            }
                        }
                        return 143;
                    }
                    if (this.mMol.getAtomicNo(nArray[0]) == 7) {
                        switch (n4) {
                            case 0: {
                                return 128;
                            }
                            case 1: {
                                return 129;
                            }
                            case 2: {
                                return 130;
                            }
                            case 3: {
                                return 131;
                            }
                            case 4: {
                                return 132;
                            }
                            case 5: {
                                return 133;
                            }
                            case 6: {
                                return 134;
                            }
                        }
                        return 135;
                    }
                    switch (this.mMol.getAtomicNo(nArray[0])) {
                        case 15: {
                            return 152;
                        }
                        case 16: {
                            return 153;
                        }
                    }
                    return 154;
                }
                case 2: {
                    if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                        return 164;
                    }
                    return 165;
                }
            }
            if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                return 166;
            }
            return 167;
        }
        if (this.getAtomZ(n) == 2) {
            if (this.getHeteros(n, nArray, -1) != 2) {
                return -2;
            }
            switch (this.getAtomSigma(n)) {
                case 2: {
                    if (this.mMol.getAtomicNo(nArray[0]) == this.mMol.getAtomicNo(nArray[1])) {
                        switch (this.mMol.getAtomicNo(nArray[0])) {
                            case 7: {
                                return 145;
                            }
                            case 8: {
                                return 144;
                            }
                            case 16: {
                                return 146;
                            }
                        }
                    }
                    return 147;
                }
            }
            if (this.mMol.getAtomicNo(nArray[0]) == this.mMol.getAtomicNo(nArray[1])) {
                switch (this.mMol.getAtomicNo(nArray[0])) {
                    case 7: {
                        return 169;
                    }
                    case 8: {
                        return 168;
                    }
                    case 16: {
                        return 170;
                    }
                }
            }
            return 171;
        }
        if (this.getAtomZ(n) == 3) {
            if (this.getHeteros(n, nArray, -1) != 3) {
                return -2;
            }
            switch (this.getAtomSigma(n)) {
                case 1: {
                    if (this.mMol.getAtomicNo(nArray[0]) == 8 && this.mMol.getAtomicNo(nArray[1]) == 8 && this.mMol.getAtomicNo(nArray[2]) == 8) {
                        return 148;
                    }
                    return 149;
                }
            }
            if (this.mMol.getAtomicNo(nArray[0]) == 8 && this.mMol.getAtomicNo(nArray[1]) == 8 && this.mMol.getAtomicNo(nArray[2]) == 8) {
                return 172;
            }
            return 173;
        }
        if (this.getAtomZ(n) == 4) {
            if (this.getHeteros(n, nArray, -1) != 4) {
                return -2;
            }
            if (this.mMol.getAtomicNo(nArray[0]) == 8 && this.mMol.getAtomicNo(nArray[1]) == 8 && this.mMol.getAtomicNo(nArray[2]) == 8 && this.mMol.getAtomicNo(nArray[3]) == 8) {
                return 150;
            }
            return 151;
        }
        return -1;
    }

    private int classCX(int n, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        if (this.bondToMet(n2)) {
            return -1;
        }
        if (this.mMol.getAtomicNo(n) == 7) {
            if (this.mMol.isAromaticAtom(n)) {
                return -1;
            }
            if (!this.bondToMet(n)) {
                n4 = this.getHeteros(n, nArray2, -1);
                if (this.mMol.getAtomCharge(n) == 1) {
                    if (this.mMol.getConnAtoms(n) == 1) {
                        this.storeEClass(532);
                    } else {
                        switch (this.getAtomZ(n)) {
                            case 2: {
                                if (n4 == 1) {
                                    this.storeEClass(516);
                                    break;
                                }
                                if (this.mMol.getAtomicNo(nArray2[0]) == 8 && this.mMol.getAtomicNo(nArray2[1]) == 8) {
                                    for (n3 = 0; n3 < 2; ++n3) {
                                        if (this.mMol.getConnAtoms(nArray2[n3]) != 1) continue;
                                        this.mMol.setAtomMarker(nArray2[n3], false);
                                    }
                                    this.storeEClass(534);
                                    break;
                                }
                                this.storeEClass(535);
                                break;
                            }
                            case 1: {
                                if (this.mMol.getAtomicNo(nArray2[0]) == 8) {
                                    if (this.mMol.getConnAtoms(nArray2[0]) == 1) {
                                        this.mMol.setAtomMarker(nArray2[0], false);
                                    }
                                    this.storeEClass(524);
                                    break;
                                }
                                this.storeEClass(525);
                                break;
                            }
                            default: {
                                this.storeEClass(533);
                                break;
                            }
                        }
                    }
                } else if (this.mMol.getConnAtoms(n) == 1) {
                    this.storeEClass(592);
                } else if (n4 != 0) {
                    if (this.hasDBondToHetero(nArray2[0])) {
                        this.storeEClass(601);
                    } else if (this.mMol.getAtomicNo(nArray2[0]) == 7) {
                        if (this.getAtomPi(nArray2[0]) != 0) {
                            this.storeEClass(604);
                        } else {
                            this.storeEClass(605);
                        }
                    } else if (this.mMol.getAtomicNo(nArray2[0]) == 8) {
                        if (this.mMol.getConnAtoms(nArray2[0]) == 1) {
                            this.mMol.setAtomMarker(nArray2[0], false);
                            this.storeEClass(606);
                        } else {
                            this.storeEClass(607);
                        }
                    } else {
                        this.storeEClass(602);
                    }
                } else {
                    n3 = this.getNextConn(n, n2);
                    if (this.mMol.isAromaticAtom(n3)) {
                        this.storeEClass(599);
                    } else if (this.hasDBondToHetero(n3)) {
                        this.storeEClass(600);
                    } else if (this.getAtomPi(n3) != 0) {
                        if (this.getAtomSigma(n3) == 2) {
                            this.storeEClass(596);
                        } else {
                            this.storeEClass(597);
                        }
                    } else if (this.getAtomZ(n3) > 1) {
                        this.storeEClass(598);
                    } else if (this.getAtomSigma(n3) > 1) {
                        this.storeEClass(594);
                    } else {
                        this.storeEClass(595);
                    }
                }
            }
        }
        this.mMol.setAtomMarker(n, false);
        if (this.getAtomPi(n2) != 0) {
            n4 = this.getNextConn(n2, n);
            this.mMol.setAtomMarker(n2, false);
            this.mMol.setAtomMarker(n4, false);
            switch (this.mMol.getAtomicNo(n)) {
                case 7: {
                    return 536;
                }
                case 8: {
                    return 537;
                }
                case 16: {
                    return 538;
                }
            }
            return 539;
        }
        n4 = this.getHeteros(n2, nArray2, n);
        switch (this.mMol.getAtomicNo(n)) {
            case 7: {
                switch (this.getAtomZ(n2)) {
                    case 4: {
                        if (n4 == 1) {
                            if (this.mMol.getAtomicNo(nArray2[0]) == 7) {
                                return 542;
                            }
                            if (this.mMol.getAtomicNo(nArray2[0]) == 8 || this.mMol.getAtomicNo(nArray2[0]) == 16) {
                                return -1;
                            }
                            return 543;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) > this.mMol.getAtomicNo(nArray2[1])) {
                            n3 = nArray2[0];
                            nArray2[0] = nArray2[1];
                            nArray2[1] = n3;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 7) {
                            switch (this.mMol.getAtomicNo(nArray2[1])) {
                                case 7: {
                                    return 560;
                                }
                                case 8: {
                                    return 561;
                                }
                                case 16: {
                                    return 562;
                                }
                            }
                            return 563;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 8) {
                            switch (this.mMol.getAtomicNo(nArray2[1])) {
                                case 8: {
                                    return 564;
                                }
                                case 16: {
                                    return 565;
                                }
                            }
                            return 566;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 16 && this.mMol.getAtomicNo(nArray2[1]) == 16) {
                            return 568;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 16 || this.mMol.getAtomicNo(nArray2[1]) == 16) {
                            return 569;
                        }
                        return 570;
                    }
                    case 3: {
                        if (this.checkAnhydride(nArray2[0], n2)) {
                            if (this.getAtomSigma(n2) != 0) {
                                switch (this.mMol.getAtomicNo(nArray2[0])) {
                                    case 7: {
                                        return 544;
                                    }
                                    case 8: {
                                        return 545;
                                    }
                                    case 16: {
                                        return 546;
                                    }
                                }
                                return 547;
                            }
                            switch (this.mMol.getAtomicNo(nArray2[0])) {
                                case 7: {
                                    return 552;
                                }
                                case 8: {
                                    return 553;
                                }
                                case 16: {
                                    return 554;
                                }
                            }
                            return 555;
                        }
                        if (this.getAtomSigma(n2) != 0) {
                            switch (this.mMol.getAtomicNo(nArray2[0])) {
                                case 7: {
                                    return 548;
                                }
                                case 8: {
                                    return 549;
                                }
                                case 16: {
                                    return 550;
                                }
                            }
                            return 551;
                        }
                        switch (this.mMol.getAtomicNo(nArray2[0])) {
                            case 7: {
                                return 556;
                            }
                            case 8: {
                                return 557;
                            }
                            case 16: {
                                return 558;
                            }
                        }
                        return 559;
                    }
                }
                if (this.getAtomSigma(n2) == 2) {
                    if (this.mMol.isAllylicAtom(n2)) {
                        return 572;
                    }
                    return 573;
                }
                if (this.getAtomSigma(n2) == 1) {
                    if (this.mMol.isAllylicAtom(n2)) {
                        return 574;
                    }
                    return 575;
                }
                return 468;
            }
            case 8: {
                switch (this.getAtomZ(n2)) {
                    case 4: {
                        if (n4 == 1) {
                            this.mMol.setAtomMarker(nArray2[0], false);
                            return 540;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) > this.mMol.getAtomicNo(nArray2[1])) {
                            n3 = nArray2[0];
                            nArray2[0] = nArray2[1];
                            nArray2[1] = n3;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 7) {
                            switch (this.mMol.getAtomicNo(nArray2[1])) {
                                case 7: {
                                    return 640;
                                }
                                case 8: {
                                    return 641;
                                }
                                case 16: {
                                    return 642;
                                }
                            }
                            return 643;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 8) {
                            switch (this.mMol.getAtomicNo(nArray2[1])) {
                                case 8: {
                                    return 644;
                                }
                                case 16: {
                                    return 645;
                                }
                            }
                            return 646;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 16 && this.mMol.getAtomicNo(nArray2[1]) == 16) {
                            return 648;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 16 || this.mMol.getAtomicNo(nArray2[1]) == 16) {
                            return 649;
                        }
                        return 650;
                    }
                    case 3: {
                        if (this.checkAnhydride(nArray2[0], n2)) {
                            if (this.getAtomSigma(n2) != 0) {
                                switch (this.mMol.getAtomicNo(nArray2[0])) {
                                    case 7: {
                                        return 656;
                                    }
                                    case 8: {
                                        return 657;
                                    }
                                    case 16: {
                                        return 658;
                                    }
                                }
                                return 659;
                            }
                            switch (this.mMol.getAtomicNo(nArray2[0])) {
                                case 7: {
                                    return 664;
                                }
                                case 8: {
                                    return 665;
                                }
                                case 16: {
                                    return 666;
                                }
                            }
                            return 667;
                        }
                        if (this.getAtomSigma(n2) != 0) {
                            switch (this.mMol.getAtomicNo(nArray2[0])) {
                                case 7: {
                                    return 660;
                                }
                                case 8: {
                                    return 661;
                                }
                                case 16: {
                                    return 662;
                                }
                            }
                            return 663;
                        }
                        switch (this.mMol.getAtomicNo(nArray2[0])) {
                            case 7: {
                                return 668;
                            }
                            case 8: {
                                return 669;
                            }
                            case 16: {
                                return 670;
                            }
                        }
                        return 671;
                    }
                }
                if (this.getAtomSigma(n2) == 2) {
                    if (this.isQuinone(n2)) {
                        return 188;
                    }
                    if (this.getCarbons(n2, nArray) != 2) {
                        return -2;
                    }
                    if (this.mMol.isAromaticAtom(nArray[0]) && this.mMol.isAromaticAtom(nArray[1])) {
                        return 688;
                    }
                    n3 = -1;
                    if (this.mMol.isAromaticAtom(nArray[0])) {
                        n3 = nArray[1];
                    }
                    if (this.mMol.isAromaticAtom(nArray[1])) {
                        n3 = nArray[0];
                    }
                    if (n3 != -1) {
                        if (this.getAtomPi(n3) != 0) {
                            return 672;
                        }
                        switch (this.getAtomZ(n3)) {
                            case 3: {
                                return 684;
                            }
                            case 2: {
                                return 685;
                            }
                            case 1: {
                                if (this.getAtomSigma(n3) == 3) {
                                    return 686;
                                }
                                return 687;
                            }
                        }
                        if (this.getAtomSigma(n3) == 4) {
                            return 690;
                        }
                        return 691;
                    }
                    if (this.getAtomPi(nArray[0]) != 0 && this.getAtomPi(nArray[1]) != 0) {
                        return 673;
                    }
                    n3 = -1;
                    if (this.getAtomPi(nArray[0]) != 0) {
                        n3 = nArray[1];
                    }
                    if (this.getAtomPi(nArray[1]) != 0) {
                        n3 = nArray[0];
                    }
                    if (n3 != -1) {
                        switch (this.getAtomZ(n3)) {
                            case 3: {
                                return 676;
                            }
                            case 2: {
                                return 677;
                            }
                            case 1: {
                                if (this.getAtomSigma(n3) == 3) {
                                    return 678;
                                }
                                return 679;
                            }
                        }
                        if (this.getAtomSigma(n3) == 4) {
                            return 674;
                        }
                        return 675;
                    }
                    int n5 = this.getAtomSigma(nArray[0]) + this.getAtomSigma(nArray[1]);
                    int n6 = this.getAtomZ(nArray[0]) + this.getAtomZ(nArray[1]);
                    if (n6 > 4) {
                        return 680;
                    }
                    if (n6 > 2) {
                        return 681;
                    }
                    if (n6 != 0) {
                        if (n5 + n6 > 6) {
                            return 682;
                        }
                        return 683;
                    }
                    if (n5 > 6) {
                        return 692;
                    }
                    return 693;
                }
                if (this.getAtomSigma(n2) == 1) {
                    n3 = this.getNextConn(n2, n);
                    if (this.mMol.isAromaticAtom(n3)) {
                        return 432;
                    }
                    if (this.getAtomPi(n3) == 2) {
                        return 435;
                    }
                    if (this.getAtomPi(n3) != 0) {
                        return 434;
                    }
                    switch (this.getAtomZ(n3)) {
                        case 3: {
                            return 440;
                        }
                        case 2: {
                            if (this.getAtomSigma(n3) == 1) {
                                return 443;
                            }
                            return 442;
                        }
                        case 1: {
                            if (this.getAtomSigma(n3) == 1) {
                                return 444;
                            }
                            if (this.getAtomSigma(n3) == 2) {
                                return 445;
                            }
                            return 446;
                        }
                    }
                    if (this.getAtomSigma(n3) < 3) {
                        return 439;
                    }
                    if (this.getAtomSigma(n3) == 3) {
                        return 438;
                    }
                    return 436;
                }
                return 469;
            }
            case 15: {
                return 102;
            }
            case 16: {
                switch (this.getAtomZ(n2)) {
                    case 4: {
                        if (n4 == 1) {
                            this.mMol.setAtomMarker(nArray2[0], false);
                            return 541;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) > this.mMol.getAtomicNo(nArray2[1])) {
                            n3 = nArray2[0];
                            nArray2[0] = nArray2[1];
                            nArray2[1] = n3;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 7) {
                            switch (this.mMol.getAtomicNo(nArray2[1])) {
                                case 7: {
                                    return 704;
                                }
                                case 8: {
                                    return 705;
                                }
                                case 16: {
                                    return 706;
                                }
                            }
                            return 707;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 8) {
                            switch (this.mMol.getAtomicNo(nArray2[1])) {
                                case 8: {
                                    return 708;
                                }
                                case 16: {
                                    return 709;
                                }
                            }
                            return 710;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 16 && this.mMol.getAtomicNo(nArray2[1]) == 16) {
                            return 712;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 16 || this.mMol.getAtomicNo(nArray2[1]) == 16) {
                            return 713;
                        }
                        return 714;
                    }
                    case 3: {
                        if (this.getAtomSigma(n2) != 0) {
                            switch (this.mMol.getAtomicNo(nArray2[0])) {
                                case 7: {
                                    return 720;
                                }
                                case 8: {
                                    return 721;
                                }
                                case 16: {
                                    return 722;
                                }
                            }
                            return 723;
                        }
                        switch (this.mMol.getAtomicNo(nArray2[0])) {
                            case 7: {
                                return 724;
                            }
                            case 8: {
                                return 725;
                            }
                            case 16: {
                                return 726;
                            }
                        }
                        return 727;
                    }
                }
                if (this.getAtomSigma(n2) == 2) {
                    if (this.mMol.isAllylicAtom(n2)) {
                        return 716;
                    }
                    return 717;
                }
                if (this.getAtomSigma(n2) == 1) {
                    if (this.mMol.isAllylicAtom(n2)) {
                        return 718;
                    }
                    return 719;
                }
                return 470;
            }
            case 34: {
                switch (this.getAtomZ(n2)) {
                    case 4: {
                        return 412;
                    }
                    case 3: {
                        if (this.getAtomSigma(n2) != 0) {
                            return 410;
                        }
                        return 411;
                    }
                }
                if (this.getAtomSigma(n2) == 2) {
                    return 408;
                }
                return 409;
            }
        }
        return -2;
    }

    private int classAs(int n) {
        this.mMol.setAtomMarker(n, false);
        if (this.getAtomSigma(n) == 0) {
            switch (this.getAtomZ(n)) {
                case 3: {
                    return 120;
                }
                case 5: {
                    return 121;
                }
            }
            return 122;
        }
        if (this.getAtomSigma(n) == 1) {
            switch (this.getAtomZ(n)) {
                case 0: {
                    return 124;
                }
                case 2: {
                    return 125;
                }
                case 4: {
                    return 126;
                }
            }
            return 127;
        }
        return 123;
    }

    private int classTe(int n) {
        this.mMol.setAtomMarker(n, false);
        if (this.getAtomSigma(n) == 0) {
            switch (this.getAtomZ(n)) {
                case 2: {
                    return 248;
                }
                case 4: {
                    return 249;
                }
                case 6: {
                    return 250;
                }
            }
            return 251;
        }
        if (this.getAtomSigma(n) == 1) {
            switch (this.getAtomZ(n)) {
                case 1: {
                    return 244;
                }
                case 3: {
                    return 245;
                }
                case 5: {
                    return 246;
                }
            }
            return 247;
        }
        if (this.getAtomSigma(n) == 2) {
            switch (this.getAtomZ(n)) {
                case 0: {
                    return 252;
                }
                case 2: {
                    return 253;
                }
                case 4: {
                    return 254;
                }
            }
            return 255;
        }
        return -1;
    }

    private int classSe(int n) {
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        this.mMol.setAtomMarker(n, false);
        int n2 = this.getCarbons(n, nArray);
        for (int i = 0; i < n2; ++i) {
            this.classCSe(nArray[i]);
        }
        if (this.getAtomZ(n) == 0) {
            if (this.getAtomSigma(n) == 2) {
                return 414;
            }
            return 415;
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n3 = this.getSortedHeteros(n, nArray2, nArray3, nArray4, -1);
        if (nArray3[0] != 0) {
            return -2;
        }
        if (this.getAtomZ(n) == 1) {
            if (this.getAtomSigma(n) == 1) {
                switch (this.mMol.getAtomicNo(nArray2[0])) {
                    case 8: {
                        if (this.mMol.getConnAtoms(nArray2[0]) == 1) {
                            this.mMol.setAtomMarker(nArray2[0], false);
                            return 384;
                        }
                        return 385;
                    }
                    case 17: {
                        this.mMol.setAtomMarker(nArray2[0], false);
                        return 386;
                    }
                    case 34: {
                        if (this.mMol.getConnAtoms(nArray2[0]) == 1) {
                            this.mMol.setAtomMarker(nArray2[0], false);
                            return 388;
                        }
                        if (this.getAtomZ(nArray2[0]) == 1) {
                            return 389;
                        }
                        return 390;
                    }
                }
                return 387;
            }
            return 391;
        }
        if (this.getAtomZ(n) == 2) {
            if (n3 == 1 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.getAtomSigma(n) == 2) {
                this.mMol.setAtomMarker(nArray2[0], false);
                return 392;
            }
            return 393;
        }
        if (this.getAtomZ(n) == 3) {
            if (n3 == 2 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.getAtomSigma(n) == 1) {
                this.mMol.setAtomMarker(nArray2[0], false);
                if (this.mMol.getAtomicNo(nArray2[1]) == 8) {
                    if (this.mMol.getConnAtoms(nArray2[1]) == 1) {
                        this.mMol.setAtomMarker(nArray2[1], false);
                        return 400;
                    }
                    return 401;
                }
                return 402;
            }
            return 403;
        }
        if (this.getAtomZ(n) == 4) {
            if (n3 == 2 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.mMol.getAtomicNo(nArray2[1]) == 8 && this.getAtomSigma(n) == 2) {
                this.mMol.setAtomMarker(nArray2[0], false);
                this.mMol.setAtomMarker(nArray2[1], false);
                return 396;
            }
            if (n3 == 3 && this.mMol.getAtomicNo(nArray2[0]) == 8) {
                this.mMol.setAtomMarker(nArray2[0], false);
                if (this.mMol.getAtomicNo(nArray2[1]) == 8 && this.mMol.getAtomicNo(nArray2[2]) == 8) {
                    return 397;
                }
                return 398;
            }
            return 399;
        }
        if (this.getAtomZ(n) == 5) {
            if (n3 == 3 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.mMol.getAtomicNo(nArray2[1]) == 8 && this.getAtomSigma(n) == 1) {
                this.mMol.setAtomMarker(nArray2[0], false);
                this.mMol.setAtomMarker(nArray2[1], false);
                if (this.mMol.getAtomicNo(nArray2[2]) == 8) {
                    if (this.mMol.getConnAtoms(nArray2[2]) == 1) {
                        this.mMol.setAtomMarker(nArray2[1], false);
                        return 404;
                    }
                    return 405;
                }
                return 406;
            }
            return 407;
        }
        if (this.getAtomZ(n) == 6) {
            if (n3 == 4 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.mMol.getAtomicNo(nArray2[1]) == 8 && this.mMol.getAtomicNo(nArray2[2]) == 8 && this.mMol.getAtomicNo(nArray2[3]) == 8) {
                this.mMol.setAtomMarker(nArray2[0], false);
                this.mMol.setAtomMarker(nArray2[1], false);
                return 394;
            }
            return 395;
        }
        return -1;
    }

    private void classCSe(int n) {
        if (this.mMol.isAromaticAtom(n)) {
            this.storeEClass(416);
            return;
        }
        if (this.hasDBondToHetero(n)) {
            this.storeEClass(424);
            return;
        }
        if (this.getAtomZ(n) == 1) {
            if (this.getAtomPi(n) != 0) {
                if (this.getAtomSigma(n) == 1) {
                    this.storeEClass(418);
                } else {
                    this.storeEClass(419);
                }
                return;
            }
            if (this.mMol.isAllylicAtom(n)) {
                this.storeEClass(423);
            }
            switch (this.getAtomSigma(n)) {
                case 3: {
                    this.storeEClass(420);
                    return;
                }
                case 2: {
                    this.storeEClass(421);
                    return;
                }
            }
            this.storeEClass(422);
            return;
        }
        if (this.getAtomZ(n) == 2) {
            if (this.getAtomPi(n) != 0) {
                this.storeEClass(417);
                return;
            }
            switch (this.getAtomSigma(n)) {
                case 2: {
                    this.storeEClass(425);
                    return;
                }
                case 1: {
                    this.storeEClass(426);
                    return;
                }
            }
            this.storeEClass(427);
            return;
        }
        if (this.getAtomZ(n) == 3) {
            if (this.getAtomSigma(n) != 0) {
                this.storeEClass(428);
            } else {
                this.storeEClass(429);
            }
            return;
        }
        this.storeEClass(430);
    }

    private int classP(int n) {
        int[] nArray = new int[16];
        this.mMol.setAtomMarker(n, false);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n5 = this.mMol.getConnAtom(n, i);
            if (this.mMol.getAtomicNo(n5) != 6) continue;
            if (this.mMol.isAromaticAtom(n5)) {
                ++n2;
                continue;
            }
            if (this.getAtomPi(n5) != 0) {
                ++n3;
                continue;
            }
            ++n4;
        }
        if (this.getAtomZ(n) == 0) {
            if (this.mMol.getAtomCharge(n) == 1) {
                return 96;
            }
            if (this.getAtomPi(n) == 0) {
                if (this.getAtomSigma(n) == 3) {
                    if (n2 == 3) {
                        return 104;
                    }
                    return 105;
                }
                if (this.getAtomSigma(n) == 2) {
                    return 98;
                }
                return 99;
            }
            if (this.getAtomPi(n) == 1) {
                if (this.getAtomSigma(n) == 4) {
                    return 100;
                }
                if (this.getAtomSigma(n) == 2) {
                    return 101;
                }
                return 103;
            }
            return -2;
        }
        if (this.mMol.getAtomCharge(n) == 1) {
            return 97;
        }
        if (this.getAtomZ(n) == 1) {
            return 110;
        }
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n6 = this.getSortedHeteros(n, nArray, nArray2, nArray3, -1);
        if (nArray2[0] != 0) {
            return -2;
        }
        if (this.getAtomZ(n) == 2) {
            if (n6 == 1) {
                if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                    this.mMol.setAtomMarker(nArray[0], false);
                    return 108;
                }
                return 109;
            }
            return 111;
        }
        if (this.getAtomZ(n) == 3) {
            if (n6 == 2) {
                if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                    this.mMol.setAtomMarker(nArray[0], false);
                    return 112;
                }
                return 113;
            }
            if (this.mMol.getAtomicNo(nArray[0]) == 8 && this.mMol.getAtomicNo(nArray[1]) == 8 && this.mMol.getAtomicNo(nArray[2]) == 8) {
                return 106;
            }
            return 107;
        }
        if (this.getAtomZ(n) == 4) {
            if (n6 == 3) {
                if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                    this.mMol.setAtomMarker(nArray[0], false);
                    if (this.mMol.getAtomicNo(nArray[1]) == 8 && this.mMol.getAtomicNo(nArray[2]) == 8) {
                        return 114;
                    }
                    return 115;
                }
                return 116;
            }
            return -2;
        }
        if (this.getAtomZ(n) == 5) {
            if (n6 == 4) {
                if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                    this.mMol.setAtomMarker(nArray[0], false);
                    if (this.mMol.getAtomicNo(nArray[1]) == 8 && this.mMol.getAtomicNo(nArray[2]) == 8 && this.mMol.getAtomicNo(nArray[3]) == 8) {
                        return 118;
                    }
                    return 119;
                }
                return 117;
            }
            return -2;
        }
        return -2;
    }

    private int classS(int n) {
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        this.mMol.setAtomMarker(n, false);
        if (!this.mMol.isAromaticAtom(n)) {
            int n2 = this.getCarbons(n, nArray);
            for (int i = 0; i < n2; ++i) {
                this.classCS(nArray[i], n);
            }
        }
        if (this.mMol.isAromaticAtom(n)) {
            return 187;
        }
        if (this.mMol.getAtomCharge(n) == 1) {
            return 735;
        }
        if (this.getAtomZ(n) == 0) {
            if (this.getAtomSigma(n) == 2) {
                return 732;
            }
            return 733;
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n3 = this.getSortedHeteros(n, nArray2, nArray3, nArray4, -1);
        if (nArray3[0] != 0) {
            return -2;
        }
        if (this.getAtomZ(n) == 1) {
            if (this.getAtomSigma(n) == 1) {
                if (this.mMol.getAtomicNo(nArray2[0]) == 16) {
                    if (this.mMol.getConnAtoms(nArray2[0]) == 1) {
                        this.mMol.setAtomMarker(nArray2[0], false);
                        return 728;
                    }
                    if (this.getAtomZ(nArray2[0]) == 1) {
                        return 729;
                    }
                    return 730;
                }
                return 731;
            }
            if (this.mMol.getConnAtoms(n) > 1) {
                return -1;
            }
            return 734;
        }
        if (this.getAtomZ(n) == 2) {
            if (n3 == 1 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.getAtomSigma(n) == 2) {
                this.mMol.setAtomMarker(nArray2[0], false);
                return 736;
            }
            return 737;
        }
        if (this.getAtomZ(n) == 3) {
            if (n3 == 2 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.getAtomSigma(n) == 1) {
                this.mMol.setAtomMarker(nArray2[0], false);
                if (this.mMol.getAtomicNo(nArray2[1]) == 8) {
                    return 744;
                }
                return 745;
            }
            return 746;
        }
        if (this.getAtomZ(n) == 4) {
            if (n3 == 2 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.mMol.getAtomicNo(nArray2[1]) == 8 && this.getAtomSigma(n) == 2) {
                this.mMol.setAtomMarker(nArray2[0], false);
                this.mMol.setAtomMarker(nArray2[1], false);
                return 740;
            }
            if (n3 == 3 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.getAtomSigma(n) == 0) {
                this.mMol.setAtomMarker(nArray2[0], false);
                if (this.mMol.getAtomicNo(nArray2[1]) == 8 && this.mMol.getAtomicNo(nArray2[2]) == 8) {
                    return 741;
                }
                return 742;
            }
            return 743;
        }
        if (this.getAtomZ(n) == 5) {
            if (n3 == 3 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.mMol.getAtomicNo(nArray2[1]) == 8 && this.getAtomSigma(n) == 1) {
                this.mMol.setAtomMarker(nArray2[0], false);
                this.mMol.setAtomMarker(nArray2[1], false);
                if (this.mMol.getAtomicNo(nArray2[2]) == 8) {
                    return 748;
                }
                return 749;
            }
            return 750;
        }
        if (this.getAtomZ(n) == 6) {
            if (n3 == 4 && this.mMol.getAtomicNo(nArray2[0]) == 8 && this.mMol.getAtomicNo(nArray2[1]) == 8) {
                this.mMol.setAtomMarker(nArray2[0], false);
                this.mMol.setAtomMarker(nArray2[1], false);
                return 738;
            }
            return 739;
        }
        return -1;
    }

    private void classCS(int n, int n2) {
        int[] nArray = new int[16];
        if (this.bondToMet(n)) {
            return;
        }
        if (this.mMol.isAromaticAtom(n)) {
            this.storeEClass(448);
            return;
        }
        if (this.getAtomPi(n) == 2) {
            this.storeEClass(449);
            return;
        }
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n3 = this.getSortedHeteros(n, nArray, nArray2, nArray3, n2);
        if (nArray2[0] != 0) {
            this.storeEClass(464);
            return;
        }
        if (this.hasDBondToHetero(n)) {
            this.storeEClass(465);
            return;
        }
        if (this.getAtomPi(n) == 1) {
            if (this.getAtomZ(n) == 2) {
                if (this.mMol.getAtomicNo(nArray[0]) == 16) {
                    this.storeEClass(456);
                } else {
                    this.storeEClass(457);
                }
            } else if (this.getAtomSigma(n) == 2) {
                this.storeEClass(450);
            } else {
                this.storeEClass(451);
            }
            return;
        }
        if (this.getAtomZ(n) == 1) {
            if (this.mMol.isAllylicAtom(n)) {
                this.storeEClass(455);
            }
            switch (this.getAtomSigma(n)) {
                case 3: {
                    this.storeEClass(454);
                    return;
                }
                case 2: {
                    this.storeEClass(453);
                    return;
                }
            }
            this.storeEClass(452);
            return;
        }
        if (this.getAtomZ(n) == 2) {
            if (this.getAtomSigma(n) == 0) {
                if (this.mMol.getAtomicNo(nArray[0]) == 16) {
                    this.storeEClass(462);
                } else {
                    this.storeEClass(463);
                }
                return;
            }
            if (this.getAtomSigma(n) == 1) {
                if (this.mMol.getAtomicNo(nArray[0]) == 16) {
                    this.storeEClass(460);
                } else {
                    this.storeEClass(461);
                }
                return;
            }
            if (this.getAtomSigma(n) == 2) {
                if (this.mMol.getAtomicNo(nArray[0]) == 16) {
                    this.storeEClass(458);
                } else {
                    this.storeEClass(459);
                }
                return;
            }
        }
        if (this.getAtomZ(n) == 3) {
            this.storeEClass(466);
            return;
        }
        if (this.getAtomZ(n) == 4) {
            this.storeEClass(467);
        }
    }

    private int classI(int n) {
        int[] nArray = new int[]{352, 353, 355, 354, 356, 359, 358, 357, 360, 361, 362, 368, 370, 369, 364, 365, 366, 367, 371, 372, 373, 374, 375, 380, 381, 377, 376, 382, 383, 378, 379};
        this.mMol.setAtomMarker(n, false);
        if (this.mMol.getConnAtoms(n) > 1) {
            return 363;
        }
        int n2 = this.classHal(n, 53);
        if (n2 < 0) {
            return n2;
        }
        return nArray[n2];
    }

    private int classBr(int n) {
        int[] nArray = new int[]{320, 321, 323, 322, 324, 327, 326, 325, 328, 329, 330, 336, 338, 337, 332, 333, 334, 335, 339, 340, 341, 342, 343, 348, 349, 345, 344, 350, 351, 346, 347};
        this.mMol.setAtomMarker(n, false);
        if (this.mMol.getConnAtoms(n) > 1) {
            return -2;
        }
        int n2 = this.classHal(n, 35);
        if (n2 < 0) {
            return n2;
        }
        return nArray[n2];
    }

    private int classCl(int n) {
        int[] nArray = new int[]{288, 289, 291, 290, 292, 295, 294, 293, 296, 297, 298, 304, 306, 305, 300, 301, 302, 303, 307, 308, 309, 310, 311, 316, 317, 313, 312, 318, 319, 314, 315};
        this.mMol.setAtomMarker(n, false);
        if (this.mMol.getConnAtoms(n) > 1) {
            return -2;
        }
        int n2 = this.classHal(n, 17);
        if (n2 < 0) {
            return n2;
        }
        return nArray[n2];
    }

    private int classF(int n) {
        int[] nArray = new int[]{256, 257, 259, 258, 260, 263, 262, 261, 264, 265, 266, 272, 274, 273, 268, 269, 270, 271, 275, 276, 277, 278, 279, 284, 285, 281, 280, 286, 287, 282, 283};
        this.mMol.setAtomMarker(n, false);
        if (this.mMol.getConnAtoms(n) > 1) {
            return -2;
        }
        int n2 = this.classHal(n, 9);
        if (n2 < 0) {
            return n2;
        }
        return nArray[n2];
    }

    private int classHal(int n, int n2) {
        int[] nArray = new int[3];
        if (this.mMol.getConnAtoms(n) != 1) {
            return -2;
        }
        int n3 = this.mMol.getConnAtom(n, 0);
        if (this.mMol.getAtomicNo(n3) == 6) {
            if (this.bondToMet(n3)) {
                return -1;
            }
            if (this.mMol.isAromaticAtom(n3)) {
                return 0;
            }
            switch (this.getAtomZ(n3)) {
                case 1: {
                    if (this.getAtomPi(n3) == 2) {
                        return 1;
                    }
                    if (this.getAtomPi(n3) == 1) {
                        if (this.getAtomSigma(n3) == 1) {
                            return 2;
                        }
                        return 3;
                    }
                    if (this.mMol.isAllylicAtom(n3)) {
                        return 4;
                    }
                    switch (this.getAtomSigma(n3)) {
                        case 3: {
                            return 5;
                        }
                        case 2: {
                            return 6;
                        }
                    }
                    return 7;
                }
                case 2: {
                    if (this.getHeteros(n3, nArray, n) != 1) {
                        return -2;
                    }
                    if (this.getAtomPi(n3) != 0) {
                        return 8;
                    }
                    if (this.mMol.isAllylicAtom(n3)) {
                        return 9;
                    }
                    return 10;
                }
                case 3: {
                    int n4 = this.getHeteros(n3, nArray, n);
                    if (n4 == 1) {
                        if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                            this.mMol.setAtomMarker(nArray[0], false);
                            return 11;
                        }
                        if (this.mMol.getAtomicNo(nArray[0]) == 7) {
                            return 12;
                        }
                        return 13;
                    }
                    if (this.mMol.getAtomicNo(nArray[0]) == n2 && this.mMol.getAtomicNo(nArray[1]) == n2) {
                        this.mMol.setAtomMarker(nArray[0], false);
                        this.mMol.setAtomMarker(nArray[1], false);
                        if (this.mMol.isStabilizedAtom(n3)) {
                            return 14;
                        }
                        return 15;
                    }
                    if (this.mMol.isStabilizedAtom(n3)) {
                        return 16;
                    }
                    return 17;
                }
                case 4: {
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    int n5 = this.getSortedHeteros(n3, nArray, nArray2, nArray3, n);
                    if (n5 == 1) {
                        if (this.mMol.getConnAtoms(nArray[0]) == 2) {
                            this.mMol.setAtomMarker(nArray[0], false);
                        }
                        return 18;
                    }
                    if (n5 == 2) {
                        if (this.mMol.getAtomicNo(nArray[0]) == 8) {
                            return 19;
                        }
                        if (this.mMol.getAtomicNo(nArray[0]) == 7) {
                            return 20;
                        }
                        return 21;
                    }
                    if (n5 != 3) break;
                    return 22;
                }
            }
            return -2;
        }
        if (this.mMol.getAtomicNo(n3) == 7) {
            if (this.mMol.isStabilizedAtom(n3)) {
                return 23;
            }
            return 24;
        }
        if (this.mMol.getAtomicNo(n3) == 8) {
            int n6 = this.getNextConn(n3, n);
            if (n6 == -1 || this.mMol.getAtomicNo(n6) == 6) {
                return 26;
            }
            return 25;
        }
        if (this.mMol.getAtomicNo(n3) == 5) {
            return 27;
        }
        if (this.mMol.getAtomicNo(n3) == 14) {
            return 28;
        }
        if (this.mMol.getAtomicNo(n3) == 15) {
            return 29;
        }
        if (this.mMol.getAtomicNo(n3) == 16) {
            return 30;
        }
        return -2;
    }

    private int classN(int n) {
        int n2;
        int n3;
        int[] nArray = new int[3];
        int[] nArray2 = new int[16];
        this.mMol.setAtomMarker(n, false);
        if (this.mMol.getConnAtoms(n) == 0) {
            return -2;
        }
        for (n3 = 0; n3 < this.mMol.getConnAtoms(n); ++n3) {
            n2 = this.mMol.getConnAtom(n, n3);
            if (!this.mMol.isElectropositive(n2)) continue;
            if (this.mMol.getAtomicNo(n2) == 14) {
                if (this.mMol.getConnAtoms(n) == 3) {
                    if (this.mMol.isStabilizedAtom(n)) {
                        return 157;
                    }
                    return 159;
                }
                if (this.mMol.isStabilizedAtom(n)) {
                    return 156;
                }
                return 158;
            }
            if (this.mMol.getAtomicNo(n2) == 5) {
                return 190;
            }
            return 191;
        }
        if (this.mMol.isAromaticAtom(n)) {
            if (this.getAtomPi(n) != 0) {
                return 184;
            }
            return 185;
        }
        if (this.isThreeRingAtom(n)) {
            n3 = 0;
            for (n2 = 0; n2 < this.mMol.getConnAtoms(n); ++n2) {
                nArray[n3] = this.mMol.getConnAtom(n, n2);
                if (!this.isThreeRingAtom(nArray[n3])) continue;
                ++n3;
            }
            if (n3 > 1) {
                if (this.mMol.getAtomicNo(nArray[0]) == 6 && this.mMol.getAtomicNo(nArray[1]) == 6) {
                    if (this.getAtomPi(nArray[0]) != 0 || this.getAtomPi(nArray[1]) != 0) {
                        return 700;
                    }
                    if (this.getAtomZ(nArray[0]) == 1 && this.getAtomZ(nArray[1]) == 1) {
                        if (this.mMol.isAllylicAtom(nArray[0]) || this.mMol.isAllylicAtom(nArray[1])) {
                            return 701;
                        }
                        return 703;
                    }
                    return 702;
                }
                return 189;
            }
        }
        for (n3 = 0; n3 < this.mMol.getConnAtoms(n); ++n3) {
            if (this.mMol.getConnBondOrder(n, n3) != 1 || this.mMol.getAtomicNo(n2 = this.mMol.getConnAtom(n, n3)) != 6) continue;
            this.classCN(n2);
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n4 = this.getSortedHeteros(n, nArray2, nArray3, nArray4, -1);
        if (this.mMol.getAtomCharge(n) == -1) {
            return -1;
        }
        if (this.mMol.getAtomCharge(n) == 1) {
            switch (this.getAtomZ(n)) {
                case 4: {
                    if (this.mMol.getConnAtoms(n) == 2 && this.mMol.getAtomicNo(this.mMol.getConnAtom(n, 0)) == 7 && this.mMol.getAtomicNo(this.mMol.getConnAtom(n, 1)) == 7) {
                        int n5 = this.getNextConn(this.mMol.getConnAtom(n, 0), n);
                        if (n5 == -1) {
                            n5 = this.getNextConn(this.mMol.getConnAtom(n, 1), n);
                        }
                        if (n5 == -1) {
                            return -2;
                        }
                        if (this.hasDBondToHetero(n5)) {
                            return 512;
                        }
                        if (this.mMol.getAtomicNo(n5) != 6) {
                            return 513;
                        }
                        if (this.getAtomPi(n5) != 0) {
                            return 514;
                        }
                        return 515;
                    }
                    if (this.mMol.getConnAtoms(n) == 3 && this.mMol.getAtomicNo(this.mMol.getConnAtom(n, 0)) == 8 && this.mMol.getAtomicNo(this.mMol.getConnAtom(n, 1)) == 8 && this.mMol.getAtomicNo(this.mMol.getConnAtom(n, 1)) == 8) {
                        for (int i = 0; i < 3; ++i) {
                            int n6 = this.mMol.getConnAtom(n, i);
                            if (this.mMol.getConnAtoms(n6) != 1) continue;
                            this.mMol.setAtomMarker(n6, false);
                        }
                        return 517;
                    }
                    return -1;
                }
                case 3: {
                    if (n4 == 3) {
                        return 531;
                    }
                    if (n4 == 2) {
                        if (this.mMol.getAtomicNo(nArray2[0]) == 8 && this.mMol.getAtomicNo(nArray2[1]) == 8 && this.mMol.getConnAtoms(nArray2[1]) == 1) {
                            this.mMol.setAtomMarker(nArray2[0], false);
                            this.mMol.setAtomMarker(nArray2[1], false);
                            return 521;
                        }
                        if (this.mMol.getAtomicNo(nArray2[0]) == 7 && this.mMol.getAtomicNo(nArray2[1]) == 8) {
                            if (this.mMol.getConnAtoms(nArray2[1]) == 1) {
                                this.mMol.setAtomMarker(nArray2[1], false);
                            }
                            return 522;
                        }
                        return 523;
                    }
                    return 519;
                }
                case 2: {
                    return 530;
                }
                case 1: {
                    if (this.mMol.getAtomicNo(nArray2[0]) == 8) {
                        if (this.mMol.getConnAtoms(nArray2[0]) == 1) {
                            this.mMol.setAtomMarker(nArray2[0], false);
                        }
                        switch (this.getAtomPi(n)) {
                            case 2: {
                                return 527;
                            }
                        }
                        return 526;
                    }
                    return 529;
                }
            }
            switch (this.getAtomPi(n)) {
                case 2: {
                    return 518;
                }
            }
            return 528;
        }
        switch (this.getAtomZ(n)) {
            case 3: {
                if (nArray3[0] != 0) {
                    return -1;
                }
                if (nArray4[0] != 0) {
                    if (this.mMol.getAtomicNo(nArray2[0]) == 7) {
                        if (this.mMol.getAtomicNo(nArray2[1]) == 7) {
                            return 615;
                        }
                        if (this.mMol.getAtomicNo(nArray2[1]) == 8) {
                            return 614;
                        }
                        return 613;
                    }
                    if (this.mMol.getAtomicNo(nArray2[0]) == 8) {
                        this.mMol.setAtomMarker(nArray2[0], false);
                        if (this.mMol.getAtomicNo(nArray2[1]) == 7) {
                            return 608;
                        }
                        if (this.mMol.getAtomicNo(nArray2[1]) == 8) {
                            return 609;
                        }
                        return 610;
                    }
                    return 611;
                }
                return 612;
            }
            case 2: {
                if (nArray4[0] != 0) {
                    if (this.mMol.getAtomicNo(nArray2[0]) == 7) {
                        if (this.mMol.getAtomCharge(nArray2[0]) == 1) {
                            return -1;
                        }
                        return 616;
                    }
                    if (this.mMol.getAtomicNo(nArray2[0]) == 8) {
                        this.mMol.setAtomMarker(nArray2[0], false);
                        return 617;
                    }
                    return 618;
                }
                return 619;
            }
            case 1: {
                if (this.mMol.getAtomicNo(nArray2[0]) == 7) {
                    switch (this.getAtomSigma(n)) {
                        case 2: {
                            return 620;
                        }
                        case 1: {
                            return 628;
                        }
                    }
                    return 624;
                }
                if (this.mMol.getAtomicNo(nArray2[0]) == 8) {
                    switch (this.getAtomSigma(n)) {
                        case 2: {
                            if (this.mMol.getConnAtoms(nArray2[0]) == 1) {
                                this.mMol.setAtomMarker(nArray2[0], false);
                                return 622;
                            }
                            return 623;
                        }
                        case 1: {
                            if (this.mMol.getConnAtoms(nArray2[0]) == 1) {
                                this.mMol.setAtomMarker(nArray2[0], false);
                                return 630;
                            }
                            return 631;
                        }
                    }
                    return 625;
                }
                switch (this.getAtomSigma(n)) {
                    case 2: {
                        return 621;
                    }
                    case 1: {
                        return 629;
                    }
                }
                return 626;
            }
        }
        if (this.mMol.getConnBondOrder(n, 0) == 3) {
            int n7 = this.mMol.getConnAtom(n, 0);
            int n8 = this.getNextConn(n7, n);
            if (n8 == -1) {
                return 476;
            }
            if (this.mMol.isElectronegative(n8)) {
                return 477;
            }
            if (this.mMol.isElectropositive(n8)) {
                if (this.mMol.getAtomicNo(n8) == 5 || this.mMol.getAtomicNo(n8) == 14) {
                    return 478;
                }
                return 479;
            }
            if (this.getAtomPi(n8) != 0) {
                return 472;
            }
            switch (this.getAtomZ(n8)) {
                case 0: {
                    return 473;
                }
                case 1: {
                    return 474;
                }
            }
            return 475;
        }
        int n9 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (!this.hasDBondToHetero(this.mMol.getConnAtom(n, i))) continue;
            ++n9;
        }
        switch (this.getAtomSigma(n)) {
            case 3: {
                switch (n9) {
                    case 0: {
                        return 632;
                    }
                    case 1: {
                        return 637;
                    }
                }
                return 639;
            }
            case 2: {
                switch (n9) {
                    case 0: {
                        return 633;
                    }
                    case 1: {
                        return 636;
                    }
                }
                return 638;
            }
        }
        if (n9 != 0) {
            return 635;
        }
        return 634;
    }

    private void classCN(int n) {
        if (this.mMol.isAromaticAtom(n)) {
            this.storeEClass(576);
            return;
        }
        if (this.hasDBondToHetero(n)) {
            this.storeEClass(584);
            return;
        }
        if (this.getAtomZ(n) == 1) {
            if (this.getAtomPi(n) != 0) {
                if (this.getAtomSigma(n) == 1) {
                    this.storeEClass(578);
                } else {
                    this.storeEClass(579);
                }
                return;
            }
            if (this.mMol.isAllylicAtom(n)) {
                this.storeEClass(583);
            }
            switch (this.getAtomSigma(n)) {
                case 3: {
                    this.storeEClass(580);
                    return;
                }
                case 2: {
                    this.storeEClass(581);
                    return;
                }
            }
            this.storeEClass(582);
            return;
        }
        if (this.getAtomZ(n) == 2) {
            if (this.getAtomPi(n) != 0) {
                this.storeEClass(577);
                return;
            }
            switch (this.getAtomSigma(n)) {
                case 2: {
                    this.storeEClass(585);
                    return;
                }
                case 1: {
                    this.storeEClass(586);
                    return;
                }
            }
            this.storeEClass(587);
            return;
        }
        if (this.getAtomZ(n) == 3) {
            if (this.getAtomSigma(n) != 0) {
                this.storeEClass(588);
            } else {
                this.storeEClass(589);
            }
            return;
        }
        this.storeEClass(590);
    }

    private int classO(int n) {
        int n2;
        int[] nArray = new int[]{0, 21, 41, 60, 78, 95, 111, 126, 140, 153, 165, 176, 186, 195, 203, 210, 216, 221, 225, 228, 230, 231};
        int[] nArray2 = new int[]{848, 863, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 862, 911, 991, 975, 927, 1007, 1023, 943};
        int[] nArray3 = new int[]{836, 768, 820, 821, 832, 833, 834, 835, 788, 484, 486, 487, 752, 753, 944, 896, 976, 960, 912, 992, 1008, 928, 769, 805, 804, 772, 773, 774, 775, 792, 776, 778, 779, 780, 781, 945, 897, 977, 961, 913, 993, 1009, 929, 816, 817, 824, 825, 826, 827, 790, 809, 813, 815, 801, 803, 807, 898, 978, 962, 914, 994, 1010, 930, 818, 828, 829, 830, 831, 791, 808, 812, 814, 800, 802, 806, 899, 979, 963, 915, 995, 1011, 931, 837, 838, 840, 841, 784, 480, 488, 492, 504, 508, 948, 900, 980, 964, 916, 996, 1012, 932, 839, 842, 844, 785, 481, 489, 493, 505, 509, 949, 901, 981, 965, 917, 997, 1013, 933, 845, 846, 786, 482, 490, 494, 506, 510, 950, 902, 982, 966, 918, 998, 1014, 934, 847, 787, 483, 491, 495, 507, 511, 951, 903, 983, 967, 919, 999, 1015, 935, 789, 798, 797, 796, 794, 795, 952, 904, 984, 968, 920, 1000, 1016, 936, 496, 498, 500, 760, 764, 953, 905, 985, 969, 921, 1001, 1017, 937, 499, 502, 762, 766, 954, 906, 986, 970, 922, 1002, 1018, 938, 503, 763, 767, 955, 907, 987, 971, 923, 1003, 1019, 939, 756, 758, 956, 908, 988, 972, 924, 1004, 1020, 940, 759, 957, 909, 989, 973, 925, 1005, 1021, 941, 958, 910, 990, 974, 926, 1006, 1022, 942, 874, 880, 888, 883, 864, 872, 892, 885, 884, 881, 869, 877, 886, 890, 889, 868, 876, 891, 882, 865, 873, 893, 870, 871, 866, 878, 879, 894};
        this.mMol.setAtomMarker(n, false);
        if (this.mMol.getConnAtoms(n) == 0) {
            return -2;
        }
        if (this.mMol.isAromaticAtom(n)) {
            return 186;
        }
        if (this.mMol.getConnAtoms(n) == 1) {
            if (this.mMol.getConnBondOrder(n, 0) == 2) {
                return -1;
            }
            int n3 = this.classAtmO(this.mMol.getConnAtom(n, 0));
            return nArray2[n3];
        }
        int n4 = this.mMol.getConnAtom(n, 0);
        int n5 = this.mMol.getConnAtom(n, 1);
        if (this.isThreeRingAtom(n)) {
            if (this.mMol.getAtomicNo(n4) == 6 && this.mMol.getAtomicNo(n5) == 6) {
                if (this.getAtomPi(n4) != 0 || this.getAtomPi(n5) != 0) {
                    return 696;
                }
                if (this.getAtomZ(n4) == 1 && this.getAtomZ(n5) == 1) {
                    if (this.mMol.isAllylicAtom(n4) || this.mMol.isAllylicAtom(n5)) {
                        return 697;
                    }
                    return 699;
                }
                return 698;
            }
            return 189;
        }
        int n6 = this.classAtmO(n4);
        if (n6 > (n2 = this.classAtmO(n5))) {
            int n7 = n6;
            n6 = n2;
            n2 = n7;
        }
        return nArray3[nArray[n6] + n2];
    }

    private int classAtmO(int n) {
        if (this.mMol.getAtomicNo(n) == 6) {
            if (this.mMol.isAromaticAtom(n)) {
                return 0;
            }
            if (this.hasDBondToHetero(n)) {
                return 1;
            }
            if (this.getAtomZ(n) == 1) {
                if (this.getAtomPi(n) != 0) {
                    if (this.getAtomSigma(n) == 1) {
                        return 2;
                    }
                    return 3;
                }
                switch (this.getAtomSigma(n)) {
                    case 3: {
                        return 4;
                    }
                    case 2: {
                        return 5;
                    }
                    case 1: {
                        return 6;
                    }
                }
                return 7;
            }
            if (this.getAtomZ(n) == 2) {
                if (this.getAtomPi(n) != 0) {
                    return 8;
                }
                switch (this.getAtomSigma(n)) {
                    case 2: {
                        return 9;
                    }
                    case 1: {
                        return 10;
                    }
                }
                return 11;
            }
            if (this.getAtomZ(n) == 3) {
                if (this.getAtomSigma(n) != 0) {
                    return 12;
                }
                return 13;
            }
            return 14;
        }
        switch (this.mMol.getAtomicNo(n)) {
            case 5: {
                return 15;
            }
            case 7: {
                return 16;
            }
            case 8: {
                return 17;
            }
            case 14: {
                return 18;
            }
            case 15: {
                return 19;
            }
            case 16: {
                return 20;
            }
        }
        return 21;
    }

    private int classC(int n) {
        int n2;
        int[][] nArrayArray = new int[][]{{-1, 192, 194, 193, 195}, {192, 200, 202, 201, 203}, {194, 202, 196, 197, 198}, {193, 201, 197, 204, 205}, {195, 203, 198, 205, 199}};
        this.mMol.setAtomMarker(n, false);
        if (this.isThreeRingAtom(n)) {
            int[] nArray = new int[3];
            this.getRingMembers(n, 3, false, nArray);
            if (this.mMol.getAtomicNo(nArray[1]) != 6 || this.mMol.getAtomicNo(nArray[2]) != 6) {
                return -2;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < 3; ++i) {
                this.mMol.setAtomMarker(nArray[i], false);
                if (this.getAtomPi(nArray[i]) != 0) {
                    bl = true;
                }
                if (this.mMol.isStabilizedAtom(nArray[i])) {
                    bl2 = true;
                }
                if (!this.mMol.isAllylicAtom(nArray[i])) continue;
                bl3 = true;
            }
            if (bl) {
                return 228;
            }
            if (bl2) {
                return 230;
            }
            if (bl3) {
                return 231;
            }
            return 229;
        }
        if (this.getAtomPi(n) == 0) {
            if (this.mMol.getAtomParity(n) == 0) {
                return -2;
            }
            if (this.getAtomSigma(n) + this.getAtomZ(n) == 4) {
                return 240;
            }
            if (this.mMol.isStabilizedAtom(n)) {
                return 241;
            }
            if (this.mMol.isAllylicAtom(n)) {
                return 242;
            }
            return 243;
        }
        int[] nArray = new int[16];
        int n3 = this.getPiConnCarbs(n, nArray);
        if (this.getAtomPi(n) == 2 && n3 == 1) {
            this.mMol.setAtomMarker(nArray[0], false);
            int n4 = this.classAcetylen(n, nArray[0]);
            int n5 = this.classAcetylen(nArray[0], n);
            if (n4 == 5 || n5 == 5) {
                return 206;
            }
            if (n4 == 6 || n5 == 6) {
                return 207;
            }
            return nArrayArray[n4][n5];
        }
        if (this.bondToMet(n)) {
            return -1;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.bondToMet(nArray[n2])) continue;
            return -1;
        }
        if (this.getAtomPi(n) == 2) {
            n2 = 0;
            for (int i = 0; i < 2; ++i) {
                if (this.mMol.isStabilizedAtom(nArray[i])) {
                    n2 = 1;
                }
                this.mMol.setAtomMarker(nArray[i], false);
            }
            if (this.getAtomZ(nArray[0]) != 0 || this.getAtomZ(nArray[1]) != 0) {
                if (n2 != 0) {
                    return 232;
                }
                return 233;
            }
            if (n2 != 0) {
                return 234;
            }
            return 235;
        }
        if (this.getAtomPi(nArray[0]) == 2) {
            return -1;
        }
        this.mMol.setAtomMarker(nArray[0], false);
        if (this.mMol.isAromaticAtom(n)) {
            int[] nArray2 = new int[16];
            int n6 = this.getRingMembers(n, 0, true, nArray2);
            if (n6 == 0) {
                return -2;
            }
            boolean bl = false;
            boolean bl4 = false;
            for (int i = 0; i < n6; ++i) {
                this.mMol.setAtomMarker(nArray2[i], false);
                for (int j = 0; j < this.mMol.getConnAtoms(nArray2[i]); ++j) {
                    int n7 = this.mMol.getConnAtom(nArray2[i], j);
                    if (this.mMol.isAromaticAtom(n7)) continue;
                    if (this.hasDBondToHetero(n7)) {
                        bl = true;
                        continue;
                    }
                    if (!this.mMol.isElectronegative(n7)) continue;
                    bl4 = true;
                }
            }
            if (bl) {
                this.storeEClass(236);
            }
            if (bl4) {
                this.storeEClass(237);
            }
            if (!bl && !bl4) {
                return 238;
            }
            return -1;
        }
        nArray[1] = n;
        n2 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.mMol.getConnAtoms(nArray[i]); ++j) {
                int n12 = this.mMol.getConnAtom(nArray[i], j);
                if (this.mMol.isElectropositive(n12) || n12 == nArray[1 - i]) continue;
                if (this.mMol.isAromaticAtom(n12)) {
                    ++n11;
                    continue;
                }
                if (this.hasDBondToHetero(n12)) {
                    ++n8;
                    continue;
                }
                if (this.mMol.isElectronegative(n12)) {
                    ++n9;
                    continue;
                }
                if (this.getAtomPi(n12) != 0) {
                    ++n2;
                    continue;
                }
                ++n10;
            }
        }
        if (n9 > 2) {
            if (n8 != 0) {
                return 223;
            }
            return 224;
        }
        if (n9 == 2) {
            if (n8 != 0) {
                return 222;
            }
            return 225;
        }
        if (n8 > 2) {
            return 216;
        }
        if (n8 == 2) {
            if (n9 != 0) {
                return 220;
            }
            return 217;
        }
        if (n9 == 1) {
            if (n8 == 1) {
                return 221;
            }
            if (n2 + n10 + n11 > 1) {
                return 227;
            }
            return 226;
        }
        if (n8 == 1) {
            if (n2 + n10 + n11 > 1) {
                return 218;
            }
            return 219;
        }
        switch (n2 + n10 + n11) {
            case 4: {
                if (n10 == 4) {
                    return 214;
                }
                return 215;
            }
            case 3: {
                if (n10 == 3) {
                    return 212;
                }
                return 213;
            }
            case 2: {
                if (n10 == 2) {
                    return 210;
                }
                return 211;
            }
        }
        if (n10 == 1) {
            return 208;
        }
        return 209;
    }

    private int classAcetylen(int n, int n2) {
        if (this.mMol.getConnAtoms(n) == 1) {
            return 0;
        }
        int n3 = this.getNextConn(n, n2);
        if (this.mMol.isAromaticAtom(n3)) {
            return 1;
        }
        if (this.mMol.isElectronegative(n3)) {
            return 2;
        }
        if (this.mMol.isElectropositive(n3)) {
            if (this.mMol.getAtomicNo(n3) == 5) {
                return 5;
            }
            return 6;
        }
        if (this.getAtomPi(n3) != 0) {
            return 3;
        }
        return 4;
    }

    private void storeEClass(int n) {
        if (n == -1) {
            return;
        }
        if (n == -2) {
            return;
        }
        Integer n2 = this.mFunctionalGroupCountMap.get(n);
        this.mFunctionalGroupCountMap.put(n, n2 == null ? 1 : n2 + 1);
    }

    private int getPiConnCarbs(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n3;
            if (this.mMol.getConnBondOrder(n, i) <= 1 || this.mMol.getAtomicNo(n3 = this.mMol.getConnAtom(n, i)) != 6) continue;
            nArray[n2++] = n3;
        }
        return n2;
    }

    private int getRingMembers(int n, int n2, boolean bl, int[] nArray) {
        RingCollection ringCollection = this.mMol.getRingSet();
        nArray[0] = n;
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            if (ringCollection.getRingSize(i) != n2 && n2 != 0 || !ringCollection.isAromatic(i) && bl) continue;
            int[] nArray2 = ringCollection.getRingAtoms(i);
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j] != n) continue;
                int n3 = 1;
                for (int k = 0; k < nArray2.length; ++k) {
                    if (nArray2[k] == n) continue;
                    nArray[n3++] = nArray2[k];
                }
                return nArray2.length;
            }
        }
        return 0;
    }

    private boolean hasDBondToHetero(int n) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (this.mMol.getConnBondOrder(n, i) != 2 || !this.mMol.isElectronegative(this.mMol.getConnAtom(n, i))) continue;
            return true;
        }
        return false;
    }

    private int getCarbons(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n3 = this.mMol.getConnAtom(n, i);
            if (this.mMol.getAtomicNo(n3) != 6) continue;
            nArray[n2++] = n3;
        }
        return n2;
    }

    private int getHeteros(int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n4 = this.mMol.getConnAtom(n, i);
            if (n4 == n2 || !this.mMol.isElectronegative(n4)) continue;
            nArray[n3++] = n4;
        }
        return n3;
    }

    private int getSortedHeteros(int n, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.mMol.getConnAtoms(n); ++n4) {
            if (this.mMol.getConnBondOrder(n, n4) != 3 || (n3 = this.mMol.getConnAtom(n, n4)) == n2 || !this.mMol.isElectronegative(n3)) continue;
            nArray[n5++] = n3;
        }
        nArray2[0] = n5;
        for (n4 = 0; n4 < this.mMol.getConnAtoms(n); ++n4) {
            if (this.mMol.getConnBondOrder(n, n4) != 2 || (n3 = this.mMol.getConnAtom(n, n4)) == n2 || !this.mMol.isElectronegative(n3)) continue;
            nArray[n5++] = n3;
        }
        nArray3[0] = n5 - nArray2[0];
        for (n4 = 0; n4 < this.mMol.getConnAtoms(n); ++n4) {
            if (this.mMol.getConnBondOrder(n, n4) != 1 || (n3 = this.mMol.getConnAtom(n, n4)) == n2 || !this.mMol.isElectronegative(n3)) continue;
            nArray[n5++] = n3;
        }
        return n5;
    }

    private int getNextConn(int n, int n2) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (this.mMol.getConnAtom(n, i) == n2) continue;
            return this.mMol.getConnAtom(n, i);
        }
        return -1;
    }

    private boolean checkAnhydride(int n, int n2) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n3 = this.mMol.getConnAtom(n, i);
            if (n3 == n2 || !this.hasDBondToHetero(n3)) continue;
            return true;
        }
        return false;
    }

    private boolean bondToMet(int n) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (!this.mMol.isMetalAtom(this.mMol.getConnAtom(n, i))) continue;
            return true;
        }
        return false;
    }

    private boolean isQuinone(int n) {
        int n2;
        int[] nArray = new int[6];
        int[] nArray2 = new int[16];
        if (this.getRingMembers(n, 6, false, nArray) != 6) {
            return false;
        }
        boolean bl = false;
        for (n2 = 1; n2 < 6; ++n2) {
            if (this.mMol.getAtomicNo(nArray[n2]) != 6) {
                return false;
            }
            if (this.getAtomPi(nArray[n2]) != 0) continue;
            if ((n2 & 1) == 0) {
                return false;
            }
            if (bl) {
                return false;
            }
            if (this.getAtomZ(nArray[n2]) != 2) {
                return false;
            }
            if (this.getHeteros(nArray[n2], nArray2, -1) != 1) {
                return false;
            }
            if (this.mMol.getAtomicNo(nArray2[0]) != 8) {
                return false;
            }
            bl = true;
        }
        if (!bl) {
            return false;
        }
        for (n2 = 1; n2 < 6; ++n2) {
            this.mMol.setAtomMarker(nArray[n2], false);
        }
        return true;
    }

    private boolean isThreeRingAtom(int n) {
        return this.mMol.getAtomRingSize(n) == 3;
    }

    private int getAtomPi(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (this.mMol.getAtomicNo(this.mMol.getConnAtom(n, i)) != 6) continue;
            n2 += this.mMol.getConnBondOrder(n, i) - 1;
        }
        return n2;
    }

    private int getAtomSigma(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (this.mMol.getAtomicNo(this.mMol.getConnAtom(n, i)) != 6) continue;
            ++n2;
        }
        return n2;
    }

    private int getAtomZ(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (!this.mMol.isElectronegative(this.mMol.getConnAtom(n, i))) continue;
            n2 += this.mMol.getConnBondOrder(n, i);
        }
        return n2;
    }
}

