/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mcs.MCS;
import com.actelion.research.chem.reaction.Reaction;

public class CommonSubGraphHelper {
    public static Result getMCS(Reaction reaction, boolean[] blArray, SSSearcher sSSearcher) {
        MCS mCS = new MCS(0, sSSearcher);
        return CommonSubGraphHelper.getCommonSubGraph(mCS, reaction, blArray);
    }

    private static Result getCommonSubGraph(MCS mCS, Reaction reaction, boolean[] blArray) {
        Result result = null;
        try {
            int n = reaction.getReactants();
            int n2 = reaction.getProducts();
            StereoMolecule stereoMolecule = null;
            int n3 = -1;
            int n4 = -1;
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                StereoMolecule stereoMolecule2 = reaction.getReactant(i);
                for (int j = 0; j < n2; ++j) {
                    int n6;
                    StereoMolecule stereoMolecule3 = reaction.getProduct(j);
                    mCS.set(stereoMolecule3, stereoMolecule2, blArray);
                    StereoMolecule stereoMolecule4 = mCS.getMCS();
                    if (stereoMolecule4 == null || n5 >= (n6 = stereoMolecule4.getAllAtoms())) continue;
                    stereoMolecule = stereoMolecule4;
                    n3 = i;
                    n4 = j;
                    n5 = n6;
                }
            }
            if (stereoMolecule != null) {
                result = new Result(stereoMolecule, n3, n4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return result;
    }

    static class Result {
        private StereoMolecule molecule;
        private int reactant;
        private int product;

        public Result(StereoMolecule stereoMolecule, int n, int n2) {
            this.setMolecule(stereoMolecule);
            this.setReactant(n);
            this.setProduct(n2);
        }

        public String toString() {
            return "MCS Result: R=" + this.getReactant() + " P=" + this.getProduct() + " #Atoms=" + this.getMolecule().getAllAtoms();
        }

        public StereoMolecule getMolecule() {
            return this.molecule;
        }

        public void setMolecule(StereoMolecule stereoMolecule) {
            this.molecule = stereoMolecule;
        }

        public int getReactant() {
            return this.reactant;
        }

        public void setReactant(int n) {
            this.reactant = n;
        }

        public int getProduct() {
            return this.product;
        }

        public void setProduct(int n) {
            this.product = n;
        }
    }
}

