/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.calc.Logarithm;
import com.actelion.research.chem.properties.complexity.ResultFragmentsStatistic;
import com.actelion.research.util.Formatter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModelExhaustiveStatistics {
    public static final String TAG_ModelExhaustiveStatistics = "ModelExhaustiveStatistics";
    private static final String TAG_ATTR_NUM_BONDS_IN_FRAGMENT = "numBondsFragment";
    private static final String TAG_ATTR_NUM_FRAGMENTS = "numFragments";
    private static final String TAG_ATTR_NUM_UNIQUE = "numUniqueFrags";
    private static final String TAG_ATTR_RATIO_COVERED_BONDS = "ratioCoveredBonds";
    private int numBondsInFrag;
    private int nFragments;
    private int nUnique;
    private double ratioCoveredBonds;

    public ModelExhaustiveStatistics(int n, int n2, int n3, double d) {
        this.numBondsInFrag = n;
        this.nFragments = n2;
        this.nUnique = n3;
        this.ratioCoveredBonds = d;
    }

    public int getNumBondsInFragment() {
        return this.numBondsInFrag;
    }

    public int getFragments() {
        return this.nFragments;
    }

    public void setFragments(int n) {
        this.nFragments = n;
    }

    public int getUnique() {
        return this.nUnique;
    }

    public void setUnique(int n) {
        this.nUnique = n;
    }

    public double getRatioCoveredBonds() {
        return this.ratioCoveredBonds;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[# bonds in fragment=");
        stringBuilder.append(this.numBondsInFrag);
        stringBuilder.append(", fragments=");
        stringBuilder.append(this.nFragments);
        stringBuilder.append(", unique=");
        stringBuilder.append(this.nUnique);
        stringBuilder.append(", non overlapping=");
        stringBuilder.append(", ratio covered bonds=");
        stringBuilder.append(this.ratioCoveredBonds);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static Comparator<ModelExhaustiveStatistics> getComparatorNumBonds() {
        Comparator<ModelExhaustiveStatistics> comparator = new Comparator<ModelExhaustiveStatistics>(){

            @Override
            public int compare(ModelExhaustiveStatistics modelExhaustiveStatistics, ModelExhaustiveStatistics modelExhaustiveStatistics2) {
                if (modelExhaustiveStatistics.getNumBondsInFragment() > modelExhaustiveStatistics2.getNumBondsInFragment()) {
                    return 1;
                }
                if (modelExhaustiveStatistics.getNumBondsInFragment() < modelExhaustiveStatistics2.getNumBondsInFragment()) {
                    return -1;
                }
                return 0;
            }
        };
        return comparator;
    }

    public static String toString(ResultFragmentsStatistic resultFragmentsStatistic) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        List<ModelExhaustiveStatistics> list = resultFragmentsStatistic.getExhaustiveStatistics();
        Collections.sort(list, ModelExhaustiveStatistics.getComparatorNumBonds());
        stringBuilder.append("Num bonds");
        stringBuilder.append("\t");
        stringBuilder.append("Fragments");
        stringBuilder.append("\t");
        stringBuilder.append("Unique");
        stringBuilder.append("\t");
        stringBuilder.append("Sum isomorphs");
        stringBuilder.append("\t");
        stringBuilder.append("Ratio coverage by isomorph all");
        stringBuilder.append("\t");
        stringBuilder.append("Ratio coverage by isomorph max freq idcode");
        stringBuilder.append("\t");
        stringBuilder.append("ln(unique)");
        stringBuilder.append("\n");
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < list.size(); ++n) {
            ModelExhaustiveStatistics modelExhaustiveStatistics = list.get(n);
            n2 += modelExhaustiveStatistics.getFragments();
            n3 += modelExhaustiveStatistics.getUnique();
            stringBuilder.append(modelExhaustiveStatistics.getNumBondsInFragment());
            stringBuilder.append("\t");
            stringBuilder.append(modelExhaustiveStatistics.getFragments());
            stringBuilder.append("\t");
            stringBuilder.append(modelExhaustiveStatistics.getUnique());
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format3(modelExhaustiveStatistics.getRatioCoveredBonds()));
            stringBuilder.append("\t");
            double d = Logarithm.get(modelExhaustiveStatistics.getUnique(), Math.E);
            stringBuilder.append(Formatter.format3(d));
            stringBuilder.append("\n");
        }
        stringBuilder.append("Sum frags = " + n2 + "\tsum distinct " + n3);
        stringBuilder.append("\n");
        n = resultFragmentsStatistic.getBonds() / 4;
        stringBuilder.append("Bonds quarter " + n);
        stringBuilder.append("\n");
        stringBuilder.append("Bonds 1");
        stringBuilder.append("\t");
        stringBuilder.append("Bonds 2");
        stringBuilder.append("\t");
        stringBuilder.append("Slope");
        stringBuilder.append("\n");
        for (int i = 1; i < list.size(); ++i) {
            ModelExhaustiveStatistics modelExhaustiveStatistics = list.get(i - 1);
            ModelExhaustiveStatistics modelExhaustiveStatistics2 = list.get(i);
            double d = Math.log(modelExhaustiveStatistics.getUnique());
            double d2 = Math.log(modelExhaustiveStatistics2.getUnique());
            double d3 = d2 - d;
            stringBuilder.append(modelExhaustiveStatistics.getNumBondsInFragment() + "\t" + modelExhaustiveStatistics2.getNumBondsInFragment() + "\t" + Formatter.format3(d3));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public Element getXMLElement(Document document) throws ParserConfigurationException, DOMException, IOException {
        Element element = document.createElement(TAG_ModelExhaustiveStatistics);
        element.setAttribute(TAG_ATTR_NUM_BONDS_IN_FRAGMENT, Integer.toString(this.numBondsInFrag));
        element.setAttribute(TAG_ATTR_NUM_FRAGMENTS, Integer.toString(this.nFragments));
        element.setAttribute(TAG_ATTR_NUM_UNIQUE, Integer.toString(this.nUnique));
        element.setAttribute(TAG_ATTR_RATIO_COVERED_BONDS, Formatter.format4(this.ratioCoveredBonds));
        return element;
    }

    public static ModelExhaustiveStatistics readXMLElement(Element element) throws ParserConfigurationException, DOMException, IOException {
        int n = Integer.parseInt(element.getAttribute(TAG_ATTR_NUM_BONDS_IN_FRAGMENT));
        int n2 = Integer.parseInt(element.getAttribute(TAG_ATTR_NUM_FRAGMENTS));
        int n3 = Integer.parseInt(element.getAttribute(TAG_ATTR_NUM_UNIQUE));
        double d = Double.parseDouble(element.getAttribute(TAG_ATTR_RATIO_COVERED_BONDS));
        ModelExhaustiveStatistics modelExhaustiveStatistics = new ModelExhaustiveStatistics(n, n2, n3, d);
        return modelExhaustiveStatistics;
    }
}

