/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.chem.properties.complexity.ContainerBitArray;
import com.actelion.research.chem.properties.complexity.IBitArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContainerFragBondsSolutions {
    public static boolean ELUSIVE = false;
    private static int[] ARR_CAPACITY = new int[]{10, 100, 200, 400, 800, 1600, 3200, 6400, 18000, 36000, 70000, 140000, 280000, 560000, 1000000, 2000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000, 4000000};
    protected static double FACTOR_CAPACITY = 1.7;
    protected static int START_CAPACITY = 100;
    protected static int DEFAULT_CAPACITY = 2000000;
    protected static int MAX_NUM_BONDS = 100;
    private ContainerBitArray containerListFragmentDefinedByBonds;
    private List<HashMap<IBitArray, IBitArray>> liHMFragmentDefinedByBonds;
    private int bondsMolecule;
    private int maximumNumberBondsInFragment;
    private int bits;

    public ContainerFragBondsSolutions(int n, int n2) {
        this.bits = n;
        int[] nArray = this.getHashMapCapacity(n2);
        this.init(nArray, n2);
    }

    private int[] getHashMapCapacity(int n) {
        int n2;
        int n3 = 0;
        int[] nArray = new int[MAX_NUM_BONDS + 1];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 1;
        }
        n2 = 0;
        while (n2 < ARR_CAPACITY.length) {
            nArray[n2] = ARR_CAPACITY[n2];
            this.maximumNumberBondsInFragment = n2++;
            if ((n3 += nArray[n2]) >= n) break;
        }
        if (n3 < n) {
            n2 = ARR_CAPACITY.length;
            while (n2 < MAX_NUM_BONDS + 1) {
                nArray[n2] = DEFAULT_CAPACITY;
                this.maximumNumberBondsInFragment = n2++;
                if ((n3 += nArray[n2]) >= n) break;
            }
        }
        if (ELUSIVE) {
            System.out.println("ContainerFragBondsSolutions maximum number of bonds in a single fragment " + this.maximumNumberBondsInFragment + ".");
        }
        return nArray;
    }

    private void init(int[] nArray, int n) {
        int n2;
        int n3 = 0;
        if (ELUSIVE) {
            System.out.println("ContainerFragBondsSolutions Capacity");
            System.out.println("Bonds\tCapacity");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 += nArray[n2];
            if (!ELUSIVE) continue;
            int n4 = n2 + 1;
            System.out.println(n4 + "\t" + nArray[n2]);
        }
        if (ELUSIVE) {
            System.out.println("ContainerFragBondsSolutions initialized cumulated hash map capacity " + n3 + ".");
        }
        this.liHMFragmentDefinedByBonds = new ArrayList<HashMap<IBitArray, IBitArray>>();
        this.liHMFragmentDefinedByBonds.add(new HashMap());
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.liHMFragmentDefinedByBonds.add(new HashMap(nArray[n2]));
        }
        this.containerListFragmentDefinedByBonds = new ContainerBitArray(this.bits, n);
        if (ELUSIVE) {
            System.out.println("ContainerFragBondsSolutions constructor finished.");
        }
    }

    public boolean addFacultative(IBitArray iBitArray) {
        boolean bl = false;
        this.calculateHash(iBitArray);
        int n = this.getBitsSet(iBitArray);
        HashMap<IBitArray, IBitArray> hashMap = this.liHMFragmentDefinedByBonds.get(n);
        if (hashMap.containsKey(iBitArray)) {
            this.containerListFragmentDefinedByBonds.receycle(iBitArray);
        } else {
            hashMap.put(iBitArray, iBitArray);
            bl = true;
        }
        return bl;
    }

    public int getBitsSet(IBitArray iBitArray) {
        int n = 0;
        for (int i = 0; i < this.bondsMolecule; ++i) {
            if (!iBitArray.isBitSet(i)) continue;
            ++n;
        }
        return n;
    }

    public IBitArray getWithCopy(IBitArray iBitArray) {
        IBitArray iBitArray2 = this.containerListFragmentDefinedByBonds.get();
        iBitArray2.copyIntoThis(iBitArray);
        return iBitArray2;
    }

    public List<IBitArray> getList(int n) {
        HashMap<IBitArray, IBitArray> hashMap = this.liHMFragmentDefinedByBonds.get(n);
        return new ArrayList<IBitArray>(hashMap.values());
    }

    public int getBondsMolecule() {
        return this.bondsMolecule;
    }

    public void setBondsMolecule(int n) {
        this.bondsMolecule = n;
    }

    public void calculateHash(IBitArray iBitArray) {
        this.containerListFragmentDefinedByBonds.calculateHash(iBitArray);
    }

    public IBitArray get() {
        return this.containerListFragmentDefinedByBonds.get();
    }

    public int getSizeBinaryArray() {
        return this.containerListFragmentDefinedByBonds.getSizeBinaryArray();
    }

    public int getTotalSizeResults() {
        int n = 0;
        for (HashMap<IBitArray, IBitArray> hashMap : this.liHMFragmentDefinedByBonds) {
            n += hashMap.size();
        }
        return n;
    }

    public void reset() {
        for (HashMap<IBitArray, IBitArray> hashMap : this.liHMFragmentDefinedByBonds) {
            hashMap.clear();
        }
        this.containerListFragmentDefinedByBonds.reset();
    }

    public void reset(int n) {
        HashMap<IBitArray, IBitArray> hashMap = this.liHMFragmentDefinedByBonds.get(n);
        ArrayList<IBitArray> arrayList = new ArrayList<IBitArray>(hashMap.keySet());
        for (IBitArray iBitArray : arrayList) {
            this.containerListFragmentDefinedByBonds.receycle(iBitArray);
        }
        hashMap.clear();
    }

    public int getMaximumCapacityBondsInFragment() {
        return this.maximumNumberBondsInFragment;
    }

    public int getCapacity() {
        return this.containerListFragmentDefinedByBonds.getCapacity();
    }

    public int getAvailable() {
        return this.containerListFragmentDefinedByBonds.getAvailable();
    }

    public int getMaximumNumberBondsInMolecule() {
        return this.bits;
    }
}

