/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.MolecularFlexibilityCalculator;
import com.actelion.research.chem.prediction.CLogPPredictor;
import com.actelion.research.chem.prediction.FastMolecularComplexityCalculator;
import com.actelion.research.chem.prediction.MolecularShapeCalculator;
import com.actelion.research.chem.prediction.PolarSurfaceAreaPredictor;
import com.actelion.research.chem.prediction.PropertySpecification;
import com.actelion.research.chem.prediction.SolubilityPredictor;

public class MolecularPropertyHelper {
    public static final int MOLECULAR_PROPERTY_MOLWEIGHT = 0;
    public static final int MOLECULAR_PROPERTY_CLOGP = 1;
    public static final int MOLECULAR_PROPERTY_CLOGS = 2;
    public static final int MOLECULAR_PROPERTY_TPSA = 3;
    public static final int MOLECULAR_PROPERTY_HDONORS = 4;
    public static final int MOLECULAR_PROPERTY_HACCEPTORS = 5;
    public static final int MOLECULAR_PROPERTY_FLEXIBILITY = 6;
    public static final int MOLECULAR_PROPERTY_COMPLEXITY = 7;
    public static final int MOLECULAR_PROPERTY_SHAPE = 8;
    public static final int MOLECULAR_PROPERTY_ROTATABLEBONDS = 9;
    public static final int MOLECULAR_PROPERTY_STEREOCENTERS = 10;
    public static final int MOLECULAR_PROPERTY_SMALLRINGCOUNT = 11;
    public static final int MOLECULAR_PROPERTY_AROMRINGCOUNT = 12;
    public static final int MOLECULAR_PROPERTY_BASIC_NITROGENS = 13;
    public static final int MOLECULAR_PROPERTY_ACIDIC_OXYGENS = 14;
    public static final PropertySpecification[] SPEC = new PropertySpecification[]{new PropertySpecification("molweight", "Molecular weight", "", "400", 50.0f, 0.0f, 800.0f), new PropertySpecification("cLogP", "cLogP", "", "4", 0.5f, 0.0f, 8.0f), new PropertySpecification("cLogS", "cLogS", "-4", "", 0.5f, -8.0f, 2.0f), new PropertySpecification("tpsa", "Polar surface area", "", "120", 20.0f, 0.0f, 250.0f), new PropertySpecification("donors", "H-Donors", "", "5", 0.5f, 0.0f, 8.0f), new PropertySpecification("acceptors", "H-Acceptors", "", "10", 1.0f, 0.0f, 16.0f), new PropertySpecification("flexibility", "Molecular flexibility", "0.3", "0.7", 0.05f, 0.0f, 1.0f), new PropertySpecification("complexity", "Molecular complexity", "0.8", "", 0.05f, 0.0f, 1.0f), new PropertySpecification("shape", "Molecular shape", "", "0.5", 0.05f, 0.0f, 1.0f), new PropertySpecification("rotatableBonds", "Rotatable bond count", "", "4", 5.0f, 0.0f, 20.0f), new PropertySpecification("stereoCenters", "Stereo center count", "1", "3", 2.0f, 0.0f, 8.0f), new PropertySpecification("smallRings", "Ring count (<= 7 atoms)", "2", "", 1.0f, 0.0f, 10.0f), new PropertySpecification("aromaticRings", "Aromatic ring count", "", "2", 1.0f, 0.0f, 6.0f), new PropertySpecification("basicN", "Basic nitrogen count", "1", "", 0.5f, 0.0f, 6.0f), new PropertySpecification("acidicO", "Acidic oxygen count", "1", "", 0.5f, 0.0f, 6.0f)};

    public static float calculateProperty(StereoMolecule stereoMolecule, int n) {
        return n == 0 ? (float)stereoMolecule.getMolweight() : (n == 1 ? new CLogPPredictor().assessCLogP(stereoMolecule) : (n == 2 ? new SolubilityPredictor().assessSolubility(stereoMolecule) : (n == 3 ? new PolarSurfaceAreaPredictor().assessPSA(stereoMolecule) : (n == 4 ? (float)MolecularPropertyHelper.getHDonorCount(stereoMolecule) : (n == 5 ? (float)MolecularPropertyHelper.getHAcceptorCount(stereoMolecule) : (n == 9 ? (float)stereoMolecule.getRotatableBondCount() : (n == 6 ? new MolecularFlexibilityCalculator().calculateMolecularFlexibility(stereoMolecule) : (n == 7 ? FastMolecularComplexityCalculator.assessComplexity(stereoMolecule) : (n == 8 ? MolecularShapeCalculator.assessShape(stereoMolecule) : (n == 10 ? (float)stereoMolecule.getStereoCenterCount() : (n == 11 ? (float)stereoMolecule.getRingSet().getSize() : (n == 12 ? (float)stereoMolecule.getAromaticRingCount() : (n == 13 ? (float)MolecularPropertyHelper.getBasicNitrogenCount(stereoMolecule) : (n == 14 ? (float)MolecularPropertyHelper.getAcidicOxygenCount(stereoMolecule) : Float.NaN))))))))))))));
    }

    public static int getPropertyCount() {
        return SPEC.length;
    }

    public static String getPropertyName(int n) {
        return MolecularPropertyHelper.SPEC[n].name;
    }

    public static String getPropertyCode(int n) {
        return MolecularPropertyHelper.SPEC[n].code;
    }

    public static String getPreferredMin(int n) {
        return MolecularPropertyHelper.SPEC[n].min;
    }

    public static String getPreferredMax(int n) {
        return MolecularPropertyHelper.SPEC[n].max;
    }

    public static float getRangeMin(int n) {
        return MolecularPropertyHelper.SPEC[n].rangeMin;
    }

    public static float getRangeMax(int n) {
        return MolecularPropertyHelper.SPEC[n].rangeMax;
    }

    public static double getValuation(double d, double d2, double d3, double d4) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d5 = 1.0;
        if (!Double.isNaN(d2)) {
            d5 *= 1.0 / (1.0 + Math.exp((d2 - d) / d4));
        }
        if (!Double.isNaN(d3)) {
            d5 *= 1.0 / (1.0 + Math.exp((d - d3) / d4));
        }
        return d5;
    }

    public static int getTypeFromCode(String string) {
        for (int i = 0; i < SPEC.length; ++i) {
            if (!MolecularPropertyHelper.SPEC[i].code.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int getTypeFromName(String string) {
        for (int i = 0; i < SPEC.length; ++i) {
            if (!MolecularPropertyHelper.SPEC[i].name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static String getMinText(int n) {
        return MolecularPropertyHelper.SPEC[n].min;
    }

    public static String getMaxText(int n) {
        return MolecularPropertyHelper.SPEC[n].max;
    }

    public static float getHalfFitnessWidth(int n) {
        return MolecularPropertyHelper.SPEC[n].halfWidth;
    }

    private static int getHAcceptorCount(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 7 && stereoMolecule.getAtomicNo(i) != 8) continue;
            ++n;
        }
        return n;
    }

    private static int getHDonorCount(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 7 && stereoMolecule.getAtomicNo(i) != 8 || stereoMolecule.getAllHydrogens(i) <= 0) continue;
            ++n;
        }
        return n;
    }

    private static int getBasicNitrogenCount(StereoMolecule stereoMolecule) {
        int n = 0;
        stereoMolecule.ensureHelperArrays(7);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isBasicNitrogen(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    private static int getAcidicOxygenCount(StereoMolecule stereoMolecule) {
        int n = 0;
        stereoMolecule.ensureHelperArrays(7);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isAcidicOxygen(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }
}

