/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.calc.SingularValueDecomposition;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.ConformerSet;
import com.actelion.research.chem.conf.ConformerSetGenerator;
import java.util.Arrays;

public class GlobularityCalculator {
    private static final boolean MINIMIZE = false;

    public static double assessGlobularity(StereoMolecule stereoMolecule, int n) {
        ConformerSet conformerSet = new ConformerSetGenerator(n, 3, false, 0L).generateConformerSet(stereoMolecule);
        return GlobularityCalculator.assessGlobularity(conformerSet);
    }

    public static double assessGlobularity(ConformerSet conformerSet) {
        if (conformerSet == null || conformerSet.size() == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        for (Conformer conformer : conformerSet) {
            d += GlobularityCalculator.assessGlobularityFromSVD(conformer);
        }
        return d / (double)conformerSet.size();
    }

    public static double assessGlobularityFromSVD(Conformer conformer) {
        int n = conformer.getSize();
        Coordinates coordinates = new Coordinates();
        for (int i = 0; i < n; ++i) {
            coordinates.add(conformer.getCoordinates(i));
        }
        coordinates.scale(1.0 / (double)n);
        double[][] dArray = new double[3][3];
        for (int i = 0; i < n; ++i) {
            conformer.getCoordinates(i).sub(coordinates);
            double[] dArray2 = dArray[0];
            dArray2[0] = dArray2[0] + conformer.getX(i) * conformer.getX(i);
            double[] dArray3 = dArray[0];
            dArray3[1] = dArray3[1] + conformer.getX(i) * conformer.getY(i);
            double[] dArray4 = dArray[0];
            dArray4[2] = dArray4[2] + conformer.getX(i) * conformer.getZ(i);
            double[] dArray5 = dArray[1];
            dArray5[0] = dArray5[0] + conformer.getY(i) * conformer.getX(i);
            double[] dArray6 = dArray[1];
            dArray6[1] = dArray6[1] + conformer.getY(i) * conformer.getY(i);
            double[] dArray7 = dArray[1];
            dArray7[2] = dArray7[2] + conformer.getY(i) * conformer.getZ(i);
            double[] dArray8 = dArray[2];
            dArray8[0] = dArray8[0] + conformer.getZ(i) * conformer.getX(i);
            double[] dArray9 = dArray[2];
            dArray9[1] = dArray9[1] + conformer.getZ(i) * conformer.getY(i);
            double[] dArray10 = dArray[2];
            dArray10[2] = dArray10[2] + conformer.getZ(i) * conformer.getZ(i);
        }
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(dArray, null, null);
        double[][] dArray11 = singularValueDecomposition.getU();
        double[] dArray12 = new double[3];
        for (int i = 0; i < n; ++i) {
            Arrays.fill(dArray12, 0.0);
            Coordinates coordinates2 = conformer.getCoordinates(i);
            for (int j = 0; j < 3; ++j) {
                int n2 = j;
                dArray12[n2] = dArray12[n2] + coordinates2.x * dArray11[0][j];
                int n3 = j;
                dArray12[n3] = dArray12[n3] + coordinates2.y * dArray11[1][j];
                int n4 = j;
                dArray12[n4] = dArray12[n4] + coordinates2.z * dArray11[2][j];
            }
            coordinates2.set(dArray12[0], dArray12[1], dArray12[2]);
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MAX_VALUE;
        double d6 = Double.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            Coordinates coordinates3 = conformer.getCoordinates(i);
            if (d > coordinates3.x) {
                d = coordinates3.x;
            }
            if (d2 < coordinates3.x) {
                d2 = coordinates3.x;
            }
            if (d3 > coordinates3.y) {
                d3 = coordinates3.y;
            }
            if (d4 < coordinates3.y) {
                d4 = coordinates3.y;
            }
            if (d5 > coordinates3.z) {
                d5 = coordinates3.z;
            }
            if (!(d6 < coordinates3.z)) continue;
            d6 = coordinates3.z;
        }
        double d7 = d2 - d;
        double d8 = d4 - d3;
        double d9 = d6 - d5;
        return d7 == 0.0 ? Double.NaN : d9 / d7;
    }
}

