/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.potentialenergy;

import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;

public class PositionConstraint
implements PotentialEnergyTerm {
    private double[] refPos = new double[3];
    private double k;
    private double d;
    private int atom;
    private Conformer conf;

    public PositionConstraint(Conformer conformer, int n, double d, double d2) {
        this.atom = n;
        this.conf = conformer;
        this.refPos[0] = conformer.getX(n);
        this.refPos[1] = conformer.getY(n);
        this.refPos[2] = conformer.getZ(n);
        this.k = d;
        this.d = d2;
    }

    @Override
    public double getFGValue(double[] dArray) {
        double d = 0.0;
        double[] dArray2 = new double[]{this.conf.getX(this.atom), this.conf.getY(this.atom), this.conf.getZ(this.atom)};
        double d2 = dArray2[0] - this.refPos[0];
        double d3 = dArray2[1] - this.refPos[1];
        double d4 = dArray2[2] - this.refPos[2];
        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d6 = 0.0;
        d6 = d5 > this.d ? d5 - this.d : 0.0;
        d += 0.5 * this.k * d6 * d6;
        int n = this.atom;
        dArray[n] = dArray[n] + d6 * d2 / Math.max(d5, 1.0E-8);
        int n2 = this.atom + 1;
        dArray[n2] = dArray[n2] + d6 * d3 / Math.max(d5, 1.0E-8);
        int n3 = this.atom + 2;
        dArray[n3] = dArray[n3] + d6 * d4 / Math.max(d5, 1.0E-8);
        return d;
    }
}

