/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore.pp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.PeriodicTable;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.phesa.EncodeFunctions;
import com.actelion.research.chem.phesa.Gaussian3D;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import com.actelion.research.chem.phesa.pharmacophore.pp.PharmacophorePointFactory;
import java.util.Base64;

public class PPGaussian
extends Gaussian3D {
    IPharmacophorePoint pp;

    public PPGaussian(int n, IPharmacophorePoint iPharmacophorePoint) {
        super(iPharmacophorePoint.getCenterID(), n, iPharmacophorePoint.getCenter(), 1.0);
        this.pp = iPharmacophorePoint;
    }

    public PPGaussian(PPGaussian pPGaussian) {
        super(pPGaussian.atomId, pPGaussian.atomicNo, new Coordinates(pPGaussian.center), pPGaussian.weight);
        this.pp = pPGaussian.pp.copyPharmacophorePoint();
    }

    private PPGaussian(String string, StereoMolecule stereoMolecule) {
        this.decode(string, stereoMolecule);
    }

    public static PPGaussian fromString(String string, StereoMolecule stereoMolecule) {
        return new PPGaussian(string, stereoMolecule);
    }

    public Coordinates getRotatedDirectionality(double[][] dArray, double d) {
        Coordinates coordinates = this.pp.getRotatedDirectionality(dArray, d);
        return coordinates;
    }

    public double getVectorSimilarity(PPGaussian pPGaussian, Coordinates coordinates) {
        return this.pp.getVectorSimilarity(pPGaussian.getPharmacophorePoint(), coordinates);
    }

    public double getVectorSimilarity(PPGaussian pPGaussian) {
        return this.getVectorSimilarity(pPGaussian, pPGaussian.getPharmacophorePoint().getDirectionality());
    }

    public IPharmacophorePoint getPharmacophorePoint() {
        return this.pp;
    }

    @Override
    public void setAtomId(int n) {
        this.pp.setCenterID(n);
    }

    @Override
    public int getAtomId() {
        return this.pp.getCenterID();
    }

    public double getSimilarity(PPGaussian pPGaussian, Coordinates coordinates) {
        double d = 1.0;
        double d2 = this.getVectorSimilarity(pPGaussian, coordinates);
        double d3 = (Math.max(0.0, d2) + 2.0 * d) / 3.0;
        return d3;
    }

    public double getSimilarity(PPGaussian pPGaussian) {
        return this.getSimilarity(pPGaussian, pPGaussian.getPharmacophorePoint().getDirectionality());
    }

    public double getInteractionSimilarity(PPGaussian pPGaussian) {
        return this.pp.getSimilarity(pPGaussian.pp);
    }

    @Override
    public void setCenter(Coordinates coordinates) {
        this.center = coordinates;
        this.pp.getCenter().x = coordinates.x;
        this.pp.getCenter().y = coordinates.y;
        this.pp.getCenter().z = coordinates.z;
    }

    @Override
    public String encode() {
        Base64.Encoder encoder = Base64.getEncoder();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Integer.toString(this.atomicNo));
        stringBuilder.append(" ");
        stringBuilder.append(encoder.encodeToString(EncodeFunctions.doubleToByteArray(this.weight)));
        stringBuilder.append(" ");
        stringBuilder.append(this.pp.encode());
        return stringBuilder.toString();
    }

    public void decode(String string, StereoMolecule stereoMolecule) {
        Base64.Decoder decoder = Base64.getDecoder();
        String[] stringArray = string.split(" ");
        if (stringArray.length == 1) {
            return;
        }
        this.atomicNo = Integer.decode(stringArray[0]);
        this.weight = EncodeFunctions.byteArrayToDouble(decoder.decode(stringArray[1].getBytes()));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 2; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(" ");
        }
        this.pp = PharmacophorePointFactory.fromString(stringBuilder.toString(), stereoMolecule);
        this.center = this.pp.getCenter();
        this.alpha = this.calculateWidth();
        this.volume = this.calculateVolume();
        this.coeff = this.calculateHeight();
        this.atomId = this.pp.getCenterID();
    }

    @Override
    public double calculateHeight() {
        return 2.82842712475;
    }

    @Override
    public void transform(Transformation transformation) {
        if (!(transformation instanceof TransformationSequence)) {
            this.pp.applyTransformation(transformation);
            this.center = this.pp.getCenter();
        } else {
            TransformationSequence transformationSequence = (TransformationSequence)transformation;
            for (Transformation transformation2 : transformationSequence.getTransformations()) {
                this.pp.applyTransformation(transformation2);
                this.center = this.pp.getCenter();
            }
        }
    }

    @Override
    public void updateCoordinates(Coordinates[] coordinatesArray) {
        this.pp.updateCoordinates(coordinatesArray);
        this.center = this.pp.getCenter();
    }

    @Override
    public void updateAtomIndeces(int[] nArray) {
        this.atomId = nArray[this.atomId];
        this.pp.updateAtomIndeces(nArray);
    }

    @Override
    public double calculateWidth() {
        double d = PeriodicTable.getElement(this.atomicNo).getVDWRadius();
        return 2.41798793102 / (d * d);
    }
}

