/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore.pp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import java.util.ArrayList;
import java.util.List;

public class AliphaticPoint
implements IPharmacophorePoint {
    private int referenceAtom;
    private List<Integer> atoms;
    private Coordinates center;
    private static final Coordinates directionality = new Coordinates(1.0, 0.0, 0.0);

    public AliphaticPoint(StereoMolecule stereoMolecule, int n, List<Integer> list) {
        this.referenceAtom = n;
        this.atoms = list;
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    public AliphaticPoint(AliphaticPoint aliphaticPoint) {
        this.referenceAtom = aliphaticPoint.referenceAtom;
        this.center = new Coordinates(aliphaticPoint.center);
        this.atoms = new ArrayList<Integer>();
        for (int n : aliphaticPoint.atoms) {
            this.atoms.add(n);
        }
    }

    @Override
    public Coordinates getCenter() {
        return this.center;
    }

    @Override
    public void updateCoordinates(Coordinates[] coordinatesArray) {
        Coordinates coordinates = new Coordinates(0.0, 0.0, 0.0);
        for (int n : this.atoms) {
            coordinates.add(coordinatesArray[n]);
        }
        coordinates.scale(1.0 / (double)this.atoms.size());
        this.center = coordinates;
    }

    @Override
    public Coordinates getDirectionality() {
        return directionality;
    }

    @Override
    public Coordinates getRotatedDirectionality(double[][] dArray, double d) {
        return null;
    }

    private AliphaticPoint(String string, StereoMolecule stereoMolecule) {
        this.decode(string, stereoMolecule);
    }

    public static AliphaticPoint fromString(String string, StereoMolecule stereoMolecule) {
        return new AliphaticPoint(string, stereoMolecule);
    }

    private void decode(String string, StereoMolecule stereoMolecule) {
        String[] stringArray = string.split(" ");
        this.referenceAtom = Integer.decode(stringArray[1]);
        this.atoms = new ArrayList<Integer>();
        for (int i = 2; i < stringArray.length; ++i) {
            this.atoms.add(Integer.decode(stringArray[i]));
        }
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    @Override
    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("r");
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.referenceAtom));
        stringBuilder.append(" ");
        for (Integer n : this.atoms) {
            stringBuilder.append(n);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    @Override
    public double getSimilarity(IPharmacophorePoint iPharmacophorePoint) {
        double d = 0.0;
        if (iPharmacophorePoint instanceof AliphaticPoint) {
            d = 1.0;
        }
        return d;
    }

    @Override
    public int getCenterID() {
        return this.referenceAtom;
    }

    @Override
    public void setCenterID(int n) {
        this.referenceAtom = n;
    }

    @Override
    public void setDirectionality(Coordinates coordinates) {
    }

    @Override
    public void updateAtomIndeces(int[] nArray) {
        this.referenceAtom = nArray[this.referenceAtom];
        for (int i = 0; i < this.atoms.size(); ++i) {
            int n = nArray[this.atoms.get(i)];
            this.atoms.set(i, n);
        }
    }

    @Override
    public IPharmacophorePoint copyPharmacophorePoint() {
        return new AliphaticPoint(this);
    }

    @Override
    public void getDirectionalityDerivativeCartesian(double[] dArray, double[] dArray2, Coordinates coordinates, double d) {
    }

    @Override
    public double getVectorSimilarity(IPharmacophorePoint iPharmacophorePoint, Coordinates coordinates) {
        return 1.0;
    }

    @Override
    public double getVectorSimilarity(IPharmacophorePoint iPharmacophorePoint) {
        return 1.0;
    }

    @Override
    public int getFunctionalityIndex() {
        return 5;
    }

    public List<Integer> getAtoms() {
        return this.atoms;
    }
}

