/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import java.nio.ByteBuffer;

public class EncodeFunctions {
    public static byte[] doubleToByteArray(double d) {
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.putDouble(d);
        return byteBuffer.array();
    }

    public static byte[] doubleArrayToByteArray(double[] dArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 * dArray.length);
        byteBuffer.asDoubleBuffer().put(dArray);
        return byteBuffer.array();
    }

    public static byte[] intArrayToByteArray(int[] nArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * nArray.length);
        byteBuffer.asIntBuffer().put(nArray);
        return byteBuffer.array();
    }

    public static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.putInt(n);
        return byteBuffer.array();
    }

    public static double byteArrayToDouble(byte[] byArray) {
        return ByteBuffer.wrap(byArray).getDouble();
    }

    public static double[] byteArrayToDoubleArray(byte[] byArray) {
        int n = 8;
        double[] dArray = new double[byArray.length / n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ByteBuffer.wrap(byArray, i * n, n).getDouble();
        }
        return dArray;
    }

    public static int[] byteArrayToIntArray(byte[] byArray) {
        int n = 4;
        int[] nArray = new int[byArray.length / n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ByteBuffer.wrap(byArray, i * n, n).getInt();
        }
        return nArray;
    }

    public static int byteArrayToInt(byte[] byArray) {
        return ByteBuffer.wrap(byArray).getInt();
    }
}

