/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.moreparsers;

import com.actelion.research.chem.moreparsers.XmlReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class CDXMLParser
extends XmlReader.XmlHandler {
    private double minX = Double.MAX_VALUE;
    private double minY = Double.MAX_VALUE;
    private double minZ = Double.MAX_VALUE;
    private double maxZ = -1.7976931348623157E308;
    private double maxY = -1.7976931348623157E308;
    private double maxX = -1.7976931348623157E308;
    private int idnext = 100000;
    protected BitSet bsAtoms = new BitSet();
    protected BitSet bsBonds = new BitSet();
    List<CDNode> atoms = new ArrayList<CDNode>();
    List<CDBond> bonds = new ArrayList<CDBond>();
    Map<String, CDBond> bondIDMap = new HashMap<String, CDBond>();
    private Stack<BracketedGroup> bracketedGroups;
    protected CDXReaderI rdr;
    public Map<String, CDNode> mapCloned;
    private Stack<String> fragments = new Stack();
    private String thisFragmentID;
    private CDNode thisNode;
    private CDNode thisAtom;
    private boolean ignoreText;
    private Stack<CDNode> nodes = new Stack();
    private List<CDNode> nostereo = new ArrayList<CDNode>();
    Map<String, Object> objectsByID = new HashMap<String, Object>();
    private String textBuffer;

    public CDXMLParser(CDXReaderI cDXReaderI) {
        this.rdr = cDXReaderI;
    }

    public void processStartElement(String string, Map<String, String> map) {
        String string2 = map.get("id");
        switch (string) {
            case "n": {
                this.objectsByID.put(string2, this.setNode(string2, map));
                break;
            }
            case "b": {
                this.objectsByID.put(string2, this.setBond(string2, map));
                break;
            }
            case "t": {
                this.textBuffer = "";
                break;
            }
            case "s": {
                this.rdr.setKeepChars(true);
                break;
            }
            case "fragment": {
                this.objectsByID.put(string2, this.setFragment(string2, map));
                break;
            }
            case "objecttag": {
                switch (map.get("name")) {
                    case "parameterizedBracketLabel": 
                    case "bracketusage": {
                        this.ignoreText = true;
                    }
                }
                break;
            }
            case "bracketedgroup": {
                this.setBracketedGroup(string2, map);
                break;
            }
            case "crossingbond": {
                BracketedGroup bracketedGroup;
                BracketedGroup bracketedGroup2 = bracketedGroup = this.bracketedGroups == null || this.bracketedGroups.isEmpty() ? null : (BracketedGroup)this.bracketedGroups.get(this.bracketedGroups.size() - 1);
                if (bracketedGroup == null || bracketedGroup.repeatCount <= 0) break;
                bracketedGroup.addCrossing(map.get("inneratomid"), map.get("bondid"));
            }
        }
    }

    public String nextID() {
        return "" + this.idnext++;
    }

    public static String getBondKey(int n, int n2) {
        return Math.min(n, n2) + "_" + Math.max(n, n2);
    }

    public CDBond getBond(CDNode cDNode, CDNode cDNode2) {
        return this.bondIDMap.get(CDXMLParser.getBondKey(cDNode.index, cDNode2.index));
    }

    void processEndElement(String string, String string2) {
        switch (string) {
            case "fragment": {
                this.thisFragmentID = this.fragments.pop();
                return;
            }
            case "objecttag": {
                this.ignoreText = false;
                return;
            }
            case "n": {
                this.thisNode = this.nodes.size() == 0 ? null : this.nodes.pop();
                return;
            }
            case "bracketedgroup": {
                break;
            }
            case "s": {
                this.textBuffer = this.textBuffer + string2.toString();
                break;
            }
            case "t": {
                if (!this.ignoreText) {
                    if (this.thisNode == null) {
                        System.out.println("CDXReader unassigned text: " + this.textBuffer);
                    } else {
                        this.thisNode.text = this.textBuffer;
                        if (this.thisAtom.elementNumber == 0) {
                            System.err.println("XmlChemDrawReader: Problem with \"" + this.textBuffer + "\"");
                        }
                        if (this.thisNode.warning != null) {
                            this.rdr.warn("Warning: " + this.textBuffer + " " + this.thisNode.warning);
                        }
                    }
                }
                this.textBuffer = "";
            }
        }
        this.rdr.setKeepChars(false);
    }

    private String[] getTokens(String string) {
        return string.split("\\s");
    }

    private String[] split(String string, String string2) {
        return string.split(string2);
    }

    int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return Integer.MIN_VALUE;
        }
    }

    private double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    private CDNode setNode(String string, Map<String, String> map) {
        String string2 = map.get("nodetype");
        if (this.thisNode != null) {
            this.nodes.push(this.thisNode);
        }
        if ("_".equals(string2)) {
            this.thisNode = null;
            this.thisAtom = null;
            return null;
        }
        this.thisAtom = this.thisNode = new CDNode(this.atoms.size(), string, string2, this.thisFragmentID, this.thisNode);
        this.addAtom(this.thisNode);
        String string3 = map.get("warning");
        if (string3 != null) {
            this.thisNode.warning = string3.replace("&apos;", "'");
            this.thisNode.isValid = string3.indexOf("ChemDraw can't interpret") < 0;
        }
        String string4 = map.get("element");
        String string5 = map.get("genericnickname");
        if (string5 != null) {
            string4 = string5;
        }
        this.thisAtom.element = string4;
        this.thisAtom.elementNumber = (short)Math.max(0, !this.checkWarningOK(string3) ? 0 : (string4 == null ? 6 : this.parseInt(string4)));
        this.thisAtom.isotope = map.get("isotope");
        string5 = map.get("charge");
        if (string5 != null) {
            this.thisAtom.formalCharge = this.parseInt(string5);
        }
        this.rdr.handleCoordinates(map);
        string5 = map.get("attachments");
        if (string5 != null) {
            this.thisNode.setMultipleAttachments(this.split(string5.trim(), " "));
        }
        if ((string5 = map.get("bondordering")) != null) {
            this.thisNode.setBondOrdering(this.split(string5.trim(), " "));
        }
        return this.thisNode;
    }

    private boolean checkWarningOK(String string) {
        return string == null || string.indexOf("valence") >= 0 || string.indexOf("very close") >= 0 || string.indexOf("two identical colinear bonds") >= 0;
    }

    private CDNode setFragment(String string, Map<String, String> map) {
        String string2;
        CDNode cDNode;
        this.thisFragmentID = string;
        this.fragments.push(this.thisFragmentID);
        CDNode cDNode2 = cDNode = this.thisNode == null || !this.thisNode.isFragment ? null : this.thisNode;
        if (cDNode != null) {
            cDNode.setInnerFragmentID(string);
        }
        if ((string2 = map.get("connectionorder")) != null) {
            this.thisNode.setConnectionOrder(string2.trim().split(" "));
        }
        return cDNode;
    }

    private CDBond setBond(String string, Map<String, String> map) {
        String string2 = map.get("b");
        String string3 = map.get("e");
        String string4 = map.get("beginattach");
        int n = string4 == null ? 0 : this.parseInt(string4);
        string4 = map.get("endattach");
        int n2 = string4 == null ? 0 : this.parseInt(string4);
        String string5 = map.get("order");
        String string6 = map.get("display");
        String string7 = map.get("display2");
        int n3 = this.rdr.getBondOrder("null");
        boolean bl = false;
        if (string6 == null) {
            if (string5 == null) {
                n3 = 1;
            } else if (string5.equals("1.5")) {
                n3 = this.rdr.getBondOrder("delocalized");
            } else {
                if (string5.indexOf(".") > 0 && !"Dash".equals(string7)) {
                    string5 = string5.substring(0, string5.indexOf("."));
                }
                n3 = this.rdr.getBondOrder(string5);
            }
        } else if (string6.equals("WedgeBegin")) {
            n3 = this.rdr.getBondOrder("up");
        } else if (string6.equals("Hash") || string6.equals("WedgedHashBegin")) {
            n3 = this.rdr.getBondOrder("down");
        } else if (string6.equals("WedgeEnd")) {
            bl = true;
            n3 = this.rdr.getBondOrder("up");
        } else if (string6.equals("WedgedHashEnd")) {
            bl = true;
            n3 = this.rdr.getBondOrder("down");
        } else if (string6.equals("Bold")) {
            n3 = this.rdr.getBondOrder("single");
        } else if (string6.equals("Wavy")) {
            n3 = this.rdr.getBondOrder("either");
        }
        if (n3 == this.rdr.getBondOrder("null")) {
            System.err.println("XmlChemDrawReader ignoring bond type " + string5);
            return null;
        }
        CDBond cDBond = bl ? new CDBond(string, string3, string2, n3) : new CDBond(string, string2, string3, n3);
        CDNode cDNode = this.getAtom(cDBond.atomIndex1);
        CDNode cDNode2 = this.getAtom(cDBond.atomIndex2);
        if (n3 == this.rdr.getBondOrder("either")) {
            if (!this.nostereo.contains(cDNode)) {
                this.nostereo.add(cDNode);
            }
            if (!this.nostereo.contains(cDNode2)) {
                this.nostereo.add(cDNode2);
            }
        }
        if (cDNode.hasMultipleAttachments) {
            cDNode.attachedAtom = cDNode2;
            return cDBond;
        }
        if (cDNode2.hasMultipleAttachments) {
            cDNode2.attachedAtom = cDNode;
            return cDBond;
        }
        if (cDNode.isFragment && n == 0) {
            n = 1;
        }
        if (cDNode2.isFragment && n2 == 0) {
            n2 = 1;
        }
        if (n > 0) {
            (bl ? cDNode2 : cDNode).addAttachedAtom(cDBond, n);
        }
        if (n2 > 0) {
            (bl ? cDNode : cDNode2).addAttachedAtom(cDBond, n2);
        }
        if (cDNode.isExternalPt) {
            cDNode.setInternalAtom(cDNode2);
        }
        if (cDNode2.isExternalPt) {
            cDNode2.setInternalAtom(cDNode);
        }
        this.addBond(cDBond);
        return cDBond;
    }

    private void setBracketedGroup(String string, Map<String, String> map) {
        String string2 = map.get("bracketusage");
        if (this.bracketedGroups == null) {
            this.bracketedGroups = new Stack();
        }
        if ("MultipleGroup".equals(string2)) {
            String[] stringArray = this.getTokens(map.get("bracketedobjectids"));
            int n = this.parseInt(map.get("repeatcount"));
            this.bracketedGroups.add(new BracketedGroup(string, stringArray, n));
        }
    }

    public void setAtom(String string, Map<String, String> map) {
        double d;
        String string2 = map.get(string);
        String[] stringArray = this.getTokens(string2);
        double d2 = this.parseDouble(stringArray[0]);
        double d3 = -this.parseDouble(stringArray[1]);
        double d4 = d = string == "xyz" ? this.parseDouble(stringArray[2]) : 0.0;
        if (d2 < this.minX) {
            this.minX = d2;
        }
        if (d2 > this.maxX) {
            this.maxX = d2;
        }
        if (d3 < this.minY) {
            this.minY = d3;
        }
        if (d3 > this.maxY) {
            this.maxY = d3;
        }
        if (d < this.minZ) {
            this.minZ = d;
        }
        if (d > this.maxZ) {
            this.maxZ = d;
        }
        this.thisAtom.set(d2, d3, d);
    }

    private void fixInvalidAtoms() {
        Cloneable cloneable;
        int n = this.getAtomCount();
        while (--n >= 0) {
            cloneable = this.getAtom(n);
            ((CDNode)cloneable).intID = Integer.MIN_VALUE;
            if (!((CDNode)cloneable).isFragment && !((CDNode)cloneable).isExternalPt && (((CDNode)cloneable).isConnected || ((CDNode)cloneable).isValid && ((CDNode)cloneable).elementNumber >= 10)) continue;
            this.bsAtoms.clear(((CDNode)cloneable).index);
        }
        this.reserializeAtoms();
        this.bsBonds.clear();
        n = this.getBondCount();
        while (--n >= 0) {
            cloneable = this.getBond(n);
            if (!((CDBond)cloneable).isValid()) continue;
            this.bsBonds.set(n);
        }
    }

    private void reserializeAtoms() {
        int n = 0;
        int n2 = this.bsAtoms.nextSetBit(0);
        while (n2 >= 0) {
            this.getAtom((int)n2).intID = ++n;
            n2 = this.bsAtoms.nextSetBit(n2 + 1);
        }
    }

    private void reindexAtomsAndBonds() {
        this.reserializeAtoms();
        int n = 0;
        int n2 = this.bsAtoms.nextSetBit(0);
        while (n2 >= 0) {
            this.getAtom((int)n2).index = n++;
            n2 = this.bsAtoms.nextSetBit(n2 + 1);
        }
        n = this.bsBonds.nextSetBit(0);
        while (n >= 0) {
            CDBond cDBond = this.getBond(n);
            cDBond.atomIndex1 = cDBond.atom1.index;
            cDBond.atomIndex2 = cDBond.atom2.index;
            n = this.bsBonds.nextSetBit(n + 1);
        }
    }

    private void fixConnections() {
        int n = this.getAtomCount();
        while (--n >= 0) {
            CDNode cDNode = this.getAtom(n);
            if (!cDNode.isFragment && !cDNode.hasMultipleAttachments) continue;
            cDNode.fixAttachments();
        }
        int n2 = this.getBondCount();
        for (n = 0; n < n2; ++n) {
            CDBond cDBond = this.getBond(n);
            if (cDBond == null) continue;
            CDNode cDNode = cDBond.atom1;
            CDNode cDNode2 = cDBond.atom2;
            cDNode.isConnected = true;
            cDNode2.isConnected = true;
            if (this.nostereo.contains(cDNode) == this.nostereo.contains(cDNode2)) continue;
            cDBond.order = 1;
        }
    }

    private void fixBracketedGroups() {
        if (this.bracketedGroups == null) {
            return;
        }
        int n = this.bracketedGroups.size();
        while (--n >= 0) {
            ((BracketedGroup)this.bracketedGroups.remove(n)).process();
        }
    }

    void dumpGraph() {
        Cloneable cloneable;
        int n;
        int n2 = this.getAtomCount();
        for (n = 0; n < n2; ++n) {
            cloneable = this.getAtom(n);
            System.out.println("CDXMLP " + n + " id=" + cloneable.id + cloneable.bsConnections + " cid=" + cloneable.clonedIndex + " fa=" + cloneable.bsFragmentAtoms + " xp=" + cloneable.isExternalPt + " ifd=" + cloneable.innerFragmentID + " ofd= " + cloneable.outerFragmentID);
        }
        n2 = this.getBondCount();
        for (n = 0; n < n2; ++n) {
            cloneable = this.getBond(n);
            System.out.println("CDXMLP bond " + n + " " + ((CDBond)cloneable).atomIndex1 + " " + ((CDBond)cloneable).atomIndex2 + cloneable);
        }
        System.out.println(this.bondIDMap);
    }

    private void centerAndScale() {
        double d;
        double d2;
        if (this.minX > this.maxX) {
            return;
        }
        double d3 = 0.0;
        int n = 0;
        double d4 = 1.0;
        int n2 = this.getBondCount();
        while (--n2 >= 0) {
            CDBond cDBond = this.getBond(n2);
            CDNode cDNode = cDBond.atom1;
            CDNode cDNode2 = cDBond.atom2;
            d2 = cDNode.distance(cDNode2);
            if (cDNode.elementNumber > 1 && cDNode2.elementNumber > 1) {
                d3 += d2;
                ++n;
                continue;
            }
            d4 = d2;
        }
        double d5 = d3 > 0.0 ? 1.45 * (double)n / d3 : (d = d4 > 0.0 ? 1.0 / d4 : 1.0);
        if (d > 0.5) {
            d = 1.0;
        }
        double d6 = (this.maxX + this.minX) / 2.0;
        d2 = (this.maxY + this.minY) / 2.0;
        double d7 = (this.maxZ + this.minZ) / 2.0;
        int n3 = this.getAtomCount();
        while (--n3 >= 0) {
            CDNode cDNode = this.getAtom(n3);
            cDNode.x = (cDNode.x - d6) * d;
            cDNode.y = (cDNode.y - d2) * d;
            cDNode.z = (cDNode.z - d7) * d;
        }
    }

    CDNode getAtom(int n) {
        return this.atoms.get(n);
    }

    CDNode addAtom(CDNode cDNode) {
        this.atoms.add(cDNode);
        this.bsAtoms.set(cDNode.index);
        return cDNode;
    }

    int getAtomCount() {
        return this.atoms.size();
    }

    CDBond addBond(CDBond cDBond) {
        cDBond.index = this.getBondCount();
        this.bsBonds.set(cDBond.index);
        this.bonds.add(cDBond);
        return cDBond;
    }

    CDBond getBond(int n) {
        return this.bonds.get(n);
    }

    int getBondCount() {
        return this.bonds.size();
    }

    public void finalizeParsing() {
        this.fixConnections();
        this.fixInvalidAtoms();
        this.fixBracketedGroups();
        this.centerAndScale();
        this.reindexAtomsAndBonds();
    }

    class BracketedGroup {
        String id;
        String[] ids;
        String[] bondIDs = new String[2];
        String[] innerAtomIDs = new String[2];
        int repeatCount;
        int pt;

        BracketedGroup(String string, String[] stringArray, int n) {
            this.id = string;
            this.ids = stringArray;
            this.repeatCount = n;
        }

        public void addCrossing(String string, String string2) {
            if (this.pt == 2) {
                System.err.println("BracketedGroup has more than two crossings");
                return;
            }
            this.bondIDs[this.pt] = string2;
            this.innerAtomIDs[this.pt] = string;
            ++this.pt;
        }

        public void process() {
            CDNode cDNode;
            if (this.pt != 2 || this.repeatCount < 2) {
                return;
            }
            CDBond cDBond = (CDBond)CDXMLParser.this.objectsByID.get(this.bondIDs[1]);
            CDNode cDNode2 = (CDNode)CDXMLParser.this.objectsByID.get(this.innerAtomIDs[1]);
            CDNode cDNode3 = (CDNode)CDXMLParser.this.objectsByID.get(this.innerAtomIDs[0]);
            CDBond cDBond2 = (CDBond)CDXMLParser.this.objectsByID.get(this.bondIDs[0]);
            CDNode cDNode4 = cDBond2.getOtherNode(cDNode3);
            BitSet bitSet = new BitSet();
            this.buildBranch(cDNode3, cDNode4, null, null, bitSet, null, null);
            double[] dArray = new double[]{cDNode4.x - cDNode2.x, cDNode4.y - cDNode2.y, cDNode4.z - cDNode2.z};
            BitSet bitSet2 = new BitSet();
            int n = this.ids.length;
            while (--n >= 0) {
                cDNode = (CDNode)CDXMLParser.this.objectsByID.get(this.ids[n]);
                cDNode.addBracketedAtoms(bitSet2);
            }
            CDNode cDNode5 = cDNode2;
            cDNode = cDNode3;
            for (int i = 1; i < this.repeatCount; ++i) {
                int n2 = CDXMLParser.this.getAtomCount();
                CDNode[] cDNodeArray = this.duplicateBracketAtoms(cDNode2, cDNode3, bitSet2);
                cDNode5 = cDNodeArray[0];
                this.patch(cDNode, cDBond, cDNode5);
                cDNode = cDNodeArray[1];
                this.shiftAtoms(n2, dArray, i, null);
            }
            this.patch(cDNode, cDBond2, cDNode4);
            this.shiftAtoms(0, dArray, this.repeatCount - 1, bitSet);
            cDBond2.invalidate();
        }

        private void shiftAtoms(int n, double[] dArray, int n2, BitSet bitSet) {
            if (bitSet == null) {
                int n3 = CDXMLParser.this.getAtomCount();
                while (--n3 >= n) {
                    CDNode cDNode = CDXMLParser.this.getAtom(n3);
                    cDNode.x += dArray[0] * (double)n2;
                    cDNode.y += dArray[1] * (double)n2;
                    cDNode.z += dArray[2] * (double)n2;
                }
            } else {
                int n4 = bitSet.nextSetBit(0);
                while (n4 >= 0) {
                    CDNode cDNode = CDXMLParser.this.getAtom(n4);
                    cDNode.x += dArray[0] * (double)n2;
                    cDNode.y += dArray[1] * (double)n2;
                    cDNode.z += dArray[2] * (double)n2;
                    n4 = bitSet.nextSetBit(n4 + 1);
                }
            }
        }

        private CDNode[] duplicateBracketAtoms(CDNode cDNode, CDNode cDNode2, BitSet bitSet) {
            CDXMLParser.this.mapCloned = new HashMap<String, CDNode>();
            CDNode cDNode3 = cDNode.clone();
            CDNode[] cDNodeArray = new CDNode[]{cDNode3, cDNode == cDNode2 ? cDNode3 : null};
            BitSet bitSet2 = new BitSet();
            this.buildBranch(null, cDNode, cDNode2, cDNode3, bitSet2, bitSet, cDNodeArray);
            return cDNodeArray;
        }

        private void buildBranch(CDNode cDNode, CDNode cDNode2, CDNode cDNode3, CDNode cDNode4, BitSet bitSet, BitSet bitSet2, CDNode[] cDNodeArray) {
            bitSet.set(cDNode2.index);
            CDNode cDNode5 = null;
            int n = cDNode2.bsConnections.nextSetBit(0);
            while (n >= 0) {
                block6: {
                    boolean bl;
                    CDNode cDNode6;
                    block7: {
                        cDNode6 = CDXMLParser.this.getAtom(n);
                        if (cDNode6 == cDNode) break block6;
                        boolean bl2 = bl = !bitSet.get(n);
                        if (bitSet2 == null) break block7;
                        if (!bitSet2.get(n) || cDNode6.isExternalPt) break block6;
                        CDBond cDBond = CDXMLParser.this.getBond(cDNode2, cDNode6);
                        CDNode cDNode7 = cDNode5 = bl ? cDNode6.clone() : CDXMLParser.this.mapCloned.get(cDNode6.id);
                        if (cDNode6 == cDNode3 && cDNodeArray[1] == null) {
                            cDNodeArray[1] = cDNode5;
                        }
                        CDBond cDBond2 = cDBond.atom1 == cDNode6 ? new CDBond(null, cDNode5.id, cDNode4.id, cDBond.order) : new CDBond(null, cDNode4.id, cDNode5.id, cDBond.order);
                        CDXMLParser.this.addBond(cDBond2);
                    }
                    if (bl) {
                        this.buildBranch(cDNode2, cDNode6, cDNode3, cDNode5, bitSet, bitSet2, cDNodeArray);
                    }
                }
                n = cDNode2.bsConnections.nextSetBit(n + 1);
            }
        }

        private void patch(CDNode cDNode, CDBond cDBond, CDNode cDNode2) {
            CDBond cDBond2 = CDXMLParser.this.addBond(new CDBond(null, cDNode.id, cDNode2.id, cDBond.order));
            cDBond2.disconnect();
            cDBond2.connect(cDNode, cDNode2);
        }
    }

    class CDBond
    implements Cloneable {
        public int atomIndex1;
        public int atomIndex2;
        public int order;
        String id;
        String id1;
        String id2;
        CDNode atom1;
        CDNode atom2;
        int index;
        boolean invalidated;

        CDBond(String string, String string2, String string3, int n) {
            this.id = string == null ? CDXMLParser.this.nextID() : string;
            this.id1 = string2;
            this.id2 = string3;
            this.order = n;
            this.atom1 = (CDNode)CDXMLParser.this.objectsByID.get(string2);
            this.atom2 = (CDNode)CDXMLParser.this.objectsByID.get(string3);
            this.atomIndex1 = this.atom1.index;
            this.atomIndex2 = this.atom2.index;
            this.atom1.bsConnections.set(this.atomIndex2);
            this.atom2.bsConnections.set(this.atomIndex1);
            CDXMLParser.this.bondIDMap.put(CDXMLParser.getBondKey(this.atomIndex1, this.atomIndex2), this);
        }

        public void connect(CDNode cDNode, CDNode cDNode2) {
            this.atom1 = cDNode;
            this.atomIndex1 = cDNode.index;
            this.atom2 = cDNode2;
            this.atomIndex2 = cDNode2.index;
            cDNode.bsConnections.set(cDNode2.index);
            cDNode2.bsConnections.set(cDNode.index);
            CDXMLParser.this.bondIDMap.put(CDXMLParser.getBondKey(this.atomIndex1, this.atomIndex2), this);
        }

        public void disconnect() {
            this.atom1.bsConnections.clear(this.atomIndex2);
            this.atom2.bsConnections.clear(this.atomIndex1);
            CDXMLParser.this.bondIDMap.remove(CDXMLParser.getBondKey(this.atomIndex1, this.atomIndex2));
        }

        CDNode getOtherNode(CDNode cDNode) {
            return CDXMLParser.this.getAtom(this.atomIndex1 == cDNode.index ? this.atomIndex2 : this.atomIndex1);
        }

        public void invalidate() {
            this.invalidated = true;
            CDXMLParser.this.bsBonds.clear(this.index);
            this.atomIndex2 = -1;
            this.atomIndex1 = -1;
        }

        public boolean isValid() {
            return !this.invalidated && this.atom1.intID >= 0 && this.atom2.intID >= 0;
        }

        public String toString() {
            return "[CDBond index " + this.index + " id " + this.id + " v=" + this.isValid() + " id1=" + this.id1 + "/" + this.atom1.index + "/" + this.atom1.clonedIndex + " id2=" + this.id2 + "/" + this.atom2.index + "/" + this.atom2.clonedIndex + "]";
        }
    }

    class CDNode
    implements Cloneable {
        public int index;
        public String id;
        public int intID;
        public String isotope;
        public String element;
        public int elementNumber;
        public double x;
        public double y;
        public double z;
        public int formalCharge;
        String nodeType;
        String warning;
        boolean isValid = true;
        boolean isConnected;
        boolean isExternalPt;
        boolean isFragment;
        String outerFragmentID;
        String innerFragmentID;
        public String text;
        CDNode parentNode;
        List<Object[]> orderedConnectionBonds;
        CDNode internalAtom;
        List<CDNode> orderedExternalPoints;
        private String[] attachments;
        private String[] bondOrdering;
        private String[] connectionOrder;
        public boolean hasMultipleAttachments;
        CDNode attachedAtom;
        public BitSet bsConnections;
        BitSet bsFragmentAtoms;
        int clonedIndex = -1;

        CDNode(int n, String string, String string2, String string3, CDNode cDNode) {
            this.id = string;
            this.index = n;
            this.outerFragmentID = string3;
            this.intID = Integer.parseInt(string);
            this.nodeType = string2;
            this.parentNode = cDNode;
            this.bsConnections = new BitSet();
            this.isFragment = "Fragment".equals(string2) || "Nickname".equals(string2);
            this.isExternalPt = "ExternalConnectionPoint".equals(string2);
            if (this.isFragment) {
                this.bsFragmentAtoms = new BitSet();
            } else if (cDNode != null && !this.isExternalPt) {
                cDNode.bsFragmentAtoms.set(n);
            }
        }

        public void set(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        public void setInnerFragmentID(String string) {
            this.innerFragmentID = string;
        }

        void setBondOrdering(String[] stringArray) {
            this.bondOrdering = stringArray;
        }

        void setConnectionOrder(String[] stringArray) {
            this.connectionOrder = stringArray;
        }

        void setMultipleAttachments(String[] stringArray) {
            this.attachments = stringArray;
            this.hasMultipleAttachments = true;
        }

        void addExternalPoint(CDNode cDNode) {
            if (this.orderedExternalPoints == null) {
                this.orderedExternalPoints = new ArrayList<CDNode>();
            }
            int n = this.orderedExternalPoints.size();
            while (--n >= 0 && this.orderedExternalPoints.get((int)n).intID >= cDNode.internalAtom.intID) {
            }
            this.orderedExternalPoints.add(++n, cDNode);
        }

        public void setInternalAtom(CDNode cDNode) {
            this.internalAtom = cDNode;
            if (this.parentNode != null) {
                this.parentNode.addExternalPoint(this);
            }
        }

        void addAttachedAtom(CDBond cDBond, int n) {
            if (this.orderedConnectionBonds == null) {
                this.orderedConnectionBonds = new ArrayList<Object[]>();
            }
            int n2 = this.orderedConnectionBonds.size();
            while (--n2 >= 0 && (Integer)this.orderedConnectionBonds.get(n2)[0] > n) {
            }
            this.orderedConnectionBonds.add(++n2, new Object[]{n, cDBond});
        }

        void fixAttachments() {
            CDNode cDNode;
            int n;
            if (this.hasMultipleAttachments && this.attachedAtom != null) {
                n = CDXMLParser.this.rdr.getBondOrder("partial");
                CDNode cDNode2 = this.attachedAtom;
                int n2 = this.attachments.length;
                while (--n2 >= 0) {
                    cDNode = (CDNode)CDXMLParser.this.objectsByID.get(this.attachments[n2]);
                    if (cDNode == null) continue;
                    CDXMLParser.this.addBond(new CDBond(null, cDNode2.id, cDNode.id, n));
                }
            }
            if (this.orderedExternalPoints == null || this.text == null) {
                return;
            }
            n = this.orderedExternalPoints.size();
            if (n != this.orderedConnectionBonds.size()) {
                System.err.println("XmlCdxReader cannot fix attachments for fragment " + this.text);
                return;
            }
            if (this.bondOrdering == null) {
                this.bondOrdering = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.bondOrdering[i] = ((CDBond)this.orderedConnectionBonds.get((int)i)[1]).id;
                }
            }
            if (this.connectionOrder == null) {
                this.connectionOrder = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.connectionOrder[i] = this.orderedExternalPoints.get((int)i).id;
                }
            }
            for (int i = 0; i < n; ++i) {
                CDBond cDBond = (CDBond)CDXMLParser.this.objectsByID.get(this.bondOrdering[i]);
                cDNode = ((CDNode)CDXMLParser.this.objectsByID.get((Object)this.connectionOrder[i])).internalAtom;
                this.updateExternalBond(cDBond, cDNode);
            }
        }

        private void updateExternalBond(CDBond cDBond, CDNode cDNode) {
            CDXMLParser.this.bsBonds.set(cDBond.index);
            cDBond.disconnect();
            if (cDBond.atomIndex2 == this.index) {
                cDBond.connect(cDBond.atom1, cDNode);
            } else if (cDBond.atomIndex1 == this.index) {
                cDBond.connect(cDNode, cDBond.atom2);
            } else {
                System.err.println("CDXMLParser attachment failed! " + cDNode + " " + cDBond);
            }
        }

        public CDNode clone() {
            try {
                CDNode cDNode = (CDNode)super.clone();
                cDNode.index = CDXMLParser.this.atoms.size();
                cDNode.id = CDXMLParser.this.nextID();
                CDXMLParser.this.mapCloned.put(this.id, cDNode);
                cDNode.clonedIndex = this.index;
                cDNode.bsConnections = new BitSet();
                CDXMLParser.this.objectsByID.put(cDNode.id, cDNode);
                CDXMLParser.this.addAtom(cDNode);
                return cDNode;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public String toString() {
            return "[CDNode " + this.id + " " + this.elementNumber + " index=" + this.index + " ext=" + this.isExternalPt + " frag=" + this.isFragment + "  " + this.x + " " + this.y + "]";
        }

        public double distance(CDNode cDNode) {
            double d = this.x - cDNode.x;
            double d2 = this.y - cDNode.y;
            return Math.sqrt(d * d + d2 * d2);
        }

        public void addBracketedAtoms(BitSet bitSet) {
            if (this.isFragment) {
                bitSet.or(this.bsFragmentAtoms);
            } else if (!this.isExternalPt) {
                bitSet.set(this.index);
            }
        }
    }

    public static interface CDXReaderI {
        public int getBondOrder(String var1);

        public void handleCoordinates(Map<String, String> var1);

        public void setKeepChars(boolean var1);

        public void warn(String var1);
    }
}

