/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mmp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MMPairs {
    private File temp = File.createTempFile("matchedmolecularpairs", ".tmp");
    private PrintWriter mmpWriter = new PrintWriter(this.temp);
    private int numberOfLines = 0;

    MMPairs() throws IOException {
        this.mmpWriter.println("value1FragmentIndex\tvalue1Atoms\tvalue2FragmentIndex\tvalue2Atoms\tcutType\tnumberOfExamples\texamples");
    }

    public void writeMMPEnumeration(HashMap<String, List<String[]>> hashMap) throws IOException {
        if (hashMap != null && hashMap.size() > 0) {
            for (Map.Entry<String, List<String[]>> entry : hashMap.entrySet()) {
                String string = "";
                for (String[] stringArray : entry.getValue()) {
                    if (string == "") {
                        string = stringArray[0] + "," + stringArray[1];
                        continue;
                    }
                    string = string + "|" + stringArray[0] + "," + stringArray[1];
                }
                this.mmpWriter.println(entry.getKey() + "\t" + Integer.toString(entry.getValue().size()) + "\t" + string);
                ++this.numberOfLines;
            }
        }
    }

    public int getMMPsCount() {
        return this.numberOfLines;
    }

    public void writeMMPs(PrintWriter printWriter) throws IOException {
        String string;
        this.mmpWriter.close();
        printWriter.println("<matchedMolecularPairs>");
        printWriter.println("<column properties>");
        printWriter.println("<columnName=\"value1FragmentIndex\">");
        printWriter.println("<columnName=\"value1Atoms\">");
        printWriter.println("<columnName=\"value2FragmentIndex\">");
        printWriter.println("<columnName=\"value2Atoms\">");
        printWriter.println("<columnName=\"cutType\">");
        printWriter.println("<columnName=\"numberOfExamples\">");
        printWriter.println("<columnName=\"examples\">");
        printWriter.println("</column properties>");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.temp));
        while ((string = bufferedReader.readLine()) != null) {
            printWriter.println(string);
        }
        bufferedReader.close();
        this.temp.delete();
        printWriter.println("</matchedMolecularPairs>");
    }
}

