/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mmp;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class MMPUniqueFragments {
    private StereoMolecule fragmentMolecule = new StereoMolecule();
    private StereoMolecule fragment = null;
    private int biggestFragment = 0;
    private LinkedHashMap<String, MMPUniqueFragment> uniqueFragments;
    private IDCodeParser idCodeParser = new IDCodeParser();
    private int fragmentIndexes = 0;

    public MMPUniqueFragments() {
        this.uniqueFragments = new LinkedHashMap();
    }

    public Integer getFragmentAtoms(String string) {
        if (this.uniqueFragments.containsKey(string)) {
            return this.uniqueFragments.get(string).fragmentAtoms;
        }
        return null;
    }

    public MMPUniqueFragment fragmentIDToFragment(String[] stringArray) {
        String string = stringArray[0];
        if (stringArray.length == 2) {
            string = stringArray[0] + "\t" + stringArray[1];
        }
        return this.fragmentIDToFragment(string);
    }

    public MMPUniqueFragment fragmentIDToFragment(String string) {
        MMPUniqueFragment mMPUniqueFragment = null;
        if (this.uniqueFragments.containsKey(string)) {
            mMPUniqueFragment = this.uniqueFragments.get(string);
        }
        if (mMPUniqueFragment == null) {
            this.addFragment(string);
        }
        if (mMPUniqueFragment != null && mMPUniqueFragment.fragmentFP == null) {
            mMPUniqueFragment.addFP(string);
        }
        return mMPUniqueFragment;
    }

    public int addFragment(String string) {
        if (!this.uniqueFragments.containsKey(string)) {
            MMPUniqueFragment mMPUniqueFragment = new MMPUniqueFragment(string);
            this.uniqueFragments.put(string, mMPUniqueFragment);
            if (mMPUniqueFragment.fragmentAtoms > this.biggestFragment) {
                this.biggestFragment = mMPUniqueFragment.fragmentAtoms;
            }
            return mMPUniqueFragment.fragmentIndex;
        }
        return this.uniqueFragments.get(string).fragmentIndex;
    }

    public void addFragment(String string, MMPUniqueFragment mMPUniqueFragment) {
        if (!this.uniqueFragments.containsKey(string)) {
            this.uniqueFragments.put(string, mMPUniqueFragment);
        }
    }

    public int addFragment(String string, int n, String[] stringArray) {
        if (!this.uniqueFragments.containsKey(string)) {
            MMPUniqueFragment mMPUniqueFragment = new MMPUniqueFragment(n, stringArray);
            this.uniqueFragments.put(string, mMPUniqueFragment);
            if (mMPUniqueFragment.fragmentAtoms > this.biggestFragment) {
                this.biggestFragment = mMPUniqueFragment.fragmentAtoms;
            }
            return mMPUniqueFragment.fragmentIndex;
        }
        return this.uniqueFragments.get(string).fragmentIndex;
    }

    public void writeUniqueFragments(PrintWriter printWriter) throws IOException {
        printWriter.println("<mmpUniqueFragments>");
        printWriter.println("<column properties>");
        printWriter.println("<columnName=\"fragmentID\">");
        printWriter.println("<columnProperty=\"specialType\tidcode\">");
        printWriter.println("<columnName=\"fragmentAtoms\">");
        printWriter.println("<columnName=\"fragmentFP1\">");
        printWriter.println("<columnProperty=\"specialType\tidcode\">");
        printWriter.println("<columnName=\"fragmentFP2\">");
        printWriter.println("<columnProperty=\"specialType\tidcode\">");
        printWriter.println("<columnName=\"fragmentFP3\">");
        printWriter.println("<columnProperty=\"specialType\tidcode\">");
        printWriter.println("<columnName=\"fragmentFP4\">");
        printWriter.println("<columnProperty=\"specialType\tidcode\">");
        printWriter.println("<columnName=\"fragmentFP5\">");
        printWriter.println("<columnProperty=\"specialType\tidcode\">");
        printWriter.println("</column properties>");
        printWriter.println("fragmentID\tfragmentAtoms\tfragmentFP1\tfragmentFP2\tfragmentFP3\tfragmentFP4\tfragmentFP5");
        if (this.biggestFragment != 0) {
            this.fragment = new StereoMolecule(this.biggestFragment + 1, this.biggestFragment + 1);
        }
        for (Map.Entry<String, MMPUniqueFragment> entry : this.uniqueFragments.entrySet()) {
            String string = entry.getKey();
            MMPUniqueFragment mMPUniqueFragment = entry.getValue();
            if (mMPUniqueFragment.fragmentFP == null) {
                mMPUniqueFragment.addFP(string);
                entry.setValue(mMPUniqueFragment);
            }
            String string2 = string + "\t" + Integer.toString(mMPUniqueFragment.fragmentAtoms) + "\t" + mMPUniqueFragment.fragmentFP[0] + "\t" + mMPUniqueFragment.fragmentFP[1] + "\t" + mMPUniqueFragment.fragmentFP[2] + "\t" + mMPUniqueFragment.fragmentFP[3] + "\t" + mMPUniqueFragment.fragmentFP[4];
            printWriter.println(string2);
        }
        printWriter.println("</mmpUniqueFragments>");
    }

    public int getUniqueFragmentsCount() {
        return this.uniqueFragments.size();
    }

    public class MMPUniqueFragment {
        private int fragmentIndex;
        private int fragmentAtoms;
        private String[] fragmentFP;

        private MMPUniqueFragment(String string) {
            this.fragmentIndex = MMPUniqueFragments.this.fragmentIndexes++;
            this.fragmentAtoms = MMPUniqueFragments.this.idCodeParser.getAtomCount(string) - 1;
            this.fragmentFP = null;
        }

        private MMPUniqueFragment(int n, String[] stringArray) {
            this.fragmentIndex = MMPUniqueFragments.this.fragmentIndexes++;
            this.fragmentAtoms = n;
            this.fragmentFP = stringArray;
        }

        private void addFP(String string) {
            if (this.fragmentFP == null) {
                int n;
                this.fragmentFP = new String[5];
                MMPUniqueFragments.this.idCodeParser.parse(MMPUniqueFragments.this.fragmentMolecule, string);
                MMPUniqueFragments.this.fragmentMolecule.ensureHelperArrays(7);
                if (MMPUniqueFragments.this.fragment == null) {
                    MMPUniqueFragments.this.fragment = new StereoMolecule(MMPUniqueFragments.this.fragmentMolecule.getAllAtoms(), MMPUniqueFragments.this.fragmentMolecule.getAllBonds());
                }
                int[] nArray = new int[MMPUniqueFragments.this.fragmentMolecule.getAtoms()];
                boolean[] blArray = new boolean[MMPUniqueFragments.this.fragmentMolecule.getAtoms()];
                int[] nArray2 = new int[MMPUniqueFragments.this.fragmentMolecule.getAtoms()];
                Arrays.fill(blArray, false);
                int n2 = 0;
                for (n = 0; n < MMPUniqueFragments.this.fragmentMolecule.getAtoms(); ++n) {
                    if (MMPUniqueFragments.this.fragmentMolecule.getAtomicNo(n) != 0 && MMPUniqueFragments.this.fragmentMolecule.getAtomicNo(n) < 142) continue;
                    nArray[n2] = n;
                    blArray[n] = true;
                    ++n2;
                }
                n = 0;
                int n3 = n2;
                for (int i = 0; i < 5; ++i) {
                    int n4;
                    int n5 = n3;
                    for (n4 = n; n4 < n3; ++n4) {
                        int n6 = nArray[n4];
                        for (int j = 0; j < MMPUniqueFragments.this.fragmentMolecule.getConnAtoms(n6); ++j) {
                            int n7 = MMPUniqueFragments.this.fragmentMolecule.getConnAtom(n6, j);
                            if (blArray[n7]) continue;
                            blArray[n7] = true;
                            nArray[n5++] = n7;
                        }
                    }
                    n = n3;
                    n3 = n5;
                    MMPUniqueFragments.this.fragmentMolecule.copyMoleculeByAtoms(MMPUniqueFragments.this.fragment, blArray, true, nArray2);
                    for (n4 = 0; n4 < nArray2.length; ++n4) {
                        if (nArray2[n4] == -1 || !MMPUniqueFragments.this.fragmentMolecule.isAromaticAtom(nArray2[n4])) continue;
                        MMPUniqueFragments.this.fragment.setAtomQueryFeature(n4, 2L, true);
                    }
                    this.fragmentFP[i] = MMPUniqueFragments.this.fragment.getIDCode();
                }
            }
        }

        public int getFragmentIndex() {
            return this.fragmentIndex;
        }

        public int getFragmentAtoms() {
            return this.fragmentAtoms;
        }

        public String[] getFragmentFP() {
            return this.fragmentFP;
        }
    }
}

