/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mmp;

import com.actelion.research.chem.ExtendedDepictor;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mmp.MMP;
import com.actelion.research.chem.mmp.MMPFragmenter;
import com.actelion.research.chem.mmp.MMPPropertyCalculator;
import com.actelion.research.chem.mmp.MMPUniqueFragments;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.swing.SwingDrawContext;
import com.actelion.research.util.Base64;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class MMPReader {
    public static final String SORT_BY_SIMILARITY = "similarity";
    public static final String SORT_BY_NUMBER_OF_EXAMPLES = "results";
    private HashMap<String, ArrayList<MMP.MoleculeIndex>> wholeMoleculesIndex;
    private List<String> molecules;
    private List<DataField> dataFields;
    private List<String> uniqueFragmentsIndex;
    private MMPUniqueFragments mmpUniqueFragments;
    private HashMap<String, List<int[]>> mmpFragmentsIndex = new HashMap();
    private HashMap<Integer, HashMap<Integer, List<int[]>>> mmpIndex = new HashMap();
    private String datasetName;
    private String date;
    private Integer keysMinAtoms;
    private String version;
    private MMPPropertyCalculator mPropertyCalculator;
    public static final Comparator<MatchedMolecularPair> NUMBER_OF_EXAMPLES_SORT = new Comparator<MatchedMolecularPair>(){

        @Override
        public int compare(MatchedMolecularPair matchedMolecularPair, MatchedMolecularPair matchedMolecularPair2) {
            return matchedMolecularPair2.numberOfExamples - matchedMolecularPair.numberOfExamples;
        }
    };
    public static final Comparator<MatchedMolecularPair> SIMILARITY_SORT = new Comparator<MatchedMolecularPair>(){

        @Override
        public int compare(MatchedMolecularPair matchedMolecularPair, MatchedMolecularPair matchedMolecularPair2) {
            return matchedMolecularPair2.similarity - matchedMolecularPair.similarity;
        }
    };
    public static final Comparator<MatchedMolecularPairExamples> EXAMPLES_SIMILARITY_SORT = new Comparator<MatchedMolecularPairExamples>(){

        @Override
        public int compare(MatchedMolecularPairExamples matchedMolecularPairExamples, MatchedMolecularPairExamples matchedMolecularPairExamples2) {
            return matchedMolecularPairExamples2.similarity - matchedMolecularPairExamples.similarity;
        }
    };

    public MMPReader(BufferedReader bufferedReader, boolean bl) throws IOException, Exception {
        this.mmpUniqueFragments = new MMPUniqueFragments();
        this.mPropertyCalculator = new MMPPropertyCalculator();
        this.readMMPFile(bufferedReader, bl);
        bufferedReader.close();
    }

    private void readMMPFile(BufferedReader bufferedReader, boolean bl) throws IOException, Exception {
        String string;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        Pattern pattern = Pattern.compile("<(.*?)=\"(.*?)\">");
        Pattern pattern2 = Pattern.compile("<(.*?rowcount)=([0-9]*?)>");
        while ((string = bufferedReader.readLine()) != null && n < 4) {
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                if (matcher.group(1).equals("dataset")) {
                    this.datasetName = matcher.group(2);
                    continue;
                }
                if (matcher.group(1).equals("date")) {
                    this.date = matcher.group(2);
                    continue;
                }
                if (matcher.group(1).equals("keysminatoms")) {
                    this.keysMinAtoms = Integer.parseInt(matcher.group(2));
                    continue;
                }
                if (!matcher.group(1).equals("version")) continue;
                this.version = matcher.group(2);
                continue;
            }
            Matcher matcher2 = pattern2.matcher(string);
            if (!matcher2.find()) continue;
            hashMap.put(matcher2.group(1), Integer.parseInt(matcher2.group(2)));
            ++n;
        }
        if (n < 4) {
            throw new IOException("General: cannot find the four rowcount lines");
        }
        if (bl) {
            System.out.println("The dataset contains " + hashMap.get("moleculesrowcount") + " molecules, " + hashMap.get("mmpuniquefragmentsrowcount") + " unique fragments, " + hashMap.get("mmpfragmentsrowcount") + " molecules fragments combinations and " + hashMap.get("mmprowcount") + " MMPs.");
            System.out.println("                  0        10        20        30        40        50        60        70        80        90       100");
        }
        this.readMolecules(bufferedReader, (Integer)hashMap.get("moleculesrowcount"), bl);
        this.readUniqueFragments(bufferedReader, (Integer)hashMap.get("mmpuniquefragmentsrowcount"), bl);
        this.readFragments(bufferedReader, (Integer)hashMap.get("mmpfragmentsrowcount"), bl);
        this.readMMPs(bufferedReader, (Integer)hashMap.get("mmprowcount"), bl);
    }

    private void readMolecules(BufferedReader bufferedReader, int n, boolean bl) throws IOException, Exception {
        this.wholeMoleculesIndex = new LinkedHashMap<String, ArrayList<MMP.MoleculeIndex>>();
        this.dataFields = new ArrayList<DataField>();
        this.molecules = new ArrayList<String>();
        this.keysMinAtoms = MMPFragmenter.KEYS_MIN_ATOMS;
        if (bl) {
            System.out.print("Molecules:        #");
        }
        try {
            String string;
            boolean bl2 = false;
            int n2 = 11;
            int n3 = 0;
            int n4 = -1;
            Pattern pattern = Pattern.compile("<(columnName=.*?)>");
            Pattern pattern2 = Pattern.compile("(\\w+)=\"(.*?)\"");
            while ((string = bufferedReader.readLine()) != null && n3 < n) {
                ArrayList<MMP.MoleculeIndex> arrayList;
                Object object;
                Object object2;
                Object object3;
                if (string.startsWith("<molecules>") || bl2 && n2 > 0) {
                    bl2 = true;
                    object3 = pattern.matcher(string);
                    if (((Matcher)object3).find()) {
                        object3 = pattern2.matcher(((Matcher)object3).group(1));
                        object2 = null;
                        String string2 = null;
                        object = null;
                        arrayList = null;
                        String string3 = null;
                        while (((Matcher)object3).find()) {
                            if (((Matcher)object3).group(1).equals("columnName")) {
                                object2 = ((Matcher)object3).group(2);
                                continue;
                            }
                            if (((Matcher)object3).group(1).equals("longName")) {
                                string2 = ((Matcher)object3).group(2);
                                continue;
                            }
                            if (((Matcher)object3).group(1).equals("percentile5")) {
                                arrayList = ((Matcher)object3).group(2);
                                continue;
                            }
                            if (((Matcher)object3).group(1).equals("percentile95")) {
                                string3 = ((Matcher)object3).group(2);
                                continue;
                            }
                            if (!((Matcher)object3).group(1).equals("category")) continue;
                            object = ((Matcher)object3).group(2);
                        }
                        if (!(object2 == null || ((String)object2).equals("moleculeIndex") || ((String)object2).equals("idcoordinates2D") || ((String)object2).equals("molecule") || ((String)object2).equals("moleculeName"))) {
                            this.dataFields.add(new DataField((String)object2, string2, (String)object, (String)((Object)arrayList), string3));
                            ++n2;
                        }
                    }
                    --n2;
                    continue;
                }
                if (!bl2 || n2 != 0) continue;
                object3 = string.split("\t", -1);
                if (((String[])object3).length == this.dataFields.size() + 4) {
                    object3 = string.split("\t", 5);
                    object2 = ((String)object3[4]).split("\t", -1);
                    int n5 = Integer.parseInt((String)object3[0]);
                    arrayList = new ArrayList();
                    if (n5 == n4) {
                        object = new MMP.MoleculeIndex(n5, (String)object3[3], (String[])object2);
                        arrayList = this.wholeMoleculesIndex.get(object3[2]);
                    } else {
                        object = new MMP.MoleculeIndex(n5, (String)object3[1], (String)object3[2], (String)object3[3], (String[])object2);
                        this.molecules.add((String)object3[2]);
                        if (this.molecules.size() != Integer.parseInt((String)object3[0]) + 1) {
                            System.out.println(this.molecules.size());
                        }
                    }
                    arrayList.add((MMP.MoleculeIndex)object);
                    this.wholeMoleculesIndex.put((String)object3[2], arrayList);
                    this.printProgress(bl, n, n3);
                    ++n3;
                    n4 = n5;
                    continue;
                }
                if (!string.startsWith("</molecules>")) continue;
                throw new IOException("molecules: Bad number of entries");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            System.out.print("\n");
        }
    }

    private void readUniqueFragments(BufferedReader bufferedReader, int n, boolean bl) {
        this.uniqueFragmentsIndex = new ArrayList<String>(n);
        if (bl) {
            System.out.print("Unique Fragments: #");
        }
        try {
            String string;
            boolean bl2 = false;
            int n2 = 17;
            int n3 = 0;
            while ((string = bufferedReader.readLine()) != null && n3 < n) {
                if (string.startsWith("<mmpUniqueFragments>") || bl2 && n2 > 0) {
                    bl2 = true;
                    --n2;
                    continue;
                }
                if (!bl2 || n2 != 0) continue;
                String[] stringArray = string.split("\t", -1);
                if (stringArray.length == 7) {
                    this.uniqueFragmentsIndex.add(stringArray[0]);
                    this.mmpUniqueFragments.addFragment(stringArray[0], Integer.parseInt(stringArray[1]), new String[]{stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6]});
                    this.printProgress(bl, n, n3);
                    ++n3;
                    continue;
                }
                if (!string.startsWith("</mmpUniqueFragments>")) continue;
                throw new IOException("mmpUniqueFragments: Bad number of entries");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            System.out.print("\n");
        }
    }

    private void readFragments(BufferedReader bufferedReader, int n, boolean bl) {
        if (bl) {
            System.out.print("Fragments:        #");
        }
        try {
            String string;
            boolean bl2 = false;
            int n2 = 9;
            int n3 = 0;
            while ((string = bufferedReader.readLine()) != null && n3 < n) {
                if (string.startsWith("<mmpFragments>") || bl2 && n2 > 0) {
                    bl2 = true;
                    --n2;
                    continue;
                }
                if (bl2 && n2 == 0) {
                    String[] stringArray = string.split("\t", -1);
                    if (stringArray.length != 5) continue;
                    if (stringArray[3].equals("1")) {
                        this.addFragment(stringArray[0], new int[]{Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[4])});
                        if (this.mmpUniqueFragments.getFragmentAtoms(this.uniqueFragmentsIndex.get(Integer.parseInt(stringArray[2]))) < this.keysMinAtoms) {
                            this.addFragment(stringArray[2], new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[4])});
                        }
                    } else {
                        this.addFragment(stringArray[0] + "\t" + stringArray[1], new int[]{Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[4])});
                    }
                    this.printProgress(bl, n, n3);
                    ++n3;
                    continue;
                }
                if (!string.startsWith("</mmpFragments>")) continue;
                throw new IOException("mmpFragments: Bad number of entries");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            System.out.print("\n");
        }
    }

    private void readMMPs(BufferedReader bufferedReader, int n, boolean bl) {
        if (bl) {
            System.out.print("MMPs:             #");
        }
        try {
            String string;
            boolean bl2 = false;
            int n2 = 11;
            int n3 = 0;
            int n4 = -1;
            HashMap<Integer, HashMap<Integer, List<int[]>>> hashMap = null;
            while ((string = bufferedReader.readLine()) != null && n3 < n) {
                if (string.startsWith("<matchedMolecularPairs>") || bl2 && n2 > 0) {
                    bl2 = true;
                    --n2;
                    continue;
                }
                if (bl2 && n2 == 0) {
                    String[] stringArray = string.split("\t", -1);
                    if (stringArray.length != 7) continue;
                    if (this.version == "1.1") {
                        int n5 = Integer.parseInt(stringArray[1]);
                        if (n5 != n4) {
                            if (hashMap != null) {
                                this.mmpIndex.putAll(hashMap);
                            }
                            hashMap = new HashMap<Integer, HashMap<Integer, List<int[]>>>();
                            n4 = n5;
                        }
                        hashMap = this.addTempMMP(hashMap, Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[2]), stringArray[6].split("\\|", -1));
                    } else {
                        this.addMMP(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[2]), stringArray[6].split("\\|", -1));
                    }
                    this.printProgress(bl, n, n3);
                    ++n3;
                    continue;
                }
                if (!string.startsWith("</matchedMolecularPairs>")) continue;
                throw new IOException("matchedMolecularPairs: Bad number of entries");
            }
            if (hashMap != null) {
                this.mmpIndex.putAll(hashMap);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            System.out.print("\n");
        }
    }

    private void printProgress(boolean bl, int n, int n2) {
        if (bl) {
            double d = (double)(n2 + 1) * 100.0 / (double)n;
            double d2 = 100.0 / (double)n;
            if (Math.floor(d) != Math.floor(d - d2)) {
                if (Math.floor(d) % 10.0 == 0.0) {
                    System.out.print("#");
                } else {
                    System.out.print(".");
                }
            }
        }
    }

    private void addFragment(String string, int[] nArray) {
        List<int[]> list = new ArrayList<int[]>();
        if (this.mmpFragmentsIndex.containsKey(string)) {
            list = this.mmpFragmentsIndex.get(string);
        }
        list.add(nArray);
        this.mmpFragmentsIndex.put(string, list);
    }

    private HashMap<Integer, HashMap<Integer, List<int[]>>> addTempMMP(HashMap<Integer, HashMap<Integer, List<int[]>>> hashMap, int n, int n2, int n3, String[] stringArray) {
        int[] nArray = new int[stringArray.length * 2 + 1];
        nArray[0] = n3;
        int n4 = 1;
        for (String string : stringArray) {
            String[] stringArray2 = string.split(",");
            nArray[n4] = Integer.parseInt(stringArray2[0]);
            nArray[n4 + 1] = Integer.parseInt(stringArray2[1]);
            n4 += 2;
        }
        Object object = new HashMap();
        List<Object> list = new ArrayList<int[]>();
        if (hashMap.containsKey(n) && ((HashMap)(object = hashMap.get(n))).containsKey(n2)) {
            list = (List)((HashMap)object).get(n2);
        }
        list.add(nArray);
        ((HashMap)object).put(n2, list);
        hashMap.put(n, (HashMap<Integer, List<int[]>>)object);
        return hashMap;
    }

    private void addMMP(int n, int n2, int n3, String[] stringArray) {
        int[] nArray = new int[stringArray.length * 2 + 1];
        nArray[0] = n3;
        int n4 = 1;
        for (String string : stringArray) {
            String[] stringArray2 = string.split(",");
            nArray[n4] = Integer.parseInt(stringArray2[0]);
            nArray[n4 + 1] = Integer.parseInt(stringArray2[1]);
            n4 += 2;
        }
        Object object = new HashMap();
        List<Object> list = new ArrayList<int[]>();
        if (this.mmpIndex.containsKey(n) && ((HashMap)(object = this.mmpIndex.get(n))).containsKey(n2)) {
            list = (List)((HashMap)object).get(n2);
        }
        list.add(nArray);
        ((HashMap)object).put(n2, list);
        this.mmpIndex.put(n, (HashMap<Integer, List<int[]>>)object);
    }

    public Integer fragmentToFragmentIndex(String string) {
        if (this.uniqueFragmentsIndex.contains(string)) {
            return this.uniqueFragmentsIndex.indexOf(string);
        }
        return null;
    }

    public Integer[] fragmentToFragmentIndex(String[] stringArray) {
        Integer[] integerArray = new Integer[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            integerArray[i] = this.fragmentToFragmentIndex(stringArray[i]);
        }
        return integerArray;
    }

    public Integer fragmentToFragmentSize(String string) {
        return this.mmpUniqueFragments.getFragmentAtoms(string);
    }

    public int getChemicalSpaceSize(String string) {
        return this.getChemicalSpaceSize(new String[]{string});
    }

    public int getChemicalSpaceSize(String[] stringArray) {
        int n = 0;
        Integer[] integerArray = this.fragmentToFragmentIndex(stringArray);
        String string = this.keysToKeysString(integerArray);
        if (string != null && this.mmpFragmentsIndex.containsKey(string)) {
            List<int[]> list = this.mmpFragmentsIndex.get(string);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int[] nArray : list) {
                hashSet.add(nArray[1]);
            }
            n = hashSet.size();
        }
        return n;
    }

    public List<String> getChemicalSpace(String[] stringArray, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Object> list = new ArrayList();
        Integer[] integerArray = this.fragmentToFragmentIndex(stringArray);
        String string3 = this.keysToKeysString(integerArray);
        int n = -1;
        if (string2 != null) {
            for (int i = 0; i < this.dataFields.size(); ++i) {
                if (!this.dataFields.get(i).fieldName.equals(string2) && !this.dataFields.get(i).longFieldName.equals(string2)) continue;
                n = i;
                break;
            }
        }
        if (string3 != null && this.mmpFragmentsIndex.containsKey(string3)) {
            list = this.mmpFragmentsIndex.get(string3);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (Object object : list) {
                hashSet.add(object[1]);
            }
            Iterator<Object> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (Integer)iterator.next();
                String string4 = this.molecules.get((Integer)object);
                String string5 = null;
                for (MMP.MoleculeIndex moleculeIndex : this.wholeMoleculesIndex.get(string4)) {
                    if (string5 == null) {
                        string5 = moleculeIndex.moleculeIDCoord;
                    }
                    if (n == -1) {
                        arrayList.add(string4 + "\t" + string5 + "\t" + moleculeIndex.moleculeName);
                        continue;
                    }
                    arrayList.add(string4 + "\t" + string5 + "\t" + moleculeIndex.moleculeName + "\t" + moleculeIndex.moleculeData[n]);
                }
            }
        }
        return arrayList;
    }

    public String getChemicalSpaceDWAR(String string, String[] stringArray, String string2) {
        int n = -1;
        if (string2 != null) {
            for (int i = 0; i < this.dataFields.size(); ++i) {
                if (!this.dataFields.get(i).fieldName.equals(string2) && !this.dataFields.get(i).longFieldName.equals(string2)) continue;
                n = i;
                string2 = this.dataFields.get(i).fieldName;
                break;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<datawarrior-fileinfo>\n");
        stringBuilder.append("<version=\"3.1\">\n");
        List<String> list = this.getChemicalSpace(stringArray, null, string2);
        stringBuilder.append("<rowcount=\"" + list.size() + "\">\n");
        stringBuilder.append("</datawarrior-fileinfo>\n");
        stringBuilder.append("<column properties>\n");
        stringBuilder.append("<columnName=\"Structure\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tidcode\">\n");
        stringBuilder.append("<columnName=\"idcoordinates2D\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tidcoordinates2D\">\n");
        stringBuilder.append("<columnProperty=\"parent\tStructure\">\n");
        stringBuilder.append("</column properties>\n");
        if (string2 != null) {
            stringBuilder.append("Structure\tidcoordinates2D\tActelion No\t" + string2 + "\n");
        } else {
            stringBuilder.append("Structure\tidcoordinates2D\tActelion No\n");
        }
        for (String string3 : list) {
            stringBuilder.append(string3 + "\n");
        }
        stringBuilder.append("<datawarrior properties>\n");
        if (n != -1) {
            stringBuilder.append("<columnDescriptionCount=\"1\">\n");
            stringBuilder.append("<columnDescription_0=\"" + string2 + "\t" + this.dataFields.get(n).longFieldName + "\">\n");
            stringBuilder.append("<colorMaxBackground__TableStructure=\"" + this.dataFields.get(n).percentile95 + "\">\n");
            stringBuilder.append("<colorMinBackground__TableStructure=\"" + this.dataFields.get(n).percentile5 + "\">\n");
            stringBuilder.append("<colorBackground__TableStructure_0=\"-13395457\">\n");
            stringBuilder.append("<colorBackground__TableStructure_1=\"-39322\">\n");
            stringBuilder.append("<colorColumnBackground__TableStructure=\"" + string2 + "\">\n");
            stringBuilder.append("<colorListModeBackground__TableStructure=\"straight\">\n");
        }
        stringBuilder.append("<columnWidth_Table_Structure=\"150\">\n");
        stringBuilder.append("<detailView=\"height[Data]=0.7;height[Structure]=0.3\">\n");
        stringBuilder.append("<filter0=\"#browser#\t<disabled>\">\n");
        stringBuilder.append("<filter1=\"#structure#\tStructure\">\n");
        stringBuilder.append("<filter2=\"#double#\t" + string2 + "\">\n");
        stringBuilder.append("<mainViewCount=\"2\">\n");
        stringBuilder.append("<mainViewDockInfo0=\"root\">\n");
        stringBuilder.append("<mainViewDockInfo1=\"Table\tright\t0.5\">\n");
        stringBuilder.append("<mainViewName0=\"Table\">\n");
        stringBuilder.append("<mainViewName1=\"Structure\">\n");
        stringBuilder.append("<mainViewType0=\"tableView\">\n");
        stringBuilder.append("<mainViewType1=\"structureView\">\n");
        stringBuilder.append("<rightSplitting=\"0.6\">\n");
        stringBuilder.append("<rowHeight_Table=\"80\">\n");
        stringBuilder.append("<structureGridColumn_Structure=\"Structure\">\n");
        stringBuilder.append("<structureGridColumns_Structure=\"4\">\n");
        stringBuilder.append("</datawarrior properties>\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getMMPsDWAR(String string, String[] stringArray, String string2, String string3, int n, List<String> list) {
        List<MatchedMolecularPair> list2 = this.getTransformations(string, stringArray, string2, n, n, null);
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<datawarrior-fileinfo>\n");
        stringBuilder.append("<version=\"3.1\">\n");
        for (MatchedMolecularPair iterator : list2) {
            if (!iterator.value2.equals(string3)) continue;
            stringBuilder.append("<rowcount=\"" + iterator.numberOfExamples + "\">\n");
            break;
        }
        stringBuilder.append("</datawarrior-fileinfo>\n");
        stringBuilder.append("<column properties>\n");
        stringBuilder.append("<columnName=\"Structure (1)\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tidcode\">\n");
        stringBuilder.append("<columnName=\"idcoordinates2D (1)\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tidcoordinates2D\">\n");
        stringBuilder.append("<columnProperty=\"parent\tStructure (1)\">\n");
        stringBuilder.append("<columnName=\"Structure (2)\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tidcode\">\n");
        stringBuilder.append("<columnName=\"idcoordinates2D (2)\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tidcoordinates2D\">\n");
        stringBuilder.append("<columnProperty=\"parent\tStructure (2)\">\n");
        stringBuilder.append("<columnName=\"FragFp 2\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tFragFp\">\n");
        stringBuilder.append("<columnProperty=\"parent\tStructure (2)\">\n");
        stringBuilder.append("<columnProperty=\"version\t1.2.1\">\n");
        stringBuilder.append("</column properties>\n");
        stringBuilder.append("FragFp 2\tStructure (1)\tidcoordinates2D (1)\tStructure (2)\tidcoordinates2D (2)\tActelion No (1)\tActelion No (2)\tSimilarity");
        for (String string4 : list) {
            stringBuilder.append("\t" + string4 + " (1)\t" + string4 + " (2)\t" + string4 + " (delta)");
        }
        stringBuilder.append("\n");
        for (MatchedMolecularPair matchedMolecularPair : list2) {
            if (!matchedMolecularPair.value2.equals(string3)) continue;
            for (int i = 0; i < matchedMolecularPair.numberOfExamples; ++i) {
                MMP.MoleculeIndex moleculeIndex = matchedMolecularPair.mmpExamples.get((int)i).example1.get(0);
                MMP.MoleculeIndex moleculeIndex2 = matchedMolecularPair.mmpExamples.get((int)i).example2.get(0);
                stringBuilder.append("\t" + moleculeIndex.moleculeIDCode + "\t" + moleculeIndex.moleculeIDCoord + "\t" + moleculeIndex2.moleculeIDCode + "\t" + moleculeIndex2.moleculeIDCoord + "\t" + moleculeIndex.moleculeName + "\t" + moleculeIndex2.moleculeName + "\t" + Integer.toString(matchedMolecularPair.similarities.get(i)));
                for (String string5 : list) {
                    int n2 = -1;
                    for (int j = 0; j < this.dataFields.size(); ++j) {
                        if (!this.dataFields.get(j).fieldName.equals(string5) && !this.dataFields.get(j).longFieldName.equals(string5)) continue;
                        n2 = j;
                        break;
                    }
                    if (n2 == -1) continue;
                    String string6 = moleculeIndex.moleculeData[n2];
                    String string7 = "";
                    if (moleculeIndex2.moleculeData != null) {
                        string7 = moleculeIndex2.moleculeData[n2];
                    }
                    String string8 = "";
                    if (!(string6.equals("") || string6.startsWith(">") || string6.startsWith("<") || string7.equals("") || string7.startsWith(">") || string7.startsWith("<"))) {
                        string8 = decimalFormat.format(Double.parseDouble(string7) - Double.parseDouble(string6));
                    }
                    stringBuilder.append("\t" + string6 + "\t" + string7 + "\t" + string8);
                }
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append("<datawarrior properties>\n");
        if (list.size() > 0) {
            stringBuilder.append("<axisColumn_2D View_0=\"" + list.get(0) + " (1)\">\n");
            stringBuilder.append("<axisColumn_2D View_1=\"" + list.get(0) + " (2)\">\n");
        }
        stringBuilder.append("<chartType_2D View=\"scatter\">\n");
        stringBuilder.append("<columnDescriptionCount=\"" + (list.size() * 3 + 1) + "\">\n");
        stringBuilder.append("<columnDescription_0=\"Similarity\tSimilarity of the local environment. 6: seed compound; 0-5: number of atoms identical to the seed compound; -1: key not found\">\n");
        int n3 = 1;
        for (String string9 : list) {
            int n4 = -1;
            for (int i = 0; i < this.dataFields.size(); ++i) {
                if (!this.dataFields.get(i).fieldName.equals(string9) && !this.dataFields.get(i).longFieldName.equals(string9)) continue;
                n4 = i;
                break;
            }
            if (n4 == -1) continue;
            stringBuilder.append("<columnDescription_" + n3 + "=\"" + string9 + " (1)\tFirst compound " + this.dataFields.get(n4).longFieldName + "\">\n");
            stringBuilder.append("<columnDescription_" + (n3 + 1) + "=\"" + string9 + " (2)\tSecond compound " + this.dataFields.get(n4).longFieldName + "\">\n");
            stringBuilder.append("<columnDescription_" + (n3 + 2) + "=\"" + string9 + " (delta)\tDifference of " + this.dataFields.get(n4).longFieldName + "\">\n");
            n3 += 3;
        }
        stringBuilder.append("<columnWidth_Table_Structure (1)=\"150\">\n");
        stringBuilder.append("<columnWidth_Table_Structure (2)=\"150\">\n");
        stringBuilder.append("<detailView=\"height[Data]=0.5;height[Structure (1)]=0.25;height[Structure (2)]=0.25\">\n");
        stringBuilder.append("<filter0=\"#browser#\t#disabled#\tStructure (1)\">\n");
        stringBuilder.append("<filter1=\"#structure#\tStructure (2)\">\n");
        stringBuilder.append("<filter2=\"#category#\tSimilarity\">\n");
        int n5 = 3;
        for (String string10 : list) {
            void var11_19;
            stringBuilder.append("<filter" + (int)var11_19 + "=\"#double#\t" + string10 + " (1)\t#disabled#\">\n");
            stringBuilder.append("<filter" + (int)(var11_19 + true) + "=\"#double#\t" + string10 + " (2)\t#disabled#\">\n");
            stringBuilder.append("<filter" + (int)(var11_19 + 2) + "=\"#double#\t" + string10 + " (delta)\t#disabled#\">\n");
            var11_19 += 3;
        }
        stringBuilder.append("<mainSplitting=\"0.8\">\n");
        stringBuilder.append("<mainView=\"Structure (2)\">\n");
        stringBuilder.append("<mainViewCount=\"4\">\n");
        stringBuilder.append("<mainViewDockInfo0=\"root\">\n");
        stringBuilder.append("<mainViewDockInfo1=\"Table\tbottom\t0.7\">\n");
        stringBuilder.append("<mainViewDockInfo2=\"Table\tright\t0.5\">\n");
        stringBuilder.append("<mainViewDockInfo3=\"Structure (1)\tright\t0.5\">\n");
        stringBuilder.append("<mainViewName0=\"Table\">\n");
        stringBuilder.append("<mainViewName1=\"2D View\">\n");
        stringBuilder.append("<mainViewName2=\"Structure (1)\">\n");
        stringBuilder.append("<mainViewName3=\"Structure (2)\">\n");
        stringBuilder.append("<mainViewType0=\"tableView\">\n");
        stringBuilder.append("<mainViewType1=\"2Dview\">\n");
        stringBuilder.append("<mainViewType2=\"structureView\">\n");
        stringBuilder.append("<mainViewType3=\"structureView\">\n");
        stringBuilder.append("<rightSplitting=\"0.6\">\n");
        stringBuilder.append("<rowHeight_Table=\"80\">\n");
        stringBuilder.append("<showNaNValues_2D View=\"true\">\n");
        stringBuilder.append("<structureGridColumn_Structure (1)=\"Structure (1)\">\n");
        stringBuilder.append("<structureGridColumn_Structure (2)=\"Structure (2)\">\n");
        stringBuilder.append("<structureGridColumns_Structure (1)=\"3\">\n");
        stringBuilder.append("<structureGridColumns_Structure (2)=\"3\">\n");
        stringBuilder.append("</datawarrior properties>\n");
        return stringBuilder.toString();
    }

    public int getTransformationsSize(String string, int n, int n2) {
        int n3 = 0;
        MMPUniqueFragments.MMPUniqueFragment mMPUniqueFragment = this.mmpUniqueFragments.fragmentIDToFragment(string);
        if (mMPUniqueFragment != null) {
            Integer n4 = mMPUniqueFragment.getFragmentAtoms();
            Integer n5 = mMPUniqueFragment.getFragmentIndex();
            if (n5 != null && this.mmpIndex.containsKey(n5)) {
                HashMap<Integer, List<int[]>> hashMap = this.mmpIndex.get(n5);
                for (int i = n4 + n; i <= n4 + n2; ++i) {
                    if (!hashMap.containsKey(i)) continue;
                    n3 += hashMap.get(i).size();
                }
            }
        }
        return n3;
    }

    private List<MatchedMolecularPair> getTransformations(String string, String[] stringArray, String string2, int n, int n2, String string3) {
        ArrayList<MatchedMolecularPair> arrayList = new ArrayList<MatchedMolecularPair>();
        Integer[] integerArray = this.fragmentToFragmentIndex(stringArray);
        String string4 = null;
        if (integerArray.length == 1 && integerArray[0] != null) {
            string4 = Integer.toString(integerArray[0]);
        } else if (integerArray.length == 2 && integerArray[0] != null && integerArray[1] != null) {
            string4 = Integer.toString(integerArray[0]) + "\t" + Integer.toString(integerArray[1]);
        }
        MMPUniqueFragments.MMPUniqueFragment mMPUniqueFragment = this.mmpUniqueFragments.fragmentIDToFragment(string2);
        if (mMPUniqueFragment != null) {
            Integer n3 = mMPUniqueFragment.getFragmentAtoms();
            Integer n4 = mMPUniqueFragment.getFragmentIndex();
            MMPUniqueFragments.MMPUniqueFragment mMPUniqueFragment2 = this.mmpUniqueFragments.fragmentIDToFragment(stringArray);
            String[] stringArray2 = null;
            if (mMPUniqueFragment2 != null) {
                stringArray2 = mMPUniqueFragment2.getFragmentFP();
            }
            String[] stringArray3 = mMPUniqueFragment.getFragmentFP();
            if (n4 != null && this.mmpIndex.containsKey(n4)) {
                HashMap<Integer, List<int[]>> hashMap = this.mmpIndex.get(n4);
                List<int[]> list = null;
                if (string4 != null && this.mmpFragmentsIndex.containsKey(string4)) {
                    list = this.mmpFragmentsIndex.get(string4);
                }
                for (int i = n3 + n; i <= n3 + n2; ++i) {
                    if (!hashMap.containsKey(i)) continue;
                    List<int[]> list2 = hashMap.get(i);
                    for (int[] nArray : list2) {
                        Object object;
                        Object object22;
                        int n5 = nArray[0];
                        String string5 = this.uniqueFragmentsIndex.get(n5);
                        int n6 = -1;
                        if (list != null) {
                            for (Object object22 : list) {
                                if (object22[0] != n5) continue;
                                n6 = object22[1];
                                break;
                            }
                        }
                        List<MatchedMolecularPairExamples> list3 = this.examplesToMolecules(nArray, stringArray2, n5, n6);
                        if (n6 == -1) {
                            Object object3;
                            Object object4;
                            object22 = this.wholeMoleculesIndex.get(string);
                            if (object22 == null) {
                                object = new StereoMolecule();
                                object4 = new IDCodeParser();
                                ((IDCodeParserWithoutCoordinateInvention)object4).parse((StereoMolecule)object, string);
                                object3 = new MMP.MoleculeIndex(-1, "", string, "", this.generateData((StereoMolecule)object));
                                object22 = new ArrayList();
                                object22.add(object3);
                            } else {
                                ((MMP.MoleculeIndex)object22.get(0)).setIDCode(string);
                            }
                            object = this.molFromKeyValue(stringArray, string5);
                            object4 = new MMP.MoleculeIndex(-1, "", ((StereoMolecule)object).getIDCode(), "", this.generateData((StereoMolecule)object));
                            object3 = new ArrayList();
                            ((ArrayList)object3).add(object4);
                            MatchedMolecularPairExamples matchedMolecularPairExamples = new MatchedMolecularPairExamples((ArrayList<MMP.MoleculeIndex>)object22, (ArrayList<MMP.MoleculeIndex>)object3, 6);
                            list3.add(0, matchedMolecularPairExamples);
                        }
                        Collections.sort(list3, EXAMPLES_SIMILARITY_SORT);
                        object22 = this.mmpUniqueFragments.fragmentIDToFragment(string5);
                        object = object22.getFragmentFP();
                        arrayList.add(new MatchedMolecularPair(string2, n4, n3, stringArray3, string5, n5, i, (String[])object, list3, this.dataFields.size(), n6));
                    }
                }
            }
        }
        if (string3 == null || string3.equals(SORT_BY_NUMBER_OF_EXAMPLES)) {
            Collections.sort(arrayList, NUMBER_OF_EXAMPLES_SORT);
        } else if (string3.equals(SORT_BY_SIMILARITY)) {
            Collections.sort(arrayList, SIMILARITY_SORT);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public String getTransformationsDWAR(String string, String[] stringArray, String string2, int n, int n2, Integer n3, List<String> list) {
        void var13_28;
        void var12_20;
        void var12_19;
        void var12_18;
        if (n3 == null) {
            n3 = 0;
        }
        List<MatchedMolecularPair> list2 = this.getTransformations(string, stringArray, string2, n, n2, null);
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<datawarrior-fileinfo>\n");
        stringBuilder.append("<version=\"3.1\">\n");
        stringBuilder.append("<rowcount=\"" + list2.size() + "\">\n");
        stringBuilder.append("</datawarrior-fileinfo>\n");
        stringBuilder.append("<column properties>\n");
        stringBuilder.append("<columnName=\"Transformation\">\n");
        stringBuilder.append("<columnProperty=\"specialType\trxncode\">\n");
        stringBuilder.append("<columnName=\"Product\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tidcode\">\n");
        stringBuilder.append("<columnName=\"Structure\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tidcode\">\n");
        stringBuilder.append("<columnName=\"idcoordinates2D\">\n");
        stringBuilder.append("<columnProperty=\"specialType\tidcoordinates2D\">\n");
        stringBuilder.append("<columnProperty=\"parent\tStructure\">\n");
        stringBuilder.append("</column properties>\n");
        stringBuilder.append("Transformation\tProduct\tDeltaAtoms\tStructure\tidcoordinates2D\tActelion No\tExists\tExamples");
        for (String iterator : list) {
            stringBuilder.append("\t" + iterator + " Avg\t" + iterator + " SD\t" + iterator + " n");
        }
        stringBuilder.append("\n");
        for (MatchedMolecularPair matchedMolecularPair : list2) {
            matchedMolecularPair.calcTransformationString();
            String string3 = this.generateBuildingBlock(matchedMolecularPair.value2);
            stringBuilder.append(matchedMolecularPair.transformationString + "\t" + string3 + "\t" + (matchedMolecularPair.value2Atoms - matchedMolecularPair.value1Atoms));
            if (!matchedMolecularPair.targetExists) {
                StereoMolecule stereoMolecule = this.molFromKeyValue(stringArray, matchedMolecularPair.value2);
                stringBuilder.append("\t" + stereoMolecule.getIDCode() + "\t\t");
            } else {
                stringBuilder.append("\t" + matchedMolecularPair.mmpExamples.get((int)0).example2.get((int)0).moleculeIDCode + "\t" + matchedMolecularPair.mmpExamples.get((int)0).example2.get((int)0).moleculeIDCoord + "\t" + matchedMolecularPair.mmpExamples.get((int)0).example1.get((int)0).moleculeName);
            }
            stringBuilder.append("\t" + matchedMolecularPair.targetExists + "\t" + matchedMolecularPair.numberOfExamples);
            for (String string4 : list) {
                int n4 = -1;
                for (int i = 0; i < this.dataFields.size(); ++i) {
                    if (!this.dataFields.get(i).fieldName.equals(string4) && !this.dataFields.get(i).longFieldName.equals(string4)) continue;
                    n4 = i;
                    break;
                }
                if (n4 == -1) continue;
                if (matchedMolecularPair.average[n4][n3] != null) {
                    stringBuilder.append("\t" + decimalFormat.format(matchedMolecularPair.average[n4][n3]));
                } else {
                    stringBuilder.append("\t");
                }
                if (matchedMolecularPair.sd[n4][n3] != null) {
                    if (Double.isNaN(matchedMolecularPair.sd[n4][n3])) {
                        stringBuilder.append("\t0.0");
                    } else {
                        stringBuilder.append("\t" + decimalFormat.format(matchedMolecularPair.sd[n4][n3]));
                    }
                } else {
                    stringBuilder.append("\t");
                }
                stringBuilder.append("\t" + matchedMolecularPair.n[n4][n3]);
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("<datawarrior properties>\n");
        if (list.size() > 0) {
            stringBuilder.append("<axisColumn_2D View_0=\"" + list.get(0) + " Avg\">\n");
            if (list.size() > 1) {
                stringBuilder.append("<axisColumn_2D View_1=\"" + list.get(1) + " Avg\">\n");
            } else {
                stringBuilder.append("<axisColumn_2D View_1=\"" + list.get(0) + " Avg\">\n");
            }
        }
        stringBuilder.append("<chartType_2D View=\"scatter\">\n");
        stringBuilder.append("<columnDescriptionCount=\"" + (list.size() * 3 + 3) + "\">\n");
        stringBuilder.append("<columnDescription_0=\"DeltaAtoms\tDifference of number of heavy atoms between seed and target\">\n");
        stringBuilder.append("<columnDescription_1=\"Exists\tTarget structure exists in the dataset or not\">\n");
        stringBuilder.append("<columnDescription_2=\"Examples\tNumber of MMPs\">\n");
        int n5 = 3;
        for (String string5 : list) {
            int n6 = -1;
            for (int i = 0; i < this.dataFields.size(); ++i) {
                if (!this.dataFields.get(i).fieldName.equals(string5) && !this.dataFields.get(i).longFieldName.equals(string5)) continue;
                n6 = i;
                break;
            }
            if (n6 == -1) continue;
            stringBuilder.append("<columnDescription_" + n5 + "=\"" + string5 + " Avg\tAverage of MMPs of " + this.dataFields.get(n6).longFieldName + "\">\n");
            stringBuilder.append("<columnDescription_" + (n5 + 1) + "=\"" + string5 + " SD\tSD of MMPs of " + this.dataFields.get(n6).longFieldName + "\">\n");
            stringBuilder.append("<columnDescription_" + (n5 + 2) + "=\"" + string5 + " n\tNumber of MMPs of " + this.dataFields.get(n6).longFieldName + "\">\n");
            n5 += 3;
        }
        stringBuilder.append("<columnWidth_Table_Structure=\"150\">\n");
        stringBuilder.append("<columnWidth_Table_Transformation=\"260\">\n");
        stringBuilder.append("<detailView=\"height[Data]=0.7;height[Structure]=0.3\">\n");
        stringBuilder.append("<filter0=\"#browser#\t#disabled#\tTransformation\">\n");
        stringBuilder.append("<filter1=\"#structure#\tStructure\">\n");
        int n7 = 2;
        if (n != n2) {
            stringBuilder.append("<filter2=\"#double#\tDeltaAtoms\">\n");
            ++var12_18;
        }
        stringBuilder.append("<filter" + (int)var12_18 + "=\"#double#\tExamples\">\n");
        stringBuilder.append("<filter" + (int)(++var12_19) + "=\"#category#\tExists\">\n");
        ++var12_20;
        for (String string6 : list) {
            void var12_21;
            stringBuilder.append("<filter" + (int)var12_21 + "=\"#double#\t" + string6 + " Avg\t#disabled#\">\n");
            ++var12_21;
        }
        stringBuilder.append("<mainSplitting=\"0.8\">\n");
        stringBuilder.append("<mainView=\"Structures\">\n");
        stringBuilder.append("<mainViewCount=\"3\">\n");
        stringBuilder.append("<mainViewDockInfo0=\"root\">\n");
        String string7 = "Transformations";
        if (n3 != 0) {
            String string8 = "Transformations (environment size " + Integer.toString(n3) + ")";
        }
        stringBuilder.append("<mainViewDockInfo1=\"" + (String)var13_28 + "\tbottom\t0.7\">\n");
        stringBuilder.append("<mainViewDockInfo2=\"" + (String)var13_28 + "\tright\t0.7\">\n");
        stringBuilder.append("<mainViewName0=\"" + (String)var13_28 + "\">\n");
        stringBuilder.append("<mainViewName1=\"2D View\">\n");
        stringBuilder.append("<mainViewName2=\"Structures\">\n");
        stringBuilder.append("<mainViewType0=\"tableView\">\n");
        stringBuilder.append("<mainViewType1=\"2Dview\">\n");
        stringBuilder.append("<mainViewType2=\"structureView\">\n");
        stringBuilder.append("<rightSplitting=\"0.6\">\n");
        stringBuilder.append("<rowHeight_" + (String)var13_28 + "=\"80\">\n");
        stringBuilder.append("<showNaNValues_2D View=\"true\">\n");
        stringBuilder.append("<structureGridColumn_Structures=\"Structure\">\n");
        stringBuilder.append("<structureGridColumns_Structures=\"3\">\n");
        stringBuilder.append("</datawarrior properties>\n");
        return stringBuilder.toString();
    }

    public List<String[]> transformationsListToTable(String[] stringArray, String string, int n, int n2) {
        List<MatchedMolecularPair> list = this.getTransformations(null, stringArray, string, n, n2, null);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (MatchedMolecularPair matchedMolecularPair : list) {
            String string2 = matchedMolecularPair.targetExists ? "1" : "0";
            arrayList.add(new String[]{matchedMolecularPair.value1, matchedMolecularPair.value2, Integer.toString(matchedMolecularPair.numberOfExamples), string2});
        }
        return arrayList;
    }

    public String getTransformationsJSON(String string, String[] stringArray, String string2, int n, int n2, String string3) {
        List<MatchedMolecularPair> list = this.getTransformations(string, stringArray, string2, n, n2, string3);
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"transformations\": [");
        int n3 = 0;
        for (MatchedMolecularPair matchedMolecularPair : list) {
            int n4;
            if (n3 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\n\t{\"value1\": \"" + matchedMolecularPair.value1.replace("\\", "\\\\") + "\"");
            stringBuilder.append(",\n\t \"value2\": \"" + matchedMolecularPair.value2.replace("\\", "\\\\") + "\"");
            stringBuilder.append(",\n\t \"n\": " + matchedMolecularPair.numberOfExamples);
            stringBuilder.append(",\n\t \"delta_atoms\": " + (matchedMolecularPair.value2Atoms - matchedMolecularPair.value1Atoms));
            stringBuilder.append(",\n\t \"similarity\": " + matchedMolecularPair.similarity);
            String string4 = matchedMolecularPair.targetExists ? "true" : "false";
            stringBuilder.append(",\n\t \"current\": " + string4 + "");
            try {
                stringBuilder.append(",\n\t \"image\": \"" + MMPReader.getB64Image(MMPReader.getImage(matchedMolecularPair.value1, matchedMolecularPair.value2, 580, 266)) + "\"");
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuilder.append(",\n\t \"compounds\": [");
            for (n4 = 0; n4 < matchedMolecularPair.numberOfExamples; ++n4) {
                if (n4 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("[\"" + matchedMolecularPair.mmpExamples.get((int)n4).example1.get((int)0).moleculeName + "\", \"" + matchedMolecularPair.mmpExamples.get((int)n4).example2.get((int)0).moleculeName + "\"]");
            }
            stringBuilder.append("]");
            stringBuilder.append(",\n\t \"similarities\": [");
            for (n4 = 0; n4 < matchedMolecularPair.numberOfExamples; ++n4) {
                if (n4 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(matchedMolecularPair.mmpExamples.get((int)n4).similarity);
            }
            stringBuilder.append("]");
            stringBuilder.append(",\n\t \"structures\": [");
            for (n4 = 0; n4 < matchedMolecularPair.numberOfExamples; ++n4) {
                if (n4 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("[\"" + matchedMolecularPair.mmpExamples.get((int)n4).example1.get((int)0).moleculeIDCode.replace("\\", "\\\\") + "\", \"" + matchedMolecularPair.mmpExamples.get((int)n4).example2.get((int)0).moleculeIDCode.replace("\\", "\\\\") + "\"]");
            }
            stringBuilder.append("]");
            stringBuilder.append(",\n\t \"coordinates\": [");
            for (n4 = 0; n4 < matchedMolecularPair.numberOfExamples; ++n4) {
                if (n4 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("[\"" + matchedMolecularPair.mmpExamples.get((int)n4).example1.get((int)0).moleculeIDCoord.replace("\\", "\\\\") + "\", \"" + matchedMolecularPair.mmpExamples.get((int)n4).example2.get((int)0).moleculeIDCoord.replace("\\", "\\\\") + "\"]");
            }
            stringBuilder.append("]");
            stringBuilder.append(",\n\t \"datas\": [");
            for (n4 = 0; n4 < matchedMolecularPair.n.length; ++n4) {
                int n5;
                if (n4 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("{");
                for (n5 = 0; n5 < 6; ++n5) {
                    if (n5 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("\n\t\t\"similarity" + n5 + "\":");
                    stringBuilder.append("\n\t\t{\"n\": " + matchedMolecularPair.n[n4][n5]);
                    stringBuilder.append(",\n\t\t \"increase\": " + matchedMolecularPair.increase[n4][n5]);
                    stringBuilder.append(",\n\t\t \"decrease\": " + matchedMolecularPair.decrease[n4][n5]);
                    stringBuilder.append(",\n\t\t \"neutral\": " + matchedMolecularPair.neutral[n4][n5]);
                    if (matchedMolecularPair.average[n4][n5] != null) {
                        stringBuilder.append(",\n\t\t \"average\": " + decimalFormat.format(matchedMolecularPair.average[n4][n5]));
                    } else {
                        stringBuilder.append(",\n\t\t \"average\": " + matchedMolecularPair.average[n4][n5]);
                    }
                    if (matchedMolecularPair.sd[n4][n5] != null) {
                        if (Double.isNaN(matchedMolecularPair.sd[n4][n5])) {
                            stringBuilder.append(",\n\t\t \"sd\": 0.0");
                        } else {
                            stringBuilder.append(",\n\t\t \"sd\": " + decimalFormat.format(matchedMolecularPair.sd[n4][n5]));
                        }
                    } else {
                        stringBuilder.append(",\n\t\t \"sd\": " + matchedMolecularPair.sd[n4][n5]);
                    }
                    stringBuilder.append("}");
                }
                stringBuilder.append(",\n\t\t \"data\": [");
                for (n5 = 0; n5 < matchedMolecularPair.numberOfExamples; ++n5) {
                    ArrayList<MMP.MoleculeIndex> arrayList = matchedMolecularPair.mmpExamples.get((int)n5).example1;
                    ArrayList<MMP.MoleculeIndex> arrayList2 = matchedMolecularPair.mmpExamples.get((int)n5).example2;
                    if (n5 > 0) {
                        stringBuilder.append(",");
                    }
                    String string5 = "";
                    if (arrayList.get((int)0).moleculeData != null) {
                        string5 = arrayList.get((int)0).moleculeData[n4];
                    }
                    String string6 = "";
                    if (arrayList2.get((int)0).moleculeData != null) {
                        string6 = arrayList2.get((int)0).moleculeData[n4];
                    }
                    string5 = string5.equals("") ? "\"n.a.\"" : (string5.startsWith(">") || string5.startsWith("<") ? "\"" + string5 + "\"" : decimalFormat.format(Double.parseDouble(string5)));
                    string6 = string6.equals("") ? "\"n.a.\"" : (string6.startsWith(">") || string6.startsWith("<") ? "\"" + string6 + "\"" : decimalFormat.format(Double.parseDouble(string6)));
                    stringBuilder.append("[" + string5 + ", " + string6 + "]");
                }
                stringBuilder.append("]}");
            }
            stringBuilder.append("]}");
            ++n3;
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    private StereoMolecule changeR1ToR2(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 142) continue;
            stereoMolecule.setAtomicNo(i, 143);
            break;
        }
        return stereoMolecule;
    }

    private String generateBuildingBlock(String string) {
        StereoMolecule stereoMolecule = new StereoMolecule();
        IDCodeParser iDCodeParser = new IDCodeParser();
        iDCodeParser.parse(stereoMolecule, string);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) >= 142) {
                stereoMolecule.setAtomQueryFeature(i, 1L, true);
                continue;
            }
            stereoMolecule.setAtomQueryFeature(i, 2048L, true);
        }
        return stereoMolecule.getIDCode();
    }

    private StereoMolecule molFromKeyValue(String[] stringArray, String string) {
        int[] nArray = new int[2 * stringArray.length];
        int[] nArray2 = new int[2 * stringArray.length];
        int[] nArray3 = new int[2 * stringArray.length];
        int[] nArray4 = new int[2 * stringArray.length];
        int[] nArray5 = new int[2 * stringArray.length];
        int[] nArray6 = new int[stringArray.length];
        StereoMolecule stereoMolecule = new StereoMolecule();
        StereoMolecule stereoMolecule2 = new StereoMolecule();
        IDCodeParser iDCodeParser = new IDCodeParser();
        iDCodeParser.parse(stereoMolecule, string);
        iDCodeParser.parse(stereoMolecule2, stringArray[0]);
        stereoMolecule.addMolecule(stereoMolecule2);
        if (stringArray.length == 2) {
            StereoMolecule stereoMolecule3 = new StereoMolecule();
            iDCodeParser.parse(stereoMolecule3, stringArray[1]);
            stereoMolecule3 = this.changeR1ToR2(stereoMolecule3);
            stereoMolecule.addMolecule(stereoMolecule3);
            nArray6[1] = 2;
        }
        stereoMolecule.ensureHelperArrays(1);
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            int n;
            int n2 = stereoMolecule.getBondAtom(0, i);
            int n3 = stereoMolecule.getBondAtom(1, i);
            if (stereoMolecule.getAtomicNo(n2) != 0 && stereoMolecule.getAtomicNo(n2) < 142 && stereoMolecule.getAtomicNo(n3) != 0 && stereoMolecule.getAtomicNo(n3) < 142) continue;
            if (stereoMolecule.getAtomicNo(n2) == 0 || stereoMolecule.getAtomicNo(n2) >= 142) {
                n = stereoMolecule.getAtomicNo(n2) - 142;
                nArray2[nArray6[n]] = i;
                nArray[nArray6[n]] = n2;
                nArray3[nArray6[n]] = 0;
                nArray4[nArray6[n]] = n3;
                nArray5[nArray6[n]] = n;
            } else {
                n = stereoMolecule.getAtomicNo(n3) - 142;
                nArray2[nArray6[n]] = i;
                nArray[nArray6[n]] = n3;
                nArray3[nArray6[n]] = 1;
                nArray4[nArray6[n]] = n2;
                nArray5[nArray6[n]] = n;
            }
            int n4 = n;
            nArray6[n4] = nArray6[n4] + 1;
        }
        stereoMolecule.setBondAtom(nArray3[0], nArray2[0], nArray4[1]);
        stereoMolecule.markBondForDeletion(nArray2[1]);
        stereoMolecule.markAtomForDeletion(nArray[1]);
        stereoMolecule.markAtomForDeletion(nArray[0]);
        if (stringArray.length == 2) {
            stereoMolecule.setBondAtom(nArray3[2], nArray2[2], nArray4[3]);
            stereoMolecule.markBondForDeletion(nArray2[3]);
            stereoMolecule.markAtomForDeletion(nArray[3]);
            stereoMolecule.markAtomForDeletion(nArray[2]);
        }
        stereoMolecule.deleteMarkedAtomsAndBonds();
        return stereoMolecule;
    }

    private List<MatchedMolecularPairExamples> examplesToMolecules(int[] nArray, String[] stringArray, int n, int n2) {
        ArrayList<MatchedMolecularPairExamples> arrayList = new ArrayList<MatchedMolecularPairExamples>();
        List<int[]> list = null;
        if (this.mmpFragmentsIndex.containsKey(Integer.toString(n))) {
            list = this.mmpFragmentsIndex.get(Integer.toString(n));
        }
        for (int i = 1; i < nArray.length; i += 2) {
            ArrayList<MMP.MoleculeIndex> arrayList2 = this.molIndexToMolecule(nArray[i]);
            ArrayList<MMP.MoleculeIndex> arrayList3 = this.molIndexToMolecule(nArray[i + 1]);
            int n3 = -1;
            if (list != null) {
                block1: for (int[] nArray2 : list) {
                    if (nArray2[1] != nArray[i + 1]) continue;
                    if (nArray2[1] == n2) {
                        n3 = 6;
                        break;
                    }
                    n3 = 0;
                    int n4 = nArray2[0];
                    String string = this.uniqueFragmentsIndex.get(n4);
                    MMPUniqueFragments.MMPUniqueFragment mMPUniqueFragment = this.mmpUniqueFragments.fragmentIDToFragment(string);
                    String[] stringArray2 = mMPUniqueFragment.getFragmentFP();
                    if (stringArray == null) break;
                    for (int j = stringArray.length - 1; j >= 0; --j) {
                        if (!stringArray[j].equals(stringArray2[j])) continue;
                        n3 = j + 1;
                        break block1;
                    }
                }
            }
            MatchedMolecularPairExamples matchedMolecularPairExamples = new MatchedMolecularPairExamples(arrayList2, arrayList3, n3);
            arrayList.add(matchedMolecularPairExamples);
        }
        return arrayList;
    }

    private ArrayList<MMP.MoleculeIndex> molIndexToMolecule(int n) {
        String string = this.molecules.get(n);
        ArrayList<MMP.MoleculeIndex> arrayList = this.wholeMoleculesIndex.get(string);
        for (MMP.MoleculeIndex moleculeIndex : arrayList) {
            moleculeIndex.setIDCode(string);
        }
        return arrayList;
    }

    public String getIDCodeFromMolName(String string) {
        for (Map.Entry<String, ArrayList<MMP.MoleculeIndex>> entry : this.wholeMoleculesIndex.entrySet()) {
            for (MMP.MoleculeIndex moleculeIndex : entry.getValue()) {
                if (!moleculeIndex.moleculeName.equals(string)) continue;
                if (entry.getValue().get((int)0).moleculeIDCoord != null) {
                    return entry.getKey() + "\t" + entry.getValue().get((int)0).moleculeIDCoord;
                }
                return entry.getKey();
            }
        }
        return null;
    }

    private String keysToKeysString(Integer[] integerArray) {
        String string = null;
        if (integerArray.length == 1 && integerArray[0] != null) {
            string = Integer.toString(integerArray[0]);
        } else if (integerArray.length == 2 && integerArray[0] != null && integerArray[1] != null) {
            string = Integer.toString(integerArray[0]) + "\t" + Integer.toString(integerArray[1]);
        }
        return string;
    }

    public List<String> getDataFields(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DataField dataField : this.dataFields) {
            if (string.equals("fieldName")) {
                arrayList.add(dataField.fieldName);
                continue;
            }
            if (string.equals("longFieldName")) {
                if (dataField.longFieldName != null) {
                    arrayList.add(dataField.longFieldName);
                    continue;
                }
                arrayList.add(dataField.fieldName);
                continue;
            }
            if (string.equals("categoryName")) {
                if (dataField.categoryName != null) {
                    arrayList.add(dataField.categoryName);
                    continue;
                }
                arrayList.add("Other");
                continue;
            }
            if (string.equals("percentile5")) {
                arrayList.add(dataField.percentile5);
                continue;
            }
            if (!string.equals("percentile95")) continue;
            arrayList.add(dataField.percentile95);
        }
        return arrayList;
    }

    public String getWhat(String string) {
        if (string.equals("datasetName")) {
            return this.datasetName;
        }
        if (string.equals("date")) {
            return this.date;
        }
        if (string.equals("numberOfMolecules")) {
            return Integer.toString(this.wholeMoleculesIndex.size());
        }
        if (string.equals("randomMoleculeName")) {
            Random random = new Random();
            if (this.molecules.size() > 0) {
                int n = random.nextInt(this.molecules.size());
                ArrayList<MMP.MoleculeIndex> arrayList = this.wholeMoleculesIndex.get(this.molecules.get(n));
                if (arrayList.size() > 0) {
                    return arrayList.get((int)0).moleculeName;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static BufferedImage getImage(String string, String string2, int n, int n2) {
        Object object;
        Object object2;
        ExtendedDepictor extendedDepictor;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        GenericRectangle genericRectangle = new GenericRectangle(0.0, 0.0, n, n2);
        StereoMolecule stereoMolecule = new StereoMolecule();
        IDCodeParser iDCodeParser = new IDCodeParser();
        iDCodeParser.parse(stereoMolecule, string);
        if (string2 == null) {
            extendedDepictor = new ExtendedDepictor(new StereoMolecule[]{stereoMolecule}, null);
        } else {
            object2 = new StereoMolecule();
            iDCodeParser.parse((StereoMolecule)object2, string2);
            object = new Reaction(new StereoMolecule[]{stereoMolecule, object2}, 1);
            extendedDepictor = new ExtendedDepictor((Reaction)object, ((Reaction)object).getDrawingObjects(), true);
        }
        object2 = (Graphics2D)bufferedImage.getGraphics();
        object = new SwingDrawContext((Graphics2D)object2);
        extendedDepictor.validateView((GenericDrawContext)object, genericRectangle, 65581);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)object2).addRenderingHints(renderingHints);
        extendedDepictor.paint((GenericDrawContext)object);
        return bufferedImage;
    }

    private static String getB64Image(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64.OutputStream outputStream = new Base64.OutputStream(byteArrayOutputStream);
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        return byteArrayOutputStream.toString("UTF-8");
    }

    private String[] generateData(StereoMolecule stereoMolecule) {
        Object[] objectArray = new String[this.dataFields.size()];
        Arrays.fill(objectArray, "");
        for (int i = 0; i < this.dataFields.size(); ++i) {
            String string;
            if (!this.dataFields.get(i).categoryName.equals("Calculated") || (string = this.mPropertyCalculator.getCalculatedValue(this.dataFields.get(i).fieldName, stereoMolecule)) == null) continue;
            objectArray[i] = string;
        }
        return objectArray;
    }

    public static class MatchedMolecularPair {
        int numberOfExamples;
        String value1;
        int value1Index;
        int value1Atoms;
        String value2;
        int value2Index;
        int value2Atoms;
        int similarity;
        Reaction transformation;
        String transformationString;
        List<MatchedMolecularPairExamples> mmpExamples;
        ArrayList<ArrayList<Double>> datas;
        ArrayList<Integer> similarities;
        int[][] n;
        int[][] increase;
        int[][] decrease;
        int[][] neutral;
        Double[][] average;
        Double[][] sd;
        Integer[][] numberOfIncrease;
        Integer[][] numberOfDecrease;
        Integer[][] numberOfNeutral;
        boolean targetExists;

        public MatchedMolecularPair(String string, int n, int n2, String[] stringArray, String string2, int n3, int n4, String[] stringArray2, List<MatchedMolecularPairExamples> list, int n5, int n6) {
            Object object;
            int n7;
            this.numberOfExamples = list.size();
            this.value1 = string;
            this.value1Index = n;
            this.value1Atoms = n2;
            this.value2 = string2;
            this.value2Index = n3;
            this.value2Atoms = n4;
            this.transformation = this.reactionFromTwoValues(string, string2);
            this.transformationString = null;
            this.mmpExamples = list;
            this.datas = new ArrayList();
            this.similarities = new ArrayList();
            this.n = new int[n5][6];
            this.average = new Double[n5][6];
            this.sd = new Double[n5][6];
            this.increase = new int[n5][6];
            this.decrease = new int[n5][6];
            this.neutral = new int[n5][6];
            this.targetExists = n6 > -1;
            for (n7 = 0; n7 < n5; ++n7) {
                this.datas.add(new ArrayList());
            }
            for (n7 = 0; n7 < this.numberOfExamples; ++n7) {
                ArrayList<MMP.MoleculeIndex> arrayList = list.get((int)n7).example1;
                object = list.get((int)n7).example2;
                int n8 = list.get((int)n7).similarity;
                Double[] doubleArray = this.averageData(arrayList, n5);
                Double[] doubleArray2 = this.averageData((ArrayList<MMP.MoleculeIndex>)object, n5);
                this.similarities.add(n8);
                for (int i = 0; i < n5; ++i) {
                    if (doubleArray[i] == null || doubleArray2[i] == null) continue;
                    for (int j = 0; j < 6; ++j) {
                        if (n8 != -1 && n8 < j) continue;
                        int[] nArray = this.n[i];
                        int n9 = j;
                        nArray[n9] = nArray[n9] + 1;
                    }
                    ArrayList<Double> arrayList2 = this.datas.get(i);
                    arrayList2.add(doubleArray2[i] - doubleArray[i]);
                    this.datas.set(i, arrayList2);
                }
            }
            for (n7 = 0; n7 < n5; ++n7) {
                for (int i = 0; i < 6; ++i) {
                    this.average[n7][i] = MatchedMolecularPair.calcAverage(this.datas.get(n7).subList(0, this.n[n7][i]));
                    this.sd[n7][i] = this.n[n7][i] > 1 ? Double.valueOf(MatchedMolecularPair.calcStanDev(this.datas.get(n7).subList(0, this.n[n7][i]))) : null;
                    object = MatchedMolecularPair.calcTendency(this.datas.get(n7).subList(0, this.n[n7][i]));
                    this.increase[n7][i] = (int)object[0];
                    this.decrease[n7][i] = (int)object[1];
                    this.neutral[n7][i] = (int)object[2];
                }
            }
            this.similarity = 0;
            for (n7 = stringArray.length - 1; n7 >= 0; --n7) {
                if (!stringArray[n7].equals(stringArray2[n7])) continue;
                this.similarity = n7 + 1;
                break;
            }
        }

        private void calcTransformationString() {
            this.transformationString = this.idCodeFromTwoValues(this.value1, this.value2);
        }

        private static Double calcAverage(List<Double> list) {
            if (list.size() > 0) {
                double d = 0.0;
                int n = 0;
                for (Double d2 : list) {
                    ++n;
                    d += d2.doubleValue();
                }
                return d / (double)n;
            }
            return null;
        }

        private static double calcStanDev(List<Double> list) {
            return Math.pow(MatchedMolecularPair.calcVariance(list), 0.5);
        }

        private static double calcVariance(List<Double> list) {
            int n = list.size();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 1.0 / (double)(n - 1);
            for (Double d4 : list) {
                d += d4.doubleValue();
                d2 += Math.pow(d4, 2.0);
            }
            return d3 * (d2 - Math.pow(d, 2.0) / (double)n);
        }

        private static int[] calcTendency(List<Double> list) {
            int[] nArray = new int[3];
            Arrays.fill(nArray, 0);
            for (Double d : list) {
                if (d >= 0.1) {
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                if (d <= -0.1) {
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                nArray[2] = nArray[2] + 1;
            }
            return nArray;
        }

        private Reaction reactionFromTwoValues(String string, String string2) {
            StereoMolecule stereoMolecule = new StereoMolecule();
            StereoMolecule stereoMolecule2 = new StereoMolecule();
            IDCodeParser iDCodeParser = new IDCodeParser();
            iDCodeParser.parse(stereoMolecule, string);
            iDCodeParser.parse(stereoMolecule2, string2);
            Reaction reaction = new Reaction(new StereoMolecule[]{stereoMolecule, stereoMolecule2}, 1);
            return reaction;
        }

        private String idCodeFromTwoValues(String string, String string2) {
            StereoMolecule stereoMolecule = new StereoMolecule();
            StereoMolecule stereoMolecule2 = new StereoMolecule();
            IDCodeParser iDCodeParser = new IDCodeParser();
            iDCodeParser.parse(stereoMolecule, string);
            iDCodeParser.parse(stereoMolecule2, string2);
            Reaction reaction = new Reaction(new StereoMolecule[]{stereoMolecule, stereoMolecule2}, 1);
            String[] stringArray = ReactionEncoder.encode(reaction, false);
            return string + "!" + string2 + "##" + stringArray[2];
        }

        private Double[] averageData(ArrayList<MMP.MoleculeIndex> arrayList, int n) {
            int n2;
            int[] nArray = new int[n];
            Object[] objectArray = new Double[n];
            Arrays.fill(nArray, 0);
            Arrays.fill(objectArray, (Object)0.0);
            for (n2 = 0; n2 < n; ++n2) {
                for (MMP.MoleculeIndex moleculeIndex : arrayList) {
                    if (moleculeIndex.moleculeData == null || !MatchedMolecularPair.isNumeric(moleculeIndex.moleculeData[n2])) continue;
                    int n3 = n2;
                    nArray[n3] = nArray[n3] + 1;
                    Object[] objectArray2 = objectArray;
                    int n4 = n2;
                    Double.valueOf((Double)objectArray2[n4] + Double.parseDouble(moleculeIndex.moleculeData[n2]));
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (nArray[n2] != 0) {
                    Object[] objectArray3 = objectArray;
                    int n5 = n2;
                    Double.valueOf((Double)objectArray3[n5] / (double)nArray[n2]);
                    continue;
                }
                objectArray[n2] = null;
            }
            return objectArray;
        }

        private static boolean isNumeric(String string) {
            if (string == null) {
                return true;
            }
            try {
                Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
    }

    private class MatchedMolecularPairExamples {
        ArrayList<MMP.MoleculeIndex> example1;
        ArrayList<MMP.MoleculeIndex> example2;
        int similarity;

        public MatchedMolecularPairExamples(ArrayList<MMP.MoleculeIndex> arrayList, ArrayList<MMP.MoleculeIndex> arrayList2, int n) {
            this.example1 = arrayList;
            this.example2 = arrayList2;
            this.similarity = n;
        }
    }

    public class DataField {
        private String fieldName;
        private String longFieldName;
        private String categoryName;
        private String percentile5;
        private String percentile95;

        private DataField(String string, String string2, String string3, String string4, String string5) {
            this.fieldName = string;
            this.categoryName = string3;
            this.longFieldName = string2;
            this.percentile5 = string4;
            this.percentile95 = string5;
        }
    }
}

