/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.type;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.type.Bond;
import java.util.HashSet;

public final class Angle {
    public static boolean inRingOfSize(MMFFMolecule mMFFMolecule, int n, int n2, int n3, int n4) {
        RingCollection ringCollection = mMFFMolecule.getRingSet();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(n);
        hashSet.add(n2);
        hashSet.add(n3);
        if (mMFFMolecule.getBond(n, n2) >= 0 && mMFFMolecule.getBond(n2, n3) >= 0) {
            for (int i = 0; i < ringCollection.getSize(); ++i) {
                if (ringCollection.getRingSize(i) != n4) continue;
                HashSet<Integer> hashSet2 = new HashSet<Integer>();
                for (int n5 : ringCollection.getRingAtoms(i)) {
                    hashSet2.add(n5);
                }
                if (!hashSet2.containsAll(hashSet)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getType(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4;
        int n5 = n4 = Bond.getType(tables, mMFFMolecule, n, n2) + Bond.getType(tables, mMFFMolecule, n2, n3);
        if (Angle.inRingOfSize(mMFFMolecule, n, n2, n3, 3)) {
            n5 += n4 > 0 ? 4 : 3;
        } else if (Angle.inRingOfSize(mMFFMolecule, n, n2, n3, 4)) {
            n5 += n4 > 0 ? 6 : 4;
        }
        return n5;
    }

    public static int getStbnType(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4 = mMFFMolecule.getAtomType(n);
        int n5 = mMFFMolecule.getAtomType(n3);
        int n6 = Bond.getType(tables, mMFFMolecule, n, n2);
        int n7 = Bond.getType(tables, mMFFMolecule, n2, n3);
        int n8 = n4 <= n5 ? n6 : n7;
        int n9 = n4 < n5 ? n7 : n6;
        int n10 = Angle.getType(tables, mMFFMolecule, n, n2, n3);
        switch (n10) {
            case 1: {
                return n8 > 0 || n8 == n9 ? 1 : 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return n8 > 0 || n8 == n9 ? 6 : 7;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return n8 > 0 || n8 == n9 ? 9 : 10;
            }
            case 8: {
                return 11;
            }
        }
        return 0;
    }
}

