/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.forcefield.mmff.EnergyTerm;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Separation;
import com.actelion.research.chem.forcefield.mmff.SortedPair;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.Vector3;
import java.util.ArrayList;
import java.util.List;

public class VanDerWaals
implements EnergyTerm {
    public final int a1t;
    public final int a2t;
    public final double rstar_ij;
    public final double well_depth;
    public final int a1;
    public final int a2;
    public final char da1;
    public final char da2;

    public VanDerWaals(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2) {
        this.a1t = mMFFMolecule.getAtomType(n);
        this.a2t = mMFFMolecule.getAtomType(n2);
        this.a1 = n;
        this.a2 = n2;
        double d = this.minimum(tables);
        double d2 = this.wellDepth(tables, d);
        this.da1 = tables.vdws.da(this.a1t);
        this.da2 = tables.vdws.da(this.a2t);
        if (this.da1 == 'D' && this.da2 == 'A' || this.da1 == 'A' && this.da2 == 'D') {
            d *= tables.vdws.darad;
            d2 *= tables.vdws.daeps;
        }
        this.rstar_ij = d;
        this.well_depth = d2;
    }

    private double minimum(Tables tables) {
        double d = tables.vdws.r_star(this.a1t);
        double d2 = tables.vdws.r_star(this.a2t);
        char c = tables.vdws.da(this.a1t);
        char c2 = tables.vdws.da(this.a2t);
        double d3 = (d - d2) / (d + d2);
        return 0.5 * (d + d2) * (1.0 + (c == 'D' || c2 == 'D' ? 0.0 : tables.vdws.b * (1.0 - Math.exp(-tables.vdws.beta * d3 * d3))));
    }

    private double wellDepth(Tables tables, double d) {
        double d2 = tables.vdws.g_i(this.a1t);
        double d3 = tables.vdws.g_i(this.a2t);
        double d4 = tables.vdws.alpha_i(this.a1t);
        double d5 = tables.vdws.alpha_i(this.a2t);
        double d6 = tables.vdws.n_i(this.a1t);
        double d7 = tables.vdws.n_i(this.a2t);
        double d8 = d * d;
        double d9 = 181.16;
        return d9 * d2 * d3 * d4 * d5 / ((Math.sqrt(d4 / d6) + Math.sqrt(d5 / d7)) * d8 * d8 * d8);
    }

    @Override
    public double getEnergy(double[] dArray) {
        double d = new Vector3(dArray, this.a1, this.a2).length();
        double d2 = d * d;
        double d3 = d2 * d2 * d2 * d;
        double d4 = 1.07 * this.rstar_ij / (d + 0.07000000000000006 * this.rstar_ij);
        double d5 = d4 * d4;
        double d6 = d5 * d5 * d5 * d4;
        double d7 = this.rstar_ij * this.rstar_ij;
        double d8 = d7 * d7 * d7 * this.rstar_ij;
        double d9 = 1.12 * d8 / (d3 + 0.1200000000000001 * d8) - 2.0;
        return d6 * d9 * this.well_depth;
    }

    @Override
    public void getGradient(double[] dArray, double[] dArray2) {
        double d = new Vector3(dArray, this.a1, this.a2).length();
        double d2 = d / this.rstar_ij;
        double d3 = d2 * d2;
        double d4 = d3 * d3 * d3;
        double d5 = d4 * d2;
        double d6 = d5 + 0.1200000000000001;
        double d7 = 1.07 / (d2 + 1.07 - 1.0);
        double d8 = d7 * d7;
        double d9 = d8 * d8 * d8 * d7;
        double d10 = this.well_depth / this.rstar_ij * d9 * (-7.840000000000001 * d4 / (d6 * d6) + (-7.840000000000001 / d6 + 14.0) / (d2 + 0.07000000000000006));
        for (int i = 0; i < 3; ++i) {
            double d11 = 0.01 * this.rstar_ij;
            if (d > 0.0) {
                d11 = d10 * (dArray[3 * this.a1 + i] - dArray[3 * this.a2 + i]) / d;
            }
            int n = 3 * this.a1 + i;
            dArray2[n] = dArray2[n] + d11;
            int n2 = 3 * this.a2 + i;
            dArray2[n2] = dArray2[n2] - d11;
        }
    }

    public static List<VanDerWaals> findIn(Tables tables, MMFFMolecule mMFFMolecule, Separation separation, double d) {
        ArrayList<VanDerWaals> arrayList = new ArrayList<VanDerWaals>();
        for (int i = 0; i < mMFFMolecule.getAllAtoms(); ++i) {
            for (int j = i + 1; j < mMFFMolecule.getAllAtoms(); ++j) {
                SortedPair sortedPair = new SortedPair(i, j);
                Separation.Relation relation = separation.get(sortedPair);
                if (relation != Separation.Relation.ONE_FOUR && relation != Separation.Relation.ONE_X) continue;
                Vector3 vector3 = new Vector3(mMFFMolecule, i, j);
                if (!(vector3.length() < d)) continue;
                arrayList.add(new VanDerWaals(tables, mMFFMolecule, i, j));
            }
        }
        return arrayList;
    }
}

