/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.forcefield.mmff.EnergyTerm;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.Vector3;
import com.actelion.research.chem.forcefield.mmff.table.Torsion;
import java.util.ArrayList;
import java.util.List;

public class TorsionAngle
implements EnergyTerm {
    public final int a1;
    public final int a2;
    public final int a3;
    public final int a4;
    public final int a1t;
    public final int a2t;
    public final int a3t;
    public final int a4t;
    public final double v1;
    public final double v2;
    public final double v3;

    public TorsionAngle(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2, int n3, int n4) {
        this.a1 = n;
        this.a2 = n2;
        this.a3 = n3;
        this.a4 = n4;
        this.a1t = mMFFMolecule.getAtomType(n);
        this.a2t = mMFFMolecule.getAtomType(n2);
        this.a3t = mMFFMolecule.getAtomType(n3);
        this.a4t = mMFFMolecule.getAtomType(n4);
        Torsion.Kb kb = tables.torsion.getForceConstants(mMFFMolecule, n, n2, n3, n4);
        this.v1 = kb.v1;
        this.v2 = kb.v2;
        this.v3 = kb.v3;
    }

    @Override
    public double getEnergy(double[] dArray) {
        Vector3 vector3 = new Vector3(dArray, this.a1, this.a2);
        Vector3 vector32 = new Vector3(dArray, this.a3, this.a2);
        Vector3 vector33 = new Vector3(dArray, this.a2, this.a3);
        Vector3 vector34 = new Vector3(dArray, this.a4, this.a3);
        Vector3 vector35 = vector3.cross(vector32);
        Vector3 vector36 = vector33.cross(vector34);
        double d = vector35.cosAngle(vector36);
        double d2 = 2.0 * d * d - 1.0;
        double d3 = d * (2.0 * d2 - 1.0);
        return 0.5 * (this.v1 * (1.0 + d) + this.v2 * (1.0 - d2) + this.v3 * (1.0 + d3));
    }

    @Override
    public void getGradient(double[] dArray, double[] dArray2) {
        Vector3[] vector3Array = new Vector3[]{new Vector3(dArray, this.a2, this.a1), new Vector3(dArray, this.a2, this.a3), new Vector3(dArray, this.a3, this.a2), new Vector3(dArray, this.a3, this.a4)};
        Vector3[] vector3Array2 = new Vector3[]{vector3Array[0].cross(vector3Array[1]), vector3Array[2].cross(vector3Array[3])};
        double[] dArray3 = new double[]{vector3Array2[0].length(), vector3Array2[1].length()};
        if (Math.abs(dArray3[0]) < 1.0E-5 || Math.abs(dArray3[1]) < 1.0E-5) {
            return;
        }
        vector3Array2[0] = vector3Array2[0].normalise();
        vector3Array2[1] = vector3Array2[1].normalise();
        double d = vector3Array2[0].dot(vector3Array2[1]);
        double d2 = 1.0 - d * d;
        double d3 = d2 > 0.0 ? Math.sqrt(d2) : 0.0;
        double d4 = 2.0 * d3 * d;
        double d5 = 3.0 * d3 - 4.0 * d3 * d2;
        double d6 = 0.5 * (-this.v1 * d3 + 2.0 * this.v2 * d4 - 3.0 * this.v3 * d5);
        double d7 = -d6 * (Math.abs(d3) < 1.0E-5 ? 1.0 / d : 1.0 / d3);
        double[] dArray4 = new double[]{1.0 / dArray3[0] * (vector3Array2[1].x - d * vector3Array2[0].x), 1.0 / dArray3[0] * (vector3Array2[1].y - d * vector3Array2[0].y), 1.0 / dArray3[0] * (vector3Array2[1].z - d * vector3Array2[0].z), 1.0 / dArray3[1] * (vector3Array2[0].x - d * vector3Array2[1].x), 1.0 / dArray3[1] * (vector3Array2[0].y - d * vector3Array2[1].y), 1.0 / dArray3[1] * (vector3Array2[0].z - d * vector3Array2[1].z)};
        int n = 3 * this.a1 + 0;
        dArray2[n] = dArray2[n] + d7 * (dArray4[2] * vector3Array[1].y - dArray4[1] * vector3Array[1].z);
        int n2 = 3 * this.a1 + 1;
        dArray2[n2] = dArray2[n2] + d7 * (dArray4[0] * vector3Array[1].z - dArray4[2] * vector3Array[1].x);
        int n3 = 3 * this.a1 + 2;
        dArray2[n3] = dArray2[n3] + d7 * (dArray4[1] * vector3Array[1].x - dArray4[0] * vector3Array[1].y);
        int n4 = 3 * this.a2 + 0;
        dArray2[n4] = dArray2[n4] + d7 * (dArray4[1] * (vector3Array[1].z - vector3Array[0].z) + dArray4[2] * (vector3Array[0].y - vector3Array[1].y) + dArray4[4] * -vector3Array[3].z + dArray4[5] * vector3Array[3].y);
        int n5 = 3 * this.a2 + 1;
        dArray2[n5] = dArray2[n5] + d7 * (dArray4[0] * (vector3Array[0].z - vector3Array[1].z) + dArray4[2] * (vector3Array[1].x - vector3Array[0].x) + dArray4[3] * vector3Array[3].z + dArray4[5] * -vector3Array[3].x);
        int n6 = 3 * this.a2 + 2;
        dArray2[n6] = dArray2[n6] + d7 * (dArray4[0] * (vector3Array[1].y - vector3Array[0].y) + dArray4[1] * (vector3Array[0].x - vector3Array[1].x) + dArray4[3] * -vector3Array[3].y + dArray4[4] * vector3Array[3].x);
        int n7 = 3 * this.a3 + 0;
        dArray2[n7] = dArray2[n7] + d7 * (dArray4[1] * vector3Array[0].z + dArray4[2] * -vector3Array[0].y + dArray4[4] * (vector3Array[3].z - vector3Array[2].z) + dArray4[5] * (vector3Array[2].y - vector3Array[3].y));
        int n8 = 3 * this.a3 + 1;
        dArray2[n8] = dArray2[n8] + d7 * (dArray4[0] * -vector3Array[0].z + dArray4[2] * vector3Array[0].x + dArray4[3] * (vector3Array[2].z - vector3Array[3].z) + dArray4[5] * (vector3Array[3].x - vector3Array[2].x));
        int n9 = 3 * this.a3 + 2;
        dArray2[n9] = dArray2[n9] + d7 * (dArray4[0] * vector3Array[0].y + dArray4[1] * -vector3Array[0].x + dArray4[3] * (vector3Array[3].y - vector3Array[2].y) + dArray4[4] * (vector3Array[2].x - vector3Array[3].x));
        int n10 = 3 * this.a4 + 0;
        dArray2[n10] = dArray2[n10] + d7 * (dArray4[4] * vector3Array[2].z - dArray4[5] * vector3Array[2].y);
        int n11 = 3 * this.a4 + 1;
        dArray2[n11] = dArray2[n11] + d7 * (dArray4[5] * vector3Array[2].x - dArray4[3] * vector3Array[2].z);
        int n12 = 3 * this.a4 + 2;
        dArray2[n12] = dArray2[n12] + d7 * (dArray4[3] * vector3Array[2].y - dArray4[4] * vector3Array[2].x);
    }

    public boolean nonZero() {
        return Math.abs(this.v1) > 0.001 || Math.abs(this.v2) > 0.001 || Math.abs(this.v3) > 0.001;
    }

    public static List<TorsionAngle> findIn(Tables tables, MMFFMolecule mMFFMolecule) {
        ArrayList<TorsionAngle> arrayList = new ArrayList<TorsionAngle>();
        for (int i = 0; i < mMFFMolecule.getAllAtoms(); ++i) {
            for (int j = 0; j < mMFFMolecule.getAllConnAtoms(i); ++j) {
                int n = mMFFMolecule.getConnAtom(i, j);
                for (int k = 0; k < mMFFMolecule.getAllConnAtoms(n); ++k) {
                    int n2 = mMFFMolecule.getConnAtom(n, k);
                    if (i == n2) continue;
                    for (int i2 = 0; i2 < mMFFMolecule.getAllConnAtoms(n2); ++i2) {
                        TorsionAngle torsionAngle;
                        int n3 = mMFFMolecule.getConnAtom(n2, i2);
                        if (n == n3 || i == n3 || n3 <= i || !(torsionAngle = new TorsionAngle(tables, mMFFMolecule, i, n, n2, n3)).nonZero()) continue;
                        arrayList.add(torsionAngle);
                    }
                }
            }
        }
        return arrayList;
    }
}

