/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.forcefield.mmff.EnergyTerm;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.Vector3;
import java.util.ArrayList;
import java.util.List;

public class StretchBend
implements EnergyTerm {
    public final MMFFMolecule mol;
    public final int a1;
    public final int a2;
    public final int a3;
    public final double theta0;
    public final double kba_ijk;
    public final double kba_kji;
    public final double r0i;
    public final double r0k;

    public StretchBend(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        this.mol = mMFFMolecule;
        this.a1 = n;
        this.a2 = n2;
        this.a3 = n3;
        this.theta0 = tables.angle.theta(mMFFMolecule, n, n2, n3);
        this.r0i = tables.bond.r0(mMFFMolecule, n, n2);
        this.r0k = tables.bond.r0(mMFFMolecule, n3, n2);
        this.kba_ijk = tables.stbn.kba(mMFFMolecule, n, n2, n3);
        this.kba_kji = tables.stbn.kba(mMFFMolecule, n3, n2, n);
    }

    @Override
    public double getEnergy(double[] dArray) {
        double d = new Vector3(dArray, this.a2, this.a1).length();
        double d2 = new Vector3(dArray, this.a2, this.a3).length();
        double d3 = new Vector3(dArray, this.a2, this.a1).angle(new Vector3(dArray, this.a2, this.a3));
        double d4 = 2.5120960256267386 * (Math.toDegrees(d3) - this.theta0);
        return d4 * (d - this.r0i) * this.kba_ijk + d4 * (d2 - this.r0k) * this.kba_kji;
    }

    @Override
    public void getGradient(double[] dArray, double[] dArray2) {
        Vector3 vector3;
        double d = new Vector3(dArray, this.a2, this.a1).length();
        double d2 = new Vector3(dArray, this.a2, this.a3).length();
        Vector3 vector32 = new Vector3(dArray, this.a2, this.a1).normalise();
        double d3 = vector32.dot(vector3 = new Vector3(dArray, this.a2, this.a3).normalise());
        double d4 = 1.0 - d3 * d3;
        double d5 = Math.max(d4 > 0.0 ? Math.sqrt(d4) : 0.0, 1.0E-8);
        double d6 = 57.29577951308232 * Math.acos(d3) - this.theta0;
        double d7 = 57.29577951308232 * (this.kba_ijk * (d - this.r0i) + this.kba_kji * (d2 - this.r0k));
        double d8 = 1.0 / d * (vector3.x - d3 * vector32.x);
        double d9 = 1.0 / d * (vector3.y - d3 * vector32.y);
        double d10 = 1.0 / d * (vector3.z - d3 * vector32.z);
        double d11 = 1.0 / d2 * (vector32.x - d3 * vector3.x);
        double d12 = 1.0 / d2 * (vector32.y - d3 * vector3.y);
        double d13 = 1.0 / d2 * (vector32.z - d3 * vector3.z);
        int n = 3 * this.a1 + 0;
        dArray2[n] = dArray2[n] + 2.5120960256267386 * (vector32.x * this.kba_ijk * d6 + d8 / -d5 * d7);
        int n2 = 3 * this.a1 + 1;
        dArray2[n2] = dArray2[n2] + 2.5120960256267386 * (vector32.y * this.kba_ijk * d6 + d9 / -d5 * d7);
        int n3 = 3 * this.a1 + 2;
        dArray2[n3] = dArray2[n3] + 2.5120960256267386 * (vector32.z * this.kba_ijk * d6 + d10 / -d5 * d7);
        int n4 = 3 * this.a2 + 0;
        dArray2[n4] = dArray2[n4] + 2.5120960256267386 * ((-vector32.x * this.kba_ijk - vector3.x * this.kba_kji) * d6 + (-d8 - d11) / -d5 * d7);
        int n5 = 3 * this.a2 + 1;
        dArray2[n5] = dArray2[n5] + 2.5120960256267386 * ((-vector32.y * this.kba_ijk - vector3.y * this.kba_kji) * d6 + (-d9 - d12) / -d5 * d7);
        int n6 = 3 * this.a2 + 2;
        dArray2[n6] = dArray2[n6] + 2.5120960256267386 * ((-vector32.z * this.kba_ijk - vector3.z * this.kba_kji) * d6 + (-d10 - d13) / -d5 * d7);
        int n7 = 3 * this.a3 + 0;
        dArray2[n7] = dArray2[n7] + 2.5120960256267386 * (vector3.x * this.kba_kji * d6 + d11 / -d5 * d7);
        int n8 = 3 * this.a3 + 1;
        dArray2[n8] = dArray2[n8] + 2.5120960256267386 * (vector3.y * this.kba_kji * d6 + d12 / -d5 * d7);
        int n9 = 3 * this.a3 + 2;
        dArray2[n9] = dArray2[n9] + 2.5120960256267386 * (vector3.z * this.kba_kji * d6 + d13 / -d5 * d7);
    }

    public static boolean valid(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4 = mMFFMolecule.getAtomType(n2);
        if (tables.atom.linear(n4) || n == n3) {
            return false;
        }
        return mMFFMolecule.getBond(n, n2) != -1 && mMFFMolecule.getBond(n2, n3) != -1;
    }

    public static List<StretchBend> findIn(Tables tables, MMFFMolecule mMFFMolecule) {
        ArrayList<StretchBend> arrayList = new ArrayList<StretchBend>();
        for (int i = 0; i < mMFFMolecule.getAllAtoms(); ++i) {
            int n = mMFFMolecule.getAtomType(i);
            if (mMFFMolecule.getAllConnAtoms(i) <= 1 && tables.atom.linear(n)) continue;
            for (int j = 0; j < mMFFMolecule.getAllConnAtoms(i); ++j) {
                int n2 = mMFFMolecule.getConnAtom(i, j);
                for (int k = 0; k < mMFFMolecule.getAllConnAtoms(i); ++k) {
                    int n3 = mMFFMolecule.getConnAtom(i, k);
                    if (n2 > n3 || !StretchBend.valid(tables, mMFFMolecule, n2, i, n3)) continue;
                    StretchBend stretchBend = new StretchBend(tables, mMFFMolecule, n2, i, n3);
                    if (!(Math.abs(stretchBend.kba_ijk) > 1.0E-4) && !(Math.abs(stretchBend.kba_kji) > 1.0E-4)) continue;
                    arrayList.add(stretchBend);
                }
            }
        }
        return arrayList;
    }
}

