/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.forcefield.AbstractForceField;
import com.actelion.research.chem.forcefield.mmff.AngleBend;
import com.actelion.research.chem.forcefield.mmff.BondStretch;
import com.actelion.research.chem.forcefield.mmff.Electrostatic;
import com.actelion.research.chem.forcefield.mmff.EnergyTerm;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.OutOfPlane;
import com.actelion.research.chem.forcefield.mmff.Separation;
import com.actelion.research.chem.forcefield.mmff.StretchBend;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.TorsionAngle;
import com.actelion.research.chem.forcefield.mmff.VanDerWaals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ForceFieldMMFF94
extends AbstractForceField {
    public static final String MMFF94 = "MMFF94";
    public static final String MMFF94S = "MMFF94s";
    public static final String MMFF94SPLUS = "MMFF94s+";
    private final MMFFMolecule mMMFFMol;
    public static Map<String, Tables> mTables = new HashMap<String, Tables>();
    private List<EnergyTerm> mEnergies = new ArrayList<EnergyTerm>();

    public ForceFieldMMFF94(StereoMolecule stereoMolecule, String string, Map<String, Object> map) {
        super(stereoMolecule);
        this.mMMFFMol = new MMFFMolecule(stereoMolecule);
        this.mMol.ensureHelperArrays(7);
        Tables tables = mTables.get(string);
        double d = map.containsKey("nonbonded cutoff") ? (Double)map.get("nonbonded cutoff") : 100.0;
        double d2 = map.containsKey("dielectric constant") ? (Double)map.get("dielectric constant") : 1.0;
        boolean bl = map.containsKey("dielectric model") ? ((String)map.get("dielectric model")).equals("distance") : false;
        Separation separation = new Separation(this.mMMFFMol);
        if (!map.containsKey("angle bend") || ((Boolean)map.get("angle bend")).booleanValue()) {
            this.mEnergies.addAll(AngleBend.findIn(tables, this.mMMFFMol));
        }
        if (!map.containsKey("bond stretch") || ((Boolean)map.get("bond stretch")).booleanValue()) {
            this.mEnergies.addAll(BondStretch.findIn(tables, this.mMMFFMol));
        }
        if (!map.containsKey("electrostatic") || ((Boolean)map.get("electrostatic")).booleanValue()) {
            this.mEnergies.addAll(Electrostatic.findIn(tables, this.mMMFFMol, separation, d, bl, d2));
        }
        if (!map.containsKey("out of plane") || ((Boolean)map.get("out of plane")).booleanValue()) {
            this.mEnergies.addAll(OutOfPlane.findIn(tables, this.mMMFFMol));
        }
        if (!map.containsKey("stretch bend") || ((Boolean)map.get("stretch bend")).booleanValue()) {
            this.mEnergies.addAll(StretchBend.findIn(tables, this.mMMFFMol));
        }
        if (!map.containsKey("torsion angle") || ((Boolean)map.get("torsion angle")).booleanValue()) {
            this.mEnergies.addAll(TorsionAngle.findIn(tables, this.mMMFFMol));
        }
        if (!map.containsKey("van der waals") || ((Boolean)map.get("van der waals")).booleanValue()) {
            this.mEnergies.addAll(VanDerWaals.findIn(tables, this.mMMFFMol, separation, d));
        }
    }

    public ForceFieldMMFF94(StereoMolecule stereoMolecule, String string) {
        this(stereoMolecule, string, new HashMap<String, Object>());
    }

    public int size() {
        return this.mMMFFMol.getAllAtoms();
    }

    @Override
    public double updateGradient() {
        int n;
        this.mGrad = new double[this.mDim];
        for (EnergyTerm energyTerm : this.mEnergies) {
            energyTerm.getGradient(this.mPos, this.mGrad);
        }
        double d = -1.0E8;
        double d2 = 0.1;
        for (n = 0; n < this.mDim; ++n) {
            int n2 = n;
            this.mGrad[n2] = this.mGrad[n2] * d2;
            if (!(this.mGrad[n] > d)) continue;
            d = this.mGrad[n];
        }
        if (d > 10.0) {
            while (d * d2 > 10.0) {
                d2 *= 0.5;
            }
            n = 0;
            while (n < this.mDim) {
                int n3 = n++;
                this.mGrad[n3] = this.mGrad[n3] * d2;
            }
        }
        return d2;
    }

    @Override
    public void zeroGradient() {
        if (this.mFixedAtoms != null) {
            int[] nArray = this.mMMFFMol.getHydrogenMap();
            for (int n : this.mFixedAtoms) {
                int n2 = nArray[n];
                this.mGrad[3 * n2] = 0.0;
                this.mGrad[3 * n2 + 1] = 0.0;
                this.mGrad[3 * n2 + 2] = 0.0;
            }
        }
    }

    @Override
    public double[] getCurrentPositions() {
        double[] dArray = Arrays.copyOf(this.mPos, this.mPos.length);
        return this.getMappedPositions(dArray);
    }

    private double[] getMappedPositions(double[] dArray) {
        int[] nArray = this.mMMFFMol.getHydrogenMap();
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            dArray2[3 * i] = dArray[3 * nArray[i]];
            dArray2[3 * i + 1] = dArray[3 * nArray[i] + 1];
            dArray2[3 * i + 2] = dArray[3 * nArray[i] + 2];
        }
        return dArray2;
    }

    @Override
    public double getTotalEnergy(double[] dArray) {
        double d = 0.0;
        for (EnergyTerm energyTerm : this.mEnergies) {
            d += energyTerm.getEnergy(dArray);
        }
        return d;
    }

    @Override
    public double getTotalEnergy() {
        return this.getTotalEnergy(this.mPos);
    }

    public static void initialize(String string) {
        ForceFieldMMFF94.loadTable(string, Tables.newMMFF94(string));
    }

    public static synchronized void loadTable(String string, Tables tables) {
        if (!mTables.containsKey(string)) {
            mTables.put(string, tables);
        }
    }

    public static Tables table(String string) {
        return mTables.get(string);
    }

    public MMFFMolecule getMMFFMolecule() {
        return this.mMMFFMol;
    }

    public void addEnergyTerm(EnergyTerm energyTerm) {
        this.mEnergies.add(energyTerm);
    }
}

