/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.scoring.plp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;

public class REPTerm
implements PotentialEnergyTerm {
    public static final double A = 3.2;
    public static final double B = 5.0;
    public static final double B_sq = 25.0;
    public static final double C = 0.05;
    public static final double D = 20.0;
    private int recAtom;
    private int ligAtom;
    private Conformer ligand;
    private Conformer receptor;

    private REPTerm(Conformer conformer, Conformer conformer2, int n, int n2) {
        this.recAtom = n;
        this.ligAtom = n2;
        this.receptor = conformer;
        this.ligand = conformer2;
    }

    public static REPTerm create(Conformer conformer, Conformer conformer2, int n, int n2) {
        return new REPTerm(conformer, conformer2, n, n2);
    }

    @Override
    public double getFGValue(double[] dArray) {
        Coordinates coordinates = this.receptor.getCoordinates(this.recAtom);
        Coordinates coordinates2 = this.ligand.getCoordinates(this.ligAtom);
        Coordinates coordinates3 = coordinates.subC(coordinates2);
        double d = coordinates3.distSq();
        Coordinates coordinates4 = new Coordinates();
        double d2 = 0.0;
        if (d > 25.0) {
            d2 = 0.0;
        } else {
            double d3 = 0.0;
            double d4 = Math.sqrt(d);
            if (d4 < 3.2) {
                d3 = -6.234374999999999 * (1.0 / d4);
                coordinates4 = coordinates3.scaleC(d3);
                d2 = d4 * -19.95 / 3.2 + 20.0;
            } else {
                d3 = -0.027777777777777783 * (1.0 / d4);
                coordinates4 = coordinates3.scaleC(d3);
                d2 = -0.05 * (d4 - 3.2) / 1.7999999999999998 + 0.05;
            }
        }
        int n = 3 * this.ligAtom;
        dArray[n] = dArray[n] - coordinates4.x;
        int n2 = 3 * this.ligAtom + 1;
        dArray[n2] = dArray[n2] - coordinates4.y;
        int n3 = 3 * this.ligAtom + 2;
        dArray[n3] = dArray[n3] - coordinates4.z;
        return d2;
    }
}

