/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.scoring.chemscore;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;
import java.util.ArrayList;
import java.util.Iterator;

public class HBTerm
implements PotentialEnergyTerm {
    private static final double D0 = 1.85;
    private static final double D1 = 0.25;
    private static final double D2 = 0.65;
    private static final double PHI0 = Math.PI;
    private static final double PHI1 = 0.5235987755982988;
    private static final double PHI2 = 1.3962634015954636;
    private static final double PSI0 = Math.PI;
    private static final double PSI1 = 1.3962634015954636;
    private static final double PSI2 = 1.7453292519943295;
    private static final double ENERGY = -3.0;
    private Conformer receptor;
    private Conformer ligand;
    private int acceptor;
    private int donor;
    private int hydrogen;
    private int[] acceptorNeighbours;
    private boolean isLigAtomDonor;
    private boolean isLigAtomAcceptor;
    private double scale;

    private HBTerm(Conformer conformer, Conformer conformer2, int n, int n2, int n3, boolean bl, boolean bl2, int[] nArray, double d) {
        this.receptor = conformer;
        this.ligand = conformer2;
        this.acceptor = n;
        this.donor = n2;
        this.hydrogen = n3;
        this.acceptorNeighbours = nArray;
        this.isLigAtomAcceptor = bl;
        this.isLigAtomDonor = bl2;
        this.scale = d;
        assert (bl2 != bl);
    }

    public static HBTerm create(Conformer conformer, Conformer conformer2, int n, int n2, int n3, boolean bl, boolean bl2, int[] nArray, double d) {
        return new HBTerm(conformer, conformer2, n, n2, n3, bl, bl2, nArray, d);
    }

    private double getDistTerm(double[] dArray) {
        Coordinates coordinates = new Coordinates();
        double d = 0.0;
        Coordinates coordinates2 = this.isLigAtomAcceptor ? this.ligand.getCoordinates(this.acceptor) : this.receptor.getCoordinates(this.acceptor);
        Coordinates coordinates3 = this.isLigAtomDonor ? this.ligand.getCoordinates(this.hydrogen) : this.receptor.getCoordinates(this.hydrogen);
        Coordinates coordinates4 = coordinates2.subC(coordinates3);
        double d2 = coordinates4.dist();
        boolean bl = false;
        double d3 = d2 - 1.85;
        if (d3 < 0.0) {
            bl = true;
            d3 = -d3;
        }
        if (d3 < 0.25) {
            d = 1.0;
        } else if (d3 > 0.65) {
            d = 0.0;
        } else {
            double d4 = -2.5 * (1.0 / d2);
            if (bl) {
                d4 *= -1.0;
            }
            coordinates = coordinates4.scaleC(d4);
            coordinates.scale(this.scale);
            if (d3 < 0.0) {
                coordinates.scaleC(-1.0);
            }
            if (this.isLigAtomAcceptor) {
                int n = 3 * this.acceptor;
                dArray[n] = dArray[n] + coordinates.x;
                int n2 = 3 * this.acceptor + 1;
                dArray[n2] = dArray[n2] + coordinates.y;
                int n3 = 3 * this.acceptor + 2;
                dArray[n3] = dArray[n3] + coordinates.z;
            } else {
                int n = 3 * this.hydrogen;
                dArray[n] = dArray[n] - coordinates.x;
                int n4 = 3 * this.hydrogen + 1;
                dArray[n4] = dArray[n4] - coordinates.y;
                int n5 = 3 * this.hydrogen + 2;
                dArray[n5] = dArray[n5] - coordinates.z;
            }
            d = (0.65 - d3) / 0.4;
        }
        return d;
    }

    private double getAngleTerm(double[] dArray, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, double d, double d2, double d3) {
        double d4 = 0.0;
        Coordinates coordinates = bl ? this.ligand.getCoordinates(n) : this.receptor.getCoordinates(n);
        Coordinates coordinates2 = bl2 ? this.ligand.getCoordinates(n2) : this.receptor.getCoordinates(n2);
        Coordinates coordinates3 = bl3 ? this.ligand.getCoordinates(n3) : this.receptor.getCoordinates(n3);
        Coordinates coordinates4 = coordinates.subC(coordinates2).unit();
        Coordinates coordinates5 = coordinates3.subC(coordinates2).unit();
        double d5 = coordinates2.distance(coordinates);
        double d6 = coordinates3.distance(coordinates2);
        double d7 = coordinates4.cosAngle(coordinates5);
        double d8 = Math.acos(d7) - d;
        boolean bl4 = false;
        if (d8 < 0.0) {
            d8 = -d8;
            bl4 = true;
        }
        if (d8 < d2) {
            d4 = 1.0;
        } else if (d8 > d3) {
            d4 = 0.0;
        } else {
            double d9 = -1.0 / (d3 - d2);
            if (bl4) {
                d9 = -d9;
            }
            d4 = (d3 - d8) / (d3 - d2);
            double d10 = 1.0 - d7 * d7;
            double d11 = 1.0E-8;
            if (d10 > 0.0) {
                d11 = Math.sqrt(d10);
            }
            double[] dArray2 = new double[]{1.0 / d5 * (coordinates5.x - d7 * coordinates4.x), 1.0 / d5 * (coordinates5.y - d7 * coordinates4.y), 1.0 / d5 * (coordinates5.z - d7 * coordinates4.z), 1.0 / d6 * (coordinates4.x - d7 * coordinates5.x), 1.0 / d6 * (coordinates4.y - d7 * coordinates5.y), 1.0 / d6 * (coordinates4.z - d7 * coordinates5.z)};
            if (bl) {
                int n4 = 3 * n;
                dArray[n4] = dArray[n4] + d9 * dArray2[0] / -d11;
                int n5 = 3 * n + 1;
                dArray[n5] = dArray[n5] + d9 * dArray2[1] / -d11;
                int n6 = 3 * n + 2;
                dArray[n6] = dArray[n6] + d9 * dArray2[2] / -d11;
            }
            if (bl2) {
                int n7 = 3 * n2;
                dArray[n7] = dArray[n7] + d9 * (-dArray2[0] - dArray2[3]) / -d11;
                int n8 = 3 * n2 + 1;
                dArray[n8] = dArray[n8] + d9 * (-dArray2[1] - dArray2[4]) / -d11;
                int n9 = 3 * n2 + 2;
                dArray[n9] = dArray[n9] + d9 * (-dArray2[2] - dArray2[5]) / -d11;
            }
            if (bl3) {
                int n10 = 3 * n3;
                dArray[n10] = dArray[n10] + d9 * dArray2[3] / -d11;
                int n11 = 3 * n3 + 1;
                dArray[n11] = dArray[n11] + d9 * dArray2[4] / -d11;
                int n12 = 3 * n3 + 2;
                dArray[n12] = dArray[n12] + d9 * dArray2[5] / -d11;
            }
        }
        return d4;
    }

    @Override
    public double getFGValue(double[] dArray) {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
        double d = 0.0;
        double[] dArray2 = new double[dArray.length];
        d = this.getDistTerm(dArray2);
        if (d != 0.0) {
            arrayList.add(d);
            arrayList2.add(dArray2);
            dArray2 = new double[dArray.length];
            d = this.getAngleTerm(dArray2, this.donor, this.hydrogen, this.acceptor, this.isLigAtomDonor, this.isLigAtomDonor, this.isLigAtomAcceptor, Math.PI, 0.5235987755982988, 1.3962634015954636);
            arrayList.add(d);
            arrayList2.add(dArray2);
            for (int iterator : this.acceptorNeighbours) {
                dArray2 = new double[dArray.length];
                d = this.getAngleTerm(dArray2, iterator, this.acceptor, this.hydrogen, this.isLigAtomAcceptor, this.isLigAtomAcceptor, this.isLigAtomDonor, Math.PI, 1.3962634015954636, 1.7453292519943295);
                arrayList.add(d);
                arrayList2.add(dArray2);
            }
        } else {
            arrayList.add(0.0);
        }
        double[] dArray3 = new double[dArray.length];
        double d2 = this.scale * -3.0;
        Iterator n2 = arrayList.iterator();
        while (n2.hasNext()) {
            double dArray32 = (Double)n2.next();
            d2 *= dArray32;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            int n3;
            double[] dArray4 = (double[])arrayList2.get(n);
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                if (n == n3) continue;
                double d3 = (Double)arrayList.get(n3);
                double d4 = d3 * this.scale * -3.0;
                int n4 = 0;
                while (n4 < dArray4.length) {
                    int n5 = n4++;
                    dArray4[n5] = dArray4[n5] * d4;
                }
            }
            for (n3 = 0; n3 < dArray3.length; ++n3) {
                int n6 = n3;
                dArray3[n6] = dArray3[n6] + dArray4[n3];
            }
        }
        for (n = 0; n < dArray3.length; ++n) {
            int n7 = n;
            dArray[n7] = dArray[n7] + dArray3[n];
        }
        return d2;
    }
}

