/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.redgraph;

import com.actelion.research.util.hash.HashSetInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class SubGraphIndices {
    private HashSetInt hsIndexAtom;

    public SubGraphIndices() {
        this.hsIndexAtom = new HashSetInt();
    }

    public SubGraphIndices(int[] nArray) {
        this.hsIndexAtom = new HashSetInt(nArray);
    }

    public int getNumIndices() {
        return this.hsIndexAtom.size();
    }

    public void clear() {
        this.hsIndexAtom.clear();
    }

    public void addIndex(int n) {
        this.hsIndexAtom.add(n);
    }

    public void addIndex(int[] nArray) {
        this.hsIndexAtom.add(nArray);
    }

    public int[] getAtomIndices() {
        return this.hsIndexAtom.getValues();
    }

    public boolean contains(int n) {
        return this.hsIndexAtom.contains(n);
    }

    public boolean equalIndices(int[] nArray) {
        if (this.hsIndexAtom.size() != nArray.length) {
            return false;
        }
        boolean bl = true;
        for (int n : nArray) {
            if (this.hsIndexAtom.contains(n)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SubGraphIndices)) {
            return false;
        }
        SubGraphIndices subGraphIndices = (SubGraphIndices)object;
        if (this.hsIndexAtom.size() != subGraphIndices.getNumIndices()) {
            return false;
        }
        int[] nArray = this.hsIndexAtom.getValues();
        int[] nArray2 = subGraphIndices.getAtomIndices();
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            bl = false;
        }
        return bl;
    }

    public boolean isOverlap(SubGraphIndices subGraphIndices) {
        int[] nArray;
        boolean bl = false;
        for (int n : nArray = subGraphIndices.hsIndexAtom.getValues()) {
            if (!this.hsIndexAtom.contains(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int getNumOverlappingIndices(SubGraphIndices subGraphIndices) {
        int[] nArray;
        int n = 0;
        for (int n2 : nArray = subGraphIndices.hsIndexAtom.getValues()) {
            if (!this.hsIndexAtom.contains(n2)) continue;
            ++n;
        }
        return n;
    }

    public void merge(SubGraphIndices subGraphIndices) {
        int[] nArray;
        for (int n : nArray = subGraphIndices.hsIndexAtom.getValues()) {
            this.hsIndexAtom.add(n);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = this.hsIndexAtom.getValues();
        Arrays.sort(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            if (i >= nArray.length - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public static void merge(List<SubGraphIndices> list) {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < list.size(); ++i) {
                SubGraphIndices subGraphIndices = list.get(i);
                for (int j = list.size() - 1; j > i; --j) {
                    SubGraphIndices subGraphIndices2 = list.get(j);
                    if (!subGraphIndices.isOverlap(subGraphIndices2)) continue;
                    subGraphIndices.merge(subGraphIndices2);
                    list.remove(j);
                    bl = true;
                }
            }
        }
    }

    public static List<SubGraphIndices> mergeOverlapping(List<SubGraphIndices> list, int n) {
        Object object;
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            SubGraphIndices subGraphIndices = list.get(n2);
            object = new OverlappingFragments(subGraphIndices);
            arrayList.add(object);
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (OverlappingFragments)arrayList.get(i);
                for (int j = arrayList.size() - 1; j > i; --j) {
                    OverlappingFragments overlappingFragments = (OverlappingFragments)arrayList.get(j);
                    if (((OverlappingFragments)object).getNumLargestOverlap(overlappingFragments) < n) continue;
                    ((OverlappingFragments)object).add(overlappingFragments);
                    arrayList.remove(j);
                }
            }
        }
        ArrayList<SubGraphIndices> arrayList2 = new ArrayList<SubGraphIndices>();
        for (OverlappingFragments overlappingFragments : arrayList) {
            arrayList2.add(overlappingFragments.getSubGraphIndices());
        }
        return arrayList2;
    }

    protected static void addAtomIndices(HashSetInt hashSetInt, List<SubGraphIndices> list) {
        for (SubGraphIndices subGraphIndices : list) {
            hashSetInt.add(subGraphIndices.getAtomIndices());
        }
    }

    public static Comparator<SubGraphIndices> getComparatorNumIndices() {
        return new Comparator<SubGraphIndices>(){

            @Override
            public int compare(SubGraphIndices subGraphIndices, SubGraphIndices subGraphIndices2) {
                int n = 0;
                if (subGraphIndices.hsIndexAtom.size() > subGraphIndices2.hsIndexAtom.size()) {
                    n = 1;
                } else if (subGraphIndices.hsIndexAtom.size() < subGraphIndices2.hsIndexAtom.size()) {
                    n = -1;
                }
                return n;
            }
        };
    }

    private static class OverlappingFragments {
        List<SubGraphIndices> liSubGraphIndices = new ArrayList<SubGraphIndices>();

        public OverlappingFragments(SubGraphIndices subGraphIndices) {
            this.liSubGraphIndices.add(subGraphIndices);
        }

        public OverlappingFragments(SubGraphIndices subGraphIndices, SubGraphIndices subGraphIndices2) {
            this.liSubGraphIndices.add(subGraphIndices);
            this.liSubGraphIndices.add(subGraphIndices2);
        }

        public void add(SubGraphIndices subGraphIndices) {
            this.liSubGraphIndices.add(subGraphIndices);
        }

        public void add(OverlappingFragments overlappingFragments) {
            this.liSubGraphIndices.addAll(overlappingFragments.liSubGraphIndices);
        }

        public int getNumLargestOverlap(OverlappingFragments overlappingFragments) {
            int n = 0;
            for (SubGraphIndices subGraphIndices : this.liSubGraphIndices) {
                for (SubGraphIndices subGraphIndices2 : overlappingFragments.liSubGraphIndices) {
                    int n2 = subGraphIndices.getNumOverlappingIndices(subGraphIndices2);
                    if (n2 <= n) continue;
                    n = n2;
                }
            }
            return n;
        }

        public boolean containsSubGraph(OverlappingFragments overlappingFragments) {
            boolean bl = false;
            block0: for (SubGraphIndices subGraphIndices : this.liSubGraphIndices) {
                for (SubGraphIndices subGraphIndices2 : overlappingFragments.liSubGraphIndices) {
                    if (!subGraphIndices.equals(subGraphIndices2)) continue;
                    bl = true;
                    break block0;
                }
            }
            return bl;
        }

        public SubGraphIndices getSubGraphIndices() {
            SubGraphIndices.merge(this.liSubGraphIndices);
            if (this.liSubGraphIndices.size() != 1) {
                throw new RuntimeException("This should not happen.");
            }
            return this.liSubGraphIndices.get(0);
        }
    }
}

