/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.generator;

import com.actelion.research.calc.combinatorics.CombinationGenerator;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistViz;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistVizFrag;
import com.actelion.research.chem.descriptor.flexophore.PPNode;
import com.actelion.research.chem.descriptor.flexophore.PPNodeViz;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SubFlexophoreGenerator {
    private int minBinDistThresh;
    private int maxDistanceBinThresh;
    private int minNumDifferentInteractionTypes;
    private ViolatedConditionsCount violatedConditionsCount;
    private HashSet<Integer> hsInteractionType;

    public SubFlexophoreGenerator(SubFlexophoreGenerator subFlexophoreGenerator) {
        this.minBinDistThresh = subFlexophoreGenerator.minBinDistThresh;
        this.maxDistanceBinThresh = subFlexophoreGenerator.maxDistanceBinThresh;
        this.minNumDifferentInteractionTypes = subFlexophoreGenerator.minNumDifferentInteractionTypes;
        this.violatedConditionsCount = new ViolatedConditionsCount();
        this.hsInteractionType = new HashSet();
    }

    public SubFlexophoreGenerator(int n, int n2, int n3) {
        this.minBinDistThresh = n;
        this.maxDistanceBinThresh = n2;
        this.minNumDifferentInteractionTypes = n3;
        this.violatedConditionsCount = new ViolatedConditionsCount();
        this.hsInteractionType = new HashSet();
    }

    public List<MolDistHist> generateSubPharmacophoresCheckedRange(MolDistHist molDistHist, int n) {
        List<int[]> list = CombinationGenerator.getAllOutOf(molDistHist.getNumPPNodes(), n);
        if (list == null) {
            return null;
        }
        ArrayList<MolDistHist> arrayList = new ArrayList<MolDistHist>();
        for (int[] nArray : list) {
            MolDistHist molDistHist2 = this.getSubFragmentCheckedRange(molDistHist, nArray);
            if (molDistHist2 == null) continue;
            int n2 = molDistHist2.getNumPPNodes();
            this.hsInteractionType.clear();
            for (int i = 0; i < n2; ++i) {
                PPNode pPNode = molDistHist2.getNode(i);
                int n3 = pPNode.getInteractionTypeCount();
                for (int j = 0; j < n3; ++j) {
                    int n4 = pPNode.getInteractionType(j);
                    this.hsInteractionType.add(n4);
                }
            }
            if (this.hsInteractionType.size() < this.minNumDifferentInteractionTypes) {
                this.violatedConditionsCount.ccViolatedMinDiffInteractionTypes++;
                continue;
            }
            arrayList.add(molDistHist2);
        }
        return arrayList;
    }

    public MolDistHist getSubFragmentCheckedRange(MolDistHist molDistHist, int[] nArray) {
        int n;
        MolDistHist molDistHist2 = new MolDistHist(nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            PPNode pPNode = new PPNode(molDistHist.getNode(nArray[n]));
            molDistHist2.addNode(pPNode);
        }
        n = 0;
        boolean bl = false;
        block1: for (int i = 0; i < nArray.length; ++i) {
            for (int j = i + 1; j < nArray.length; ++j) {
                int n2;
                byte[] byArray = molDistHist.getDistHist(nArray[i], nArray[j]);
                if (n == 0) {
                    for (n2 = this.minBinDistThresh; n2 < byArray.length; ++n2) {
                        if (byArray[n2] <= 0) continue;
                        n = 1;
                        break;
                    }
                }
                for (n2 = byArray.length - 1; n2 > this.maxDistanceBinThresh; --n2) {
                    if (byArray[n2] <= 0) continue;
                    bl = true;
                    break block1;
                }
                molDistHist2.setDistHist(i, j, byArray);
            }
        }
        if (n == 0 || bl) {
            if (n == 0) {
                this.violatedConditionsCount.ccMissedMinRange++;
            }
            if (bl) {
                this.violatedConditionsCount.ccViolatedMaxRange++;
            }
            return null;
        }
        molDistHist2.realize();
        return molDistHist2;
    }

    public ViolatedConditionsCount getViolatedConditionsCount() {
        return this.violatedConditionsCount;
    }

    public static List<MolDistHistViz> generateSubPharmacophores(MolDistHistViz molDistHistViz, int n, int n2) {
        int n3;
        ArrayList arrayList = new ArrayList();
        for (n3 = 0; n3 < n2 + 1; ++n3) {
            arrayList.add(new HashSet());
        }
        n3 = Math.min(molDistHistViz.getNumPPNodes(), n2) + 1;
        for (int i = n; i < n3; ++i) {
            List<MolDistHistViz> list = SubFlexophoreGenerator.generateSubPharmacophores(molDistHistViz, i);
            ((HashSet)arrayList.get(i)).addAll(list);
        }
        ArrayList<MolDistHistViz> arrayList2 = new ArrayList<MolDistHistViz>();
        for (HashSet hashSet : arrayList) {
            arrayList2.addAll(hashSet);
        }
        return arrayList2;
    }

    public static List<MolDistHistViz> generateSubPharmacophores(List<MolDistHistViz> list, int n, int n2) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n2 + 1; ++i) {
            arrayList.add(new HashSet());
        }
        for (MolDistHistViz object : list) {
            int hashSet = Math.min(object.getNumPPNodes(), n2) + 1;
            for (int i = n; i < hashSet; ++i) {
                List<MolDistHistViz> list2 = SubFlexophoreGenerator.generateSubPharmacophores(object, i);
                ((HashSet)arrayList.get(i)).addAll(list2);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        for (HashSet hashSet : arrayList) {
            arrayList2.addAll(hashSet);
        }
        return arrayList2;
    }

    public static List<MolDistHistViz> generateSubPharmacophores(MolDistHistViz molDistHistViz, int n) {
        List<int[]> list = CombinationGenerator.getAllOutOf(molDistHistViz.getNumPPNodes(), n);
        if (list == null) {
            return null;
        }
        HashSet<MolDistHistViz> hashSet = new HashSet<MolDistHistViz>();
        List<MolDistHistVizFrag> list2 = SubFlexophoreGenerator.getSubFragments(molDistHistViz, list);
        for (MolDistHistViz molDistHistViz2 : list2) {
            hashSet.add(molDistHistViz2);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        return arrayList;
    }

    public static List<MolDistHistVizFrag> getSubFragments(MolDistHistViz molDistHistViz, List<int[]> list) {
        ArrayList<MolDistHistVizFrag> arrayList = new ArrayList<MolDistHistVizFrag>(list.size());
        for (int[] nArray : list) {
            boolean bl = true;
            if (molDistHistViz.getNumInevitablePharmacophorePoints() > 0) {
                int n = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (!molDistHistViz.isInevitablePharmacophorePoint(nArray[i])) continue;
                    ++n;
                }
                if (n < molDistHistViz.getNumInevitablePharmacophorePoints()) {
                    bl = false;
                }
            }
            if (!bl) continue;
            MolDistHistVizFrag molDistHistVizFrag = SubFlexophoreGenerator.getSubFragment(molDistHistViz, nArray);
            arrayList.add(molDistHistVizFrag);
        }
        return arrayList;
    }

    public static MolDistHistVizFrag getSubFragment(MolDistHistViz molDistHistViz, int[] nArray) {
        int n;
        MolDistHistVizFrag molDistHistVizFrag = new MolDistHistVizFrag(nArray.length, molDistHistViz.getMolecule());
        for (n = 0; n < nArray.length; ++n) {
            PPNodeViz pPNodeViz = new PPNodeViz(molDistHistViz.getNode(nArray[n]));
            molDistHistVizFrag.addNode(pPNodeViz);
        }
        for (n = 0; n < nArray.length; ++n) {
            for (int i = n + 1; i < nArray.length; ++i) {
                byte[] byArray = molDistHistViz.getDistHist(nArray[n], nArray[i]);
                molDistHistVizFrag.setDistHist(n, i, byArray);
            }
        }
        molDistHistVizFrag.setArrIndexParentNodes(nArray);
        molDistHistVizFrag.realize();
        return molDistHistVizFrag;
    }

    public static List<MolDistHist> generateSubPharmacophores(MolDistHist molDistHist, int n) {
        List<int[]> list = CombinationGenerator.getAllOutOf(molDistHist.getNumPPNodes(), n);
        if (list == null) {
            return null;
        }
        ArrayList<MolDistHist> arrayList = new ArrayList<MolDistHist>();
        for (int[] nArray : list) {
            MolDistHist molDistHist2 = SubFlexophoreGenerator.getSubFragment(molDistHist, nArray);
            arrayList.add(molDistHist2);
        }
        return arrayList;
    }

    public static MolDistHist getSubFragment(MolDistHist molDistHist, int[] nArray) {
        int n;
        MolDistHist molDistHist2 = new MolDistHist(nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            PPNode pPNode = new PPNode(molDistHist.getNode(nArray[n]));
            molDistHist2.addNode(pPNode);
        }
        for (n = 0; n < nArray.length; ++n) {
            for (int i = n + 1; i < nArray.length; ++i) {
                byte[] byArray = molDistHist.getDistHist(nArray[n], nArray[i]);
                molDistHist2.setDistHist(n, i, byArray);
            }
        }
        molDistHist2.realize();
        return molDistHist2;
    }

    public static class ViolatedConditionsCount {
        private long ccMissedMinRange = 0L;
        private long ccViolatedMaxRange = 0L;
        private long ccViolatedMinDiffInteractionTypes = 0L;

        public void add(ViolatedConditionsCount violatedConditionsCount) {
            this.ccMissedMinRange += violatedConditionsCount.ccMissedMinRange;
            this.ccViolatedMaxRange += violatedConditionsCount.ccViolatedMaxRange;
            this.ccViolatedMinDiffInteractionTypes += violatedConditionsCount.ccViolatedMinDiffInteractionTypes;
        }

        public long getCcMissedMinRange() {
            return this.ccMissedMinRange;
        }

        public long getCcViolatedMaxRange() {
            return this.ccViolatedMaxRange;
        }

        public long getCcViolatedMinDiffInteractionTypes() {
            return this.ccViolatedMinDiffInteractionTypes;
        }
    }
}

