/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.generator;

import com.actelion.research.chem.interactionstatistics.InteractionDistanceStatistics;
import com.actelion.research.chem.interactionstatistics.InteractionSimilarityTable;
import com.actelion.research.util.datamodel.IntegerDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class InteractionTypeMap {
    private double threshSimilarity;
    private HashMap<Integer, List<IntegerDouble>> hmAtomType_ListSimilars;
    private InteractionSimilarityTable interactionSimilarityTable;
    private List<Integer> liAtomTypes;

    public InteractionTypeMap(double d) {
        this.threshSimilarity = d;
        this.interactionSimilarityTable = InteractionSimilarityTable.getInstance();
        InteractionDistanceStatistics interactionDistanceStatistics = InteractionDistanceStatistics.getInstance();
        this.liAtomTypes = interactionDistanceStatistics.getAtomTypes();
        this.hmAtomType_ListSimilars = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<IntegerDouble> getSimilars(int n) {
        List<IntegerDouble> list = this.hmAtomType_ListSimilars.get(n);
        if (list != null) return list;
        Class<InteractionTypeMap> clazz = InteractionTypeMap.class;
        synchronized (InteractionTypeMap.class) {
            ArrayList<IntegerDouble> arrayList = new ArrayList<IntegerDouble>(this.liAtomTypes.size());
            for (int n2 : this.liAtomTypes) {
                double d = 1.0 - this.interactionSimilarityTable.getDistance(n, n2);
                if (!(d >= this.threshSimilarity)) continue;
                arrayList.add(new IntegerDouble(n2, d));
            }
            Collections.sort(arrayList, IntegerDouble.getComparatorDouble());
            Collections.reverse(arrayList);
            this.hmAtomType_ListSimilars.put(n, arrayList);
            return arrayList;
        }
    }
}

