/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.chem.descriptor.flexophore.ConstantsFlexophoreHardPPPoints;
import com.actelion.research.chem.descriptor.flexophore.IPPNode;
import com.actelion.research.chem.descriptor.flexophore.generator.ConstantsFlexophoreGenerator;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class PPNode
implements Comparable<PPNode>,
IPPNode {
    public static final int NUM_BYTES_INTERACTION_TYPE = 3;
    private static final int BYTES_FREQUENCY_INTERACTION = 1;
    public static final int DUMMY_INTERACT_ID = 37;
    public static final String SEPARATOR_ATOMS = ",";
    public static final String MULT_FREQ = "*";
    public static final int INFO_DEFAULT = -1;
    private static final int MASK1 = 255;
    private static final int BUFFER_SIZE = 3 * PPNode.getNumBytesEntry();
    private byte[] arrInteractionType;
    private byte size;
    transient boolean heteroAtom;
    transient byte modeFlexophore;

    public PPNode() {
        this.init();
    }

    public PPNode(PPNode pPNode) {
        this.copy(pPNode);
    }

    public void add(int n) {
        if (n >= ConstantsFlexophoreGenerator.MAX_VAL_INTERACTION_TYPE) {
            throw new RuntimeException("Interaction type " + n + " larger than " + ConstantsFlexophoreGenerator.MAX_VAL_INTERACTION_TYPE + ".");
        }
        boolean bl = false;
        for (byte by = 0; by < this.size; by = (byte)(by + 1)) {
            int n2 = this.getInteractionType(by);
            if (n != n2) continue;
            this.incrementAtomTypeCount(by);
            bl = true;
            break;
        }
        if (!bl) {
            this.initInteractionType(n);
        }
    }

    public void addAtoms(PPNode pPNode) {
        for (int i = 0; i < pPNode.getInteractionTypeCount(); ++i) {
            if (this.containsInteractionID(pPNode.getInteractionType(i))) continue;
            this.add(pPNode.getInteractionType(i));
        }
    }

    @Override
    public int compareTo(PPNode pPNode) {
        int n;
        int n2 = 0;
        int n3 = this.getInteractionTypeCount();
        int n4 = pPNode.getInteractionTypeCount();
        int n5 = PPNode.getMaximumInteractionType(this);
        if (n5 > (n = PPNode.getMaximumInteractionType(pPNode))) {
            n2 = 1;
        } else if (n5 < n) {
            n2 = -1;
        } else if (n3 > n4) {
            n2 = 1;
        } else if (n3 < n4) {
            n2 = -1;
        } else {
            for (int i = 0; i < n3; ++i) {
                int n6;
                int n7 = this.getInteractionType(i);
                if (n7 > (n6 = pPNode.getInteractionType(i))) {
                    n2 = 1;
                    continue;
                }
                if (n7 >= n6) continue;
                n2 = -1;
            }
        }
        return n2;
    }

    public boolean containsInteractionID(int n) {
        boolean bl = false;
        if (this.arrInteractionType == null) {
            return bl;
        }
        int n2 = this.getInteractionTypeCount();
        for (int i = 0; i < n2; ++i) {
            if (this.getInteractionType(i) != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void copy(PPNode pPNode) {
        this.arrInteractionType = new byte[pPNode.arrInteractionType.length];
        System.arraycopy(pPNode.arrInteractionType, 0, this.arrInteractionType, 0, pPNode.arrInteractionType.length);
        this.size = pPNode.size;
        this.modeFlexophore = pPNode.modeFlexophore;
    }

    public PPNode getCopy() {
        return new PPNode(this);
    }

    public boolean equals(Object object) {
        PPNode pPNode = (PPNode)object;
        return this.equalAtoms(pPNode);
    }

    public void realize() {
        int n = this.size * PPNode.getNumBytesEntry();
        this.arrInteractionType = ArrayUtilsCalc.resize(this.arrInteractionType, n);
        this.sortInteractionTypes();
        this.calcHasHeteroAtom();
    }

    public boolean equalAtoms(PPNode pPNode) {
        int n;
        boolean bl = true;
        int n2 = this.getInteractionTypeCount();
        if (n2 != (n = pPNode.getInteractionTypeCount())) {
            bl = false;
        } else {
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4 = this.getInteractionType(i);
                if (n4 == (n3 = pPNode.getInteractionType(i))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public byte[] get() {
        return this.arrInteractionType;
    }

    @Override
    public int getInteractionTypeCount() {
        return this.size;
    }

    @Override
    public int getInteractionType(int n) {
        int n2 = this.getIndexInteractionTypeInArray(n);
        return PPNode.getInteractionTypeFromByteArray(this.arrInteractionType[n2], this.arrInteractionType[n2 + 1], this.arrInteractionType[n2 + 2]);
    }

    private int getIndexInteractionTypeInArray(int n) {
        return n * PPNode.getNumBytesEntry();
    }

    private int incrementAtomTypeCount(int n) {
        int n2 = this.getIndexInteractionTypeInArray(n);
        int n3 = n2 + 3;
        this.arrInteractionType[n3] = (byte)(this.arrInteractionType[n3] + 1);
        return this.arrInteractionType[n2 + 3];
    }

    protected static int getInteractionTypeFromByteArray(byte by, byte by2, byte by3) {
        int n = (by3 & 0xFF) << 16;
        n |= (by2 & 0xFF) << 8;
        return n |= by & 0xFF;
    }

    InterActionTypeFreq getInteraction(int n) {
        int n2 = this.getIndexInteractionTypeInArray(n);
        InterActionTypeFreq interActionTypeFreq = new InterActionTypeFreq(this.getInteractionType(n), this.arrInteractionType[n2 + 3]);
        return interActionTypeFreq;
    }

    public int getAtomicNo(int n) {
        return InteractionAtomTypeCalculator.getAtomicNumber(this.getInteractionType(n));
    }

    public boolean isAromatic(int n) {
        return InteractionAtomTypeCalculator.isAromatic(this.getInteractionType(n));
    }

    public static int getAtomicNoFromInteractionType(int n) {
        return InteractionAtomTypeCalculator.getAtomicNumber(n);
    }

    public static PPNode getDummy() {
        PPNode pPNode = new PPNode();
        pPNode.add(37);
        return pPNode;
    }

    @Override
    public boolean hasHeteroAtom() {
        return this.heteroAtom;
    }

    private void calcHasHeteroAtom() {
        this.heteroAtom = false;
        int n = this.getInteractionTypeCount();
        for (int i = 0; i < n; ++i) {
            if (this.getAtomicNo(i) == 6) continue;
            this.heteroAtom = true;
            break;
        }
    }

    public boolean isCarbonExclusiveNode() {
        boolean bl = true;
        int n = this.getInteractionTypeCount();
        for (int i = 0; i < n; ++i) {
            if (this.getAtomicNo(i) == 6) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean containsHetero() {
        return this.heteroAtom;
    }

    private void init() {
        this.arrInteractionType = new byte[BUFFER_SIZE];
        this.modeFlexophore = 0;
    }

    public void set(byte[] byArray, byte by) {
        this.arrInteractionType = byArray;
        this.size = by;
    }

    public byte getModeFlexophore() {
        return this.modeFlexophore;
    }

    public void setModeFlexophore(byte by) {
        this.modeFlexophore = by;
    }

    private void initInteractionType(int n) {
        if (n > ConstantsFlexophoreGenerator.MAX_VAL_INTERACTION_TYPE) {
            throw new RuntimeException("Interaction type to large for PPNode!");
        }
        int n2 = this.getIndexInteractionTypeInArray(this.size);
        this.setInterActionType(n, n2, (byte)1);
        this.size = (byte)(this.size + 1);
        int n3 = this.size * PPNode.getNumBytesEntry();
        if (n3 == this.arrInteractionType.length) {
            this.arrInteractionType = ArrayUtilsCalc.resize(this.arrInteractionType, this.arrInteractionType.length + BUFFER_SIZE);
        }
    }

    private void setInterActionType(int n, int n2, byte by) {
        byte by2 = (byte)(n & 0xFF);
        byte by3 = (byte)(n >> 8);
        byte by4 = (byte)(n >> 16);
        this.arrInteractionType[n2] = by2;
        this.arrInteractionType[n2 + 1] = by3;
        this.arrInteractionType[n2 + 2] = by4;
        this.arrInteractionType[n2 + 3] = by;
    }

    public void sortInteractionTypes() {
        ArrayList<InterActionTypeFreq> arrayList = new ArrayList<InterActionTypeFreq>();
        for (byte by = 0; by < this.size; by = (byte)(by + 1)) {
            arrayList.add(this.getInteraction(by));
        }
        Comparator<InterActionTypeFreq> comparator = new Comparator<InterActionTypeFreq>(){

            @Override
            public int compare(InterActionTypeFreq interActionTypeFreq, InterActionTypeFreq interActionTypeFreq2) {
                int n = 0;
                if (interActionTypeFreq.interactionType > interActionTypeFreq2.interactionType) {
                    n = 1;
                } else if (interActionTypeFreq.interactionType < interActionTypeFreq2.interactionType) {
                    n = -1;
                }
                return n;
            }
        };
        Collections.sort(arrayList, comparator);
        for (int i = 0; i < arrayList.size(); ++i) {
            InterActionTypeFreq interActionTypeFreq = (InterActionTypeFreq)arrayList.get(i);
            int n = this.getIndexInteractionTypeInArray(i);
            this.setInterActionType(interActionTypeFreq.interactionType, n, interActionTypeFreq.frequency);
        }
    }

    public double getFractionCarbonInteractions() {
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < this.getInteractionTypeCount(); ++i) {
            InterActionTypeFreq interActionTypeFreq = this.getInteraction(i);
            int n2 = interActionTypeFreq.interactionType;
            if (InteractionAtomTypeCalculator.isCarbonInteraction(n2)) {
                n += interActionTypeFreq.frequency;
            }
            d += (double)interActionTypeFreq.frequency;
        }
        double d2 = (double)n / d;
        return d2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        int n = this.getInteractionTypeCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(SEPARATOR_ATOMS);
            }
            InterActionTypeFreq interActionTypeFreq = this.getInteraction(i);
            stringBuilder.append(interActionTypeFreq.interactionType);
            if (interActionTypeFreq.frequency <= 1) continue;
            stringBuilder.append(MULT_FREQ);
            stringBuilder.append(interActionTypeFreq.frequency);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static PPNode getHeteroOnlyNode(PPNode pPNode) {
        PPNode pPNode2 = new PPNode();
        int n = pPNode.getInteractionTypeCount();
        for (int i = 0; i < n; ++i) {
            int n2 = pPNode.getInteractionType(i);
            if (InteractionAtomTypeCalculator.getAtomicNumber(n2) == 6) continue;
            pPNode2.add(n2);
        }
        pPNode2.realize();
        return pPNode2;
    }

    public String toStringText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuilder.append(SEPARATOR_ATOMS);
            }
            InterActionTypeFreq interActionTypeFreq = this.getInteraction(i);
            String string = InteractionAtomTypeCalculator.getString(interActionTypeFreq.interactionType);
            stringBuilder.append(string);
            if (interActionTypeFreq.frequency <= 1) continue;
            stringBuilder.append(MULT_FREQ);
            stringBuilder.append(interActionTypeFreq.frequency);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toStringElusive() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuilder.append(SEPARATOR_ATOMS);
            }
            InterActionTypeFreq interActionTypeFreq = this.getInteraction(i);
            String string = InteractionAtomTypeCalculator.getString(interActionTypeFreq.interactionType);
            stringBuilder.append(interActionTypeFreq.interactionType);
            stringBuilder.append(":");
            stringBuilder.append(string);
            if (interActionTypeFreq.frequency <= 1) continue;
            stringBuilder.append(MULT_FREQ);
            stringBuilder.append(interActionTypeFreq.frequency);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toStringLongHardPPPoint() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuilder.append(SEPARATOR_ATOMS);
            }
            InterActionTypeFreq interActionTypeFreq = this.getInteraction(i);
            String string = ConstantsFlexophoreHardPPPoints.toStringPPPoints(interActionTypeFreq.interactionType);
            stringBuilder.append(string);
            if (interActionTypeFreq.frequency <= 1) continue;
            stringBuilder.append(MULT_FREQ);
            stringBuilder.append(interActionTypeFreq.frequency);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static PPNode read(String string) {
        String[] stringArray = string.split(SEPARATOR_ATOMS);
        PPNode pPNode = new PPNode();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.contains(MULT_FREQ)) {
                String[] stringArray2 = string2.split("\\*");
                int n = Integer.parseInt(stringArray2[0]);
                int n2 = Integer.parseInt(stringArray2[1]);
                for (int j = 0; j < n2; ++j) {
                    pPNode.add(n);
                }
                continue;
            }
            int n = Integer.parseInt(string2);
            pPNode.add(n);
        }
        pPNode.realize();
        return pPNode;
    }

    private static int getMaximumInteractionType(PPNode pPNode) {
        int n = 0;
        int n2 = pPNode.getInteractionTypeCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = pPNode.getInteractionType(i);
            if (n3 >= n) continue;
            n = n3;
        }
        return n;
    }

    public static int getNumBytesEntry() {
        return 4;
    }

    private static class InterActionTypeFreq {
        int interactionType;
        byte frequency;

        public InterActionTypeFreq(int n, byte by) {
            this.interactionType = n;
            this.frequency = by;
        }

        public String toString() {
            return "InterActionTypeFreq{interactionType=" + this.interactionType + ", frequency=" + this.frequency + '}';
        }
    }
}

