/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.chem.descriptor.flexophore.DistHist;
import com.actelion.research.chem.descriptor.flexophore.IMolDistHist;
import com.actelion.research.chem.descriptor.flexophore.PPNode;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import com.actelion.research.util.StringFunctions;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MolDistHist
extends DistHist
implements Serializable,
IMolDistHist {
    private static final long serialVersionUID = 5042020L;
    public static final boolean VERBOSE = false;
    private static final int SIZE_BUFFER = 16 * MolDistHist.getNumBytesEntry();
    private byte[] arrNode;
    private int posNode;
    private boolean finalized;
    private byte modeFlexophore;
    private int[][] nodeAtoms;

    public MolDistHist() {
        this.initHistogramArray(0);
        this.init();
    }

    public MolDistHist(int n) {
        this.initHistogramArray(n);
        this.init();
    }

    public MolDistHist(MolDistHist molDistHist) {
        this.initHistogramArray(molDistHist.getNumPPNodes());
        this.init();
        molDistHist.copy(this);
    }

    public MolDistHist copy() {
        MolDistHist molDistHist = new MolDistHist();
        this.copy(molDistHist);
        return molDistHist;
    }

    private void init() {
        this.modeFlexophore = 0;
    }

    public boolean check() {
        boolean bl = true;
        int n = this.getNumPPNodes();
        for (int i = 0; i < n; ++i) {
            PPNode pPNode = this.getNode(i);
            int n2 = pPNode.getInteractionTypeCount();
            for (int j = 0; j < n2; ++j) {
                int n3 = pPNode.getInteractionType(j);
                String string = InteractionAtomTypeCalculator.getString(n3);
                if (string.length() != 0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void copy(MolDistHist molDistHist) {
        super.copy(molDistHist);
        molDistHist.arrNode = new byte[this.arrNode.length];
        System.arraycopy(this.arrNode, 0, molDistHist.arrNode, 0, this.arrNode.length);
        molDistHist.posNode = this.posNode;
        molDistHist.modeFlexophore = this.modeFlexophore;
        molDistHist.realize();
    }

    public boolean equals(Object object) {
        Object object2;
        int n;
        boolean bl = true;
        MolDistHist molDistHist = null;
        try {
            molDistHist = (MolDistHist)object;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        if (this.getNumPPNodes() != molDistHist.getNumPPNodes()) {
            return false;
        }
        for (n = 0; n < this.getNumPPNodes(); ++n) {
            PPNode pPNode = this.getNode(n);
            if (pPNode.equals(object2 = molDistHist.getNode(n))) continue;
            bl = false;
            break;
        }
        for (n = 0; n < this.getNumPPNodes(); ++n) {
            block4: for (int i = n + 1; i < this.getNumPPNodes(); ++i) {
                object2 = this.getDistHist(n, i);
                byte[] byArray = molDistHist.getDistHist(n, i);
                for (int j = 0; j < byArray.length; ++j) {
                    if (object2[j] == byArray[j]) continue;
                    bl = false;
                    continue block4;
                }
            }
        }
        return bl;
    }

    public byte getModeFlexophore() {
        return this.modeFlexophore;
    }

    @Override
    protected void initHistogramArray(int n) {
        super.initHistogramArray(n);
        this.arrNode = new byte[n * (PPNode.getNumBytesEntry() + 1)];
        this.finalized = false;
    }

    public void addNode(PPNode pPNode) {
        byte[] byArray = pPNode.get();
        byte by = (byte)pPNode.getInteractionTypeCount();
        int n = this.posNode + byArray.length + 1;
        if (this.arrNode.length < n) {
            int n2 = SIZE_BUFFER;
            while (this.arrNode.length + n2 < n) {
                n2 *= 2;
            }
            this.resizeNodeArray(this.arrNode.length + n2);
        }
        this.arrNode[this.posNode++] = by;
        System.arraycopy(byArray, 0, this.arrNode, this.posNode, byArray.length);
        this.posNode += byArray.length;
        this.finalized = false;
    }

    protected byte[] getArrNode() {
        return this.arrNode;
    }

    protected void setArrNode(byte[] byArray) {
        this.arrNode = byArray;
        int n = 0;
        while (byArray[n] > 0 && (n += byArray[n] * 3 + 1) < byArray.length) {
        }
    }

    public void realize() {
        int n = this.getNumPPNodes();
        if (n == 0) {
            throw new RuntimeException("No pharmacophore points in Flexophore.");
        }
        int n2 = this.getPositionNode(n - 1);
        int n3 = n2 + this.arrNode[n2] * PPNode.getNumBytesEntry() + 1;
        this.resizeNodeArray(n3);
        if (this.getNumPPNodes() == 0) {
            return;
        }
        this.finalized = true;
    }

    private void resizeNodeArray(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.arrNode, 0, byArray, 0, Math.min(this.arrNode.length, n));
        this.arrNode = byArray;
        this.finalized = false;
    }

    public int getConnAtom(int n, int n2) {
        if (n2 >= n) {
            ++n2;
        }
        return n2;
    }

    public int[][] getNodeAtoms() {
        return this.nodeAtoms;
    }

    public void setNodeAtoms(int[][] nArray) {
        this.nodeAtoms = nArray;
    }

    public int hashCode() {
        String string = this.toString();
        string = string.replace(" ", "");
        return string.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.toStringNodes());
        stringBuilder.append(this.toStringHists());
        return stringBuilder.toString();
    }

    public String toStringNodes() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            stringBuilder.append(this.getNode(i).toString());
            if (i < this.getNumPPNodes() - 1) {
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public String toStringNodesElusive() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            stringBuilder.append(this.getNode(i).toStringElusive());
            if (i < this.getNumPPNodes() - 1) {
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public String toStringNodesLineWise() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            stringBuilder.append(this.getNode(i).toString());
            if (i >= this.getNumPPNodes() - 1) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String toStringNodesElusiveLineWise() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            stringBuilder.append(this.getNode(i).toStringElusive());
            if (i >= this.getNumPPNodes() - 1) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String toStringHists() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            for (int j = i + 1; j < this.getNumPPNodes(); ++j) {
                byte[] byArray = this.getDistHist(i, j);
                if (byArray == null) continue;
                stringBuilder.append(ArrayUtilsCalc.toString(byArray));
            }
        }
        return stringBuilder.toString();
    }

    protected boolean isFinalized() {
        return this.finalized;
    }

    private int getPositionNode(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.arrNode[n2] * PPNode.getNumBytesEntry() + 1;
        }
        return n2;
    }

    @Override
    public PPNode getNode(int n) {
        PPNode pPNode = new PPNode();
        int n2 = this.getPositionNode(n);
        int n3 = this.arrNode[n2] * PPNode.getNumBytesEntry();
        byte[] byArray = new byte[n3];
        System.arraycopy(this.arrNode, n2 + 1, byArray, 0, n3);
        pPNode.set(byArray, this.arrNode[n2]);
        pPNode.realize();
        return pPNode;
    }

    public int getPPPoints(int n) {
        int n2 = this.getPositionNode(n);
        byte by = this.arrNode[n2];
        return by;
    }

    @Override
    public int getSizeBytes() {
        int n = super.getSizeBytes();
        n += this.arrNode.length;
        return n += 4;
    }

    @Override
    public int getNumInevitablePharmacophorePoints() {
        return 0;
    }

    @Override
    public boolean isInevitablePharmacophorePoint(int n) {
        return false;
    }

    public static int getNumBytesEntry() {
        return PPNode.getNumBytesEntry() + 1;
    }

    public static List<PPNode> readNodes(String string) {
        int n = string.indexOf(40);
        boolean bl = false;
        ArrayList<PPNode> arrayList = new ArrayList<PPNode>();
        while (!bl) {
            int n2 = StringFunctions.nextClosing(string, n, '(', ')');
            if (n2 == -1) {
                throw new RuntimeException("Error for MolDistHist " + string);
            }
            String string2 = string.substring(n + 1, n2);
            PPNode pPNode = PPNode.read(string2);
            arrayList.add(pPNode);
            n = string.indexOf(40, n2);
            if (n != -1) continue;
            bl = true;
        }
        return arrayList;
    }

    public static MolDistHist read(String string) {
        int n;
        String string2 = "[0-9]+";
        List<PPNode> list = MolDistHist.readNodes(string);
        int n2 = list.size();
        MolDistHist molDistHist = new MolDistHist(n2);
        for (PPNode object2 : list) {
            molDistHist.addNode(object2);
        }
        boolean bl = false;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n3 = string.indexOf("][");
        int n4 = (n2 * n2 - n2) / 2;
        if (n4 == 0) {
            bl = true;
        }
        while (!bl) {
            n = StringFunctions.nextClosing(string, n3, '[', ']');
            String i = string.substring(n3, n);
            List<Point> j = StringFunctions.match(i, string2);
            if (j.size() != 80) {
                throw new RuntimeException("Error in histogram.");
            }
            byte[] byArray = new byte[80];
            int n5 = 0;
            for (Point point : j) {
                String string3 = i.substring(point.x, point.y);
                byArray[n5++] = (byte)(Integer.parseInt(string3) & 0xFF);
            }
            arrayList.add(byArray);
            n3 = string.indexOf(91, n);
            if (arrayList.size() != n4) continue;
            bl = true;
        }
        n = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                molDistHist.setDistHist(i, j, (byte[])arrayList.get(n++));
            }
        }
        return molDistHist;
    }
}

