/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistViz;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class MDHFeature
implements Comparable<MDHFeature> {
    private static final NumberFormat NF = new DecimalFormat("0.0000");
    private int index;
    private int counter1;
    private int counter2;
    public MolDistHistViz mdhvFeature;
    private HashSet<Integer> hsMatchingIndex1;
    private HashSet<Integer> hsMatchingIndex2;

    public MDHFeature(MolDistHistViz molDistHistViz, int n) {
        this.init();
        this.mdhvFeature = molDistHistViz;
        this.index = n;
    }

    public MDHFeature(MolDistHistViz molDistHistViz) {
        this.init();
        this.mdhvFeature = molDistHistViz;
    }

    private void init() {
        this.hsMatchingIndex1 = new HashSet();
        this.hsMatchingIndex2 = new HashSet();
    }

    @Override
    public int compareTo(MDHFeature mDHFeature) {
        if (this.counter1 > mDHFeature.counter1) {
            return 1;
        }
        if (this.counter1 < mDHFeature.counter1) {
            return -1;
        }
        return 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCounter1() {
        return this.counter1;
    }

    public int getCounter2() {
        return this.counter2;
    }

    public MolDistHistViz getMdhvFeature() {
        return this.mdhvFeature;
    }

    public void increaseClass1(int n) {
        ++this.counter1;
        if (!this.hsMatchingIndex1.add(n)) {
            throw new RuntimeException("Index " + n + " is already in active list.");
        }
    }

    public void increaseClass2(int n) {
        ++this.counter2;
        if (!this.hsMatchingIndex2.add(n)) {
            throw new RuntimeException("Index " + n + " is already in inactive list.");
        }
    }

    public double getRatioClass1Class2() {
        if (this.counter2 == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)this.counter1 / (double)this.counter2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.index);
        double d = -1.0;
        d = this.counter1 == 0 && this.counter2 == 0 ? -1.0 : (this.counter2 == 0 ? (double)this.counter1 : this.getRatioClass1Class2());
        stringBuilder.append(" risk\t" + this.counter1 + ", no risk\t" + this.counter2 + ", ratio\t" + NF.format(d));
        return stringBuilder.toString();
    }

    public String toStringListClass1() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.hsMatchingIndex1);
        Collections.sort(arrayList);
        return ArrayUtilsCalc.toString(arrayList);
    }

    public String toStringListClass2() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.hsMatchingIndex2);
        Collections.sort(arrayList);
        return ArrayUtilsCalc.toString(arrayList);
    }
}

