/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;

public class DescriptorHandlerIntVector<U>
implements DescriptorHandler<int[], U> {
    protected static final int[] FAILED_OBJECT = new int[0];
    private static final double CORRECTION_FACTOR = 0.42;
    private double correctionFactor = 0.42;

    public void setCorrectionFactor(double d) {
        this.correctionFactor = d;
    }

    @Override
    public float getSimilarity(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return Float.NaN;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += Math.max(nArray[i], nArray2[i]);
            n2 += Math.min(nArray[i], nArray2[i]);
        }
        return this.normalizeValue((float)n2 / (float)n);
    }

    private float normalizeValue(double d) {
        return d <= 0.0 ? 0.0f : (d >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(d, this.correctionFactor), 1.0 / this.correctionFactor)));
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_IntegerVector;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_IntegerVector.version;
    }

    @Override
    public String encode(int[] nArray) {
        return this.calculationFailed(nArray) ? "Calculation Failed" : new String(new DescriptorEncoder().encodeIntArray(nArray));
    }

    @Override
    public int[] decode(String string) {
        return string == null ? null : new DescriptorEncoder().decodeIntArray(string);
    }

    @Override
    public int[] decode(byte[] byArray) {
        return byArray == null ? null : new DescriptorEncoder().decodeIntArray(byArray);
    }

    @Override
    public int[] createDescriptor(U u) {
        return (int[])u;
    }

    @Override
    public boolean calculationFailed(int[] nArray) {
        return nArray == null || nArray.length == 0;
    }

    @Override
    public DescriptorHandler<int[], U> getThreadSafeCopy() {
        return this;
    }
}

