/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.reaction.FunctionalGroupClassifier;
import java.util.Arrays;
import java.util.TreeSet;

public class DescriptorHandlerFunctionalGroups
implements DescriptorHandler<int[][], StereoMolecule> {
    private static final double CORRECTION_FACTOR = 0.7;
    private static final int[][] FAILED_OBJECT = new int[][]{{1, 0}};
    private static DescriptorHandlerFunctionalGroups sDefaultInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerFunctionalGroups getDefaultInstance() {
        Class<DescriptorHandlerFunctionalGroups> clazz = DescriptorHandlerFunctionalGroups.class;
        synchronized (DescriptorHandlerFunctionalGroups.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerFunctionalGroups();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public boolean calculationFailed(int[][] nArray) {
        return nArray == null || nArray.length == 1 && nArray[0][1] == 0;
    }

    @Override
    public int[][] createDescriptor(StereoMolecule stereoMolecule) {
        if (stereoMolecule == null) {
            return null;
        }
        FunctionalGroupClassifier functionalGroupClassifier = new FunctionalGroupClassifier(stereoMolecule);
        return functionalGroupClassifier.getOrganicFunctionalGroupCounts();
    }

    @Override
    public int[][] decode(String string) {
        return string == null ? (int[][])null : (string.equals("Calculation Failed") ? FAILED_OBJECT : new DescriptorEncoder().decodePairs(string));
    }

    @Override
    public int[][] decode(byte[] byArray) {
        return byArray == null ? (int[][])null : (Arrays.equals(byArray, FAILED_BYTES) ? FAILED_OBJECT : new DescriptorEncoder().decodePairs(byArray));
    }

    @Override
    public String encode(int[][] nArray) {
        return this.calculationFailed(nArray) ? "Calculation Failed" : new String(new DescriptorEncoder().encodePairs(nArray));
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_OrganicFunctionalGroups;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_OrganicFunctionalGroups.version;
    }

    @Override
    public float getSimilarity(int[][] nArray, int[][] nArray2) {
        Object[] objectArray2;
        if (nArray == null || nArray2 == null) {
            return Float.NaN;
        }
        if (nArray.length == 0 && nArray2.length == 0) {
            return 1.0f;
        }
        if (nArray.length == 0 || nArray2.length == 0) {
            return 0.0f;
        }
        TreeSet<Match> treeSet = new TreeSet<Match>();
        int n = 0;
        int n2 = -1;
        for (Object[] objectArray2 : nArray) {
            n2 = 0;
            for (int[] nArray3 : nArray2) {
                int n3 = FunctionalGroupClassifier.getFunctionalGroupEquivalenceLevel(objectArray2[0], (int)nArray3[0]);
                if (n3 != -1) {
                    for (int i = 0; i < objectArray2[1]; ++i) {
                        for (int j = 0; j < nArray3[1]; ++j) {
                            treeSet.add(new Match(n + i, n2 + j, n3));
                        }
                    }
                }
                n2 += nArray3[1];
            }
            n += objectArray2[1];
        }
        float f = n + n2;
        float f2 = 0.0f;
        boolean[] blArray = new boolean[n];
        objectArray2 = new boolean[n2];
        Object object = treeSet.iterator();
        while (object.hasNext()) {
            Match match = (Match)object.next();
            if (blArray[match.fg1] || objectArray2[match.fg2] != 0) continue;
            float f3 = 1.0f - 0.1f * (float)match.level;
            f2 += f3;
            f -= f3;
            blArray[match.fg1] = true;
            objectArray2[match.fg2] = 1;
        }
        return this.normalizeValue(f2 / f);
    }

    private float normalizeValue(double d) {
        return d <= 0.0 ? 0.0f : (d >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(d, 0.7), 1.4285714285714286)));
    }

    @Override
    public DescriptorHandler<int[][], StereoMolecule> getThreadSafeCopy() {
        return new DescriptorHandlerFunctionalGroups();
    }

    private class Match
    implements Comparable<Match> {
        int fg1;
        int fg2;
        int level;

        Match(int n, int n2, int n3) {
            this.fg1 = n;
            this.fg2 = n2;
            this.level = n3;
        }

        @Override
        public int compareTo(Match match) {
            int n;
            if (this.level != match.level) {
                return this.level < match.level ? -1 : 1;
            }
            int n2 = this.fg1 < this.fg2 ? (this.fg1 << 10) + this.fg2 : (this.fg2 << 10) + this.fg1;
            int n3 = n = match.fg1 < match.fg2 ? (match.fg1 << 10) + match.fg2 : (match.fg2 << 10) + match.fg1;
            return n2 < n ? -1 : (n2 > n ? 1 : 0);
        }
    }
}

