/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf.torsionstrain;

import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.interactionstatistics.SplineFunction;
import com.actelion.research.util.FastSpline;
import com.actelion.research.util.SmoothingSplineInterpolator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StatisticalTorsionPotential {
    private volatile Map<String, SplineFunction> torsionPotentials;
    private final Map<String, int[]> torsionStatistics;
    private static volatile StatisticalTorsionPotential instance;
    private static final String DATABASE_COD = "cod/";
    private static final String DATABASE_CSD = "csd/";
    private static final String TORSION_BINS_FILE = "torsionBins.txt";
    private static final String TORSION_IDS_FILE = "torsionID.txt";
    private static final String BASE_PATH = "/resources/";
    private static String database;
    private List<String> torsionIDs = new ArrayList<String>();
    public static final double OCCURENCE_CUTOFF = 500.0;
    public static final double BIN_SIZE = 5.0;
    public static final double CHI = 1.0E-4;
    public static final double MAX = 10.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatisticalTorsionPotential getInstance() {
        if (instance != null) return instance;
        Class<StatisticalTorsionPotential> clazz = StatisticalTorsionPotential.class;
        synchronized (StatisticalTorsionPotential.class) {
            if (instance != null) return instance;
            instance = new StatisticalTorsionPotential();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private StatisticalTorsionPotential() {
        this.torsionStatistics = new ConcurrentHashMap<String, int[]>();
        TorsionDB.initialize(2);
        if (database == null) {
            InputStream inputStream = TorsionDB.class.getResourceAsStream("/resources/csd/torsionBins.txt");
            database = inputStream != null ? DATABASE_CSD : DATABASE_COD;
        }
        this.initialize();
    }

    private void initialize() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(TorsionDB.class.getResourceAsStream(BASE_PATH + database + TORSION_IDS_FILE)));
        try {
            this.readTorsionIDs(bufferedReader);
            this.initBins();
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
        this.calculatePotentials();
    }

    private synchronized void calculatePotentials() {
        this.splineCalculation();
    }

    private void readTorsionIDs(BufferedReader bufferedReader) throws IOException {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null && string.length() != 0) {
                String string2 = string.trim();
                this.torsionIDs.add(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void initBins() {
        for (String string : this.torsionIDs) {
            byte[] byArray = TorsionDB.getTorsionBinCounts(string);
            int[] nArray = new int[byArray.length];
            IntStream.range(0, nArray.length).forEach(n -> {
                nArray[n] = byArray[n];
            });
            this.torsionStatistics.putIfAbsent(string, nArray);
        }
    }

    public SplineFunction getFunction(String string) {
        return this.torsionPotentials.get(string);
    }

    private void splineCalculation() {
        this.torsionPotentials = new HashMap<String, SplineFunction>();
        double[] dArray = new double[72];
        this.torsionStatistics.entrySet().stream().forEach(entry -> {
            SplineFunction splineFunction = new SplineFunction();
            splineFunction.setOccurencesArray((int[])entry.getValue());
            this.torsionPotentials.putIfAbsent((String)entry.getKey(), splineFunction);
        });
        Map<String, double[]> map = this.torsionStatistics.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> this.normalization((int[])entry.getValue())));
        AtomicInteger atomicInteger = new AtomicInteger(0);
        map.entrySet().stream().forEach(entry -> {
            atomicInteger.getAndIncrement();
            IntStream.range(0, ((double[])entry.getValue()).length).forEach(n -> {
                int n2 = n;
                dArray[n2] = dArray[n2] + ((double[])entry.getValue())[n];
            });
        });
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] / (double)atomicInteger.get();
        }
        map.replaceAll((string, dArray2) -> this.normalize((double[])dArray2, dArray));
        double[] dArray3 = new double[dArray.length];
        IntStream.range(0, dArray3.length).forEach(n -> {
            dArray[n] = ((double)n + 0.5) * 5.0;
        });
        for (String string2 : map.keySet()) {
            double[] dArray4 = new double[dArray3.length];
            Arrays.fill(dArray4, 1.0);
            SmoothingSplineInterpolator smoothingSplineInterpolator = new SmoothingSplineInterpolator();
            smoothingSplineInterpolator.setLambda(0.005);
            smoothingSplineInterpolator.setSigma(dArray4);
            FastSpline fastSpline = smoothingSplineInterpolator.interpolate(dArray3, map.get(string2));
            double[] dArray5 = new double[dArray3.length];
            for (int i = 0; i < dArray3.length; ++i) {
                try {
                    dArray5[i] = fastSpline.value(dArray3[i]);
                    continue;
                }
                catch (Exception exception) {
                    dArray5[i] = 0.0;
                }
            }
            SplineFunction splineFunction = this.torsionPotentials.get(string2);
            splineFunction.setSplineFunction(fastSpline);
            splineFunction.setDiscreteFunction(map.get(string2));
        }
    }

    private double[] normalize(double[] dArray, double[] dArray2) {
        IntStream.range(0, dArray.length).forEach(n -> {
            dArray[n] = -Math.log((dArray[n] + 1.0E-4) / (dArray2[n] + 1.0E-4));
        });
        return dArray;
    }

    private double[] normalization(int[] nArray) {
        int n;
        double[] dArray = new double[nArray.length];
        double d = 0.0;
        for (n = 0; n < nArray.length; ++n) {
            d += (double)nArray[n];
        }
        if (d == 0.0) {
            return dArray;
        }
        for (n = 0; n < nArray.length; ++n) {
            dArray[n] = (double)nArray[n] / d;
        }
        return dArray;
    }

    public SplineFunction getFunction(long l) {
        return this.torsionPotentials.get(l);
    }
}

