/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.BondLengthSet;
import com.actelion.research.chem.conf.TorsionDB;

public class AtomAssembler {
    private StereoMolecule mMol;

    public AtomAssembler(StereoMolecule stereoMolecule) {
        this.mMol = stereoMolecule;
    }

    public int addImplicitHydrogens() {
        this.mMol.ensureHelperArrays(7);
        int n = 0;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            n += this.addImplicitHydrogens(i);
        }
        return n;
    }

    public int addImplicitHydrogens(int n) {
        Coordinates coordinates;
        int n2;
        int n3;
        if (this.mMol.getAtomicNo(n) == 0) {
            return 0;
        }
        int n4 = this.mMol.getImplicitHydrogens(n);
        if (n4 == 0) {
            return 0;
        }
        if (this.mMol.getConnAtoms(n) == 0) {
            return this.addHydrogensToSingleAtom(n, n4);
        }
        int n5 = this.mMol.getAtomPi(n);
        int n6 = n5 == 2 ? 1 : (n5 == 1 || this.mMol.getAtomicNo(n) == 5 || this.mMol.isFlatNitrogen(n) ? 2 : 3);
        Coordinates coordinates2 = this.mMol.getCoordinates(n);
        double d = BondLengthSet.getBondLength(BondLengthSet.getBondIndex(1, false, false, this.mMol.getAtomicNo(n), 1, n5, 0));
        if (n6 == 1) {
            Coordinates coordinates3 = this.mMol.getCoordinates(this.mMol.getConnAtom(n, 0));
            Coordinates coordinates4 = coordinates2.addC(coordinates2.subC(coordinates3).unit().scale(d));
            int n7 = this.mMol.addAtom(1);
            this.mMol.setAtomX(n7, coordinates4.x);
            this.mMol.setAtomY(n7, coordinates4.y);
            this.mMol.setAtomZ(n7, coordinates4.z);
            this.mMol.addBond(n, n7, 1);
            return 1;
        }
        int[] nArray = new int[4];
        nArray[2] = n;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            nArray[1] = this.mMol.getConnAtom(n, i);
            for (n3 = 0; n3 < this.mMol.getConnAtoms(nArray[1]); ++n3) {
                int n8;
                int n9;
                double d2;
                nArray[0] = this.mMol.getConnAtom(nArray[1], n3);
                if (nArray[0] == nArray[2]) continue;
                if (this.mMol.getConnAtoms(nArray[2]) == 3) {
                    nArray[3] = -1;
                    double d3 = TorsionDB.calculateTorsionExtended(this.mMol, nArray);
                    this.addAtomWithConstraints(this.mMol.getCoordinates(nArray[0]), this.mMol.getCoordinates(nArray[1]), this.mMol.getCoordinates(nArray[2]), n, 1, 1.902408884673819, d3, d);
                    return 1;
                }
                double d4 = d2 = n6 == 2 ? 2.0943951023931953 : 1.902408884673819;
                if (this.mMol.getConnAtoms(nArray[2]) == 2) {
                    for (n9 = 0; n9 < this.mMol.getConnAtoms(nArray[2]); ++n9) {
                        nArray[3] = this.mMol.getConnAtom(nArray[2], n9);
                        if (nArray[3] == nArray[1]) continue;
                        double d5 = TorsionDB.calculateTorsionExtended(this.mMol, nArray);
                        if ((d5 += n6 == 2 ? Math.PI : 2.0943951023931953) > Math.PI) {
                            d5 -= Math.PI * 2;
                        }
                        this.addAtomWithConstraints(this.mMol.getCoordinates(nArray[0]), this.mMol.getCoordinates(nArray[1]), this.mMol.getCoordinates(nArray[2]), n, 1, d2, d5, d);
                        if (n4 != 1) {
                            if ((d5 += 2.0943951023931953) > Math.PI) {
                                d5 -= Math.PI * 2;
                            }
                            this.addAtomWithConstraints(this.mMol.getCoordinates(nArray[0]), this.mMol.getCoordinates(nArray[1]), this.mMol.getCoordinates(nArray[2]), n, 1, d2, d5, d);
                        }
                        return n4;
                    }
                }
                for (n9 = n3 + 1; n9 < this.mMol.getConnAtoms(nArray[1]); ++n9) {
                    n8 = this.mMol.getConnAtom(nArray[1], n9);
                    if (n8 == nArray[2] || this.mMol.getConnBondOrder(nArray[1], n9) != 1) continue;
                    nArray[0] = n8;
                    break;
                }
                n8 = (n9 = this.mMol.getAtomPi(nArray[1])) == 2 ? 1 : (n9 == 1 || this.mMol.getAtomicNo(nArray[1]) == 5 || this.mMol.isFlatNitrogen(nArray[1]) ? 2 : 3);
                double d6 = n8 == 2 ? -2.6179938779914944 : -Math.PI;
                for (int j = 0; j < n4; ++j) {
                    this.addAtomWithConstraints(this.mMol.getCoordinates(nArray[0]), this.mMol.getCoordinates(nArray[1]), this.mMol.getCoordinates(nArray[2]), n, 1, d2, d6, d);
                    d6 += n6 == 2 ? Math.PI : 2.0943951023931953;
                }
                return n4;
            }
        }
        if (n4 == 1 && n6 == this.mMol.getConnAtoms(n)) {
            Coordinates coordinates5 = new Coordinates();
            for (n3 = 0; n3 < this.mMol.getConnAtoms(n); ++n3) {
                coordinates5.add(coordinates2.subC(this.mMol.getCoordinates(this.mMol.getConnAtom(n, n3))).unit());
            }
            coordinates5.unit();
            n3 = this.mMol.addAtom(1);
            this.mMol.addBond(n, n3, 1);
            this.mMol.setAtomX(n3, coordinates2.x + d * coordinates5.x);
            this.mMol.setAtomY(n3, coordinates2.y + d * coordinates5.y);
            this.mMol.setAtomZ(n3, coordinates2.z + d * coordinates5.z);
            return 1;
        }
        double d7 = n6 == 2 ? 2.0943951023931953 : 1.911135530933791;
        double d8 = n6 == 2 ? Math.PI : 2.0943951023931953;
        int n10 = this.mMol.getConnAtom(n, 0);
        Coordinates coordinates6 = coordinates2.subC(this.mMol.getCoordinates(n10));
        boolean bl = coordinates6.z != 0.0 && (Math.abs(coordinates6.x) + Math.abs(coordinates6.y)) / Math.abs(coordinates6.z) < 0.01;
        boolean bl2 = false;
        if (bl) {
            if (coordinates6.z < 0.0) {
                bl2 = true;
            }
        } else if (coordinates6.x == 0.0) {
            if (coordinates6.y < 0.0) {
                bl2 = true;
            }
        } else if (coordinates6.x < 0.0) {
            bl2 = true;
        }
        double d9 = 0.0;
        if (this.mMol.getConnAtoms(n) == 2) {
            n2 = this.mMol.getConnAtom(n, 1);
            if (bl) {
                n10 = n2;
                n2 = this.mMol.getConnAtom(n, 0);
                coordinates6 = coordinates2.subC(this.mMol.getCoordinates(n10));
                bl = false;
            }
            coordinates = new Coordinates(this.mMol.getCoordinates(n10));
            coordinates.add(0.0, 0.0, 1.0);
            d9 = this.calculateDihedral(coordinates, this.mMol.getCoordinates(n10), this.mMol.getCoordinates(n), this.mMol.getCoordinates(n2));
            d9 += d8;
        }
        if (bl) {
            double d10 = -Math.cos(d7) * d;
            if (bl2) {
                d9 += Math.PI;
                d10 = -d10;
            }
            double d11 = d * Math.sin(Math.PI - d7);
            for (int i = 0; i < n4; ++i) {
                int n11 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n11, 1);
                this.mMol.setAtomX(n11, coordinates2.x + d11 * Math.sin(d9));
                this.mMol.setAtomY(n11, coordinates2.y + d11 * Math.cos(d9));
                this.mMol.setAtomZ(n11, coordinates2.z + d10);
                d9 += d8;
            }
            return n4;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            coordinates = new Coordinates(this.mMol.getCoordinates(n10));
            coordinates.add(0.0, 0.0, bl2 ? -1.0 : 1.0);
            Coordinates coordinates7 = this.mMol.getCoordinates(n10);
            Coordinates coordinates8 = this.mMol.getCoordinates(n);
            this.addAtomWithConstraints(coordinates, coordinates7, coordinates8, n, 1, d7, d9, d);
            d9 += d8;
        }
        return n4;
    }

    private int addHydrogensToSingleAtom(int n, int n2) {
        Coordinates coordinates = this.mMol.getCoordinates(n);
        double d = BondLengthSet.getBondLength(BondLengthSet.getBondIndex(1, false, false, this.mMol.getAtomicNo(n), 1, 0, 0));
        switch (n2) {
            case 1: {
                int n3 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n3, 1);
                this.mMol.setAtomX(n3, coordinates.x + d);
                this.mMol.setAtomY(n3, coordinates.y);
                this.mMol.setAtomZ(n3, coordinates.z);
                return 1;
            }
            case 2: {
                double d2 = Math.PI / 180 * (this.mMol.getAtomicNo(n) == 8 ? 104.45 : (this.mMol.getAtomicNo(n) == 16 ? 92.1 : 109.5));
                int n4 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n4, 1);
                this.mMol.setAtomX(n4, coordinates.x + d);
                this.mMol.setAtomY(n4, coordinates.y);
                this.mMol.setAtomZ(n4, coordinates.z);
                n4 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n4, 1);
                this.mMol.setAtomX(n4, coordinates.x + d * Math.cos(d2));
                this.mMol.setAtomY(n4, coordinates.y + d * Math.sin(d2));
                this.mMol.setAtomZ(n4, coordinates.z);
                return 2;
            }
            case 3: {
                double d3 = 0.3665191429188092;
                double d4 = d * Math.cos(d3);
                double d5 = d * Math.sin(d3);
                int n5 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n5, 1);
                this.mMol.setAtomX(n5, coordinates.x + d4);
                this.mMol.setAtomY(n5, coordinates.y);
                this.mMol.setAtomZ(n5, coordinates.z - d5);
                n5 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n5, 1);
                this.mMol.setAtomX(n5, coordinates.x - 0.5 * d4);
                this.mMol.setAtomY(n5, coordinates.y + 0.866 * d4);
                this.mMol.setAtomZ(n5, coordinates.z - d5);
                n5 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n5, 1);
                this.mMol.setAtomX(n5, coordinates.x - 0.5 * d4);
                this.mMol.setAtomY(n5, coordinates.y - 0.866 * d4);
                this.mMol.setAtomZ(n5, coordinates.z - d5);
                return 3;
            }
            case 4: {
                double d6 = 0.34033920413889424;
                double d7 = d * Math.cos(d6);
                double d8 = d * Math.sin(d6);
                int n6 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n6, 1);
                this.mMol.setAtomX(n6, coordinates.x - d7);
                this.mMol.setAtomY(n6, coordinates.y);
                this.mMol.setAtomZ(n6, coordinates.z + d8);
                n6 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n6, 1);
                this.mMol.setAtomX(n6, coordinates.x + 0.5 * d7);
                this.mMol.setAtomY(n6, coordinates.y + 0.866 * d7);
                this.mMol.setAtomZ(n6, coordinates.z + d8);
                n6 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n6, 1);
                this.mMol.setAtomX(n6, coordinates.x + 0.5 * d7);
                this.mMol.setAtomY(n6, coordinates.y - 0.866 * d7);
                this.mMol.setAtomZ(n6, coordinates.z + d8);
                n6 = this.mMol.addAtom(1);
                this.mMol.addBond(n, n6, 1);
                this.mMol.setAtomX(n6, coordinates.x);
                this.mMol.setAtomY(n6, coordinates.y);
                this.mMol.setAtomZ(n6, coordinates.z - d);
                return 4;
            }
        }
        return 0;
    }

    private double calculateDihedral(Coordinates coordinates, Coordinates coordinates2, Coordinates coordinates3, Coordinates coordinates4) {
        Coordinates coordinates5 = coordinates2.subC(coordinates);
        Coordinates coordinates6 = coordinates3.subC(coordinates2);
        Coordinates coordinates7 = coordinates4.subC(coordinates3);
        Coordinates coordinates8 = coordinates5.cross(coordinates6);
        Coordinates coordinates9 = coordinates6.cross(coordinates7);
        return -Math.atan2(coordinates6.getLength() * coordinates5.dot(coordinates9), coordinates8.dot(coordinates9));
    }

    private void addAtomWithConstraints(Coordinates coordinates, Coordinates coordinates2, Coordinates coordinates3, int n, int n2, double d, double d2, double d3) {
        double d4 = d3 * Math.sin(Math.PI - d);
        double d5 = -d4 * Math.sin(d2);
        double d6 = d4 * Math.cos(d2);
        double d7 = d3 * Math.cos(Math.PI - d);
        Coordinates coordinates4 = coordinates3.subC(coordinates2).unit();
        Coordinates coordinates5 = coordinates.subC(coordinates2).cross(coordinates4).unit();
        Coordinates coordinates6 = coordinates5.cross(coordinates4).unit();
        double[][] dArray = new double[3][3];
        dArray[0][0] = -coordinates5.x;
        dArray[0][1] = -coordinates5.y;
        dArray[0][2] = -coordinates5.z;
        dArray[1][0] = -coordinates6.x;
        dArray[1][1] = -coordinates6.y;
        dArray[1][2] = -coordinates6.z;
        dArray[2][0] = coordinates4.x;
        dArray[2][1] = coordinates4.y;
        dArray[2][2] = coordinates4.z;
        Coordinates coordinates7 = new Coordinates(d5, d6, d7).rotate(dArray).add(coordinates3);
        int n3 = this.mMol.addAtom(n2);
        this.mMol.addBond(n, n3, 1);
        this.mMol.setAtomX(n3, coordinates7.x);
        this.mMol.setAtomY(n3, coordinates7.y);
        this.mMol.setAtomZ(n3, coordinates7.z);
    }
}

