/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.alignment3d.transformation;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.Scaling;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.alignment3d.transformation.Translation;
import com.actelion.research.chem.conf.Conformer;

public interface Transformation {
    public static final String ROTATION = "r";
    public static final String TRANSLATION = "t";
    public static final String SCALING = "s";
    public static final String DELIMITER = " ";

    public void apply(Coordinates var1);

    public void apply(double[] var1);

    default public void apply(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            this.apply(stereoMolecule.getCoordinates(i));
        }
    }

    default public void apply(Conformer conformer) {
        for (int i = 0; i < conformer.getMolecule().getAllAtoms(); ++i) {
            this.apply(conformer.getCoordinates(i));
        }
    }

    public String encode();

    public static Transformation decode(String string) {
        if (string.startsWith(ROTATION)) {
            return Rotation.decode(string);
        }
        if (string.startsWith(TRANSLATION)) {
            return Translation.decode(string);
        }
        if (string.startsWith(SCALING)) {
            return Scaling.decode(string);
        }
        if (string.startsWith(String.valueOf('{'))) {
            return TransformationSequence.decode(string);
        }
        return null;
    }
}

