/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.StereoMolecule;
import java.util.Arrays;

public class ScaffoldHelper {
    public static void createMurckoScaffold(StereoMolecule stereoMolecule, boolean bl) {
        boolean[] blArray = ScaffoldHelper.findMurckoScaffold(stereoMolecule);
        if (blArray == null) {
            stereoMolecule.deleteMolecule();
            return;
        }
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (blArray[i]) continue;
            stereoMolecule.markAtomForDeletion(i);
        }
        stereoMolecule.deleteMarkedAtomsAndBonds();
        if (bl) {
            ScaffoldHelper.makeSkeleton(stereoMolecule);
        }
    }

    public static StereoMolecule getMurckoScaffold(StereoMolecule stereoMolecule, boolean bl) {
        boolean[] blArray = ScaffoldHelper.findMurckoScaffold(stereoMolecule);
        if (blArray == null) {
            return null;
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, false, null);
        if (bl) {
            ScaffoldHelper.makeSkeleton(stereoMolecule2);
        }
        return stereoMolecule2;
    }

    public static void makeSkeleton(StereoMolecule stereoMolecule) {
        int n;
        for (n = 0; n < stereoMolecule.getAllBonds(); ++n) {
            stereoMolecule.setBondType(n, 1);
        }
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            stereoMolecule.setAtomicNo(n, 6);
        }
    }

    public static boolean[] findMurckoScaffold(StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        int n4;
        stereoMolecule.ensureHelperArrays(7);
        if (stereoMolecule.getRingSet().getSize() == 0) {
            return null;
        }
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (n4 = 0; n4 < stereoMolecule.getAtoms(); ++n4) {
            if (!stereoMolecule.isRingAtom(n4)) continue;
            blArray[n4] = true;
        }
        do {
            n4 = 0;
            for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                if (!blArray[n3] || stereoMolecule.getConnAtoms(n3) <= 2) continue;
                for (n2 = 0; n2 < stereoMolecule.getConnAtoms(n3); ++n2) {
                    n = stereoMolecule.getConnAtom(n3, n2);
                    if (blArray[n]) continue;
                    ScaffoldHelper.addShortestPathToMember(stereoMolecule, n3, n, blArray);
                }
            }
        } while (n4 != 0);
        do {
            n4 = 0;
            for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                if (!blArray[n3] || stereoMolecule.getAtomPi(n3) == 0) continue;
                for (n2 = 0; n2 < stereoMolecule.getConnAtoms(n3); ++n2) {
                    n = stereoMolecule.getConnAtom(n3, n2);
                    if (blArray[n] || stereoMolecule.getConnBondOrder(n3, n2) <= 1) continue;
                    blArray[n] = true;
                    n4 |= n < n3 ? 1 : 0;
                }
            }
        } while (n4 != 0);
        return blArray;
    }

    private static void addShortestPathToMember(StereoMolecule stereoMolecule, int n, int n2, boolean[] blArray) {
        int[] nArray = new int[stereoMolecule.getAtoms()];
        int[] nArray2 = new int[stereoMolecule.getAtoms()];
        Arrays.fill(nArray, -1);
        nArray2[0] = n2;
        nArray[n] = -2;
        nArray[n2] = n;
        int n3 = 0;
        for (int i = 0; i <= n3; ++i) {
            for (int j = 0; j < stereoMolecule.getConnAtoms(nArray2[i]); ++j) {
                int n4 = stereoMolecule.getConnAtom(nArray2[i], j);
                if (nArray[n4] != -1) continue;
                if (blArray[n4]) {
                    int n5 = nArray2[i];
                    while (!blArray[n5]) {
                        blArray[n5] = true;
                        n5 = nArray[n5];
                    }
                    return;
                }
                nArray2[++n3] = n4;
                nArray[n4] = nArray2[i];
            }
        }
    }

    public static void createMostCentralRingSystem(StereoMolecule stereoMolecule) {
        boolean[] blArray = ScaffoldHelper.findMostCentralRingSystem(stereoMolecule);
        if (blArray == null) {
            stereoMolecule.deleteMolecule();
            return;
        }
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (blArray[i]) continue;
            stereoMolecule.markAtomForDeletion(i);
        }
        stereoMolecule.deleteMarkedAtomsAndBonds();
    }

    public static StereoMolecule getMostCentralRingSystem(StereoMolecule stereoMolecule) {
        boolean[] blArray = ScaffoldHelper.findMostCentralRingSystem(stereoMolecule);
        if (blArray == null) {
            return null;
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, false, null);
        return stereoMolecule2;
    }

    public static boolean[] findMostCentralRingSystem(StereoMolecule stereoMolecule) {
        boolean[] blArray = ScaffoldHelper.findCuttableBonds(stereoMolecule);
        if (blArray == null) {
            return null;
        }
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        int n = stereoMolecule.getFragmentNumbers(nArray, blArray, false);
        float[] fArray = new float[n];
        int[] nArray2 = new int[n];
        boolean[] blArray2 = new boolean[n];
        float[] fArray2 = stereoMolecule.getAverageTopologicalAtomDistance();
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            int n2 = nArray[i];
            fArray[n2] = fArray[n2] + fArray2[i];
            int n3 = nArray[i];
            nArray2[n3] = nArray2[n3] + 1;
            if (!stereoMolecule.isRingAtom(i)) continue;
            blArray2[nArray[i]] = true;
        }
        double d = Double.MAX_VALUE;
        int n4 = -1;
        for (int i = 0; i < n; ++i) {
            if (!blArray2[i] || !(d > (double)fArray[i] / (double)nArray2[i])) continue;
            d = (double)fArray[i] / (double)nArray2[i];
            n4 = i;
        }
        boolean[] blArray3 = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            blArray3[i] = nArray[i] == n4;
        }
        return blArray3;
    }

    private static boolean[] findCuttableBonds(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(7);
        if (stereoMolecule.getRingSet().getSize() == 0) {
            return null;
        }
        boolean[] blArray = new boolean[stereoMolecule.getBonds()];
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (stereoMolecule.isRingBond(i) || !stereoMolecule.isRingAtom(stereoMolecule.getBondAtom(0, i)) && !stereoMolecule.isRingAtom(stereoMolecule.getBondAtom(1, i))) continue;
            blArray[i] = true;
        }
        return blArray;
    }
}

