/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMoleculeFunctions;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RingHelper {
    public static final int MAX_RING_SIZE = 100;
    private int[][] arrTopoDist;
    private RingCollection ringCollection;
    private List<int[]> liRing;

    public RingHelper(StereoMolecule stereoMolecule) {
        this.ringCollection = new RingCollection(stereoMolecule, 3, 100);
        this.arrTopoDist = ExtendedMoleculeFunctions.getTopologicalDistanceMatrix(stereoMolecule);
        this.liRing = new ArrayList<int[]>();
    }

    public RingCollection getRingCollection() {
        return this.ringCollection;
    }

    public int getLargestRingSize() {
        int n = 0;
        this.liRing.clear();
        int n2 = this.ringCollection.getSize();
        for (int i = 0; i < n2; ++i) {
            this.liRing.add(this.ringCollection.getRingAtoms(i));
        }
        Collections.sort(this.liRing, new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                int n = 0;
                if (nArray.length > nArray2.length) {
                    n = 1;
                } else if (nArray.length < nArray2.length) {
                    n = -1;
                }
                return n;
            }
        });
        Collections.reverse(this.liRing);
        for (int[] nArray : this.liRing) {
            if (this.isEnclosingRing(nArray)) continue;
            n = nArray.length;
            break;
        }
        return n;
    }

    public boolean isEnclosingRing(int[] nArray) {
        boolean bl = false;
        int n = 1;
        int n2 = nArray.length / 2 + 1;
        block0: for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            for (int j = n; j < n2; ++j) {
                int n4;
                int n5;
                int n6;
                int n7 = i + j;
                if (n7 >= nArray.length) {
                    n7 -= nArray.length;
                }
                if ((n6 = n7 - i) > n2) {
                    n6 = i - n7 - nArray.length;
                }
                if ((n5 = this.arrTopoDist[n3][n4 = nArray[n7]]) >= n6) continue;
                bl = true;
                break block0;
            }
        }
        return bl;
    }
}

