/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

class MesoFragmentMembers
implements Comparable<MesoFragmentMembers> {
    public boolean[] isMember;
    public int[] memberAtom;

    public MesoFragmentMembers(int n) {
        this.isMember = new boolean[n];
    }

    public void add(int n) {
        this.isMember[n] = true;
    }

    private void consolidate() {
        int n = 0;
        for (boolean bl : this.isMember) {
            if (!bl) continue;
            ++n;
        }
        this.memberAtom = new int[n];
        n = 0;
        for (int i = 0; i < this.isMember.length; ++i) {
            if (!this.isMember[i]) continue;
            this.memberAtom[n++] = i;
        }
    }

    public boolean hasStereoCenters(boolean[] blArray) {
        this.consolidate();
        for (int i = 0; i < this.memberAtom.length; ++i) {
            if (!blArray[this.memberAtom[i]]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(MesoFragmentMembers mesoFragmentMembers) {
        if (this.memberAtom.length != mesoFragmentMembers.memberAtom.length) {
            return this.memberAtom.length < mesoFragmentMembers.memberAtom.length ? -1 : 1;
        }
        for (int i = 0; i < this.memberAtom.length; ++i) {
            if (this.memberAtom[i] == mesoFragmentMembers.memberAtom[i]) continue;
            return this.memberAtom[i] < mesoFragmentMembers.memberAtom[i] ? -1 : 1;
        }
        return 0;
    }
}

