/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.StereoMolecule;

public class AtomTypeCalculator {
    public static final int cPropertiesAll = 32702;
    public static final int cPropertiesForSolubility = 2144;
    public static final int cPropertiesForCLogPCharges = 6241;
    public static final int cPropertiesForCLogP = 2145;
    public static final int cPropertiesForMutator = 32190;
    public static final int cPropertiesBasicType = 60;
    public static final int cPropertiesAtomSmallRing = 1;
    public static final int cPropertiesAtomRingSize = 2;
    public static final int cPropertiesAtomAromatic = 4;
    public static final int cPropertiesAtomAllylic = 8;
    public static final int cPropertiesAtomStabilized = 16;
    public static final int cPropertiesAtomCharged = 4096;
    public static final int cPropertiesAtomRingCount = 8192;
    public static final int cPropertiesConnBondOrder = 32;
    public static final int cPropertiesConnAtomTypeSimple = 64;
    public static final int cPropertiesConnAtomType = 128;
    public static final int cPropertiesConnAtomNeighbours = 256;
    public static final int cPropertiesConnAtomNeighboursExact = 512;
    public static final int cPropertiesConnAtomSmallRing = 1024;
    public static final int cPropertiesConnAtomAromatic = 2048;
    public static final int cPropertiesConnAtomStabilized = 16384;
    private static final long ATOM_FLAG_COUNT = 15L;
    private static final long CONN_FLAG_COUNT = 11L;
    private static final long ATOM_FLAGS_ATOMICNO = 15L;
    private static final long ATOM_FLAGS_RINGSIZE = 112L;
    private static final long ATOM_SHIFT_RINGSIZE = 4L;
    private static final long ATOM_FLAGS_RINGCOUNT = 896L;
    private static final long ATOM_SHIFT_RINGCOUNT = 7L;
    private static final long ATOM_FLAG_SMALLRING = 64L;
    private static final long ATOM_FLAG_AROMATIC = 1024L;
    private static final long ATOM_FLAG_ALLYLIC = 2048L;
    private static final long ATOM_FLAG_STABILIZED = 4096L;
    private static final long ATOM_FLAG_CHARGED = 8192L;
    private static final long ATOM_FLAG_AMPHOLYTIC = 16384L;
    private static final long CONN_FLAGS_ALL = 2047L;
    private static final long CONN_FLAGS_ATOMICNO = 15L;
    private static final long CONN_FLAGS_BONDORDER = 48L;
    private static final long CONN_SHIFT_BONDORDER = 4L;
    private static final long CONN_FLAGS_NEIGHBOURS = 192L;
    private static final long CONN_SHIFT_NEIGHBOURS = 6L;
    private static final long CONN_FLAG_SMALLRING = 256L;
    private static final long CONN_FLAG_AROMATIC = 512L;
    private static final long CONN_FLAG_STABILIZED = 1024L;
    private static final short[] cAtomicNoCode = new short[]{-1, -1, -1, 0, 0, 1, 2, 3, 4, 5, -1, 0, 0, 0, 6, 7, 8, 9, -1, 0, 0, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 1, 11, 11, 12, 13, -1, 0, 0, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 0, 0, 0, 11, 14, -1, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 10, 10, 10, 10, 10, 10, 10, 10, 1, 1, 1, 1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final short[] cSimpleAtomicNoCode = new short[]{-1, -1, -1, 0, 0, 0, 2, 5, 5, 5, -1, 0, 0, 0, 0, 9, 9, 9, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final String[] cAtomicNoCodeString = new String[]{"MainGroupMetal", "Boron", "Carbon", "Nitrogen", "Oxygen", "Fluor", "Silicon", "Phosphorous", "Sulfur", "Chlorine", "Transition Metal", "MainGroupNonMetal", "Selene", "Bromine", "Iodine", "LanthanideOrActinide"};
    private static final String[] cSimpleAtomicNoCodeString = new String[]{"Metal", "-", "Carbon", "-", "-", "Small Hetero", "-", "-", "-", "Large Hetero", "-", "-", "-", "-", "-", "-"};

    public static String getAtomicNoCodeString(int n) {
        return cAtomicNoCodeString[n];
    }

    public static String getSimpleAtomicNoCodeString(int n) {
        return cSimpleAtomicNoCodeString[n];
    }

    public static void printAtomType(StereoMolecule stereoMolecule, int n) {
        try {
            AtomTypeCalculator.printAtomType(AtomTypeCalculator.getAtomType(stereoMolecule, n));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static String getHeaderString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AtomicNo-Code");
        if ((n & 2) != 0) {
            stringBuffer.append("\tRingsize");
        }
        if ((n & 1) != 0) {
            stringBuffer.append("\tRingmember");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("\tAromatic");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("\tAllylic");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("\tStabilized");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("\tCharged\tAmpholytic");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append("\tRingCount");
        }
        for (int i = 1; i <= 4; ++i) {
            if ((n & 0x20) != 0) {
                stringBuffer.append("\tConnBondType" + i);
            }
            if ((n & 0x80) != 0) {
                stringBuffer.append("\tConnAtomType" + i);
            } else if ((n & 0x40) != 0) {
                stringBuffer.append("\tSimpleConnAtomType" + i);
            }
            if ((n & 0x100) != 0) {
                stringBuffer.append("\tConnMoreNeighbours" + i);
            }
            if ((n & 0x400) != 0) {
                stringBuffer.append("\tConnIsSmallRingMember" + i);
            }
            if ((n & 0x800) != 0) {
                stringBuffer.append("\tConnIsAromatic" + i);
            }
            if ((n & 0x4000) == 0) continue;
            stringBuffer.append("\tConnIsStabilized" + i);
        }
        return stringBuffer.toString();
    }

    public static String getTypeString(long l, int n) {
        long l2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AtomTypeCalculator.getAtomicNoCodeString((int)(l & 0xFL)));
        if ((n & 2) != 0) {
            l2 = (l & 0x70L) >> 4;
            if (l2 != 0L) {
                l2 += 2L;
            }
            stringBuffer.append("\t" + l2);
        }
        if ((n & 1) != 0) {
            stringBuffer.append("\t" + ((l & 0x40L) != 0L ? "yes" : "no"));
        }
        if ((n & 4) != 0) {
            stringBuffer.append("\t" + ((l & 0x400L) != 0L ? "yes" : "no"));
        }
        if ((n & 8) != 0) {
            stringBuffer.append("\t" + ((l & 0x800L) != 0L ? "yes" : "no"));
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("\t" + ((l & 0x1000L) != 0L ? "yes" : "no"));
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("\t" + ((l & 0x2000L) != 0L ? "yes" : "no"));
            stringBuffer.append("\t" + ((l & 0x4000L) != 0L ? "yes" : "no"));
        }
        if ((n & 0x2000) != 0) {
            l2 = (l & 0x380L) >> 7;
            stringBuffer.append("\t" + l2);
        }
        l >>= 15;
        for (int i = 1; i <= 4; ++i) {
            long l3 = l & 0x7FFL;
            if (l3 != 0L) {
                if ((n & 0x20) != 0) {
                    stringBuffer.append("\t" + ((l3 & 0x30L) >> 4));
                }
                if ((n & 0x80) != 0) {
                    stringBuffer.append("\t" + AtomTypeCalculator.getAtomicNoCodeString((int)(l3 & 0xFL)));
                } else if ((n & 0x40) != 0) {
                    stringBuffer.append("\t" + AtomTypeCalculator.getSimpleAtomicNoCodeString((int)(l3 & 0xFL)));
                }
                if ((n & 0x100) != 0) {
                    long l4 = (l3 & 0xC0L) >> 6;
                    if ((n & 0x200) == 0) {
                        stringBuffer.append("\t" + (l4 == 0L ? "no" : "yes"));
                    } else {
                        stringBuffer.append("\t" + l4);
                    }
                }
                if ((n & 0x400) != 0) {
                    stringBuffer.append("\t" + ((l3 & 0x100L) != 0L ? "yes" : "no"));
                }
                if ((n & 0x800) != 0) {
                    stringBuffer.append("\t" + ((l3 & 0x200L) != 0L ? "yes" : "no"));
                }
                if ((n & 0x4000) != 0) {
                    stringBuffer.append("\t" + ((l3 & 0x400L) != 0L ? "yes" : "no"));
                }
            }
            l >>= 11;
        }
        return stringBuffer.toString();
    }

    public static String toString(long l) {
        return AtomTypeCalculator.toString(l, 32702);
    }

    public static String toString(long l, int n) {
        long l2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AtomTypeCalculator.getAtomicNoCodeString((int)(l & 0xFL)) + ":");
        if ((n & 0x1000) != 0) {
            if ((l & 0x2000L) != 0L) {
                stringBuffer.append("Chg");
            }
            if ((l & 0x4000L) != 0L) {
                stringBuffer.append("Amp");
            }
        }
        if ((n & 0x2000) != 0) {
            l2 = (l & 0x380L) >> 7;
            stringBuffer.append("Rc" + l2);
        }
        if ((n & 2) != 0) {
            l2 = (l & 0x70L) >> 4;
            if (l2 != 0L) {
                l2 += 2L;
            }
            stringBuffer.append("Rs" + l2);
        }
        if ((n & 4) != 0 && (l & 0x400L) != 0L) {
            stringBuffer.append("Ar");
        }
        if ((n & 8) != 0 && (l & 0x800L) != 0L) {
            stringBuffer.append("Al");
        }
        if ((n & 0x10) != 0 && (l & 0x1000L) != 0L) {
            stringBuffer.append("St");
        }
        l >>= 15;
        for (int i = 0; i < 4 && l != 0L; l >>= 11, ++i) {
            if ((n & 0x20) != 0) {
                int n2 = (int)((l & 0x30L) >> 4);
                switch (n2) {
                    case 0: {
                        stringBuffer.append(" *");
                        break;
                    }
                    case 1: {
                        stringBuffer.append(" -");
                        break;
                    }
                    case 2: {
                        stringBuffer.append(" =");
                        break;
                    }
                    case 3: {
                        stringBuffer.append(" #");
                    }
                }
            }
            stringBuffer.append("{");
            if ((n & 0x80) != 0) {
                stringBuffer.append(AtomTypeCalculator.getAtomicNoCodeString((int)(l & 0xFL)) + ":");
            } else if ((n & 0x40) != 0) {
                stringBuffer.append(AtomTypeCalculator.getSimpleAtomicNoCodeString((int)(l & 0xFL)) + ":");
            }
            long l3 = ((l & 0xC0L) >> 6) + 1L;
            if ((n & 0x100) != 0) {
                stringBuffer.append("N" + l3);
            }
            if ((n & 0x400) != 0 && (l & 0x100L) != 0L) {
                stringBuffer.append("Ri");
            }
            if ((n & 0x800) != 0 && (l & 0x200L) != 0L) {
                stringBuffer.append("Ar");
            }
            if ((n & 0x4000) != 0 && (l & 0x400L) != 0L) {
                stringBuffer.append("St");
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public static void printAtomType(long l) {
        System.out.println(AtomTypeCalculator.toString(l));
    }

    public static long getAtomType(StereoMolecule stereoMolecule, int n) throws Exception {
        return AtomTypeCalculator.getAtomType(stereoMolecule, n, 32702);
    }

    public static long getAtomType(StereoMolecule stereoMolecule, int n, int n2) throws Exception {
        int n3;
        stereoMolecule.ensureHelperArrays(7);
        long[] lArray = new long[stereoMolecule.getConnAtoms(n)];
        int n4 = 0;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n5 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAtomicNo(n5) == 1) continue;
            long l = 0L;
            if ((n2 & 0x20) != 0) {
                long l2 = stereoMolecule.getConnBondOrder(n, i);
                if (n2 == 32190) {
                    if (l2 < 3L && stereoMolecule.isDelocalizedBond(stereoMolecule.getConnBond(n, i)) && stereoMolecule.getAtomPi(n) == 1) {
                        l2 = 0L;
                    }
                } else if (l2 < 3L && stereoMolecule.isAromaticBond(stereoMolecule.getConnBond(n, i))) {
                    l2 = 0L;
                }
                l |= l2 << 4;
            }
            if ((n2 & 0x80) != 0) {
                if (cAtomicNoCode[stereoMolecule.getAtomicNo(n5)] == -1) {
                    throw new Exception("unsupported atomicNo:" + stereoMolecule.getAtomicNo(n5));
                }
                l += (long)cAtomicNoCode[stereoMolecule.getAtomicNo(n5)];
            } else if ((n2 & 0x40) != 0) {
                if (cSimpleAtomicNoCode[stereoMolecule.getAtomicNo(n5)] == -1) {
                    throw new Exception("unsupported atomicNo:" + stereoMolecule.getAtomicNo(n5));
                }
                l += (long)cSimpleAtomicNoCode[stereoMolecule.getAtomicNo(n5)];
            }
            if ((n2 & 0x100) != 0) {
                int n6 = stereoMolecule.getConnAtoms(n5) - 1;
                if (n6 > 3) {
                    n6 = 3;
                }
                if ((n2 & 0x200) == 0 && n6 > 1) {
                    n6 = 1;
                }
                l |= (long)(n6 << 6);
            }
            if ((n2 & 0x400) != 0 && stereoMolecule.isSmallRingAtom(n5)) {
                l |= 0x100L;
            }
            if ((n2 & 0x800) != 0 && stereoMolecule.isAromaticAtom(n5)) {
                l |= 0x200L;
            }
            if ((n2 & 0x4000) != 0 && stereoMolecule.isStabilizedAtom(n5)) {
                l |= 0x400L;
            }
            int n7 = 0;
            while (l < lArray[n7]) {
                ++n7;
            }
            for (int j = i; j > n7; --j) {
                lArray[j] = lArray[j - 1];
            }
            lArray[n7] = l;
            ++n4;
        }
        if (n4 > 4) {
            n4 = 4;
        }
        long l = 0L;
        for (n3 = 0; n3 < n4; ++n3) {
            l <<= 11;
            l |= lArray[n3];
        }
        l <<= 15;
        if (cAtomicNoCode[stereoMolecule.getAtomicNo(n)] == -1) {
            throw new Exception("unsupported atomicNo:" + stereoMolecule.getAtomicNo(n));
        }
        l |= (long)cAtomicNoCode[stereoMolecule.getAtomicNo(n)];
        if ((n2 & 2) != 0) {
            n3 = stereoMolecule.getAtomRingSize(n);
            if (n3 > 9) {
                n3 = 9;
            }
            if (n3 > 2) {
                n3 -= 2;
            }
            l |= (long)(n3 << 4);
        } else if ((n2 & 1) != 0 && stereoMolecule.isSmallRingAtom(n)) {
            l |= 0x40L;
        }
        if ((n2 & 4) != 0 && stereoMolecule.isAromaticAtom(n)) {
            l |= 0x400L;
        }
        if ((n2 & 8) != 0 && stereoMolecule.isAllylicAtom(n)) {
            l |= 0x800L;
        }
        if ((n2 & 0x10) != 0 && stereoMolecule.isStabilizedAtom(n)) {
            l |= 0x1000L;
        }
        if ((n2 & 0x1000) != 0) {
            if (AtomFunctionAnalyzer.hasUnbalancedAtomCharge(stereoMolecule, n)) {
                l |= 0x2000L;
            }
            if (AtomFunctionAnalyzer.isBasicNitrogen(stereoMolecule, n)) {
                for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                    if (!AtomFunctionAnalyzer.isAcidicOxygen(stereoMolecule, n3)) continue;
                    l |= 0x4000L;
                    break;
                }
            }
        }
        if ((n2 & 0x2000) != 0) {
            long l3 = stereoMolecule.getAtomRingCount(n, 10);
            l |= l3 << 7;
        }
        return l;
    }
}

