/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;

public class AtomFunctionAnalyzer {
    private static int getOxoCount(StereoMolecule stereoMolecule, int n) {
        int n2 = 0;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (stereoMolecule.getConnBondOrder(n, i) != 2 || stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n, i)) != 8) continue;
            ++n2;
        }
        return n2;
    }

    private static int getFakeOxoCount(StereoMolecule stereoMolecule, int n) {
        int n2 = 0;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (stereoMolecule.getConnBondOrder(n, i) != 2 || stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n, i)) != 7 && stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n, i)) != 8 && stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n, i)) != 16) continue;
            ++n2;
        }
        return n2;
    }

    public static int getNegativeNeighbourCount(StereoMolecule stereoMolecule, int n) {
        int n2 = 0;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (!stereoMolecule.isElectronegative(stereoMolecule.getConnAtom(n, i))) continue;
            ++n2;
        }
        return n2;
    }

    public static boolean isAlkylAmine(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 7 || stereoMolecule.isAromaticAtom(n) || stereoMolecule.getAtomPi(n) != 0) {
            return false;
        }
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n2 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAtomicNo(n2) == 6 && stereoMolecule.getAtomPi(n2) == 0 && !stereoMolecule.isAromaticAtom(n2) && AtomFunctionAnalyzer.getNegativeNeighbourCount(stereoMolecule, n2) == 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isStabilized(StereoMolecule stereoMolecule, int n, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n2;
            if (stereoMolecule.isAromaticBond(stereoMolecule.getConnBond(n, i)) || stereoMolecule.getConnBondOrder(n, i) != 1 || stereoMolecule.isAromaticAtom(n2 = stereoMolecule.getConnAtom(n, i)) || (stereoMolecule.getAtomicNo(n2) != 6 || AtomFunctionAnalyzer.getFakeOxoCount(stereoMolecule, n2) != 1) && (stereoMolecule.getAtomicNo(n2) != 16 || AtomFunctionAnalyzer.getFakeOxoCount(stereoMolecule, n2) != 2)) continue;
            if (bl2 || !bl) {
                return true;
            }
            bl2 = true;
        }
        return false;
    }

    public static boolean isAmide(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 7 || stereoMolecule.getAtomPi(n) != 0 || stereoMolecule.isAromaticAtom(n)) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n2 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAtomicNo(n2) == 6 && AtomFunctionAnalyzer.getOxoCount(stereoMolecule, n2) == 1 || stereoMolecule.getAtomicNo(n2) == 16 && AtomFunctionAnalyzer.getOxoCount(stereoMolecule, n2) == 2) {
                bl = true;
                continue;
            }
            if (stereoMolecule.getAtomicNo(n2) == 6) continue;
            return false;
        }
        return bl;
    }

    public static boolean isAmine(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 7 || stereoMolecule.isAromaticAtom(n) || stereoMolecule.getAtomPi(n) != 0) {
            return false;
        }
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n2 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAtomicNo(n2) == 6 && (stereoMolecule.isAromaticAtom(n2) || stereoMolecule.getAtomPi(n2) == 0 && AtomFunctionAnalyzer.getNegativeNeighbourCount(stereoMolecule, n2) == 1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isArylAmine(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 7 || stereoMolecule.isAromaticAtom(n) || stereoMolecule.getAtomPi(n) != 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n2 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAtomicNo(n2) != 6 || !stereoMolecule.isAromaticAtom(n2) && (stereoMolecule.getAtomPi(n2) != 0 || AtomFunctionAnalyzer.getNegativeNeighbourCount(stereoMolecule, n2) != 1)) {
                return false;
            }
            if (!stereoMolecule.isAromaticAtom(n2)) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean hasUnbalancedAtomCharge(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomCharge(n) == 0) {
            return false;
        }
        boolean bl = true;
        int n2 = stereoMolecule.getAtomCharge(n);
        int n3 = stereoMolecule.getConnAtoms(n);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = stereoMolecule.getConnAtom(n, i);
            n4 += stereoMolecule.getAtomCharge(n5);
        }
        if (Math.abs(n2) <= Math.abs(n4) && Math.signum(n2) != Math.signum(n4)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isAcidicOxygen(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 8 || stereoMolecule.getAtomCharge(n) != 0 || stereoMolecule.getConnAtoms(n) != 1 || stereoMolecule.getConnBondOrder(n, 0) != 1) {
            return false;
        }
        int n2 = stereoMolecule.getConnAtom(n, 0);
        if (stereoMolecule.getAtomicNo(n2) == 6) {
            int n3 = stereoMolecule.getConnAtoms(n2);
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5 = stereoMolecule.getConnAtom(n2, i);
                if (n5 == n || stereoMolecule.getAtomicNo(n5) != 8 || stereoMolecule.getBondType(n4 = stereoMolecule.getBond(n2, n5)) != 2) continue;
                return true;
            }
        } else if (stereoMolecule.getAtomicNo(n2) == 7) {
            if (stereoMolecule.getAtomCharge(n2) == 1) {
                return true;
            }
        } else if (stereoMolecule.getAtomicNo(n2) == 16) {
            int n6 = stereoMolecule.getConnAtoms(n2);
            int n7 = 0;
            for (int i = 0; i < n6; ++i) {
                int n8;
                int n9 = stereoMolecule.getConnAtom(n2, i);
                if (n9 == n || stereoMolecule.getAtomicNo(n9) != 8 || stereoMolecule.getBondType(n8 = stereoMolecule.getBond(n2, n9)) != 2) continue;
                ++n7;
            }
            if (n7 == 2) {
                return true;
            }
        } else if (AtomFunctionAnalyzer.isAcidicOxygenAtPhosphoricAcid(stereoMolecule, n)) {
            return true;
        }
        return false;
    }

    public static boolean isAcidicOxygenAtPhosphoricAcid(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 8) {
            return false;
        }
        if (stereoMolecule.getConnAtoms(n) != 1) {
            return false;
        }
        int n2 = stereoMolecule.getConnAtom(n, 0);
        if (stereoMolecule.getAtomicNo(n2) == 15) {
            int n3 = stereoMolecule.getConnAtoms(n2);
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5 = stereoMolecule.getConnAtom(n2, i);
                if (n5 == n || stereoMolecule.getAtomicNo(n5) != 8 || stereoMolecule.getBondType(n4 = stereoMolecule.getBond(n2, n5)) != 2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMemberOfNitroGroup(StereoMolecule stereoMolecule, int n) {
        boolean bl;
        block4: {
            block3: {
                bl = false;
                if (stereoMolecule.getAtomicNo(n) != 7 && stereoMolecule.getAtomicNo(n) != 8) {
                    return false;
                }
                if (stereoMolecule.getAtomicNo(n) != 7) break block3;
                if (!AtomFunctionAnalyzer.isNitroGroupN(stereoMolecule, n)) break block4;
                bl = true;
                break block4;
            }
            if (stereoMolecule.getAtomicNo(n) == 8) {
                int n2 = stereoMolecule.getConnAtoms(n);
                for (int i = 0; i < n2; ++i) {
                    int n3 = stereoMolecule.getConnAtom(n, i);
                    if (stereoMolecule.getAtomicNo(n3) != 7 || !AtomFunctionAnalyzer.isNitroGroupN(stereoMolecule, n3)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isNitroGroupN(StereoMolecule stereoMolecule, int n) {
        boolean bl = false;
        if (stereoMolecule.getAtomicNo(n) != 7) {
            return false;
        }
        int n2 = stereoMolecule.getConnAtoms(n);
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            int n5 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAtomicNo(n5) != 8) continue;
            int n6 = stereoMolecule.getBond(n, n5);
            if (stereoMolecule.getBondOrder(n6) == 1) {
                n3 = n5;
                continue;
            }
            if (stereoMolecule.getBondOrder(n6) != 2) continue;
            n4 = n5;
        }
        if (n3 > -1 && n4 > -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean isBasicNitrogen(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 7 || stereoMolecule.getAtomCharge(n) != 0 || stereoMolecule.getConnAtoms(n) + stereoMolecule.getAtomPi(n) > 3) {
            return false;
        }
        if (stereoMolecule.isAromaticAtom(n)) {
            if (stereoMolecule.getAtomPi(n) != 1) {
                return false;
            }
            if (stereoMolecule.getAtomRingCount(n, 7) != 1) {
                return false;
            }
            RingCollection ringCollection = stereoMolecule.getRingSet();
            for (int i = 0; i < ringCollection.getSize(); ++i) {
                int n2;
                int n3;
                int n4;
                int n5;
                if (!ringCollection.isAtomMember(i, n)) continue;
                if (ringCollection.getRingSize(i) != 5 && ringCollection.getRingSize(i) != 6) break;
                int[] nArray = ringCollection.getRingAtoms(i);
                int n6 = -1;
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    if (nArray[n5] != n) continue;
                    n6 = n5;
                    break;
                }
                n5 = 0;
                int[] nArray2 = null;
                int[] nArray3 = null;
                if (nArray.length == 5) {
                    nArray2 = new int[]{nArray[n6 - 1 < 0 ? n6 + 4 : n6 - 1], nArray[n6 - 4 < 0 ? n6 + 1 : n6 - 4]};
                    nArray3 = new int[]{nArray[n6 - 2 < 0 ? n6 + 3 : n6 - 2], nArray[n6 - 3 < 0 ? n6 + 2 : n6 - 3]};
                }
                if (nArray.length == 6) {
                    nArray2 = new int[]{nArray[n6 - 1 < 0 ? n6 + 5 : n6 - 1], nArray[n6 - 3 < 0 ? n6 + 3 : n6 - 3], nArray[n6 - 5 < 0 ? n6 + 1 : n6 - 5]};
                    nArray3 = new int[]{nArray[n6 - 2 < 0 ? n6 + 4 : n6 - 2], nArray[n6 - 4 < 0 ? n6 + 2 : n6 - 4]};
                }
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (n == nArray[n4] || stereoMolecule.getAtomicNo(nArray[n4]) != 7 || stereoMolecule.getAtomPi(nArray[n4]) != 1) continue;
                    --n5;
                }
                block3: for (n4 = 0; n4 < nArray2.length; ++n4) {
                    int n7;
                    n3 = -1;
                    n2 = -1;
                    for (n7 = 0; n7 < stereoMolecule.getConnAtoms(nArray2[n4]); ++n7) {
                        if (stereoMolecule.isAromaticBond(stereoMolecule.getConnBond(nArray2[n4], n7))) continue;
                        n3 = stereoMolecule.getConnAtom(nArray2[n4], n7);
                        n2 = stereoMolecule.getConnBond(nArray2[n4], n7);
                        break;
                    }
                    if (n3 == -1) continue;
                    if (stereoMolecule.getAtomicNo(n3) == 7 && stereoMolecule.getAtomPi(n3) == 0 && stereoMolecule.getConnAtoms(n3) + stereoMolecule.getAtomPi(n3) <= 3 && !AtomFunctionAnalyzer.isStabilized(stereoMolecule, n3, false)) {
                        ++n5;
                        continue;
                    }
                    if (stereoMolecule.getAtomicNo(n3) == 8 && stereoMolecule.getConnAtoms(n3) == 1) {
                        n5 += 2;
                        continue;
                    }
                    if (!stereoMolecule.isAromaticBond(n2)) continue;
                    for (n7 = 0; n7 < ringCollection.getSize(); ++n7) {
                        if (!ringCollection.isAromatic(n7) || !ringCollection.isAtomMember(n7, n3)) continue;
                        int[] nArray4 = ringCollection.getRingAtoms(n7);
                        for (int j = 0; j < nArray4.length; ++j) {
                            if (stereoMolecule.getAtomicNo(nArray4[j]) != 7 || stereoMolecule.getAtomPi(nArray4[j]) != 1) continue;
                            --n5;
                            continue block3;
                        }
                        continue block3;
                    }
                }
                for (n4 = 0; n4 < nArray3.length; ++n4) {
                    n3 = -1;
                    for (n2 = 0; n2 < stereoMolecule.getConnAtoms(nArray3[n4]); ++n2) {
                        if (stereoMolecule.isAromaticBond(stereoMolecule.getConnBond(nArray3[n4], n2))) continue;
                        n3 = stereoMolecule.getConnAtom(nArray3[n4], n2);
                    }
                    if (stereoMolecule.getAtomicNo(nArray3[n4]) == 6) {
                        if (n3 == -1 || AtomFunctionAnalyzer.getFakeOxoCount(stereoMolecule, n3) == 0) continue;
                        --n5;
                        continue;
                    }
                    if (stereoMolecule.getAtomicNo(nArray3[n4]) != 7 || stereoMolecule.getAtomPi(nArray3[n4]) != 0 || n3 != -1 && (stereoMolecule.isAromaticAtom(n3) || AtomFunctionAnalyzer.getFakeOxoCount(stereoMolecule, n3) != 0)) continue;
                    ++n5;
                }
                return n5 > 0;
            }
            return false;
        }
        if (stereoMolecule.getAtomPi(n) > 1) {
            return false;
        }
        if (stereoMolecule.getAtomPi(n) == 1) {
            int n8;
            int n9;
            int n10 = -1;
            int n11 = 0;
            for (n9 = 0; n9 < stereoMolecule.getConnAtoms(n); ++n9) {
                n8 = stereoMolecule.getConnAtom(n, n9);
                if (stereoMolecule.getConnBondOrder(n, n9) == 2) {
                    if (stereoMolecule.getAtomicNo(n8) != 6) {
                        return false;
                    }
                    n10 = n8;
                    continue;
                }
                if (stereoMolecule.getAtomicNo(n8) == 8) {
                    return false;
                }
                if (stereoMolecule.getAtomicNo(n8) == 7) {
                    --n11;
                    if (!AtomFunctionAnalyzer.isStabilized(stereoMolecule, n8, false)) continue;
                    --n11;
                    continue;
                }
                if (!stereoMolecule.isAromaticAtom(n8)) continue;
                --n11;
            }
            if (n10 == -1) {
                return false;
            }
            n9 = 0;
            for (n8 = 0; n8 < stereoMolecule.getConnAtoms(n10); ++n8) {
                if (stereoMolecule.getConnBondOrder(n10, n8) != 1) continue;
                int n12 = stereoMolecule.getConnAtom(n10, n8);
                if (AtomFunctionAnalyzer.getFakeOxoCount(stereoMolecule, n12) != 0) {
                    return false;
                }
                if (stereoMolecule.isAromaticAtom(n12)) {
                    ++n9;
                }
                if (stereoMolecule.getAtomicNo(n12) == 7 && !AtomFunctionAnalyzer.isStabilized(stereoMolecule, n12, true)) {
                    ++n11;
                }
                if (stereoMolecule.getAtomicNo(n12) != 8 && stereoMolecule.getAtomicNo(n12) != 16) continue;
                --n11;
            }
            if (n9 == 2) {
                --n11;
            }
            return n11 >= 0;
        }
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n13 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.isAromaticAtom(n13)) {
                return false;
            }
            if (stereoMolecule.getAtomicNo(n13) != 6) {
                return false;
            }
            if (AtomFunctionAnalyzer.getFakeOxoCount(stereoMolecule, n13) != 0) {
                return false;
            }
            if (stereoMolecule.getAtomPi(n13) == 0 || !AtomFunctionAnalyzer.isVinylogFakeOxo(stereoMolecule, n13)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVinylogFakeOxo(StereoMolecule stereoMolecule, int n) {
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (stereoMolecule.getConnBondOrder(n, i) == 1) continue;
            int n2 = stereoMolecule.getConnAtom(n, i);
            for (int j = 0; j < stereoMolecule.getConnAtoms(n2); ++j) {
                if (stereoMolecule.getConnBondOrder(n2, j) != 1 || AtomFunctionAnalyzer.getFakeOxoCount(stereoMolecule, stereoMolecule.getConnAtom(n2, j)) == 0) continue;
                return true;
            }
        }
        return false;
    }
}

